# Structure Definition Use Codes / Keywords - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Structure Definition Use Codes / Keywords**

## CodeSystem: Structure Definition Use Codes / Keywords 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/definition-use | *Version*:2.0.0 | |
| Active as of 2025-11-13 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DefinitionUseCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1191 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Structure Definition Use Codes / Keywords 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DefinitionUseCodes](ValueSet-definition-use.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "definition-use",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fhir"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/definition-use",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1191"
    }
  ],
  "version" : "2.0.0",
  "name" : "DefinitionUseCodes",
  "title" : "Structure Definition Use Codes / Keywords",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Structure Definition Use Codes / Keywords",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/definition-use",
  "content" : "complete",
  "concept" : [
    {
      "code" : "fhir-structure",
      "display" : "FHIR Structure",
      "definition" : "This structure is defined as part of the base FHIR Specification"
    },
    {
      "code" : "custom-resource",
      "display" : "Custom Resource",
      "definition" : "This structure is intended to be treated like a FHIR resource (e.g. on the FHIR API)"
    },
    {
      "code" : "dam",
      "display" : "Domain Analysis Model",
      "definition" : "This structure captures an analysis of a domain"
    },
    {
      "code" : "wire-format",
      "display" : "Wire Format",
      "definition" : "This structure represents and existing structure (e.g. CDA, HL7 v2)"
    },
    {
      "code" : "archetype",
      "display" : "Domain Analysis Model",
      "definition" : "This structure captures an analysis of a domain"
    },
    {
      "code" : "template",
      "display" : "Template",
      "definition" : "This structure is a template (n.b: 'template' has many meanings)"
    }
  ]
}

```
