# Coverage Copay Type Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Coverage Copay Type Codes**

## CodeSystem: Coverage Copay Type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/coverage-copay-type | *Version*:1.0.1 | | |
| Active as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CoverageCopayTypeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1149 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes sample Coverage Copayment Type codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CoverageCopayTypeCodes](ValueSet-coverage-copay-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "coverage-copay-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/coverage-copay-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1149"
    }
  ],
  "version" : "1.0.1",
  "name" : "CoverageCopayTypeCodes",
  "title" : "Coverage Copay Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes sample Coverage Copayment Type codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/coverage-copay-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "gpvisit",
      "display" : "GP Office Visit",
      "definition" : "An office visit for a general practitioner of a discipline."
    },
    {
      "code" : "spvisit",
      "display" : "Specialist Office Visit",
      "definition" : "An office visit for a specialist practitioner of a discipline"
    },
    {
      "code" : "emergency",
      "display" : "Emergency",
      "definition" : "An episode in an emergency department."
    },
    {
      "code" : "inpthosp",
      "display" : "Inpatient Hospital",
      "definition" : "An episode of an Inpatient hospital stay."
    },
    {
      "code" : "televisit",
      "display" : "Tele-visit",
      "definition" : "A visit held where the patient is remote relative to the practitioner, e.g. by phone, computer or video conference."
    },
    {
      "code" : "urgentcare",
      "display" : "Urgent Care",
      "definition" : "A visit to an urgent care facility - typically a community care clinic."
    },
    {
      "code" : "copaypct",
      "display" : "Copay Percentage",
      "definition" : "A standard percentage applied to all classes or service or product not otherwise specified."
    },
    {
      "code" : "copay",
      "display" : "Copay Amount",
      "definition" : "A standard fixed currency amount applied to all classes or service or product not otherwise specified."
    },
    {
      "code" : "deductible",
      "display" : "Deductible",
      "definition" : "The accumulated amount of patient payment before the coverage begins to pay for services."
    },
    {
      "code" : "maxoutofpocket",
      "display" : "Maximum out of pocket",
      "definition" : "The maximum amout of payment for services which a patient, or family, is expected to incur - typically annually."
    }
  ]
}

```
