# Coverage Class Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Coverage Class Codes**

## CodeSystem: Coverage Class Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/coverage-class | *Version*:1.0.1 | | |
| Active as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CoverageClassCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1147 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes Coverage Class codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CoverageClassCodes](ValueSet-coverage-class.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "coverage-class",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/coverage-class",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1147"
    }
  ],
  "version" : "1.0.1",
  "name" : "CoverageClassCodes",
  "title" : "Coverage Class Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes Coverage Class codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/coverage-class",
  "content" : "complete",
  "concept" : [
    {
      "code" : "group",
      "display" : "Group",
      "definition" : "An employee group"
    },
    {
      "code" : "subgroup",
      "display" : "SubGroup",
      "definition" : "A sub-group of an employee group"
    },
    {
      "code" : "plan",
      "display" : "Plan",
      "definition" : "A specific suite of benefits."
    },
    {
      "code" : "subplan",
      "display" : "SubPlan",
      "definition" : "A subset of a specific suite of benefits."
    },
    {
      "code" : "class",
      "display" : "Class",
      "definition" : "A class of benefits."
    },
    {
      "code" : "subclass",
      "display" : "SubClass",
      "definition" : "A subset of a class of benefits."
    },
    {
      "code" : "sequence",
      "display" : "Sequence",
      "definition" : "A sequence number associated with a short-term continuance of the coverage."
    },
    {
      "code" : "rxbin",
      "display" : "RX BIN",
      "definition" : "Pharmacy benefit manager's Business Identification Number."
    },
    {
      "code" : "rxpcn",
      "display" : "RX PCN",
      "definition" : "A Pharmacy Benefit Manager specified Processor Control Number."
    },
    {
      "code" : "rxid",
      "display" : "RX Id",
      "definition" : "A Pharmacy Benefit Manager specified Member ID."
    },
    {
      "code" : "rxgroup",
      "display" : "RX Group",
      "definition" : "A Pharmacy Benefit Manager specified Group number."
    }
  ]
}

```
