# Contact entity type - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Contact entity type**

## CodeSystem: Contact entity type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/contactentity-type | *Version*:1.0.0 | | |
| Draft as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ContactEntityType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1129 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
This example value set defines a set of codes that can be used to indicate the purpose for which you would contact a contact party. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ContactEntityType](ValueSet-contactentity-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "contactentity-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/contactentity-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1129"
    }
  ],
  "version" : "1.0.0",
  "name" : "ContactEntityType",
  "title" : "Contact entity type",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This example value set defines a set of codes that can be used to indicate the purpose for which you would contact a contact party.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/contactentity-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "BILL",
      "display" : "Billing",
      "definition" : "Contact details for information regarding to billing/general finance enquiries."
    },
    {
      "code" : "ADMIN",
      "display" : "Administrative",
      "definition" : "Contact details for administrative enquiries."
    },
    {
      "code" : "HR",
      "display" : "Human Resource",
      "definition" : "Contact details for issues related to Human Resources, such as staff matters, OH&S etc."
    },
    {
      "code" : "PAYOR",
      "display" : "Payor",
      "definition" : "Contact details for dealing with issues related to insurance claims/adjudication/payment."
    },
    {
      "code" : "PATINF",
      "display" : "Patient",
      "definition" : "Generic information contact for patients."
    },
    {
      "code" : "PRESS",
      "display" : "Press",
      "definition" : "Dedicated contact point for matters relating to press enquiries."
    }
  ]
}

```
