# CompositeMeasureScoring - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CompositeMeasureScoring**

## CodeSystem: CompositeMeasureScoring 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/composite-measure-scoring | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CompositeMeasureScoring |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1235 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The composite scoring method of the measure. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CompositeMeasureScoring](ValueSet-composite-measure-scoring.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "composite-measure-scoring",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/composite-measure-scoring",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1235"
    }
  ],
  "version" : "1.0.1",
  "name" : "CompositeMeasureScoring",
  "title" : "CompositeMeasureScoring",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The composite scoring method of the measure.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/composite-measure-scoring",
  "content" : "complete",
  "concept" : [
    {
      "code" : "opportunity",
      "display" : "Opportunity",
      "definition" : "Opportunity scoring combines the scores from component measures by combining the numerators and denominators for each component."
    },
    {
      "code" : "all-or-nothing",
      "display" : "All-or-nothing",
      "definition" : "All-or-nothing scoring includes an individual in the numerator of the composite measure if they are in the numerators of all of the component measures in which they are in the denominator."
    },
    {
      "code" : "linear",
      "display" : "Linear",
      "definition" : "Linear scoring gives an individual a score based on the number of numerators in which they appear."
    },
    {
      "code" : "weighted",
      "display" : "Weighted",
      "definition" : "Weighted scoring gives an individual a score based on a weighted factor for each component numerator in which they appear."
    }
  ]
}

```
