# Cited Artifact Abstract Type - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cited Artifact Abstract Type**

## CodeSystem: Cited Artifact Abstract Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/cited-artifact-abstract-type | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:CitedArtifactAbstractType |

 
Used to express the reason and specific aspect for the variant abstract, such as language and specific language 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CitedArtifactAbstractType](ValueSet-cited-artifact-abstract-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cited-artifact-abstract-type",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/cited-artifact-abstract-type",
  "version" : "1.0.0",
  "name" : "CitedArtifactAbstractType",
  "title" : "Cited Artifact Abstract Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T16:55:11+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Used to express the reason and specific aspect for the variant abstract, such as language and specific language",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/cited-artifact-abstract-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "primary-human-use",
      "display" : "Primary human use",
      "definition" : "Human-friendly main or official abstract"
    },
    {
      "code" : "primary-machine-use",
      "display" : "Primary machine use",
      "definition" : "Machine-friendly main or official abstract"
    },
    {
      "code" : "truncated",
      "display" : "Truncated",
      "definition" : "Truncated abstract"
    },
    {
      "code" : "short-abstract",
      "display" : "Short abstract",
      "definition" : "Brief abstract, for use when abstracts are provided in different sizes or lengths"
    },
    {
      "code" : "long-abstract",
      "display" : "Long abstract",
      "definition" : "Long version of the abstract, for use when abstracts are provided in different sizes or lengths"
    },
    {
      "code" : "plain-language",
      "display" : "Plain language",
      "definition" : "Additional form of abstract written for the general public"
    },
    {
      "code" : "different-publisher",
      "display" : "Different publisher for abstract",
      "definition" : "Abstract produced by a different publisher than the cited artifact"
    },
    {
      "code" : "language",
      "display" : "Different language",
      "definition" : "Additional form of abstract in a different language"
    },
    {
      "code" : "autotranslated",
      "display" : "Different language derived from autotranslation",
      "definition" : "Machine translated form of abstract in a different language, language element codes the language into which it was translated by machine"
    },
    {
      "code" : "duplicate-pmid",
      "display" : "Different text in additional Medline entry",
      "definition" : "Alternative form of abstract in two or more Medline entries"
    },
    {
      "code" : "earlier-abstract",
      "display" : "Different text in an earlier version",
      "definition" : "Alternative form of abstract in an earlier version such as epub ahead of print"
    }
  ]
}

```
