# Evidence Certainty Type - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Evidence Certainty Type**

## CodeSystem: Evidence Certainty Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/certainty-type | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:EvidenceCertaintyType |

 
The aspect of quality, confidence, or certainty. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EvidenceCertaintyType](ValueSet-certainty-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "certainty-type",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/certainty-type",
  "version" : "1.0.0",
  "name" : "EvidenceCertaintyType",
  "title" : "Evidence Certainty Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T16:55:11+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "The aspect of quality, confidence, or certainty.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/certainty-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "Overall",
      "display" : "Overall certainty",
      "definition" : "Overall certainty of evidence (quality of evidence)."
    },
    {
      "code" : "RiskOfBias",
      "display" : "Risk of bias",
      "definition" : "methodologic concerns reducing internal validity."
    },
    {
      "code" : "Inconsistency",
      "display" : "Inconsistency",
      "definition" : "concerns that findings are not similar enough to support certainty."
    },
    {
      "code" : "Indirectness",
      "display" : "Indirectness",
      "definition" : "concerns reducing external validity."
    },
    {
      "code" : "Imprecision",
      "display" : "Imprecision",
      "definition" : "fuzzy or wide variability."
    },
    {
      "code" : "PublicationBias",
      "display" : "Publication bias",
      "definition" : "likelihood that what is published misrepresents what is available to publish."
    },
    {
      "code" : "DoseResponseGradient",
      "display" : "Dose response gradient",
      "definition" : "higher certainty due to dose response relationship."
    },
    {
      "code" : "PlausibleConfounding",
      "display" : "Plausible confounding",
      "definition" : "higher certainty due to risk of bias in opposite direction."
    },
    {
      "code" : "LargeEffect",
      "display" : "Large effect",
      "definition" : "higher certainty due to large effect size."
    }
  ]
}

```
