# StatisticCertaintySubcomponentRating - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **StatisticCertaintySubcomponentRating**

## CodeSystem: StatisticCertaintySubcomponentRating 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/certainty-subcomponent-rating | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:StatisticCertaintySubcomponentRating |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1362 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The quality rating of the subcomponent of a quality of evidence rating. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [StatisticCertaintySubcomponentRating](ValueSet-certainty-subcomponent-rating.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "certainty-subcomponent-rating",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/certainty-subcomponent-rating",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1362"
    }
  ],
  "version" : "1.0.0",
  "name" : "StatisticCertaintySubcomponentRating",
  "title" : "StatisticCertaintySubcomponentRating",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The quality rating of the subcomponent of a quality of evidence rating.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/certainty-subcomponent-rating",
  "content" : "complete",
  "concept" : [
    {
      "code" : "no-change",
      "display" : "no change to rating",
      "definition" : "no change to quality rating."
    },
    {
      "code" : "downcode1",
      "display" : "reduce rating: -1",
      "definition" : "reduce quality rating by 1."
    },
    {
      "code" : "downcode2",
      "display" : "reduce rating: -2",
      "definition" : "reduce quality rating by 2."
    },
    {
      "code" : "downcode3",
      "display" : "reduce rating: -3",
      "definition" : "reduce quality rating by 3."
    },
    {
      "code" : "upcode1",
      "display" : "increase rating: +1",
      "definition" : "increase quality rating by 1."
    },
    {
      "code" : "upcode2",
      "display" : "increase rating: +2",
      "definition" : "increase quality rating by 2."
    },
    {
      "code" : "no-concern",
      "display" : "no serious concern",
      "definition" : "no serious concern."
    },
    {
      "code" : "serious-concern",
      "display" : "serious concern",
      "definition" : "serious concern."
    },
    {
      "code" : "critical-concern",
      "display" : "critical concern",
      "definition" : "critical concern."
    },
    {
      "code" : "present",
      "display" : "present",
      "definition" : "possible reason for increasing quality rating was checked and found to bepresent."
    },
    {
      "code" : "absent",
      "display" : "absent",
      "definition" : "possible reason for increasing quality rating was checked and found to be absent."
    }
  ]
}

```
