# CDS Hooks Indicator - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CDS Hooks Indicator**

## CodeSystem: CDS Hooks Indicator 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/cdshooks-indicator | *Version*:2.0.0 | |
| Draft as of 2025-11-13 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CDSHooksIndicator |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This codesystem captures the indicator codes defined by the CDS Hooks specification. The indicator is included as an element of the cards in a CDS Hooks response and conveys the urgency and/or importance of the information in each card. See[Card Attributes](https://cds-hooks.hl7.org/1.0/#card-attributes)in the CDS Hooks specification for more information. Note - the CodeSystem is transitioning from the Vocabulary Work Group to Clinical Decision Support (CDS) Work Group. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cdshooks-indicator",
  "meta" : {
    "lastUpdated" : "2023-02-07T06:31:57.154+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/cdshooks-indicator",
  "version" : "2.0.0",
  "name" : "CDSHooksIndicator",
  "title" : "CDS Hooks Indicator",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This codesystem captures the indicator codes defined by the CDS Hooks specification.    The indicator is included as an element of the cards in a CDS Hooks response and    conveys the urgency and/or importance of the information in each card. See [Card    Attributes](https://cds-hooks.hl7.org/1.0/#card-attributes) in the CDS Hooks specification    for more information. Note - the CodeSystem is transitioning from the Vocabulary Work Group to Clinical Decision Support (CDS) Work Group.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "info",
      "display" : "Information",
      "definition" : "The response is informational and indicates that it contains additional information      or relevant guidance that may be of interest"
    },
    {
      "code" : "warning",
      "display" : "Warning",
      "definition" : "The response is a warning and indicates that it contains urgent or highly relevant      information that should be considered"
    },
    {
      "code" : "critical",
      "display" : "Critical",
      "definition" : "The response is critical and indicates that it contains information or activities      that have high urgency and importance that should be immediately addressed"
    }
  ]
}

```
