# CatalogType - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CatalogType**

## CodeSystem: CatalogType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/catalogType | *Version*:1.0.1 | |
| Active as of 2024-04-24 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CatalogType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1288 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
The type of catalog. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CatalogType](ValueSet-catalogType.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "catalogType",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/catalogType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1288"
    }
  ],
  "version" : "1.0.1",
  "name" : "CatalogType",
  "title" : "CatalogType",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The type of catalog.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/catalogType",
  "content" : "complete",
  "concept" : [
    {
      "code" : "medication",
      "display" : "Medication Catalog",
      "definition" : "Medication Catalog."
    },
    {
      "code" : "device",
      "display" : "Device Catalog",
      "definition" : "Device Catalog."
    },
    {
      "code" : "protocol",
      "display" : "Protocol List",
      "definition" : "Protocol List."
    }
  ]
}

```
