# Benefit cost applicability - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Benefit cost applicability**

## CodeSystem: Benefit cost applicability 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/applicability | *Version*:1.0.1 | | |
| Active as of 2018-06-05 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:BenefitCostApplicability |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.0 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Whether the cost applies to in-network or out-of-network providers. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [BenefitCostApplicability](ValueSet-insuranceplan-applicability.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "applicability",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/applicability",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.0"
    }
  ],
  "version" : "1.0.1",
  "name" : "BenefitCostApplicability",
  "title" : "Benefit cost applicability",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-06-05T14:06:02+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Whether the cost applies to in-network or out-of-network providers.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/insuranceplan-applicability",
  "content" : "complete",
  "concept" : [
    {
      "code" : "in-network",
      "display" : "In Network",
      "definition" : "Provider is contracted with the health insurance company to provide services to plan members for specific pre-negotiated rates"
    },
    {
      "code" : "out-of-network",
      "display" : "Out of Network",
      "definition" : "Provider is  not contracted with the health insurance company to provide services to plan members for specific pre-negotiated rates"
    },
    {
      "code" : "other",
      "display" : "Other",
      "definition" : "Other applicability"
    }
  ]
}

```
