# Using CPT with HL7 Standards - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**External Content**](external_content.md)
* [**External Code Systems**](external_code_systems.md)
* **Using CPT with HL7 Standards**

## Using CPT with HL7 Standards

This page describes how to use CPT with HL7 Standards.

### Using CPT with FHIR R5

#### Summary

| | |
| :--- | :--- |
| Source | CPT is made managed by the[American Medical Association](http://www.ama-assn.org/ama) |
| System | The URI[http://www.ama-assn.org/go/cpt](http://www.ama-assn.org/go/cpt)identifies the CPT code system |
| Version | Where a version is appropriate, use the year of release e.g. 2014 |
| Code | "Code" in the CPT tables (a 5-character code), a modifier code (2 characters), or an expression with modifiers (see below) |
| Display | The correct display for a CPT code is one of the descriptions associated with the code. There are multiple description options that vary by length and target audience, including: long descriptions, medium descriptions, short descriptions, consumer friendly descriptors and clinician descriptors. The long mixed-case description is the preferred general purpose display as the others are not fully descriptive. There is no defined display for CPT expressions |
| Inactive | For CPT Link ontology licensees, inactive codes are listed in the History folder in the “Deleted_DTK_pipe” and “Deleted_DTK_tab” files.For CPT flat file licensees, codes that exist in the flat file are active and codes that are not present are inactive. Deletions/changes between the previous release year and current release year are displayed in the “Appendix B” PDF. |
| Subsumption | No Subsumption relationships are defined by CPT |
| Filter Properties | There are several defined - see below |

#### Version Issues

A new code-year of CPT is released by the end of August each year for use the subsequent calendar year. CPT versions are identified by the year of their intended use e.g. `2020`. For example, the CPT 2020 codes are released at the end of August 2019 and intended for use during the 2020 calendar year.

#### Example Usage

```

  <coding>
    <system value="http://www.ama-assn.org/go/cpt"/>
    <version value="2023"/>
    <code value="31502"/>
    <display value="Tracheotomy tube change prior to establishment of fistula tract"/>
  </coding>

```

#### Copyright/License Issues

CPT is a registered trademark of the American Medical Association. The AMA holds the copyright for the CPT coding system and a license is required for use.

When Value Sets include CPT codes, the `ValueSet.compose.include.copyright` element should have the text "CPT © Copyright 2023 American Medical Association. All rights reserved. AMA and CPT are registered trademarks of the American Medical Association.". The year in the copyright element should be adjusted to reflect the release year(s) being used.

 Note that due to the copyright and licensing rules around CPT, HL7 does not distribute a pre-built CodeSystem for CPT. If implementers would find a CPT code system useful, they may build one using the HL7 Java validator. See [HL7 Confluence](http://confluence/link/to/provide) for details. 

 With regard to version, the copyright phrase above SHOULD be included in the `ValueSet.copyright` statement for any value set that includes CPT codes. 

#### Modifier Syntax

 CPT defines a series of 2 letter modifier codes that provide additional information about the main CPT code. Some contexts of use of CPT codes separate the base code and the modifier codes into separate fields (e.g. claiming) while other contexts of use expect that the modifiers will be combined with the main code (e.g. Procedure.code). When the modifiers are combined in a single field, modifiers are appended to the main code in any order using `:` as a separater (per established X12 usage): 

```

  <coding>
    <system value="http://www.ama-assn.org/go/cpt"/>
    <version value="2023"/>
    <code value="21899:63"/>
  </coding>

```

 Notes: 

* Tthe combination of base code and modifiers must be done according to the rules defined in the CPT documentation
* Other separator characters are used in other contexts, including in the AMA documenation, notably `-` and `.`. Expressions using these separators are not conformant, and the separators must be replaced by `:`

#### CPT Concept Properties

This specification defines three properties that all CPT concepts have:

* Name: modifier
  * Cardinality: 1..1
  * Type: boolean
  * Description: True if the code is a 2 letter modifer code, and false otherwise. This property is defined to make it easy to define modifier only value sets (see value sets below)
* Name: modified
  * Cardinality: 1..1
  * Type: boolean
  * Description: Whether the code is an expression - i.e. whether it includes modifiers using the modifier syntax described above. All of the base codes defined in the CPT distribution have modified = false. This fairly trivial property is defined so it can be used in the filters below
* Name: kind
  * Cardinality: 0..*
  * Type: code
  * Description: The kind of CPT code. The values may be one of:* `code`: A base CPT code
* `cat-1`: CPT Level I Modifiers
* `cat-2`: A Category II code or modifier
* `physical-status`: Anesthesia Physical Status Modifiers
* `general`: A general modifier
* `hcpcs`: Level II (HCPCS/National) Modifiers
* `metadata`: A kind of code or designation
All predefined concepts have a type. Concepts defined by an expression do not have a kind. Note that some concepts have more than one kind: some general modifiers are cat-1 modifiers, but not all are, and orthopox codes are also normal CPT codes.
* Name: orthopox
  * Cardinality: 0..1
  * Type: boolean
  * Description: Whether code is one of the Pathology and Laboratory and Immunization Code(s) for Orthopoxvirus. This code might be used in some value set filters
* Name: telemedicine
  * Cardinality: 0..1
  * Type: boolean
  * Description: Whether code is one of the Pathology and Laboratory and Immunization Code(s) for telemedicine. This code might be used in some value set filters, and is defined for use internally by terminology servers when validating expressions for modifier 95

#### CPT Filter Properties

This specification defines six filters that may be used with the CPT code system.

* Name: modifier
  * Operation(s): =
  * Value(s): true or false
  * Description: Whether the code is a modifier or not (based on the modifier property). Typically, a value set would use`modifier=false`to specify base codes only, for example in`Claim.item.detail.productOrService`, while`modifier=true`woudl be used to specify modifier codes, for example in`Claim.item.detail.modifier`
* Name: kind
  * Operation(s): =/in
  * Value(s): a kind from the list above, or a comma seperated list of kinds
  * Description: Select a kind of code from the list above
* Name: modified
  * Operation(s): =
  * Value(s): true or false
  * Description: Whether an expression is allowed or not. A typical use of this would be with`Procedure.code`, a value set would specify two includes:`kind in code,cat-2`and`modified=true`, to indicate that CPT codes might be a base CPT code or an expression.
* Name: code
  * Operation(s): in
  * Value(s): a series of ranges seperated by commas
  * Description: Ranges may be a single code, or a range of codes e.g.`20100-69990, 92920, 92926-92928`
* Name: telemedicine
  * Operation(s): =
  * Value(s): true or false
  * Description: Select or unselect codes that are appropriate for use with the telemedicine modifier 95
* Name: orthopox
  * Operation(s): =
  * Value(s): true or false
  * Description: Select or unselect codes that are marked as orthopox codes

#### CPT Implicit Value Sets

There are no general implicit value set formula defined for CPT, but there are four predefined value sets that implementers may find generally useful: 

* url: `http://hl7.org/fhir/ValueSet/cpt-all`:a value set that includes all CPT codes (including base codes, modifiers and internal metadata)
  * Compose: ```"compose" : { "include" : [{ "system" : "http://www.ama-assn.org/go/cpt", "copyright" : "CPT © Copyright 2023 American Medical Association. All rights reserved. AMA and CPT are registered trademarks of the American Medical Association." }] }```Note that the include level copyright is an R5 feature. IN previous versions of FHIR, the copyright must go in ValueSet.copyright.
* url: `http://hl7.org/fhir/ValueSet/cpt-base`:All codes in CPT that represent procedure codes (no modifiers allowed - e.g. for Claim.item.productOrService)
  * Compose: ```"compose" : { "include" : [{ // plain codes (no modifiers) "system" : "http://www.ama-assn.org/go/cpt", "copyright" : "CPT © Copyright 2023 American Medical Association. All rights reserved. AMA and CPT are registered trademarks of the American Medical Association.", "filter" : [{ "property" : "modified", "op" : "=", "value" : "false" },{ "property" : "modifier", "op" : "=", "value" : "false" }] }] }```
* url: `http://hl7.org/fhir/ValueSet/cpt-modifiers`:CPT modifiers (e.g. for Claim.item.modifier)
  * Compose: ```"compose" : { "include" : [{ // only modifiers "system" : "http://www.ama-assn.org/go/cpt", "copyright" : "CPT © Copyright 2023 American Medical Association. All rights reserved. AMA and CPT are registered trademarks of the American Medical Association.", "filter" : [{ "property" : "modifier", "op" : "=", "value" : "true" }] }] }```
* url: `http://hl7.org/fhir/ValueSet/cpt-usable`:All codes in CPT codes (no modifiers) that represent procedure codes (e.g. for Procedure.code).
  * Compose: ```"compose" : { "include" : [{ // plain codes (no modifiers) "system" : "http://www.ama-assn.org/go/cpt", "copyright" : "CPT © Copyright 2023 American Medical Association. All rights reserved. AMA and CPT are registered trademarks of the American Medical Association.", "filter" : [{ "property" : "modified", "op" : "=", "value" : "false" },{ "property" : "modifier", "op" : "=", "value" : "false" }] },{ // codes with modifiers (grammar enforces rules) "system" : "http://www.ama-assn.org/go/cpt", "filter" : [{ "property" : "modified", "op" : "=", "value" : "true" }] }] }```

### Using CPT with earlier versions of FHIR

 This page documents the correct usage of CPT with R5, but the concepts apply to all versions of FHIR. Earlier versions of FHIR contained a 'Using CPT with HL7 FHIR RX page' (e.g. [R4](http://hl7.org/fhir/R4/cpt.html)). This page should be understood to replace those earlier pages. Note that this pages defines additional valid codes, properties, filters and the expression syntax which add facilities not previously described, but do not otherwise invalidate the advice in those earlier pages. 

