#  - HL7 Terminology (THO) v6.5.3

## : 



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "hxutg1-1-0-15",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-NDFRT-cs-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-NDFRT-cs-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-NDFRT-cs-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-NDFRT-cs-3-1-14</b></p><a name=\"hx1n-NDFRT-cs-3-1-14\"> </a><a name=\"hchx1n-NDFRT-cs-3-1-14\"> </a><p>Provenance for <a href=\"CodeSystem/NDFRT\">CodeSystem/NDFRT</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 15:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/NDFRT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T15:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Added National Drug File Reference Terminology (NDF-RT) Code System Metadata Record; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-UNII-cs-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-UNII-cs-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-UNII-cs-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-UNII-cs-3-1-14</b></p><a name=\"hx1n-UNII-cs-3-1-14\"> </a><a name=\"hchx1n-UNII-cs-3-1-14\"> </a><p>Provenance for <a href=\"CodeSystem/UNII\">CodeSystem/UNII</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 15:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/UNII"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T15:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Added Unique Ingredient Identifier (UNII) Code System Metadata Record; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-ISO3166Part1-cs-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-ISO3166Part1-cs-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-ISO3166Part1-cs-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-ISO3166Part1-cs-3-1-14</b></p><a name=\"hx1n-ISO3166Part1-cs-3-1-14\"> </a><a name=\"hchx1n-ISO3166Part1-cs-3-1-14\"> </a><p>Provenance for <a href=\"CodeSystem/ISO3166Part1\">CodeSystem/ISO3166Part1</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 15:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ISO3166Part1"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T15:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Added ISO 3166 Part 1 Code System Metadata Record; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-ISO3166Part2-cs-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-ISO3166Part2-cs-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-ISO3166Part2-cs-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-ISO3166Part2-cs-3-1-14</b></p><a name=\"hx1n-ISO3166Part2-cs-3-1-14\"> </a><a name=\"hchx1n-ISO3166Part2-cs-3-1-14\"> </a><p>Provenance for <a href=\"CodeSystem/ISO3166Part2\">CodeSystem/ISO3166Part2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 15:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ISO3166Part2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T15:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Added ISO 3166 Part 2 Code System Metadata Record; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-ISO3166Part3-cs-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-ISO3166Part3-cs-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-ISO3166Part3-cs-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-ISO3166Part3-cs-3-1-14</b></p><a name=\"hx1n-ISO3166Part3-cs-3-1-14\"> </a><a name=\"hchx1n-ISO3166Part3-cs-3-1-14\"> </a><p>Provenance for <a href=\"CodeSystem/ISO3166Part3\">CodeSystem/ISO3166Part3</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 15:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ISO3166Part3"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T15:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Added ISO 3166 Part 3 Code System Metadata Record; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-NDFRT-ns-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-NDFRT-ns-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-NDFRT-ns-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-NDFRT-ns-3-1-14</b></p><a name=\"hx1n-NDFRT-ns-3-1-14\"> </a><a name=\"hchx1n-NDFRT-ns-3-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-NDFRT.html\">NamingSystem National Drug File Reference Terminology (NDF-RT)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 15:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NDFRT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T15:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Added National Drug File Reference Terminology (NDF-RT) Code System Identifier Record; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-UNII-ns-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-UNII-ns-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-UNII-ns-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-UNII-ns-3-1-14</b></p><a name=\"hx1n-UNII-ns-3-1-14\"> </a><a name=\"hchx1n-UNII-ns-3-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-UNII.html\">NamingSystem Unique Ingredient Identifier (UNII)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 15:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/UNII"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T15:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Added Unique Ingredient Identifier (UNII) Code System Identifier Record; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-ISO3166Part1-ns-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-ISO3166Part1-ns-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-ISO3166Part1-ns-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-ISO3166Part1-ns-3-1-14</b></p><a name=\"hx1n-ISO3166Part1-ns-3-1-14\"> </a><a name=\"hchx1n-ISO3166Part1-ns-3-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-ISO3166Part1.html\">NamingSystem ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 15:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ISO3166Part1"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T15:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Added ISO 3166 Part 1 Code System Identifier Record; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-ISO3166Part2-ns-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-ISO3166Part2-ns-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-ISO3166Part2-ns-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-ISO3166Part2-ns-3-1-14</b></p><a name=\"hx1n-ISO3166Part2-ns-3-1-14\"> </a><a name=\"hchx1n-ISO3166Part2-ns-3-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-ISO3166Part2.html\">NamingSystem ISO 3166-2 Codes for the representation of names of countries and their subdivisions — Part 2: Country subdivision code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 15:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ISO3166Part2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T15:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Added ISO 3166 Part 2 Code System Identifier Record; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-ISO3166Part3-ns-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-ISO3166Part3-ns-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-ISO3166Part3-ns-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-ISO3166Part3-ns-3-1-14</b></p><a name=\"hx1n-ISO3166Part3-ns-3-1-14\"> </a><a name=\"hchx1n-ISO3166Part3-ns-3-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-ISO3166Part3.html\">NamingSystem ISO 3166-3 Codes for the representation of names of countries and their subdivisions — Part 3: Code for formerly used names of countries</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 15:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ISO3166Part3"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T15:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Added ISO 3166 Part 3 Code System Identifier Record; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-iso3166-1edition2alpha2-cs-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-iso3166-1edition2alpha2-cs-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-iso3166-1edition2alpha2-cs-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-iso3166-1edition2alpha2-cs-3-1-14</b></p><a name=\"hx1n-iso3166-1edition2alpha2-cs-3-1-14\"> </a><a name=\"hchx1n-iso3166-1edition2alpha2-cs-3-1-14\"> </a><p>Provenance for <a href=\"CodeSystem/iso3166-1edition2alpha2\">CodeSystem/iso3166-1edition2alpha2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2023-08-23 10:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/iso3166-1edition2alpha2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2023-08-23T10:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Code System Metadata Record being retired; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-iso3166-1edition2alpha3-cs-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-iso3166-1edition2alpha3-cs-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-iso3166-1edition2alpha3-cs-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-iso3166-1edition2alpha3-cs-3-1-14</b></p><a name=\"hx1n-iso3166-1edition2alpha3-cs-3-1-14\"> </a><a name=\"hchx1n-iso3166-1edition2alpha3-cs-3-1-14\"> </a><p>Provenance for <a href=\"CodeSystem/iso3166-1edition2alpha3\">CodeSystem/iso3166-1edition2alpha3</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2023-08-23 10:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/iso3166-1edition2alpha3"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2023-08-23T10:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Code System Metadata Record being retired; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-iso3166-2-cs-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-iso3166-2-cs-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-iso3166-2-cs-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-iso3166-2-cs-3-1-14</b></p><a name=\"hx1n-v3-iso3166-2-cs-3-1-14\"> </a><a name=\"hchx1n-v3-iso3166-2-cs-3-1-14\"> </a><p>Provenance for <a href=\"CodeSystem/v3-iso3166-2\">CodeSystem/v3-iso3166-2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2023-08-23 10:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-iso3166-2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2023-08-23T10:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Code System Metadata Record being retired; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-iso3166-1edition2-cs-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-iso3166-1edition2-cs-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-iso3166-1edition2-cs-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-iso3166-1edition2-cs-3-1-14</b></p><a name=\"hx1n-iso3166-1edition2-cs-3-1-14\"> </a><a name=\"hchx1n-iso3166-1edition2-cs-3-1-14\"> </a><p>Provenance for <a href=\"CodeSystem/iso3166-1edition2\">CodeSystem/iso3166-1edition2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2023-08-23 10:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/iso3166-1edition2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2023-08-23T10:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Code System Metadata Record being retired; UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-iso3166-1edition2alpha2-ns-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-iso3166-1edition2alpha2-ns-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-iso3166-1edition2alpha2-ns-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-iso3166-1edition2alpha2-ns-3-1-14</b></p><a name=\"hx1n-iso3166-1edition2alpha2-ns-3-1-14\"> </a><a name=\"hchx1n-iso3166-1edition2alpha2-ns-3-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-iso3166-1edition2alpha2.html\">NamingSystem ISO 3166 Part 1 Country Codes, 2nd Edition, Alpha-2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 10:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso3166-1edition2alpha2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T10:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Code System Identification Record being retired – UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-iso3166-1edition2alpha3-ns-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-iso3166-1edition2alpha3-ns-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-iso3166-1edition2alpha3-ns-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-iso3166-1edition2alpha3-ns-3-1-14</b></p><a name=\"hx1n-iso3166-1edition2alpha3-ns-3-1-14\"> </a><a name=\"hchx1n-iso3166-1edition2alpha3-ns-3-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-iso3166-1edition2alpha3.html\">NamingSystem ISO 3166 Part 1 Country Codes, 2nd Edition, Alpha-3</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 10:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso3166-1edition2alpha3"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T10:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Code System Identification Record being retired – UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-iso3166-2-ns-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-iso3166-2-ns-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-iso3166-2-ns-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-iso3166-2-ns-3-1-14</b></p><a name=\"hx1n-iso3166-2-ns-3-1-14\"> </a><a name=\"hchx1n-iso3166-2-ns-3-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-iso3166-2.html\">NamingSystem ISO 3166 Part 2 Country Subdivision Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 10:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso3166-2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T10:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Code System Identification Record being retired – UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-iso3166-1edition2-ns-3-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-iso3166-1edition2-ns-3-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-iso3166-1edition2-ns-3-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-iso3166-1edition2-ns-3-1-14</b></p><a name=\"hx1n-iso3166-1edition2-ns-3-1-14\"> </a><a name=\"hchx1n-iso3166-1edition2-ns-3-1-14\"> </a><p>Provenance for <a href=\"NamingSystem-iso3166-1edition2.html\">NamingSystem ISO 3166 Part 1 Country Codes, 2nd Edition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-23</td></tr><tr><td>Recorded</td><td>2022-08-23 10:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iso3166-1edition2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-23"
        },
        "recorded" : "2022-08-23T10:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Code System Identification Record being retired – UP-289"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-nciThesaurus-cs-3-0-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-nciThesaurus-cs-3-0-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-nciThesaurus-cs-3-0-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-nciThesaurus-cs-3-0-10</b></p><a name=\"hx1n-v3-nciThesaurus-cs-3-0-10\"> </a><a name=\"hchx1n-v3-nciThesaurus-cs-3-0-10\"> </a><p>Provenance for <a href=\"CodeSystem/v3-nciThesaurus\">CodeSystem/v3-nciThesaurus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-10-22</td></tr><tr><td>Recorded</td><td>2022-10-22 00:39:26-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-nciThesaurus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-10-22"
        },
        "recorded" : "2022-10-22T00:39:26-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update Preferred URI for NCI Thesaurus; up-345"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-nciThesaurus-ns-3-0-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-nciThesaurus-ns-3-0-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-nciThesaurus-ns-3-0-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-nciThesaurus-ns-3-0-10</b></p><a name=\"hx1n-v3-nciThesaurus-ns-3-0-10\"> </a><a name=\"hchx1n-v3-nciThesaurus-ns-3-0-10\"> </a><p>Provenance for <a href=\"NamingSystem-v3-nciThesaurus.html\">NamingSystem NCI Thesaurus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-10-22</td></tr><tr><td>Recorded</td><td>2022-10-22 00:39:33-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-nciThesaurus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-10-22"
        },
        "recorded" : "2022-10-22T00:39:33-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update Preferred URI for NCI Thesaurus; up-345"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-appropriateness-score-cs-3-0-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-appropriateness-score-cs-3-0-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-appropriateness-score-cs-3-0-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-appropriateness-score-cs-3-0-11</b></p><a name=\"hx1n-appropriateness-score-cs-3-0-11\"> </a><a name=\"hchx1n-appropriateness-score-cs-3-0-11\"> </a><p>Provenance for <a href=\"CodeSystem-appropriateness-score.html\">CodeSystem Appropriateness Score</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-10-22</td></tr><tr><td>Recorded</td><td>2022-10-22 11:12:07-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/appropriateness-score"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-10-22"
        },
        "recorded" : "2022-10-22T11:12:07-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create new CodeSystem for Appropriateness Score based upon RAND; up-360"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-appropriateness-score-vs-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-appropriateness-score-vs-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-appropriateness-score-vs-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-appropriateness-score-vs-3-0-12</b></p><a name=\"hx1n-appropriateness-score-vs-3-0-12\"> </a><a name=\"hchx1n-appropriateness-score-vs-3-0-12\"> </a><p>Provenance for <a href=\"ValueSet-appropriateness-score.html\">ValueSet Appropriateness Score</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-10-22</td></tr><tr><td>Recorded</td><td>2022-10-22 11:24:43-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/appropriateness-score"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-10-22"
        },
        "recorded" : "2022-10-22T11:24:43-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create Appropriateness Score Valueset; up-361"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-clinical-discharge-disposition-vs-3-0-13",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-clinical-discharge-disposition-vs-3-0-13",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-clinical-discharge-disposition-vs-3-0-13\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-clinical-discharge-disposition-vs-3-0-13</b></p><a name=\"hx1n-clinical-discharge-disposition-vs-3-0-13\"> </a><a name=\"hchx1n-clinical-discharge-disposition-vs-3-0-13\"> </a><p>Provenance for <a href=\"ValueSet-clinical-discharge-disposition.html\">ValueSet Clinical Discharge Disposition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-10-22</td></tr><tr><td>Recorded</td><td>2022-10-22 14:08:25-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/clinical-discharge-disposition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-10-22"
        },
        "recorded" : "2022-10-22T14:08:25-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create Clinical Discharge Disposition Valueset; up-362"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-HL7DocumentFormatCodes-cs-3-0-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-HL7DocumentFormatCodes-cs-3-0-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-HL7DocumentFormatCodes-cs-3-0-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-HL7DocumentFormatCodes-cs-3-0-14</b></p><a name=\"hx1n-v3-HL7DocumentFormatCodes-cs-3-0-14\"> </a><a name=\"hchx1n-v3-HL7DocumentFormatCodes-cs-3-0-14\"> </a><p>Provenance for <a href=\"CodeSystem-v3-HL7DocumentFormatCodes.html\">CodeSystem HL7 Document Format Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-10-22</td></tr><tr><td>Recorded</td><td>2022-10-22 14:14:19-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-HL7DocumentFormatCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-10-22"
        },
        "recorded" : "2022-10-22T14:14:19-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Please add additional format Codes to the http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes codeSystem; up-UP-337"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActCode-cs-3-0-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActCode-cs-3-0-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActCode-cs-3-0-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActCode-cs-3-0-1</b></p><a name=\"hx1n-v3-ActCode-cs-3-0-1\"> </a><a name=\"hchx1n-v3-ActCode-cs-3-0-1\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActCode.html\">CodeSystem ActCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-01-17</td></tr><tr><td>Recorded</td><td>2023-01-17 15:40:43-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Mohammad Jafari</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Security</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-01-17"
        },
        "recorded" : "2023-01-17T15:40:43-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "add a new code (HAS-INLINE-SEC-LABELS) to v3-ActCode to the value set ObligationPolicy; up-370"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Mohammad Jafari"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Security"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-DocumentSectionType-vs-3-0-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-DocumentSectionType-vs-3-0-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-DocumentSectionType-vs-3-0-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-DocumentSectionType-vs-3-0-1</b></p><a name=\"hx1n-v3-DocumentSectionType-vs-3-0-1\"> </a><a name=\"hchx1n-v3-DocumentSectionType-vs-3-0-1\"> </a><p>Provenance for <a href=\"ValueSet-v3-DocumentSectionType.html\">ValueSet DocumentSectionType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-01-17</td></tr><tr><td>Recorded</td><td>2023-01-17 16:11:01-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-DocumentSectionType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-01-17"
        },
        "recorded" : "2023-01-17T16:11:01-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "updating metada to add SD as steward of value set; up-a"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ParticipationType-cs-3-0-2",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ParticipationType-cs-3-0-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ParticipationType-cs-3-0-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ParticipationType-cs-3-0-2</b></p><a name=\"hx1n-v3-ParticipationType-cs-3-0-2\"> </a><a name=\"hchx1n-v3-ParticipationType-cs-3-0-2\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ParticipationType.html\">CodeSystem ParticipationType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-01-17</td></tr><tr><td>Recorded</td><td>2023-01-17 15:44:14-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ParticipationType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-01-17"
        },
        "recorded" : "2023-01-17T15:44:14-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Adding Witness and Notary terms to the Personal and Legal Relationship Value SEt; up-326"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-consent-verification-vs-3-0-3",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-consent-verification-vs-3-0-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-consent-verification-vs-3-0-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-consent-verification-vs-3-0-3</b></p><a name=\"hx1n-consent-verification-vs-3-0-3\"> </a><a name=\"hchx1n-consent-verification-vs-3-0-3\"> </a><p>Provenance for <a href=\"ValueSet-consent-verification.html\">ValueSet Consent Verification Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-01-24</td></tr><tr><td>Recorded</td><td>2023-01-24 09:04:21-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>David Pyke</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CBCP</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/consent-verification"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-01-24"
        },
        "recorded" : "2023-01-24T09:04:21-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Typo in ConsentVerificationCodes Title; up-254"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "David Pyke"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CBCP"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0871-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0871-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0871-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0871-vs-5-3-9</b></p><a name=\"hx1n-v2-0871-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0871-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0871.html\">ValueSet hl7VS-supplyRiskCodes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0871"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:48.36-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0881-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0881-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0881-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0881-vs-5-3-9</b></p><a name=\"hx1n-v2-0881-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0881-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0881.html\">ValueSet hl7VS-roleExecutingPhysician</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0881"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:48.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0882-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0882-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0882-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0882-vs-5-3-9</b></p><a name=\"hx1n-v2-0882-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0882-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0882.html\">ValueSet hl7VS-medicalRoleExecutingPhysician</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0882"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:49.18-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0894-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0894-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0894-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0894-vs-5-3-9</b></p><a name=\"hx1n-v2-0894-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0894-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0894.html\">ValueSet hl7VS-sideOfBody</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0894"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:49.60-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0895-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0895-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0895-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0895-vs-5-3-9</b></p><a name=\"hx1n-v2-0895-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0895-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0895.html\">ValueSet hl7VS-presentOnAdmission(poa)Indicator</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0895"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:50.01-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0904-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0904-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0904-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0904-vs-5-3-9</b></p><a name=\"hx1n-v2-0904-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0904-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0904.html\">ValueSet hl7VS-securityCheckScheme</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0904"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:50.44-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0905-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0905-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0905-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0905-vs-5-3-9</b></p><a name=\"hx1n-v2-0905-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0905-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0905.html\">ValueSet hl7VS-shipmentStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0905"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:50.86-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0906-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0906-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0906-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0906-vs-5-3-9</b></p><a name=\"hx1n-v2-0906-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0906-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0906.html\">ValueSet hl7VS-actpriority</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0906"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:51.29-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0907-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0907-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0907-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0907-vs-5-3-9</b></p><a name=\"hx1n-v2-0907-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0907-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0907.html\">ValueSet hl7VS-confidentiality</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0907"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:51.69-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0909-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0909-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0909-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0909-vs-5-3-9</b></p><a name=\"hx1n-v2-0909-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0909-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0909.html\">ValueSet hl7VS-patientResultsReleaseCategorizationScheme</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0909"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:52.10-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0912-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0912-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0912-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0912-vs-5-3-9</b></p><a name=\"hx1n-v2-0912-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0912-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0912.html\">ValueSet hl7VS-participation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0912"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:52.49-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0914-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0914-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0914-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0914-vs-5-3-9</b></p><a name=\"hx1n-v2-0914-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0914-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0914.html\">ValueSet hl7VS-rootCause</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0914"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:52.89-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0916-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0916-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0916-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0916-vs-5-3-9</b></p><a name=\"hx1n-v2-0916-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0916-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0916.html\">ValueSet hl7VS-relevantClincialInformation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0916"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:53.30-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0917-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0917-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0917-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0917-vs-5-3-9</b></p><a name=\"hx1n-v2-0917-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0917-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0917.html\">ValueSet hl7VS-bolusType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0917"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:53.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0918-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0918-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0918-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0918-vs-5-3-9</b></p><a name=\"hx1n-v2-0918-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0918-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0918.html\">ValueSet hl7VS-pcaType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0918"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:54.10-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0919-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0919-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0919-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0919-vs-5-3-9</b></p><a name=\"hx1n-v2-0919-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0919-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0919.html\">ValueSet hl7VS-exclusiveTest</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0919"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:54.51-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0920-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0920-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0920-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0920-vs-5-3-9</b></p><a name=\"hx1n-v2-0920-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0920-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0920.html\">ValueSet hl7VS-preferredSpecimen-AttributeStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0920"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:54.91-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0921-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0921-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0921-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0921-vs-5-3-9</b></p><a name=\"hx1n-v2-0921-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0921-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0921.html\">ValueSet hl7VS-certificationTypeCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:55-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0921"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:55.34-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0922-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0922-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0922-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0922-vs-5-3-9</b></p><a name=\"hx1n-v2-0922-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0922-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0922.html\">ValueSet hl7VS-certificationCategoryCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:55-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0922"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:55.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0923-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0923-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0923-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0923-vs-5-3-9</b></p><a name=\"hx1n-v2-0923-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0923-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0923.html\">ValueSet hl7VS-processInterruption</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:56-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0923"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:56.17-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0924-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0924-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0924-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0924-vs-5-3-9</b></p><a name=\"hx1n-v2-0924-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0924-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0924.html\">ValueSet hl7VS-cumulativeDosageLimitUom</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:56-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0924"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:56.60-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0925-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0925-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0925-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0925-vs-5-3-9</b></p><a name=\"hx1n-v2-0925-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0925-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0925.html\">ValueSet hl7VS-phlebotomyIssue</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0925"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:57.02-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0926-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0926-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0926-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0926-vs-5-3-9</b></p><a name=\"hx1n-v2-0926-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0926-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0926.html\">ValueSet hl7VS-phlebotomyStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0926"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:57.45-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0927-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0927-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0927-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0927-vs-5-3-9</b></p><a name=\"hx1n-v2-0927-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0927-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0927.html\">ValueSet hl7VS-armStick</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0927"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:57.87-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0929-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0929-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0929-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0929-vs-5-3-9</b></p><a name=\"hx1n-v2-0929-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0929-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0929.html\">ValueSet hl7VS-weightUnits</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:58-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0929"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:58.30-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0930-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0930-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0930-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0930-vs-5-3-9</b></p><a name=\"hx1n-v2-0930-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0930-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0930.html\">ValueSet hl7VS-volumeUnits</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:58-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0930"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:58.72-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0931-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0931-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0931-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0931-vs-5-3-9</b></p><a name=\"hx1n-v2-0931-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0931-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0931.html\">ValueSet hl7VS-temperatureUnits</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:59-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0931"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:59.13-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0932-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0932-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0932-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0932-vs-5-3-9</b></p><a name=\"hx1n-v2-0932-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0932-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0932.html\">ValueSet hl7VS-donationDurationUnits</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:59-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0932"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:59.56-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0933-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0933-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0933-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0933-vs-5-3-9</b></p><a name=\"hx1n-v2-0933-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0933-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0933.html\">ValueSet hl7VS-intendedProcedureType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:48:59-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0933"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:48:59.98-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0935-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0935-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0935-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0935-vs-5-3-9</b></p><a name=\"hx1n-v2-0935-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0935-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0935.html\">ValueSet hl7VS-processInterruptionReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:00-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0935"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:00.40-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0936-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0936-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0936-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0936-vs-5-3-9</b></p><a name=\"hx1n-v2-0936-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0936-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0936.html\">ValueSet hl7VS-VS-observationType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:00-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0936"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:00.81-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0937-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0937-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0937-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0937-vs-5-3-9</b></p><a name=\"hx1n-v2-0937-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0937-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0937.html\">ValueSet hl7VS-VS-observationSubtype</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:01-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0937"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:01.23-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0938-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0938-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0938-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0938-vs-5-3-9</b></p><a name=\"hx1n-v2-0938-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0938-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0938.html\">ValueSet hl7VS-VS-collectionEvent</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:01-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0938"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:01.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0939-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0939-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0939-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0939-vs-5-3-9</b></p><a name=\"hx1n-v2-0939-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0939-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0939.html\">ValueSet hl7VS-VS-communicationLocation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:02-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0939"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:02.06-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0940-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0940-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0940-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0940-vs-5-3-9</b></p><a name=\"hx1n-v2-0940-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0940-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0940.html\">ValueSet hl7VS-VS-limitationTypeCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:02-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0940"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:02.51-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0942-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0942-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0942-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0942-vs-5-3-9</b></p><a name=\"hx1n-v2-0942-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0942-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0942.html\">ValueSet V2 Table 0942 Version Master</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:02-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0942"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:02.96-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0945-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0945-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0945-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0945-vs-5-3-9</b></p><a name=\"hx1n-v2-0945-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0945-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0945.html\">ValueSet hl7VS-auto-DilutionType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:03-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0945"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:03.38-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0946-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0946-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0946-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0946-vs-5-3-9</b></p><a name=\"hx1n-v2-0946-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0946-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0946.html\">ValueSet hl7VS-supplierType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:03-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0946"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:03.80-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0948-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0948-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0948-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0948-vs-5-3-9</b></p><a name=\"hx1n-v2-0948-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0948-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0948.html\">ValueSet hl7VS-relationshipType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:04-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0948"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:04.21-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0949-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0949-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0949-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0949-vs-5-3-9</b></p><a name=\"hx1n-v2-0949-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0949-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0949.html\">ValueSet hl7VS-orderControlCodeReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:04-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0949"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:04.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0950-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0950-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0950-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0950-vs-5-3-9</b></p><a name=\"hx1n-v2-0950-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0950-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0950.html\">ValueSet hl7VS-orderStatusModifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0950"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:05.07-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0951-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0951-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0951-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0951-vs-5-3-9</b></p><a name=\"hx1n-v2-0951-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0951-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0951.html\">ValueSet hl7VS-ReasonForStudy</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0951"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:05.49-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0952-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0952-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0952-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0952-vs-5-3-9</b></p><a name=\"hx1n-v2-0952-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0952-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0952.html\">ValueSet Confidentiality</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0952"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:05.89-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0959-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0959-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0959-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0959-vs-5-3-9</b></p><a name=\"hx1n-v2-0959-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0959-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0959.html\">ValueSet workClassificationODH</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:06-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0959"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:06.29-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0961-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0961-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0961-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0961-vs-5-3-9</b></p><a name=\"hx1n-v2-0961-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0961-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0961.html\">ValueSet DeviceType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:06-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0961"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:06.70-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0962-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0962-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0962-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0962-vs-5-3-9</b></p><a name=\"hx1n-v2-0962-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0962-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0962.html\">ValueSet FHIRdeviceStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0962"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:07.11-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0970-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0970-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0970-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0970-vs-5-3-9</b></p><a name=\"hx1n-v2-0970-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0970-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0970.html\">ValueSet hl7VS-onlineVerificationResult</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0970"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:07.95-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-0971-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-0971-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-0971-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-0971-vs-5-3-9</b></p><a name=\"hx1n-v2-0971-vs-5-3-9\"> </a><a name=\"hchx1n-v2-0971-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-0971.html\">ValueSet hl7VS-onlineVerificationResultErrorCodes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:08-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-0971"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:08.34-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-4000-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-4000-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-4000-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-4000-vs-5-3-9</b></p><a name=\"hx1n-v2-4000-vs-5-3-9\"> </a><a name=\"hchx1n-v2-4000-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-4000.html\">ValueSet hl7VS-name-addressRepresentation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:08-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-4000"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:08.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-notAllCodes-0291-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-notAllCodes-0291-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-notAllCodes-0291-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-notAllCodes-0291-vs-5-3-9</b></p><a name=\"hx1n-v2-notAllCodes-0291-vs-5-3-9\"> </a><a name=\"hchx1n-v2-notAllCodes-0291-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-notAllCodes-0291.html\">ValueSet hl7VS-subtypeOfReferencedData</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:09-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-notAllCodes-0291"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:09.17-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-notAllCodes-0347-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-notAllCodes-0347-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-notAllCodes-0347-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-notAllCodes-0347-vs-5-3-9</b></p><a name=\"hx1n-v2-notAllCodes-0347-vs-5-3-9\"> </a><a name=\"hchx1n-v2-notAllCodes-0347-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-notAllCodes-0347.html\">ValueSet HL7 Value Set for State/Province</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:09-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-notAllCodes-0347"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:09.59-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v2-notAllCodes-0399-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v2-notAllCodes-0399-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v2-notAllCodes-0399-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v2-notAllCodes-0399-vs-5-3-9</b></p><a name=\"hx1n-v2-notAllCodes-0399-vs-5-3-9\"> </a><a name=\"hchx1n-v2-notAllCodes-0399-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v2-notAllCodes-0399.html\">ValueSet hl7VS-countryCode-3alpha</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v2-notAllCodes-0399"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:10.01-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AcknowledgementCondition-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AcknowledgementCondition-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AcknowledgementCondition-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AcknowledgementCondition-cs-5-3-9</b></p><a name=\"hx1n-v3-AcknowledgementCondition-cs-5-3-9\"> </a><a name=\"hchx1n-v3-AcknowledgementCondition-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-AcknowledgementCondition.html\">CodeSystem AcknowledgementCondition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-AcknowledgementCondition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:10.42-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AcknowledgementDetailCode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AcknowledgementDetailCode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AcknowledgementDetailCode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AcknowledgementDetailCode-cs-5-3-9</b></p><a name=\"hx1n-v3-AcknowledgementDetailCode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-AcknowledgementDetailCode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-AcknowledgementDetailCode.html\">CodeSystem AcknowledgementDetailCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-AcknowledgementDetailCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:10.85-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AcknowledgementDetailType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AcknowledgementDetailType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AcknowledgementDetailType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AcknowledgementDetailType-cs-5-3-9</b></p><a name=\"hx1n-v3-AcknowledgementDetailType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-AcknowledgementDetailType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-AcknowledgementDetailType.html\">CodeSystem AcknowledgementDetailType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:11-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-AcknowledgementDetailType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:11.28-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AcknowledgementType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AcknowledgementType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AcknowledgementType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AcknowledgementType-cs-5-3-9</b></p><a name=\"hx1n-v3-AcknowledgementType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-AcknowledgementType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-AcknowledgementType.html\">CodeSystem AcknowledgementType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:11-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-AcknowledgementType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:11.70-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClass-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClass-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClass-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClass-cs-5-3-9</b></p><a name=\"hx1n-v3-ActClass-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClass-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActClass.html\">CodeSystem ActClass</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActClass"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:12.12-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActCode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActCode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActCode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActCode-cs-5-3-9</b></p><a name=\"hx1n-v3-ActCode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActCode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActCode.html\">CodeSystem ActCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:12.53-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActExposureLevelCode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActExposureLevelCode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActExposureLevelCode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActExposureLevelCode-cs-5-3-9</b></p><a name=\"hx1n-v3-ActExposureLevelCode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActExposureLevelCode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActExposureLevelCode.html\">CodeSystem ActExposureLevelCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActExposureLevelCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:12.93-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActInvoiceElementModifier-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActInvoiceElementModifier-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActInvoiceElementModifier-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActInvoiceElementModifier-cs-5-3-9</b></p><a name=\"hx1n-v3-ActInvoiceElementModifier-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActInvoiceElementModifier-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActInvoiceElementModifier.html\">CodeSystem ActInvoiceElementModifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActInvoiceElementModifier"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:13.35-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActMood-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActMood-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActMood-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActMood-cs-5-3-9</b></p><a name=\"hx1n-v3-ActMood-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActMood-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActMood.html\">CodeSystem ActMood</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActMood"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:13.78-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActPriority-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActPriority-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActPriority-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActPriority-cs-5-3-9</b></p><a name=\"hx1n-v3-ActPriority-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActPriority-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActPriority.html\">CodeSystem ActPriority</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:14-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActPriority"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:14.20-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActReason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActReason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActReason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActReason-cs-5-3-9</b></p><a name=\"hx1n-v3-ActReason-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActReason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActReason.html\">CodeSystem ActReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:14-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActReason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:14.60-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActRelationshipCheckpoint-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActRelationshipCheckpoint-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActRelationshipCheckpoint-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActRelationshipCheckpoint-cs-5-3-9</b></p><a name=\"hx1n-v3-ActRelationshipCheckpoint-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActRelationshipCheckpoint-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActRelationshipCheckpoint.html\">CodeSystem ActRelationshipCheckpoint</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActRelationshipCheckpoint"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:15.02-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActRelationshipJoin-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActRelationshipJoin-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActRelationshipJoin-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActRelationshipJoin-cs-5-3-9</b></p><a name=\"hx1n-v3-ActRelationshipJoin-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActRelationshipJoin-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActRelationshipJoin.html\">CodeSystem ActRelationshipJoin</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActRelationshipJoin"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:15.43-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActRelationshipSplit-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActRelationshipSplit-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActRelationshipSplit-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActRelationshipSplit-cs-5-3-9</b></p><a name=\"hx1n-v3-ActRelationshipSplit-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActRelationshipSplit-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActRelationshipSplit.html\">CodeSystem ActRelationshipSplit</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActRelationshipSplit"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:15.85-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActRelationshipSubset-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActRelationshipSubset-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActRelationshipSubset-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActRelationshipSubset-cs-5-3-9</b></p><a name=\"hx1n-v3-ActRelationshipSubset-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActRelationshipSubset-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActRelationshipSubset.html\">CodeSystem ActRelationshipSubset</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:16-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActRelationshipSubset"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:16.28-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActRelationshipType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActRelationshipType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActRelationshipType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActRelationshipType-cs-5-3-9</b></p><a name=\"hx1n-v3-ActRelationshipType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActRelationshipType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActRelationshipType.html\">CodeSystem ActRelationshipType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:16-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActRelationshipType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:16.69-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActSite-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActSite-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActSite-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActSite-cs-5-3-9</b></p><a name=\"hx1n-v3-ActSite-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActSite-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActSite.html\">CodeSystem ActSite</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:17-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActSite"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:17.09-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActStatus-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActStatus-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActStatus-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActStatus-cs-5-3-9</b></p><a name=\"hx1n-v3-ActStatus-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActStatus-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActStatus.html\">CodeSystem ActStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:17-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActStatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:17.51-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActUncertainty-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActUncertainty-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActUncertainty-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActUncertainty-cs-5-3-9</b></p><a name=\"hx1n-v3-ActUncertainty-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActUncertainty-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActUncertainty.html\">CodeSystem ActUncertainty</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:17-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActUncertainty"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:17.92-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActUSPrivacyLaw-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActUSPrivacyLaw-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActUSPrivacyLaw-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActUSPrivacyLaw-cs-5-3-9</b></p><a name=\"hx1n-v3-ActUSPrivacyLaw-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ActUSPrivacyLaw-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActUSPrivacyLaw.html\">CodeSystem ActUSPrivacyLaw</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:18-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActUSPrivacyLaw"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:18.32-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AddressPartType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AddressPartType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AddressPartType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AddressPartType-cs-5-3-9</b></p><a name=\"hx1n-v3-AddressPartType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-AddressPartType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-AddressPartType.html\">CodeSystem AddressPartType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:18-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-AddressPartType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:18.74-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AddressUse-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AddressUse-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AddressUse-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AddressUse-cs-5-3-9</b></p><a name=\"hx1n-v3-AddressUse-cs-5-3-9\"> </a><a name=\"hchx1n-v3-AddressUse-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-AddressUse.html\">CodeSystem AddressUse</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-AddressUse"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:19.15-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AdministrativeGender-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AdministrativeGender-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AdministrativeGender-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AdministrativeGender-cs-5-3-9</b></p><a name=\"hx1n-v3-AdministrativeGender-cs-5-3-9\"> </a><a name=\"hchx1n-v3-AdministrativeGender-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-AdministrativeGender.html\">CodeSystem AdministrativeGender</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-AdministrativeGender"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:19.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AmericanIndianAlaskaNativeLanguages-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AmericanIndianAlaskaNativeLanguages-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AmericanIndianAlaskaNativeLanguages-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AmericanIndianAlaskaNativeLanguages-cs-5-3-9</b></p><a name=\"hx1n-v3-AmericanIndianAlaskaNativeLanguages-cs-5-3-9\"> </a><a name=\"hchx1n-v3-AmericanIndianAlaskaNativeLanguages-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-AmericanIndianAlaskaNativeLanguages.html\">CodeSystem AmericanIndianAlaskaNativeLanguages</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-AmericanIndianAlaskaNativeLanguages"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:19.94-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-Calendar-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-Calendar-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-Calendar-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-Calendar-cs-5-3-9</b></p><a name=\"hx1n-v3-Calendar-cs-5-3-9\"> </a><a name=\"hchx1n-v3-Calendar-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-Calendar.html\">CodeSystem Calendar</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:20-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-Calendar"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:20.33-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-CalendarCycle-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-CalendarCycle-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-CalendarCycle-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-CalendarCycle-cs-5-3-9</b></p><a name=\"hx1n-v3-CalendarCycle-cs-5-3-9\"> </a><a name=\"hchx1n-v3-CalendarCycle-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-CalendarCycle.html\">CodeSystem Calendar Cycle Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:20-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-CalendarCycle"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:20.73-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-CalendarType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-CalendarType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-CalendarType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-CalendarType-cs-5-3-9</b></p><a name=\"hx1n-v3-CalendarType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-CalendarType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-CalendarType.html\">CodeSystem CalendarType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-CalendarType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:21.14-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-Charset-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-Charset-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-Charset-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-Charset-cs-5-3-9</b></p><a name=\"hx1n-v3-Charset-cs-5-3-9\"> </a><a name=\"hchx1n-v3-Charset-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-Charset.html\">CodeSystem Charset</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-Charset"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:21.53-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-CodingRationale-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-CodingRationale-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-CodingRationale-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-CodingRationale-cs-5-3-9</b></p><a name=\"hx1n-v3-CodingRationale-cs-5-3-9\"> </a><a name=\"hchx1n-v3-CodingRationale-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-CodingRationale.html\">CodeSystem CodingRationale</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-CodingRationale"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:21.93-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-CommunicationFunctionType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-CommunicationFunctionType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-CommunicationFunctionType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-CommunicationFunctionType-cs-5-3-9</b></p><a name=\"hx1n-v3-CommunicationFunctionType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-CommunicationFunctionType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-CommunicationFunctionType.html\">CodeSystem CommunicationFunctionType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-CommunicationFunctionType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:22.40-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-CompressionAlgorithm-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-CompressionAlgorithm-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-CompressionAlgorithm-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-CompressionAlgorithm-cs-5-3-9</b></p><a name=\"hx1n-v3-CompressionAlgorithm-cs-5-3-9\"> </a><a name=\"hchx1n-v3-CompressionAlgorithm-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-CompressionAlgorithm.html\">CodeSystem CompressionAlgorithm</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-CompressionAlgorithm"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:22.91-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-Confidentiality-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-Confidentiality-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-Confidentiality-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-Confidentiality-cs-5-3-9</b></p><a name=\"hx1n-v3-Confidentiality-cs-5-3-9\"> </a><a name=\"hchx1n-v3-Confidentiality-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-Confidentiality.html\">CodeSystem Confidentiality</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:23-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-Confidentiality"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:23.35-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ContainerCap-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ContainerCap-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ContainerCap-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ContainerCap-cs-5-3-9</b></p><a name=\"hx1n-v3-ContainerCap-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ContainerCap-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ContainerCap.html\">CodeSystem ContainerCap</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:23-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ContainerCap"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:23.77-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ContainerSeparator-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ContainerSeparator-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ContainerSeparator-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ContainerSeparator-cs-5-3-9</b></p><a name=\"hx1n-v3-ContainerSeparator-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ContainerSeparator-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ContainerSeparator.html\">CodeSystem ContainerSeparator</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:24-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ContainerSeparator"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:24.21-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ContentProcessingMode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ContentProcessingMode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ContentProcessingMode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ContentProcessingMode-cs-5-3-9</b></p><a name=\"hx1n-v3-ContentProcessingMode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ContentProcessingMode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ContentProcessingMode.html\">CodeSystem ContentProcessingMode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:24-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ContentProcessingMode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:24.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ContextControl-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ContextControl-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ContextControl-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ContextControl-cs-5-3-9</b></p><a name=\"hx1n-v3-ContextControl-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ContextControl-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ContextControl.html\">CodeSystem ContextControl</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ContextControl"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:25.04-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-DataOperation-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-DataOperation-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-DataOperation-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-DataOperation-cs-5-3-9</b></p><a name=\"hx1n-v3-DataOperation-cs-5-3-9\"> </a><a name=\"hchx1n-v3-DataOperation-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-DataOperation.html\">CodeSystem DataOperation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-DataOperation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:25.44-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-Dentition-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-Dentition-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-Dentition-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-Dentition-cs-5-3-9</b></p><a name=\"hx1n-v3-Dentition-cs-5-3-9\"> </a><a name=\"hchx1n-v3-Dentition-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-Dentition.html\">CodeSystem Dentition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-Dentition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:25.84-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-DeviceAlertLevel-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-DeviceAlertLevel-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-DeviceAlertLevel-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-DeviceAlertLevel-cs-5-3-9</b></p><a name=\"hx1n-v3-DeviceAlertLevel-cs-5-3-9\"> </a><a name=\"hchx1n-v3-DeviceAlertLevel-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-DeviceAlertLevel.html\">CodeSystem DeviceAlertLevel</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-DeviceAlertLevel"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:26.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-DocumentCompletion-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-DocumentCompletion-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-DocumentCompletion-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-DocumentCompletion-cs-5-3-9</b></p><a name=\"hx1n-v3-DocumentCompletion-cs-5-3-9\"> </a><a name=\"hchx1n-v3-DocumentCompletion-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-DocumentCompletion.html\">CodeSystem DocumentCompletion</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-DocumentCompletion"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:26.69-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-DocumentStorage-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-DocumentStorage-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-DocumentStorage-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-DocumentStorage-cs-5-3-9</b></p><a name=\"hx1n-v3-DocumentStorage-cs-5-3-9\"> </a><a name=\"hchx1n-v3-DocumentStorage-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-DocumentStorage.html\">CodeSystem DocumentStorage</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:27-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-DocumentStorage"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:27.12-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EducationLevel-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EducationLevel-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EducationLevel-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EducationLevel-cs-5-3-9</b></p><a name=\"hx1n-v3-EducationLevel-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EducationLevel-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EducationLevel.html\">CodeSystem Education Level</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:27-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EducationLevel"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:27.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EmployeeJobClass-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EmployeeJobClass-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EmployeeJobClass-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EmployeeJobClass-cs-5-3-9</b></p><a name=\"hx1n-v3-EmployeeJobClass-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EmployeeJobClass-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EmployeeJobClass.html\">CodeSystem EmployeeJobClass</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:27-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EmployeeJobClass"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:27.94-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EncounterAdmissionSource-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EncounterAdmissionSource-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EncounterAdmissionSource-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EncounterAdmissionSource-cs-5-3-9</b></p><a name=\"hx1n-v3-EncounterAdmissionSource-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EncounterAdmissionSource-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EncounterAdmissionSource.html\">CodeSystem EncounterAdmissionSource</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:28-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EncounterAdmissionSource"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:28.35-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EncounterSpecialCourtesy-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EncounterSpecialCourtesy-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EncounterSpecialCourtesy-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EncounterSpecialCourtesy-cs-5-3-9</b></p><a name=\"hx1n-v3-EncounterSpecialCourtesy-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EncounterSpecialCourtesy-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EncounterSpecialCourtesy.html\">CodeSystem EncounterSpecialCourtesy</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:28-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EncounterSpecialCourtesy"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:28.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EntityClass-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EntityClass-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EntityClass-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EntityClass-cs-5-3-9</b></p><a name=\"hx1n-v3-EntityClass-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EntityClass-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EntityClass.html\">CodeSystem EntityClass</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EntityClass"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:29.17-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EntityCode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EntityCode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EntityCode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EntityCode-cs-5-3-9</b></p><a name=\"hx1n-v3-EntityCode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EntityCode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EntityCode.html\">CodeSystem EntityCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EntityCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:29.56-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EntityDeterminer-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EntityDeterminer-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EntityDeterminer-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EntityDeterminer-cs-5-3-9</b></p><a name=\"hx1n-v3-EntityDeterminer-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EntityDeterminer-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EntityDeterminer.html\">CodeSystem EntityDeterminer</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EntityDeterminer"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:29.97-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EntityHandling-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EntityHandling-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EntityHandling-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EntityHandling-cs-5-3-9</b></p><a name=\"hx1n-v3-EntityHandling-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EntityHandling-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EntityHandling.html\">CodeSystem EntityHandling</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:30-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EntityHandling"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:30.39-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EntityNamePartQualifier-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EntityNamePartQualifier-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EntityNamePartQualifier-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EntityNamePartQualifier-cs-5-3-9</b></p><a name=\"hx1n-v3-EntityNamePartQualifier-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EntityNamePartQualifier-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EntityNamePartQualifier.html\">CodeSystem EntityNamePartQualifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:30-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EntityNamePartQualifier"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:30.81-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EntityNamePartQualifierR2-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EntityNamePartQualifierR2-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EntityNamePartQualifierR2-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EntityNamePartQualifierR2-cs-5-3-9</b></p><a name=\"hx1n-v3-EntityNamePartQualifierR2-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EntityNamePartQualifierR2-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EntityNamePartQualifierR2.html\">CodeSystem EntityNamePartQualifierR2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EntityNamePartQualifierR2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:31.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EntityNamePartType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EntityNamePartType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EntityNamePartType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EntityNamePartType-cs-5-3-9</b></p><a name=\"hx1n-v3-EntityNamePartType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EntityNamePartType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EntityNamePartType.html\">CodeSystem EntityNamePartType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EntityNamePartType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:31.65-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EntityNamePartTypeR2-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EntityNamePartTypeR2-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EntityNamePartTypeR2-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EntityNamePartTypeR2-cs-5-3-9</b></p><a name=\"hx1n-v3-EntityNamePartTypeR2-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EntityNamePartTypeR2-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EntityNamePartTypeR2.html\">CodeSystem EntityNamePartTypeR2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:32-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EntityNamePartTypeR2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:32.09-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EntityNameUse-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EntityNameUse-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EntityNameUse-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EntityNameUse-cs-5-3-9</b></p><a name=\"hx1n-v3-EntityNameUse-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EntityNameUse-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EntityNameUse.html\">CodeSystem EntityNameUse</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:32-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EntityNameUse"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:32.51-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EntityNameUseR2-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EntityNameUseR2-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EntityNameUseR2-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EntityNameUseR2-cs-5-3-9</b></p><a name=\"hx1n-v3-EntityNameUseR2-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EntityNameUseR2-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EntityNameUseR2.html\">CodeSystem EntityNameUseR2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:32-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EntityNameUseR2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:32.93-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EntityRisk-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EntityRisk-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EntityRisk-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EntityRisk-cs-5-3-9</b></p><a name=\"hx1n-v3-EntityRisk-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EntityRisk-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EntityRisk.html\">CodeSystem EntityRisk</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EntityRisk"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:33.35-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EntityStatus-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EntityStatus-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EntityStatus-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EntityStatus-cs-5-3-9</b></p><a name=\"hx1n-v3-EntityStatus-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EntityStatus-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EntityStatus.html\">CodeSystem EntityStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EntityStatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:33.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-EquipmentAlertLevel-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-EquipmentAlertLevel-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-EquipmentAlertLevel-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-EquipmentAlertLevel-cs-5-3-9</b></p><a name=\"hx1n-v3-EquipmentAlertLevel-cs-5-3-9\"> </a><a name=\"hchx1n-v3-EquipmentAlertLevel-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-EquipmentAlertLevel.html\">CodeSystem EquipmentAlertLevel</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:34-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-EquipmentAlertLevel"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:34.17-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-Ethnicity-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-Ethnicity-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-Ethnicity-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-Ethnicity-cs-5-3-9</b></p><a name=\"hx1n-v3-Ethnicity-cs-5-3-9\"> </a><a name=\"hchx1n-v3-Ethnicity-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-Ethnicity.html\">CodeSystem Ethnicity</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:34-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-Ethnicity"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:34.56-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ExposureMode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ExposureMode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ExposureMode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ExposureMode-cs-5-3-9</b></p><a name=\"hx1n-v3-ExposureMode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ExposureMode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ExposureMode.html\">CodeSystem ExposureMode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:34-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ExposureMode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:34.98-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-GenderStatus-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-GenderStatus-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-GenderStatus-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-GenderStatus-cs-5-3-9</b></p><a name=\"hx1n-v3-GenderStatus-cs-5-3-9\"> </a><a name=\"hchx1n-v3-GenderStatus-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-GenderStatus.html\">CodeSystem GenderStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-GenderStatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:35.38-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-GTSAbbreviation-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-GTSAbbreviation-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-GTSAbbreviation-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-GTSAbbreviation-cs-5-3-9</b></p><a name=\"hx1n-v3-GTSAbbreviation-cs-5-3-9\"> </a><a name=\"hchx1n-v3-GTSAbbreviation-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-GTSAbbreviation.html\">CodeSystem GTSAbbreviation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-GTSAbbreviation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:35.80-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-hl7ApprovalStatus-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-hl7ApprovalStatus-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-hl7ApprovalStatus-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-hl7ApprovalStatus-cs-5-3-9</b></p><a name=\"hx1n-v3-hl7ApprovalStatus-cs-5-3-9\"> </a><a name=\"hchx1n-v3-hl7ApprovalStatus-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-hl7ApprovalStatus.html\">CodeSystem HL7ApprovalStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-hl7ApprovalStatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:36.21-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-hl7CMETAttribution-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-hl7CMETAttribution-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-hl7CMETAttribution-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-hl7CMETAttribution-cs-5-3-9</b></p><a name=\"hx1n-v3-hl7CMETAttribution-cs-5-3-9\"> </a><a name=\"hchx1n-v3-hl7CMETAttribution-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-hl7CMETAttribution.html\">CodeSystem HL7CMETAttribution</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-hl7CMETAttribution"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:36.61-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-HL7ContextConductionStyle-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-HL7ContextConductionStyle-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-HL7ContextConductionStyle-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-HL7ContextConductionStyle-cs-5-3-9</b></p><a name=\"hx1n-v3-HL7ContextConductionStyle-cs-5-3-9\"> </a><a name=\"hchx1n-v3-HL7ContextConductionStyle-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-HL7ContextConductionStyle.html\">CodeSystem HL7ContextConductionStyle</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-HL7ContextConductionStyle"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:37.01-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-HL7DefinedRoseProperty-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-HL7DefinedRoseProperty-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-HL7DefinedRoseProperty-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-HL7DefinedRoseProperty-cs-5-3-9</b></p><a name=\"hx1n-v3-HL7DefinedRoseProperty-cs-5-3-9\"> </a><a name=\"hchx1n-v3-HL7DefinedRoseProperty-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-HL7DefinedRoseProperty.html\">CodeSystem HL7DefinedRoseProperty</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-HL7DefinedRoseProperty"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:37.42-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-HL7DocumentFormatCodes-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-HL7DocumentFormatCodes-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-HL7DocumentFormatCodes-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-HL7DocumentFormatCodes-cs-5-3-9</b></p><a name=\"hx1n-v3-HL7DocumentFormatCodes-cs-5-3-9\"> </a><a name=\"hchx1n-v3-HL7DocumentFormatCodes-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-HL7DocumentFormatCodes.html\">CodeSystem HL7 Document Format Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-HL7DocumentFormatCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:37.83-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-hl7ITSType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-hl7ITSType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-hl7ITSType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-hl7ITSType-cs-5-3-9</b></p><a name=\"hx1n-v3-hl7ITSType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-hl7ITSType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-hl7ITSType.html\">CodeSystem HL7ITSType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-hl7ITSType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:38.23-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-hl7ITSVersionCode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-hl7ITSVersionCode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-hl7ITSVersionCode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-hl7ITSVersionCode-cs-5-3-9</b></p><a name=\"hx1n-v3-hl7ITSVersionCode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-hl7ITSVersionCode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-hl7ITSVersionCode.html\">CodeSystem HL7 ITS Version Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-hl7ITSVersionCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:38.68-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-hl7PublishingDomain-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-hl7PublishingDomain-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-hl7PublishingDomain-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-hl7PublishingDomain-cs-5-3-9</b></p><a name=\"hx1n-v3-hl7PublishingDomain-cs-5-3-9\"> </a><a name=\"hchx1n-v3-hl7PublishingDomain-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-hl7PublishingDomain.html\">CodeSystem HL7PublishingDomain</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-hl7PublishingDomain"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:39.09-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-hl7PublishingSection-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-hl7PublishingSection-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-hl7PublishingSection-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-hl7PublishingSection-cs-5-3-9</b></p><a name=\"hx1n-v3-hl7PublishingSection-cs-5-3-9\"> </a><a name=\"hchx1n-v3-hl7PublishingSection-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-hl7PublishingSection.html\">CodeSystem HL7PublishingSection</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-hl7PublishingSection"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:39.50-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-hl7PublishingSubSection-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-hl7PublishingSubSection-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-hl7PublishingSubSection-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-hl7PublishingSubSection-cs-5-3-9</b></p><a name=\"hx1n-v3-hl7PublishingSubSection-cs-5-3-9\"> </a><a name=\"hchx1n-v3-hl7PublishingSubSection-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-hl7PublishingSubSection.html\">CodeSystem HL7PublishingSubSection</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-hl7PublishingSubSection"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:39.90-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-hl7Realm-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-hl7Realm-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-hl7Realm-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-hl7Realm-cs-5-3-9</b></p><a name=\"hx1n-v3-hl7Realm-cs-5-3-9\"> </a><a name=\"hchx1n-v3-hl7Realm-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-hl7Realm.html\">CodeSystem HL7Realm</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:40-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-hl7Realm"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:40.33-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-HL7StandardVersionCode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-HL7StandardVersionCode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-HL7StandardVersionCode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-HL7StandardVersionCode-cs-5-3-9</b></p><a name=\"hx1n-v3-HL7StandardVersionCode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-HL7StandardVersionCode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-HL7StandardVersionCode.html\">CodeSystem HL7StandardVersionCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:40-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-HL7StandardVersionCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:40.74-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-HL7UpdateMode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-HL7UpdateMode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-HL7UpdateMode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-HL7UpdateMode-cs-5-3-9</b></p><a name=\"hx1n-v3-HL7UpdateMode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-HL7UpdateMode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-HL7UpdateMode.html\">CodeSystem HL7UpdateMode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-HL7UpdateMode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:41.16-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-hl7V3Conformance-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-hl7V3Conformance-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-hl7V3Conformance-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-hl7V3Conformance-cs-5-3-9</b></p><a name=\"hx1n-v3-hl7V3Conformance-cs-5-3-9\"> </a><a name=\"hchx1n-v3-hl7V3Conformance-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-hl7V3Conformance.html\">CodeSystem HL7V3Conformance</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-hl7V3Conformance"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:41.57-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-hl7VoteResolution-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-hl7VoteResolution-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-hl7VoteResolution-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-hl7VoteResolution-cs-5-3-9</b></p><a name=\"hx1n-v3-hl7VoteResolution-cs-5-3-9\"> </a><a name=\"hchx1n-v3-hl7VoteResolution-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-hl7VoteResolution.html\">CodeSystem HL7VoteResolution</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-hl7VoteResolution"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:41.98-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-HtmlLinkType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-HtmlLinkType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-HtmlLinkType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-HtmlLinkType-cs-5-3-9</b></p><a name=\"hx1n-v3-HtmlLinkType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-HtmlLinkType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-HtmlLinkType.html\">CodeSystem HtmlLinkType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:42-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-HtmlLinkType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:42.39-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-IdentifierReliability-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-IdentifierReliability-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-IdentifierReliability-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-IdentifierReliability-cs-5-3-9</b></p><a name=\"hx1n-v3-IdentifierReliability-cs-5-3-9\"> </a><a name=\"hchx1n-v3-IdentifierReliability-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-IdentifierReliability.html\">CodeSystem IdentifierReliability</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:42-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-IdentifierReliability"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:42.82-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-IdentifierScope-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-IdentifierScope-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-IdentifierScope-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-IdentifierScope-cs-5-3-9</b></p><a name=\"hx1n-v3-IdentifierScope-cs-5-3-9\"> </a><a name=\"hchx1n-v3-IdentifierScope-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-IdentifierScope.html\">CodeSystem IdentifierScope</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-IdentifierScope"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:43.26-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-IntegrityCheckAlgorithm-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-IntegrityCheckAlgorithm-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-IntegrityCheckAlgorithm-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-IntegrityCheckAlgorithm-cs-5-3-9</b></p><a name=\"hx1n-v3-IntegrityCheckAlgorithm-cs-5-3-9\"> </a><a name=\"hchx1n-v3-IntegrityCheckAlgorithm-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-IntegrityCheckAlgorithm.html\">CodeSystem IntegrityCheckAlgorithm</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-IntegrityCheckAlgorithm"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:43.69-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-LanguageAbilityMode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-LanguageAbilityMode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-LanguageAbilityMode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-LanguageAbilityMode-cs-5-3-9</b></p><a name=\"hx1n-v3-LanguageAbilityMode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-LanguageAbilityMode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-LanguageAbilityMode.html\">CodeSystem LanguageAbilityMode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-LanguageAbilityMode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:44.11-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-LanguageAbilityProficiency-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-LanguageAbilityProficiency-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-LanguageAbilityProficiency-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-LanguageAbilityProficiency-cs-5-3-9</b></p><a name=\"hx1n-v3-LanguageAbilityProficiency-cs-5-3-9\"> </a><a name=\"hchx1n-v3-LanguageAbilityProficiency-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-LanguageAbilityProficiency.html\">CodeSystem LanguageAbilityProficiency</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-LanguageAbilityProficiency"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:44.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-LivingArrangement-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-LivingArrangement-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-LivingArrangement-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-LivingArrangement-cs-5-3-9</b></p><a name=\"hx1n-v3-LivingArrangement-cs-5-3-9\"> </a><a name=\"hchx1n-v3-LivingArrangement-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-LivingArrangement.html\">CodeSystem LivingArrangement</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-LivingArrangement"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:45.00-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-LocalMarkupIgnore-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-LocalMarkupIgnore-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-LocalMarkupIgnore-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-LocalMarkupIgnore-cs-5-3-9</b></p><a name=\"hx1n-v3-LocalMarkupIgnore-cs-5-3-9\"> </a><a name=\"hchx1n-v3-LocalMarkupIgnore-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-LocalMarkupIgnore.html\">CodeSystem LocalMarkupIgnore</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-LocalMarkupIgnore"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:45.44-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-LocalRemoteControlState-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-LocalRemoteControlState-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-LocalRemoteControlState-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-LocalRemoteControlState-cs-5-3-9</b></p><a name=\"hx1n-v3-LocalRemoteControlState-cs-5-3-9\"> </a><a name=\"hchx1n-v3-LocalRemoteControlState-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-LocalRemoteControlState.html\">CodeSystem LocalRemoteControlState</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-LocalRemoteControlState"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:45.94-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ManagedParticipationStatus-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ManagedParticipationStatus-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ManagedParticipationStatus-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ManagedParticipationStatus-cs-5-3-9</b></p><a name=\"hx1n-v3-ManagedParticipationStatus-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ManagedParticipationStatus-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ManagedParticipationStatus.html\">CodeSystem ManagedParticipationStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:46-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ManagedParticipationStatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:46.37-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ManufacturerModelNameExample-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ManufacturerModelNameExample-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ManufacturerModelNameExample-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ManufacturerModelNameExample-cs-5-3-9</b></p><a name=\"hx1n-v3-ManufacturerModelNameExample-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ManufacturerModelNameExample-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ManufacturerModelNameExample.html\">CodeSystem ManufacturerModelNameExample</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:46-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ManufacturerModelNameExample"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:46.77-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-MapRelationship-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-MapRelationship-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-MapRelationship-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-MapRelationship-cs-5-3-9</b></p><a name=\"hx1n-v3-MapRelationship-cs-5-3-9\"> </a><a name=\"hchx1n-v3-MapRelationship-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-MapRelationship.html\">CodeSystem MapRelationship</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:47-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-MapRelationship"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:47.20-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-MaritalStatus-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-MaritalStatus-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-MaritalStatus-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-MaritalStatus-cs-5-3-9</b></p><a name=\"hx1n-v3-MaritalStatus-cs-5-3-9\"> </a><a name=\"hchx1n-v3-MaritalStatus-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-MaritalStatus.html\">CodeSystem MaritalStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:47-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-MaritalStatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:47.66-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-mediaType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-mediaType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-mediaType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-mediaType-cs-5-3-9</b></p><a name=\"hx1n-v3-mediaType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-mediaType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-mediaType.html\">CodeSystem Media Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-mediaType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:48.09-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-MessageWaitingPriority-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-MessageWaitingPriority-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-MessageWaitingPriority-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-MessageWaitingPriority-cs-5-3-9</b></p><a name=\"hx1n-v3-MessageWaitingPriority-cs-5-3-9\"> </a><a name=\"hchx1n-v3-MessageWaitingPriority-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-MessageWaitingPriority.html\">CodeSystem MessageWaitingPriority</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-MessageWaitingPriority"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:48.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ModifyIndicator-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ModifyIndicator-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ModifyIndicator-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ModifyIndicator-cs-5-3-9</b></p><a name=\"hx1n-v3-ModifyIndicator-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ModifyIndicator-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ModifyIndicator.html\">CodeSystem ModifyIndicator</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ModifyIndicator"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:49.02-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-NullFlavor-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-NullFlavor-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-NullFlavor-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-NullFlavor-cs-5-3-9</b></p><a name=\"hx1n-v3-NullFlavor-cs-5-3-9\"> </a><a name=\"hchx1n-v3-NullFlavor-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-NullFlavor.html\">CodeSystem NullFlavor</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-NullFlavor"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:49.53-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ObservationCategory-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ObservationCategory-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ObservationCategory-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ObservationCategory-cs-5-3-9</b></p><a name=\"hx1n-v3-ObservationCategory-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ObservationCategory-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ObservationCategory.html\">CodeSystem ObservationCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ObservationCategory"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:49.96-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ObservationInterpretation-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ObservationInterpretation-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ObservationInterpretation-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ObservationInterpretation-cs-5-3-9</b></p><a name=\"hx1n-v3-ObservationInterpretation-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ObservationInterpretation-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ObservationInterpretation.html\">CodeSystem ObservationInterpretation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ObservationInterpretation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:50.36-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ObservationMethod-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ObservationMethod-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ObservationMethod-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ObservationMethod-cs-5-3-9</b></p><a name=\"hx1n-v3-ObservationMethod-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ObservationMethod-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ObservationMethod.html\">CodeSystem ObservationMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ObservationMethod"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:50.75-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ObservationValue-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ObservationValue-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ObservationValue-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ObservationValue-cs-5-3-9</b></p><a name=\"hx1n-v3-ObservationValue-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ObservationValue-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ObservationValue.html\">CodeSystem ObservationValue</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ObservationValue"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:51.16-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-orderableDrugForm-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-orderableDrugForm-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-orderableDrugForm-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-orderableDrugForm-cs-5-3-9</b></p><a name=\"hx1n-v3-orderableDrugForm-cs-5-3-9\"> </a><a name=\"hchx1n-v3-orderableDrugForm-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-orderableDrugForm.html\">CodeSystem Orderable Drug Form</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-orderableDrugForm"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:51.57-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ParticipationFunction-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ParticipationFunction-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ParticipationFunction-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ParticipationFunction-cs-5-3-9</b></p><a name=\"hx1n-v3-ParticipationFunction-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ParticipationFunction-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ParticipationFunction.html\">CodeSystem ParticipationFunction</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ParticipationFunction"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:52.00-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ParticipationMode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ParticipationMode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ParticipationMode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ParticipationMode-cs-5-3-9</b></p><a name=\"hx1n-v3-ParticipationMode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ParticipationMode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ParticipationMode.html\">CodeSystem ParticipationMode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ParticipationMode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:52.42-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ParticipationSignature-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ParticipationSignature-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ParticipationSignature-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ParticipationSignature-cs-5-3-9</b></p><a name=\"hx1n-v3-ParticipationSignature-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ParticipationSignature-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ParticipationSignature.html\">CodeSystem ParticipationSignature</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ParticipationSignature"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:52.83-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ParticipationType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ParticipationType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ParticipationType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ParticipationType-cs-5-3-9</b></p><a name=\"hx1n-v3-ParticipationType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ParticipationType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ParticipationType.html\">CodeSystem ParticipationType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ParticipationType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:53.22-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-PatientImportance-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-PatientImportance-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-PatientImportance-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-PatientImportance-cs-5-3-9</b></p><a name=\"hx1n-v3-PatientImportance-cs-5-3-9\"> </a><a name=\"hchx1n-v3-PatientImportance-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-PatientImportance.html\">CodeSystem PatientImportance</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-PatientImportance"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:53.62-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-PaymentTerms-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-PaymentTerms-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-PaymentTerms-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-PaymentTerms-cs-5-3-9</b></p><a name=\"hx1n-v3-PaymentTerms-cs-5-3-9\"> </a><a name=\"hchx1n-v3-PaymentTerms-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-PaymentTerms.html\">CodeSystem PaymentTerms</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-PaymentTerms"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:54.02-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-PersonDisabilityType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-PersonDisabilityType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-PersonDisabilityType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-PersonDisabilityType-cs-5-3-9</b></p><a name=\"hx1n-v3-PersonDisabilityType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-PersonDisabilityType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-PersonDisabilityType.html\">CodeSystem PersonDisabilityType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-PersonDisabilityType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:54.42-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ProbabilityDistributionType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ProbabilityDistributionType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ProbabilityDistributionType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ProbabilityDistributionType-cs-5-3-9</b></p><a name=\"hx1n-v3-ProbabilityDistributionType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ProbabilityDistributionType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ProbabilityDistributionType.html\">CodeSystem ProbabilityDistributionType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ProbabilityDistributionType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:54.83-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ProcessingID-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ProcessingID-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ProcessingID-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ProcessingID-cs-5-3-9</b></p><a name=\"hx1n-v3-ProcessingID-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ProcessingID-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ProcessingID.html\">CodeSystem ProcessingID</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:55-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ProcessingID"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:55.22-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ProcessingMode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ProcessingMode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ProcessingMode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ProcessingMode-cs-5-3-9</b></p><a name=\"hx1n-v3-ProcessingMode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ProcessingMode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ProcessingMode.html\">CodeSystem ProcessingMode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:55-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ProcessingMode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:55.63-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-QueryParameterValue-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-QueryParameterValue-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-QueryParameterValue-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-QueryParameterValue-cs-5-3-9</b></p><a name=\"hx1n-v3-QueryParameterValue-cs-5-3-9\"> </a><a name=\"hchx1n-v3-QueryParameterValue-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-QueryParameterValue.html\">CodeSystem QueryParameterValue</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:56-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-QueryParameterValue"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:56.04-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-QueryPriority-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-QueryPriority-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-QueryPriority-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-QueryPriority-cs-5-3-9</b></p><a name=\"hx1n-v3-QueryPriority-cs-5-3-9\"> </a><a name=\"hchx1n-v3-QueryPriority-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-QueryPriority.html\">CodeSystem QueryPriority</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:56-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-QueryPriority"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:56.45-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-QueryRequestLimit-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-QueryRequestLimit-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-QueryRequestLimit-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-QueryRequestLimit-cs-5-3-9</b></p><a name=\"hx1n-v3-QueryRequestLimit-cs-5-3-9\"> </a><a name=\"hchx1n-v3-QueryRequestLimit-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-QueryRequestLimit.html\">CodeSystem QueryRequestLimit</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:56-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-QueryRequestLimit"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:56.87-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-QueryResponse-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-QueryResponse-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-QueryResponse-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-QueryResponse-cs-5-3-9</b></p><a name=\"hx1n-v3-QueryResponse-cs-5-3-9\"> </a><a name=\"hchx1n-v3-QueryResponse-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-QueryResponse.html\">CodeSystem QueryResponse</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-QueryResponse"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:57.31-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-QueryStatusCode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-QueryStatusCode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-QueryStatusCode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-QueryStatusCode-cs-5-3-9</b></p><a name=\"hx1n-v3-QueryStatusCode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-QueryStatusCode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-QueryStatusCode.html\">CodeSystem QueryStatusCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-QueryStatusCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:57.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-Race-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-Race-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-Race-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-Race-cs-5-3-9</b></p><a name=\"hx1n-v3-Race-cs-5-3-9\"> </a><a name=\"hchx1n-v3-Race-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-Race.html\">CodeSystem Race</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:58-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-Race"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:58.17-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-RelationalOperator-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-RelationalOperator-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-RelationalOperator-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-RelationalOperator-cs-5-3-9</b></p><a name=\"hx1n-v3-RelationalOperator-cs-5-3-9\"> </a><a name=\"hchx1n-v3-RelationalOperator-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-RelationalOperator.html\">CodeSystem RelationalOperator</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:58-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-RelationalOperator"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:58.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-RelationshipConjunction-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-RelationshipConjunction-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-RelationshipConjunction-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-RelationshipConjunction-cs-5-3-9</b></p><a name=\"hx1n-v3-RelationshipConjunction-cs-5-3-9\"> </a><a name=\"hchx1n-v3-RelationshipConjunction-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-RelationshipConjunction.html\">CodeSystem RelationshipConjunction</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:59-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-RelationshipConjunction"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:59.09-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ReligiousAffiliation-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ReligiousAffiliation-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ReligiousAffiliation-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ReligiousAffiliation-cs-5-3-9</b></p><a name=\"hx1n-v3-ReligiousAffiliation-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ReligiousAffiliation-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ReligiousAffiliation.html\">CodeSystem Religious Affiliation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:59-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ReligiousAffiliation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:59.51-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ResponseLevel-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ResponseLevel-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ResponseLevel-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ResponseLevel-cs-5-3-9</b></p><a name=\"hx1n-v3-ResponseLevel-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ResponseLevel-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ResponseLevel.html\">CodeSystem ResponseLevel</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:49:59-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ResponseLevel"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:49:59.93-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ResponseModality-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ResponseModality-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ResponseModality-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ResponseModality-cs-5-3-9</b></p><a name=\"hx1n-v3-ResponseModality-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ResponseModality-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ResponseModality.html\">CodeSystem ResponseModality</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:00-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ResponseModality"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:00.42-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ResponseMode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ResponseMode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ResponseMode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ResponseMode-cs-5-3-9</b></p><a name=\"hx1n-v3-ResponseMode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-ResponseMode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ResponseMode.html\">CodeSystem ResponseMode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:00-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ResponseMode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:00.91-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-RoleClass-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-RoleClass-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-RoleClass-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-RoleClass-cs-5-3-9</b></p><a name=\"hx1n-v3-RoleClass-cs-5-3-9\"> </a><a name=\"hchx1n-v3-RoleClass-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-RoleClass.html\">CodeSystem RoleClass</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:01-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-RoleClass"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:01.35-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-RoleCode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-RoleCode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-RoleCode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-RoleCode-cs-5-3-9</b></p><a name=\"hx1n-v3-RoleCode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-RoleCode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-RoleCode.html\">CodeSystem RoleCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:01-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-RoleCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:01.82-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-RoleLinkStatus-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-RoleLinkStatus-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-RoleLinkStatus-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-RoleLinkStatus-cs-5-3-9</b></p><a name=\"hx1n-v3-RoleLinkStatus-cs-5-3-9\"> </a><a name=\"hchx1n-v3-RoleLinkStatus-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-RoleLinkStatus.html\">CodeSystem RoleLinkStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:02-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-RoleLinkStatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:02.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-RoleLinkType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-RoleLinkType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-RoleLinkType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-RoleLinkType-cs-5-3-9</b></p><a name=\"hx1n-v3-RoleLinkType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-RoleLinkType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-RoleLinkType.html\">CodeSystem RoleLinkType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:02-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-RoleLinkType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:02.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-RoleStatus-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-RoleStatus-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-RoleStatus-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-RoleStatus-cs-5-3-9</b></p><a name=\"hx1n-v3-RoleStatus-cs-5-3-9\"> </a><a name=\"hchx1n-v3-RoleStatus-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-RoleStatus.html\">CodeSystem RoleStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:03-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-RoleStatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:03.04-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-RouteOfAdministration-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-RouteOfAdministration-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-RouteOfAdministration-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-RouteOfAdministration-cs-5-3-9</b></p><a name=\"hx1n-v3-RouteOfAdministration-cs-5-3-9\"> </a><a name=\"hchx1n-v3-RouteOfAdministration-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-RouteOfAdministration.html\">CodeSystem RouteOfAdministration</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:03-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-RouteOfAdministration"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:03.43-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-Sequencing-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-Sequencing-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-Sequencing-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-Sequencing-cs-5-3-9</b></p><a name=\"hx1n-v3-Sequencing-cs-5-3-9\"> </a><a name=\"hchx1n-v3-Sequencing-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-Sequencing.html\">CodeSystem Sequencing</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:03-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-Sequencing"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:03.83-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-SetOperator-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-SetOperator-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-SetOperator-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-SetOperator-cs-5-3-9</b></p><a name=\"hx1n-v3-SetOperator-cs-5-3-9\"> </a><a name=\"hchx1n-v3-SetOperator-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-SetOperator.html\">CodeSystem SetOperator</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:04-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-SetOperator"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:04.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-SoftwareNameExample-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-SoftwareNameExample-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-SoftwareNameExample-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-SoftwareNameExample-cs-5-3-9</b></p><a name=\"hx1n-v3-SoftwareNameExample-cs-5-3-9\"> </a><a name=\"hchx1n-v3-SoftwareNameExample-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-SoftwareNameExample.html\">CodeSystem SoftwareNameExample</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:04-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-SoftwareNameExample"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:04.65-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-SpecimenType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-SpecimenType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-SpecimenType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-SpecimenType-cs-5-3-9</b></p><a name=\"hx1n-v3-SpecimenType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-SpecimenType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-SpecimenType.html\">CodeSystem SpecimenType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-SpecimenType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:05.06-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-styleType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-styleType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-styleType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-styleType-cs-5-3-9</b></p><a name=\"hx1n-v3-styleType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-styleType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-styleType.html\">CodeSystem Style Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-styleType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:05.46-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-substanceAdminSubstitution-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-substanceAdminSubstitution-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-substanceAdminSubstitution-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-substanceAdminSubstitution-cs-5-3-9</b></p><a name=\"hx1n-v3-substanceAdminSubstitution-cs-5-3-9\"> </a><a name=\"hchx1n-v3-substanceAdminSubstitution-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-substanceAdminSubstitution.html\">CodeSystem Substance Admin Substitution</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-substanceAdminSubstitution"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:05.85-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-SubstitutionCondition-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-SubstitutionCondition-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-SubstitutionCondition-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-SubstitutionCondition-cs-5-3-9</b></p><a name=\"hx1n-v3-SubstitutionCondition-cs-5-3-9\"> </a><a name=\"hchx1n-v3-SubstitutionCondition-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-SubstitutionCondition.html\">CodeSystem SubstitutionCondition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:06-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-SubstitutionCondition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:06.29-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-TableCellHorizontalAlign-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-TableCellHorizontalAlign-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-TableCellHorizontalAlign-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-TableCellHorizontalAlign-cs-5-3-9</b></p><a name=\"hx1n-v3-TableCellHorizontalAlign-cs-5-3-9\"> </a><a name=\"hchx1n-v3-TableCellHorizontalAlign-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-TableCellHorizontalAlign.html\">CodeSystem TableCellHorizontalAlign</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:06-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-TableCellHorizontalAlign"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:06.74-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-TableCellScope-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-TableCellScope-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-TableCellScope-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-TableCellScope-cs-5-3-9</b></p><a name=\"hx1n-v3-TableCellScope-cs-5-3-9\"> </a><a name=\"hchx1n-v3-TableCellScope-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-TableCellScope.html\">CodeSystem TableCellScope</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-TableCellScope"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:07.16-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-TableCellVerticalAlign-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-TableCellVerticalAlign-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-TableCellVerticalAlign-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-TableCellVerticalAlign-cs-5-3-9</b></p><a name=\"hx1n-v3-TableCellVerticalAlign-cs-5-3-9\"> </a><a name=\"hchx1n-v3-TableCellVerticalAlign-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-TableCellVerticalAlign.html\">CodeSystem TableCellVerticalAlign</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-TableCellVerticalAlign"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:07.60-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-TableFrame-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-TableFrame-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-TableFrame-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-TableFrame-cs-5-3-9</b></p><a name=\"hx1n-v3-TableFrame-cs-5-3-9\"> </a><a name=\"hchx1n-v3-TableFrame-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-TableFrame.html\">CodeSystem TableFrame</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:08-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-TableFrame"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:08.00-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-TableRules-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-TableRules-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-TableRules-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-TableRules-cs-5-3-9</b></p><a name=\"hx1n-v3-TableRules-cs-5-3-9\"> </a><a name=\"hchx1n-v3-TableRules-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-TableRules.html\">CodeSystem TableRules</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:08-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-TableRules"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:08.39-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-TargetAwareness-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-TargetAwareness-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-TargetAwareness-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-TargetAwareness-cs-5-3-9</b></p><a name=\"hx1n-v3-TargetAwareness-cs-5-3-9\"> </a><a name=\"hchx1n-v3-TargetAwareness-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-TargetAwareness.html\">CodeSystem TargetAwareness</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:08-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-TargetAwareness"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:08.80-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-TelecommunicationCapabilities-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-TelecommunicationCapabilities-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-TelecommunicationCapabilities-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-TelecommunicationCapabilities-cs-5-3-9</b></p><a name=\"hx1n-v3-TelecommunicationCapabilities-cs-5-3-9\"> </a><a name=\"hchx1n-v3-TelecommunicationCapabilities-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-TelecommunicationCapabilities.html\">CodeSystem TelecommunicationCapabilities</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:09-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-TelecommunicationCapabilities"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:09.27-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-TimingEvent-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-TimingEvent-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-TimingEvent-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-TimingEvent-cs-5-3-9</b></p><a name=\"hx1n-v3-TimingEvent-cs-5-3-9\"> </a><a name=\"hchx1n-v3-TimingEvent-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-TimingEvent.html\">CodeSystem TimingEvent</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:09-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-TimingEvent"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:09.70-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-TransmissionRelationshipTypeCode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-TransmissionRelationshipTypeCode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-TransmissionRelationshipTypeCode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-TransmissionRelationshipTypeCode-cs-5-3-9</b></p><a name=\"hx1n-v3-TransmissionRelationshipTypeCode-cs-5-3-9\"> </a><a name=\"hchx1n-v3-TransmissionRelationshipTypeCode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-TransmissionRelationshipTypeCode.html\">CodeSystem TransmissionRelationshipTypeCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-TransmissionRelationshipTypeCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:10.12-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-TribalEntityUS-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-TribalEntityUS-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-TribalEntityUS-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-TribalEntityUS-cs-5-3-9</b></p><a name=\"hx1n-v3-TribalEntityUS-cs-5-3-9\"> </a><a name=\"hchx1n-v3-TribalEntityUS-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-TribalEntityUS.html\">CodeSystem TribalEntityUS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-TribalEntityUS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:10.51-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-triggerEventID-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-triggerEventID-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-triggerEventID-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-triggerEventID-cs-5-3-9</b></p><a name=\"hx1n-triggerEventID-cs-5-3-9\"> </a><a name=\"hchx1n-triggerEventID-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-triggerEventID.html\">CodeSystem Trigger Event ID</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/triggerEventID"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:10.92-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-URLScheme-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-URLScheme-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-URLScheme-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-URLScheme-cs-5-3-9</b></p><a name=\"hx1n-v3-URLScheme-cs-5-3-9\"> </a><a name=\"hchx1n-v3-URLScheme-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-URLScheme.html\">CodeSystem Universal Resource Locator Scheme</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:11-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-URLScheme"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:11.35-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-VaccineManufacturer-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-VaccineManufacturer-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-VaccineManufacturer-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-VaccineManufacturer-cs-5-3-9</b></p><a name=\"hx1n-v3-VaccineManufacturer-cs-5-3-9\"> </a><a name=\"hchx1n-v3-VaccineManufacturer-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-VaccineManufacturer.html\">CodeSystem VaccineManufacturer</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:11-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-VaccineManufacturer"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:11.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-VaccineType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-VaccineType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-VaccineType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-VaccineType-cs-5-3-9</b></p><a name=\"hx1n-v3-VaccineType-cs-5-3-9\"> </a><a name=\"hchx1n-v3-VaccineType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-VaccineType.html\">CodeSystem VaccineType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-VaccineType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:12.17-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-WorkClassificationODH-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-WorkClassificationODH-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-WorkClassificationODH-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-WorkClassificationODH-cs-5-3-9</b></p><a name=\"hx1n-v3-WorkClassificationODH-cs-5-3-9\"> </a><a name=\"hchx1n-v3-WorkClassificationODH-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-v3-WorkClassificationODH.html\">CodeSystem Work Classification (Occupational Data for Health)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-WorkClassificationODH"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:12.58-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-PeriodicIntervalOfTimeAbbreviation-ns-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-PeriodicIntervalOfTimeAbbreviation-ns-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-PeriodicIntervalOfTimeAbbreviation-ns-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-PeriodicIntervalOfTimeAbbreviation-ns-5-3-9</b></p><a name=\"hx1n-v3-PeriodicIntervalOfTimeAbbreviation-ns-5-3-9\"> </a><a name=\"hchx1n-v3-PeriodicIntervalOfTimeAbbreviation-ns-5-3-9\"> </a><p>Provenance for <a href=\"NamingSystem-v3-PeriodicIntervalOfTimeAbbreviation.html\">NamingSystem PeriodicIntervalOfTimeAbbreviation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-PeriodicIntervalOfTimeAbbreviation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:12.99-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-policyHolderRole-ns-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-policyHolderRole-ns-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-policyHolderRole-ns-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-policyHolderRole-ns-5-3-9</b></p><a name=\"hx1n-v3-policyHolderRole-ns-5-3-9\"> </a><a name=\"hchx1n-v3-policyHolderRole-ns-5-3-9\"> </a><p>Provenance for <a href=\"NamingSystem-v3-policyHolderRole.html\">NamingSystem Policy Holder Role</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-policyHolderRole"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:13.39-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ProcedureMethod-ns-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ProcedureMethod-ns-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ProcedureMethod-ns-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ProcedureMethod-ns-5-3-9</b></p><a name=\"hx1n-v3-ProcedureMethod-ns-5-3-9\"> </a><a name=\"hchx1n-v3-ProcedureMethod-ns-5-3-9\"> </a><p>Provenance for <a href=\"NamingSystem-v3-ProcedureMethod.html\">NamingSystem ProcedureMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-ProcedureMethod"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:13.80-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-SpecialArrangement-ns-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-SpecialArrangement-ns-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-SpecialArrangement-ns-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-SpecialArrangement-ns-5-3-9</b></p><a name=\"hx1n-v3-SpecialArrangement-ns-5-3-9\"> </a><a name=\"hchx1n-v3-SpecialArrangement-ns-5-3-9\"> </a><p>Provenance for <a href=\"NamingSystem-v3-SpecialArrangement.html\">NamingSystem SpecialArrangement</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:14-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-SpecialArrangement"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:14.22-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-UnitOfMeasurePrefix-ns-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-UnitOfMeasurePrefix-ns-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-UnitOfMeasurePrefix-ns-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-UnitOfMeasurePrefix-ns-5-3-9</b></p><a name=\"hx1n-v3-UnitOfMeasurePrefix-ns-5-3-9\"> </a><a name=\"hchx1n-v3-UnitOfMeasurePrefix-ns-5-3-9\"> </a><p>Provenance for <a href=\"NamingSystem-v3-UnitOfMeasurePrefix.html\">NamingSystem Unit of Measure Prefix</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:14-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-UnitOfMeasurePrefix"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:14.63-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-tst0272-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-tst0272-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-tst0272-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-tst0272-vs-5-3-9</b></p><a name=\"hx1n-v3-tst0272-vs-5-3-9\"> </a><a name=\"hchx1n-v3-tst0272-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-tst0272.html\">ValueSet _0272</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-tst0272"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:15.05-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-tst0275a-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-tst0275a-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-tst0275a-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-tst0275a-vs-5-3-9</b></p><a name=\"hx1n-v3-tst0275a-vs-5-3-9\"> </a><a name=\"hchx1n-v3-tst0275a-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-tst0275a.html\">ValueSet _0275a</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-tst0275a"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:15.44-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-tst0280-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-tst0280-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-tst0280-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-tst0280-vs-5-3-9</b></p><a name=\"hx1n-v3-tst0280-vs-5-3-9\"> </a><a name=\"hchx1n-v3-tst0280-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-tst0280.html\">ValueSet _0280</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-tst0280"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:15.87-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-Abenakian-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-Abenakian-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-Abenakian-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-Abenakian-vs-5-3-9</b></p><a name=\"hx1n-v3-Abenakian-vs-5-3-9\"> </a><a name=\"hchx1n-v3-Abenakian-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-Abenakian.html\">ValueSet Abenakian</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:16-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-Abenakian"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:16.29-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AccessMedicalDevice-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AccessMedicalDevice-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AccessMedicalDevice-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AccessMedicalDevice-vs-5-3-9</b></p><a name=\"hx1n-v3-AccessMedicalDevice-vs-5-3-9\"> </a><a name=\"hchx1n-v3-AccessMedicalDevice-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-AccessMedicalDevice.html\">ValueSet AccessMedicalDevice</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:16-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-AccessMedicalDevice"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:16.72-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AcknowledgementCondition-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AcknowledgementCondition-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AcknowledgementCondition-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AcknowledgementCondition-vs-5-3-9</b></p><a name=\"hx1n-v3-AcknowledgementCondition-vs-5-3-9\"> </a><a name=\"hchx1n-v3-AcknowledgementCondition-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-AcknowledgementCondition.html\">ValueSet AcknowledgementCondition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:17-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-AcknowledgementCondition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:17.12-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AcknowledgementDetailCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AcknowledgementDetailCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AcknowledgementDetailCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AcknowledgementDetailCode-vs-5-3-9</b></p><a name=\"hx1n-v3-AcknowledgementDetailCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-AcknowledgementDetailCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-AcknowledgementDetailCode.html\">ValueSet AcknowledgementDetailCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:17-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-AcknowledgementDetailCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:17.52-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AcknowledgementDetailNotSupportedCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AcknowledgementDetailNotSupportedCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AcknowledgementDetailNotSupportedCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AcknowledgementDetailNotSupportedCode-vs-5-3-9</b></p><a name=\"hx1n-v3-AcknowledgementDetailNotSupportedCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-AcknowledgementDetailNotSupportedCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-AcknowledgementDetailNotSupportedCode.html\">ValueSet AcknowledgementDetailNotSupportedCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:17-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-AcknowledgementDetailNotSupportedCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:17.93-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AcknowledgementDetailSyntaxErrorCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AcknowledgementDetailSyntaxErrorCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AcknowledgementDetailSyntaxErrorCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AcknowledgementDetailSyntaxErrorCode-vs-5-3-9</b></p><a name=\"hx1n-v3-AcknowledgementDetailSyntaxErrorCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-AcknowledgementDetailSyntaxErrorCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-AcknowledgementDetailSyntaxErrorCode.html\">ValueSet AcknowledgementDetailSyntaxErrorCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:18-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-AcknowledgementDetailSyntaxErrorCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:18.36-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AcknowledgementDetailType-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AcknowledgementDetailType-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AcknowledgementDetailType-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AcknowledgementDetailType-vs-5-3-9</b></p><a name=\"hx1n-v3-AcknowledgementDetailType-vs-5-3-9\"> </a><a name=\"hchx1n-v3-AcknowledgementDetailType-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-AcknowledgementDetailType.html\">ValueSet AcknowledgementDetailType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:18-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-AcknowledgementDetailType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:18.78-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-AcknowledgementType-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-AcknowledgementType-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-AcknowledgementType-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-AcknowledgementType-vs-5-3-9</b></p><a name=\"hx1n-v3-AcknowledgementType-vs-5-3-9\"> </a><a name=\"hchx1n-v3-AcknowledgementType-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-AcknowledgementType.html\">ValueSet AcknowledgementType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-AcknowledgementType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:19.21-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActAccommodationReason-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActAccommodationReason-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActAccommodationReason-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActAccommodationReason-vs-5-3-9</b></p><a name=\"hx1n-v3-ActAccommodationReason-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActAccommodationReason-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActAccommodationReason.html\">ValueSet ActAccommodationReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActAccommodationReason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:19.63-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActAccountCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActAccountCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActAccountCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActAccountCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActAccountCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActAccountCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActAccountCode.html\">ValueSet ActAccountCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:20-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActAccountCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:20.03-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActAdjudicationCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActAdjudicationCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActAdjudicationCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActAdjudicationCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActAdjudicationCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActAdjudicationCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActAdjudicationCode.html\">ValueSet ActAdjudicationCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:20-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActAdjudicationCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:20.45-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActAdjudicationGroupCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActAdjudicationGroupCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActAdjudicationGroupCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActAdjudicationGroupCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActAdjudicationGroupCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActAdjudicationGroupCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActAdjudicationGroupCode.html\">ValueSet ActAdjudicationGroupCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:20-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActAdjudicationGroupCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:20.88-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActAdjudicationResultActionCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActAdjudicationResultActionCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActAdjudicationResultActionCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActAdjudicationResultActionCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActAdjudicationResultActionCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActAdjudicationResultActionCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActAdjudicationResultActionCode.html\">ValueSet ActAdjudicationResultActionCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActAdjudicationResultActionCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:21.30-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActAdministrativeAuthorizationDetectedIssueCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActAdministrativeAuthorizationDetectedIssueCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActAdministrativeAuthorizationDetectedIssueCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActAdministrativeAuthorizationDetectedIssueCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActAdministrativeAuthorizationDetectedIssueCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActAdministrativeAuthorizationDetectedIssueCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActAdministrativeAuthorizationDetectedIssueCode.html\">ValueSet ActAdministrativeAuthorizationDetectedIssueCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActAdministrativeAuthorizationDetectedIssueCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:21.70-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActAdministrativeDetectedIssueCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActAdministrativeDetectedIssueCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActAdministrativeDetectedIssueCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActAdministrativeDetectedIssueCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActAdministrativeDetectedIssueCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActAdministrativeDetectedIssueCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActAdministrativeDetectedIssueCode.html\">ValueSet ActAdministrativeDetectedIssueCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActAdministrativeDetectedIssueCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:22.10-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActAdministrativeDetectedIssueManagementCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActAdministrativeDetectedIssueManagementCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActAdministrativeDetectedIssueManagementCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActAdministrativeDetectedIssueManagementCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActAdministrativeDetectedIssueManagementCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActAdministrativeDetectedIssueManagementCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActAdministrativeDetectedIssueManagementCode.html\">ValueSet ActAdministrativeDetectedIssueManagementCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActAdministrativeDetectedIssueManagementCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:22.50-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActAdministrativeRuleDetectedIssueCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActAdministrativeRuleDetectedIssueCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActAdministrativeRuleDetectedIssueCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActAdministrativeRuleDetectedIssueCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActAdministrativeRuleDetectedIssueCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActAdministrativeRuleDetectedIssueCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActAdministrativeRuleDetectedIssueCode.html\">ValueSet ActAdministrativeRuleDetectedIssueCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActAdministrativeRuleDetectedIssueCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:22.92-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActAmbulatoryEncounterCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActAmbulatoryEncounterCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActAmbulatoryEncounterCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActAmbulatoryEncounterCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActAmbulatoryEncounterCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActAmbulatoryEncounterCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActAmbulatoryEncounterCode.html\">ValueSet ActAmbulatoryEncounterCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:23-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActAmbulatoryEncounterCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:23.32-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActAntigenInvalidReason-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActAntigenInvalidReason-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActAntigenInvalidReason-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActAntigenInvalidReason-vs-5-3-9</b></p><a name=\"hx1n-v3-ActAntigenInvalidReason-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActAntigenInvalidReason-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActAntigenInvalidReason.html\">ValueSet ActAntigenInvalidReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:23-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActAntigenInvalidReason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:23.73-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActBillableModifierCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActBillableModifierCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActBillableModifierCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActBillableModifierCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActBillableModifierCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActBillableModifierCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActBillableModifierCode.html\">ValueSet ActBillableModifierCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:24-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActBillableModifierCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:24.15-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActBillingArrangementCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActBillingArrangementCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActBillingArrangementCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActBillingArrangementCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActBillingArrangementCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActBillingArrangementCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActBillingArrangementCode.html\">ValueSet ActBillingArrangementCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:24-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActBillingArrangementCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:24.56-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActBoundedROICode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActBoundedROICode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActBoundedROICode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActBoundedROICode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActBoundedROICode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActBoundedROICode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActBoundedROICode.html\">ValueSet ActBoundedROICode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:24-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActBoundedROICode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:24.99-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActCareProvisionCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActCareProvisionCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActCareProvisionCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActCareProvisionCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActCareProvisionCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActCareProvisionCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActCareProvisionCode.html\">ValueSet ActCareProvisionCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActCareProvisionCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:25.40-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClaimAttachmentCategoryCode-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClaimAttachmentCategoryCode-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClaimAttachmentCategoryCode-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClaimAttachmentCategoryCode-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClaimAttachmentCategoryCode-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClaimAttachmentCategoryCode-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClaimAttachmentCategoryCode.html\">ValueSet ActClaimAttachmentCategoryCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClaimAttachmentCategoryCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:25.83-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClass-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClass-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClass-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClass-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClass-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClass-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClass.html\">ValueSet ActClass</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClass"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:26.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassAccession-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassAccession-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassAccession-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassAccession-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassAccession-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassAccession-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassAccession.html\">ValueSet ActClassAccession</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassAccession"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:26.69-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassAccommodation-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassAccommodation-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassAccommodation-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassAccommodation-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassAccommodation-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassAccommodation-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassAccommodation.html\">ValueSet ActClassAccommodation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:27-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassAccommodation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:27.10-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassAccount-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassAccount-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassAccount-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassAccount-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassAccount-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassAccount-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassAccount.html\">ValueSet ActClassAccount</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:27-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassAccount"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:27.50-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassAcquisitionExposure-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassAcquisitionExposure-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassAcquisitionExposure-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassAcquisitionExposure-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassAcquisitionExposure-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassAcquisitionExposure-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassAcquisitionExposure.html\">ValueSet ActClassAcquisitionExposure</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:27-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassAcquisitionExposure"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:27.92-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassAction-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassAction-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassAction-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassAction-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassAction-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassAction-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassAction.html\">ValueSet ActClassAction</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:28-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassAction"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:28.32-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassBattery-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassBattery-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassBattery-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassBattery-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassBattery-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassBattery-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassBattery.html\">ValueSet ActClassBattery</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:28-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassBattery"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:28.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassBioSequence-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassBioSequence-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassBioSequence-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassBioSequence-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassBioSequence-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassBioSequence-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassBioSequence.html\">ValueSet ActClassBioSequence</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassBioSequence"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:29.11-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassBioSequenceVariation-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassBioSequenceVariation-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassBioSequenceVariation-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassBioSequenceVariation-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassBioSequenceVariation-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassBioSequenceVariation-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassBioSequenceVariation.html\">ValueSet ActClassBioSequenceVariation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassBioSequenceVariation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:29.53-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassBoundedRoi-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassBoundedRoi-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassBoundedRoi-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassBoundedRoi-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassBoundedRoi-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassBoundedRoi-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassBoundedRoi.html\">ValueSet ActClassBoundedRoi</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:30-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassBoundedRoi"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:30.03-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassCareProvision-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassCareProvision-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassCareProvision-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassCareProvision-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassCareProvision-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassCareProvision-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassCareProvision.html\">ValueSet ActClassCareProvision</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:30-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassCareProvision"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:30.49-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassCategory-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassCategory-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassCategory-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassCategory-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassCategory-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassCategory-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassCategory.html\">ValueSet ActClassCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:30-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassCategory"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:30.91-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassCdaLevelOneClinicalDocument-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassCdaLevelOneClinicalDocument-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassCdaLevelOneClinicalDocument-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassCdaLevelOneClinicalDocument-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassCdaLevelOneClinicalDocument-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassCdaLevelOneClinicalDocument-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassCdaLevelOneClinicalDocument.html\">ValueSet ActClassCdaLevelOneClinicalDocument</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassCdaLevelOneClinicalDocument"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:31.38-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassClinicalDocument-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassClinicalDocument-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassClinicalDocument-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassClinicalDocument-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassClinicalDocument-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassClinicalDocument-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassClinicalDocument.html\">ValueSet ActClassClinicalDocument</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassClinicalDocument"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:31.82-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassClinicalTrial-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassClinicalTrial-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassClinicalTrial-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassClinicalTrial-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassClinicalTrial-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassClinicalTrial-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassClinicalTrial.html\">ValueSet ActClassClinicalTrial</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:32-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassClinicalTrial"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:32.21-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassClinicalTrialTimepointEvent-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassClinicalTrialTimepointEvent-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassClinicalTrialTimepointEvent-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassClinicalTrialTimepointEvent-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassClinicalTrialTimepointEvent-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassClinicalTrialTimepointEvent-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassClinicalTrialTimepointEvent.html\">ValueSet ActClassClinicalTrialTimepointEvent</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:32-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassClinicalTrialTimepointEvent"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:32.61-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassCluster-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassCluster-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassCluster-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassCluster-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassCluster-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassCluster-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassCluster.html\">ValueSet ActClassCluster</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassCluster"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:33.02-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassCompositeOrder-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassCompositeOrder-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassCompositeOrder-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassCompositeOrder-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassCompositeOrder-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassCompositeOrder-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassCompositeOrder.html\">ValueSet ActClassCompositeOrder</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassCompositeOrder"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:33.41-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassComposition-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassComposition-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassComposition-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassComposition-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassComposition-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassComposition-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassComposition.html\">ValueSet ActClassComposition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassComposition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:33.81-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassConcern-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassConcern-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassConcern-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassConcern-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassConcern-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassConcern-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassConcern.html\">ValueSet ActClassConcern</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:34-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassConcern"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:34.21-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassCondition-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassCondition-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassCondition-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassCondition-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassCondition-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassCondition-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassCondition.html\">ValueSet ActClassCondition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:34-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassCondition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:34.63-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassConsent-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassConsent-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassConsent-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassConsent-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassConsent-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassConsent-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassConsent.html\">ValueSet ActClassConsent</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassConsent"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:35.03-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassContainer-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassContainer-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassContainer-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassContainer-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassContainer-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassContainer-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassContainer.html\">ValueSet ActClassContainer</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassContainer"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:35.43-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassContainerRegistration-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassContainerRegistration-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassContainerRegistration-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassContainerRegistration-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassContainerRegistration-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassContainerRegistration-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassContainerRegistration.html\">ValueSet ActClassContainerRegistration</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassContainerRegistration"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:35.83-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassContract-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassContract-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassContract-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassContract-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassContract-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassContract-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassContract.html\">ValueSet ActClassContract</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassContract"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:36.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassControlAct-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassControlAct-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassControlAct-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassControlAct-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassControlAct-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassControlAct-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassControlAct.html\">ValueSet ActClassControlAct</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassControlAct"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:36.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassCorrelatedObservationSequences-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassCorrelatedObservationSequences-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassCorrelatedObservationSequences-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassCorrelatedObservationSequences-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassCorrelatedObservationSequences-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassCorrelatedObservationSequences-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassCorrelatedObservationSequences.html\">ValueSet ActClassCorrelatedObservationSequences</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassCorrelatedObservationSequences"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:37.04-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassCoverage-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassCoverage-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassCoverage-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassCoverage-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassCoverage-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassCoverage-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassCoverage.html\">ValueSet ActClassCoverage</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassCoverage"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:37.44-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassDetectedIssue-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassDetectedIssue-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassDetectedIssue-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassDetectedIssue-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassDetectedIssue-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassDetectedIssue-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassDetectedIssue.html\">ValueSet ActClassDetectedIssue</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassDetectedIssue"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:37.83-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassDeterminantPeptide-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassDeterminantPeptide-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassDeterminantPeptide-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassDeterminantPeptide-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassDeterminantPeptide-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassDeterminantPeptide-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassDeterminantPeptide.html\">ValueSet ActClassDeterminantPeptide</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassDeterminantPeptide"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:38.22-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassDiagnosticImage-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassDiagnosticImage-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassDiagnosticImage-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassDiagnosticImage-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassDiagnosticImage-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassDiagnosticImage-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassDiagnosticImage.html\">ValueSet ActClassDiagnosticImage</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassDiagnosticImage"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:38.62-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassDiet-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassDiet-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassDiet-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassDiet-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassDiet-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassDiet-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassDiet.html\">ValueSet ActClassDiet</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassDiet"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:39.03-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassDisciplinaryAction-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassDisciplinaryAction-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassDisciplinaryAction-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassDisciplinaryAction-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassDisciplinaryAction-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassDisciplinaryAction-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassDisciplinaryAction.html\">ValueSet ActClassDisciplinaryAction</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassDisciplinaryAction"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:39.43-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassDocument-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassDocument-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassDocument-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassDocument-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassDocument-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassDocument-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassDocument.html\">ValueSet ActClassDocument</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassDocument"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:39.82-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassDocumentBody-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassDocumentBody-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassDocumentBody-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassDocumentBody-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassDocumentBody-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassDocumentBody-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassDocumentBody.html\">ValueSet ActClassDocumentBody</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:40-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassDocumentBody"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:40.23-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassDocumentSection-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassDocumentSection-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassDocumentSection-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassDocumentSection-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassDocumentSection-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassDocumentSection-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassDocumentSection.html\">ValueSet ActClassDocumentSection</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:40-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassDocumentSection"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:40.62-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassElectronicHealthRecord-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassElectronicHealthRecord-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassElectronicHealthRecord-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassElectronicHealthRecord-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassElectronicHealthRecord-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassElectronicHealthRecord-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassElectronicHealthRecord.html\">ValueSet ActClassElectronicHealthRecord</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassElectronicHealthRecord"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:41.03-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassEncounter-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassEncounter-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassEncounter-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassEncounter-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassEncounter-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassEncounter-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassEncounter.html\">ValueSet ActClassEncounter</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassEncounter"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:41.43-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassExposure-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassExposure-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassExposure-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassExposure-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassExposure-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassExposure-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassExposure.html\">ValueSet ActClassExposure</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassExposure"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:41.82-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassExpressionLevel-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassExpressionLevel-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassExpressionLevel-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassExpressionLevel-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassExpressionLevel-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassExpressionLevel-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassExpressionLevel.html\">ValueSet ActClassExpressionLevel</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:42-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassExpressionLevel"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:42.22-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassExtract-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassExtract-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassExtract-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassExtract-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassExtract-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassExtract-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassExtract.html\">ValueSet ActClassExtract</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:42-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassExtract"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:42.61-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassFinancialAdjudication-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassFinancialAdjudication-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassFinancialAdjudication-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassFinancialAdjudication-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassFinancialAdjudication-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassFinancialAdjudication-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassFinancialAdjudication.html\">ValueSet ActClassFinancialAdjudication</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassFinancialAdjudication"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:43.01-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassFinancialContract-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassFinancialContract-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassFinancialContract-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassFinancialContract-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassFinancialContract-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassFinancialContract-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassFinancialContract.html\">ValueSet ActClassFinancialContract</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassFinancialContract"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:43.41-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassFinancialTransaction-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassFinancialTransaction-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassFinancialTransaction-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassFinancialTransaction-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassFinancialTransaction-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassFinancialTransaction-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassFinancialTransaction.html\">ValueSet ActClassFinancialTransaction</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassFinancialTransaction"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:43.79-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassFolder-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassFolder-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassFolder-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassFolder-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassFolder-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassFolder-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassFolder.html\">ValueSet ActClassFolder</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassFolder"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:44.19-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassGenomicObservation-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassGenomicObservation-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassGenomicObservation-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassGenomicObservation-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassGenomicObservation-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassGenomicObservation-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassGenomicObservation.html\">ValueSet ActClassGenomicObservation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassGenomicObservation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:44.58-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassGrouper-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassGrouper-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassGrouper-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassGrouper-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassGrouper-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassGrouper-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassGrouper.html\">ValueSet ActClassGrouper</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassGrouper"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:44.98-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassIncident-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassIncident-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassIncident-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassIncident-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassIncident-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassIncident-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassIncident.html\">ValueSet ActClassIncident</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassIncident"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:45.37-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassInform-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassInform-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassInform-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassInform-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassInform-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassInform-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassInform.html\">ValueSet ActClassInform</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassInform"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:45.77-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassInformation-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassInformation-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassInformation-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassInformation-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassInformation-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassInformation-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassInformation.html\">ValueSet ActClassInformation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:46-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassInformation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:46.17-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassInvestigation-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassInvestigation-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassInvestigation-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassInvestigation-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassInvestigation-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassInvestigation-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassInvestigation.html\">ValueSet ActClassInvestigation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:46-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassInvestigation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:46.57-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassInvoiceElement-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassInvoiceElement-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassInvoiceElement-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassInvoiceElement-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassInvoiceElement-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassInvoiceElement-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassInvoiceElement.html\">ValueSet ActClassInvoiceElement</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:46-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassInvoiceElement"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:46.97-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassJurisdictionalPolicy-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassJurisdictionalPolicy-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassJurisdictionalPolicy-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassJurisdictionalPolicy-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassJurisdictionalPolicy-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassJurisdictionalPolicy-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassJurisdictionalPolicy.html\">ValueSet ActClassJurisdictionalPolicy</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:47-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassJurisdictionalPolicy"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:47.36-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassLocus-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassLocus-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassLocus-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassLocus-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassLocus-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassLocus-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassLocus.html\">ValueSet ActClassLocus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:47-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassLocus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:47.75-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassMonitoringProgram-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassMonitoringProgram-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassMonitoringProgram-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassMonitoringProgram-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassMonitoringProgram-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassMonitoringProgram-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassMonitoringProgram.html\">ValueSet ActClassMonitoringProgram</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassMonitoringProgram"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:48.15-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassObservation-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassObservation-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassObservation-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassObservation-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassObservation-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassObservation-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassObservation.html\">ValueSet ActClassObservation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassObservation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:48.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassObservationSeries-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassObservationSeries-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassObservationSeries-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassObservationSeries-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassObservationSeries-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassObservationSeries-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassObservationSeries.html\">ValueSet ActClassObservationSeries</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassObservationSeries"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:48.93-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassOrganizationalPolicy-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassOrganizationalPolicy-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassOrganizationalPolicy-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassOrganizationalPolicy-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassOrganizationalPolicy-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassOrganizationalPolicy-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassOrganizationalPolicy.html\">ValueSet ActClassOrganizationalPolicy</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassOrganizationalPolicy"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:49.33-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassOutbreak-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassOutbreak-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassOutbreak-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassOutbreak-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassOutbreak-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassOutbreak-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassOutbreak.html\">ValueSet ActClassOutbreak</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassOutbreak"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:49.74-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassOutbreak2-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassOutbreak2-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassOutbreak2-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassOutbreak2-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassOutbreak2-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassOutbreak2-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassOutbreak2.html\">ValueSet ActClassOutbreak2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassOutbreak2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:50.14-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassOverlayRoi-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassOverlayRoi-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassOverlayRoi-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassOverlayRoi-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassOverlayRoi-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassOverlayRoi-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassOverlayRoi.html\">ValueSet ActClassOverlayRoi</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassOverlayRoi"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:50.53-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassPhenotype-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassPhenotype-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassPhenotype-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassPhenotype-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassPhenotype-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassPhenotype-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassPhenotype.html\">ValueSet ActClassPhenotype</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassPhenotype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:50.92-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassPolicy-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassPolicy-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassPolicy-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassPolicy-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassPolicy-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassPolicy-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassPolicy.html\">ValueSet ActClassPolicy</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassPolicy"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:51.32-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassPolypeptide-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassPolypeptide-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassPolypeptide-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassPolypeptide-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassPolypeptide-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassPolypeptide-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassPolypeptide.html\">ValueSet ActClassPolypeptide</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassPolypeptide"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:51.73-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassPosition-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassPosition-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassPosition-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassPosition-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassPosition-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassPosition-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassPosition.html\">ValueSet ActClassPosition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassPosition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:52.13-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassPositionAccuracy-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassPositionAccuracy-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassPositionAccuracy-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassPositionAccuracy-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassPositionAccuracy-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassPositionAccuracy-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassPositionAccuracy.html\">ValueSet ActClassPositionAccuracy</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassPositionAccuracy"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:52.53-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassPositionCoordinate-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassPositionCoordinate-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassPositionCoordinate-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassPositionCoordinate-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassPositionCoordinate-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassPositionCoordinate-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassPositionCoordinate.html\">ValueSet ActClassPositionCoordinate</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassPositionCoordinate"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:52.91-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassProcedure-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassProcedure-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassProcedure-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassProcedure-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassProcedure-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassProcedure-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassProcedure.html\">ValueSet ActClassProcedure</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassProcedure"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:53.31-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassProcessStep-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassProcessStep-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassProcessStep-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassProcessStep-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassProcessStep-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassProcessStep-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassProcessStep.html\">ValueSet ActClassProcessStep</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassProcessStep"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:53.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassPublicHealthCase-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassPublicHealthCase-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassPublicHealthCase-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassPublicHealthCase-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassPublicHealthCase-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassPublicHealthCase-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassPublicHealthCase.html\">ValueSet ActClassPublicHealthCase</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassPublicHealthCase"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:54.11-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassPublicHealthCase2-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassPublicHealthCase2-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassPublicHealthCase2-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassPublicHealthCase2-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassPublicHealthCase2-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassPublicHealthCase2-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassPublicHealthCase2.html\">ValueSet ActClassPublicHealthCase2</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassPublicHealthCase2"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:54.50-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassRecordOrganizer-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassRecordOrganizer-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassRecordOrganizer-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassRecordOrganizer-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassRecordOrganizer-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassRecordOrganizer-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassRecordOrganizer.html\">ValueSet ActClassRecordOrganizer</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassRecordOrganizer"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:54.90-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1n-v3-ActClassRegistration-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1n-v3-ActClassRegistration-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1n-v3-ActClassRegistration-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1n-v3-ActClassRegistration-vs-5-3-9</b></p><a name=\"hx1n-v3-ActClassRegistration-vs-5-3-9\"> </a><a name=\"hchx1n-v3-ActClassRegistration-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClassRegistration.html\">ValueSet ActClassRegistration</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:50:55-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClassRegistration"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:50:55.31-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : 