# HL7 Code Systems - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* **HL7 Code Systems**

## HL7 Code Systems

 Code systems defined by HL7 and published in HL7 International Standards 

 The list of code systems here are all of the code systems maintained by HL7 through the Unified Terminology Governance (UTG) process, published by HL7 in the different HL7 product families. Updates and maintenace in UTG is a continuous process, and the content available here is updated frequently. 

* Identity: 
  * Name: 
  * Version: 
  * Status: 
  * Content: 
  * Owner: 
  * Copyright: 
  * Date: 
  * Description: 
* Identity: [FDI-surface](CodeSystem-FDI-surface.md)
  * Name: Surface Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes a smattering of FDI tooth surface codes.
* Identity: [accepting-patients](CodeSystem-accepting-patients.md)
  * Name: Accepting Patients
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system defines a set of codes that can be used to indicate a practice is accepting new pa…
* Identity: [action-type](CodeSystem-action-type.md)
  * Name: ActionType
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of action to be performed.
* Identity: [activity-definition…](CodeSystem-activity-definition-category.md)
  * Name: ActivityDefinitionCategory
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: High-level categorization of the type of activity.
* Identity: [adjudication](CodeSystem-adjudication.md)
  * Name: Adjudication Value Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes a smattering of Adjudication Value codes which includes codes to indicate t…
* Identity: [adjudication-error](CodeSystem-adjudication-error.md)
  * Name: Adjudication Error Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes a smattering of adjudication codes.
* Identity: [adjudication-reason](CodeSystem-adjudication-reason.md)
  * Name: Adjudication Reason Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes smattering of Adjudication Reason codes.
* Identity: [admit-source](CodeSystem-admit-source.md)
  * Name: Admit source
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines a set of codes that can be used to indicate from where the patient came in.
* Identity: [adverse-event-categ…](CodeSystem-adverse-event-category.md)
  * Name: AdverseEventCategory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-08-28
  * Description: Overall categorization of the event, e.g. product-related or situational.
* Identity: [adverse-event-causa…](CodeSystem-adverse-event-causality-assess.md)
  * Name: AdverseEventCausalityAssessment
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes for the assessment of whether the entity caused the event.
* Identity: [adverse-event-causa…](CodeSystem-adverse-event-causality-method.md)
  * Name: AdverseEventCausalityMethod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-08-28
  * Description: This code system contains methods for assessing causality.
* Identity: [adverse-event-serio…](CodeSystem-adverse-event-seriousness.md)
  * Name: AdverseEventSeriousness
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Overall seriousness of this event for the patient.
* Identity: [adverse-event-sever…](CodeSystem-adverse-event-severity.md)
  * Name: AdverseEventSeverity
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The severity of the adverse event itself, in direct relation to the subject.
* Identity: [allerg-intol-substa…](CodeSystem-allerg-intol-substance-exp-risk.md)
  * Name: AllergyIntoleranceSubstanceExposureRisk
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The risk of an adverse reaction (allergy or intolerance) for this patient upon exposure to the subs…
* Identity: [allergyintolerance-…](CodeSystem-allergyintolerance-clinical.md)
  * Name: AllergyIntolerance Clinical Status Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Preferred value set for AllergyIntolerance Clinical Status.
* Identity: [allergyintolerance-…](CodeSystem-allergyintolerance-verification.md)
  * Name: AllergyIntolerance Verification Status
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: The verification status to support or decline the clinical status of the allergy or intolerance.
* Identity: [applicability](CodeSystem-applicability.md)
  * Name: Benefit cost applicability
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2018-06-05
  * Description: Whether the cost applies to in-network or out-of-network providers.
* Identity: [appointment-cancell…](CodeSystem-appointment-cancellation-reason.md)
  * Name: Appointment cancellation reason
  * Version: 2.1.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This example value set defines a set of reasons for the cancellation of an appointment.
* Identity: [appropriateness-sco…](CodeSystem-appropriateness-score.md)
  * Name: Appropriateness Score
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-18
  * Description: The scoring for appropriateness of an action based upon RAND.
* Identity: [artifact-contributi…](CodeSystem-artifact-contribution-instance-type.md)
  * Name: Artifact Contribution Instance Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Artifact Contribution Instance Type
* Identity: [artifact-identifier…](CodeSystem-artifact-identifier-type.md)
  * Name: Artifact Identifier Type Codes
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-02-20
  * Description: Identifier types for an artifact (e.g. version-independent, version-specific, short-name, endorser,…
* Identity: [artifact-relationsh…](CodeSystem-artifact-relationship-type.md)
  * Name: Artifact Relationship Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: n/a
  * Date: 2025-02-24
  * Description: This artifact incorporates the target artifact. This artifact is constructed with the target artifa…
* Identity: [artifact-url-classi…](CodeSystem-artifact-url-classifier.md)
  * Name: Artifact Url Classifier
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Code the reason for different URLs, eg abstract and full-text.
* Identity: [artifact-version-po…](CodeSystem-artifact-version-policy-codes.md)
  * Name: Artifact Version Policy Codes
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-02-16
  * Description: The versioning policy of an artifact (metadata, strict)
* Identity: [attribute-estimate-…](CodeSystem-attribute-estimate-type.md)
  * Name: StatisticAttribute Estimate Type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Method of reporting variability of estimates, such as confidence intervals, interquartile range or …
* Identity: [audit-entity-type](CodeSystem-audit-entity-type.md)
  * Name: Audit event entity type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2024-06-28
  * Description: Code for the entity type involved in the audit event.
* Identity: [audit-event-outcome](CodeSystem-audit-event-outcome.md)
  * Name: AuditEventOutcome
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2024-06-28
  * Description: Indicates whether the event succeeded or failed.
* Identity: [audit-event-type](CodeSystem-audit-event-type.md)
  * Name: Audit Event ID
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: DICOM
  * Date: 2015-03-26
  * Description: Event Types for Audit Events - defined by DICOM with some FHIR specific additions.
* Identity: [basic-resource-type](CodeSystem-basic-resource-type.md)
  * Name: Basic Resource Types
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines codes for resources not yet supported by (or which will never be supported b…
* Identity: [benefit-network](CodeSystem-benefit-network.md)
  * Name: Network Type Codes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system represents the contractual relationship between a provider and payer for administr…
* Identity: [benefit-term](CodeSystem-benefit-term.md)
  * Name: Benefit Term Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes a smattering of Benefit Term codes.
* Identity: [benefit-type](CodeSystem-benefit-type.md)
  * Name: Benefit Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes a smattering of Benefit type codes.
* Identity: [benefit-unit](CodeSystem-benefit-unit.md)
  * Name: Unit Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes a smattering of Unit type codes.
* Identity: [can-push-updates](CodeSystem-can-push-updates.md)
  * Name: Can-push-updates
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Ability of the primary source to push updates/alerts
* Identity: [care-service-access…](CodeSystem-care-service-accessibility.md)
  * Name: Care Service Accessibility
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system defines a set of codes that can be used to describe care service accessibility opt…
* Identity: [catalogType](CodeSystem-catalogType.md)
  * Name: CatalogType
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of catalog.
* Identity: [cdshooks-indicator](CodeSystem-cdshooks-indicator.md)
  * Name: CDS Hooks Indicator
  * Version: 2.0.0
  * Status: draft
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This codesystem captures the indicator codes defined by the CDS Hooks specification. The indicat…
* Identity: [certainty-rating](CodeSystem-certainty-rating.md)
  * Name: StatisticCertaintyRating
  * Version: 2.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The relative quality of the statistic.
* Identity: [certainty-subcompon…](CodeSystem-certainty-subcomponent-rating.md)
  * Name: StatisticCertaintySubcomponentRating
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The quality rating of the subcomponent of a quality of evidence rating.
* Identity: [certainty-subcompon…](CodeSystem-certainty-subcomponent-type.md)
  * Name: StatisticCertaintySubcomponentType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The subcomponent classification of quality of evidence rating systems.
* Identity: [certainty-type](CodeSystem-certainty-type.md)
  * Name: Evidence Certainty Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: The aspect of quality, confidence, or certainty.
* Identity: [characteristic-meth…](CodeSystem-characteristic-method.md)
  * Name: CharacteristicMethod
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The method used to determine the characteristic(s) of the variable.
* Identity: [chargeitem-billingc…](CodeSystem-chargeitem-billingcodes.md)
  * Name: ChargeItemCode
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Example set of codes that can be used for billing purposes.
* Identity: [choice-list-orienta…](CodeSystem-choice-list-orientation.md)
  * Name: ChoiceListOrientation
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Direction in which lists of possible answers should be displayed.
* Identity: [chromosome-human](CodeSystem-chromosome-human.md)
  * Name: chromosome-human
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [cg](http://www.hl7.org/Special/committees/clingenomics)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Chromosome number for human.
* Identity: [citation-artifact-c…](CodeSystem-citation-artifact-classifier.md)
  * Name: Citation Artifact Classifier
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2020-01-20
  * Description: Citation artifact classifier
* Identity: [citation-classifica…](CodeSystem-citation-classification-type.md)
  * Name: Citation Classification Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Citation classification type
* Identity: [citation-summary-st…](CodeSystem-citation-summary-style.md)
  * Name: Citation Summary Style
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: The format for display of the citation.
* Identity: [cited-artifact-abst…](CodeSystem-cited-artifact-abstract-type.md)
  * Name: Cited Artifact Abstract Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to express the reason and specific aspect for the variant abstract, such as language and speci…
* Identity: [cited-artifact-clas…](CodeSystem-cited-artifact-classification-type.md)
  * Name: Cited Artifact Classification Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Cited Artifact Classification Type
* Identity: [cited-artifact-cont…](CodeSystem-cited-artifact-contribution-type.md)
  * Name: Cited Artifact Contribution Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Citation contribution.
* Identity: [cited-artifact-part…](CodeSystem-cited-artifact-part-type.md)
  * Name: Cited Artifact Part Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: To describe the reason for the variant citation, such as version number or subpart specification.
* Identity: [cited-artifact-stat…](CodeSystem-cited-artifact-status-type.md)
  * Name: Cited Artifact Status Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Cited Artifact Status Type
* Identity: [cited-medium](CodeSystem-cited-medium.md)
  * Name: Cited Medium
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: NLM codes Internet or Print.
* Identity: [claim-exception](CodeSystem-claim-exception.md)
  * Name: Exception Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Exception codes.
* Identity: [claim-type](CodeSystem-claim-type.md)
  * Name: Claim Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes Claim Type codes.
* Identity: [claimcareteamrole](CodeSystem-claimcareteamrole.md)
  * Name: Claim Care Team Role Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Claim roles of the care team members providing products and services.
* Identity: [claiminformationcat…](CodeSystem-claiminformationcategory.md)
  * Name: Claim Information Category Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Information Category codes.
* Identity: [common-tags](CodeSystem-common-tags.md)
  * Name: Common Tags
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Common Tag Codes defined by FHIR project
* Identity: [communication-categ…](CodeSystem-communication-category.md)
  * Name: CommunicationCategory
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes for general categories of communications such as alerts, instructions, etc.
* Identity: [communication-not-d…](CodeSystem-communication-not-done-reason.md)
  * Name: CommunicationNotDoneReason
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes for the reason why a communication did not happen.
* Identity: [communication-topic](CodeSystem-communication-topic.md)
  * Name: CommunicationTopic
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes describing the purpose or content of the communication.
* Identity: [composite-measure-s…](CodeSystem-composite-measure-scoring.md)
  * Name: CompositeMeasureScoring
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The composite scoring method of the measure.
* Identity: [composition-altcode…](CodeSystem-composition-altcode-kind.md)
  * Name: AlternativeCodeKind
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Indicates the type of use for which the code is defined.
* Identity: [composition-altcode…](CodeSystem-composition-altcode-kind.md)
  * Name: AlternativeCodeKind
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Indicates the type of use for which the code is defined.
* Identity: [conceptdomains](CodeSystem-conceptdomains.md)
  * Name: Concept Domains
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: CC0
  * Date: 2025-11-13
  * Description: Concept Domains - includes both v2 abd v3 concept domains
* Identity: [condition-category](CodeSystem-condition-category.md)
  * Name: Condition Category Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Preferred value set for Condition Categories.
* Identity: [condition-clinical](CodeSystem-condition-clinical.md)
  * Name: Condition Clinical Status Codes
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Preferred value set for Condition Clinical Status.
* Identity: [condition-state](CodeSystem-condition-state.md)
  * Name: ConditionState
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Enumeration indicating whether the condition is currently active, inactive, or has been resolved.
* Identity: [condition-ver-status](CodeSystem-condition-ver-status.md)
  * Name: ConditionVerificationStatus
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The verification status to support or decline the clinical status of the condition or diagnosis.
* Identity: [conformance-expecta…](CodeSystem-conformance-expectation.md)
  * Name: ConformanceExpectation
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Indicates the degree of adherence to a specified behavior or capability expected for a system to be…
* Identity: [consentaction](CodeSystem-consentaction.md)
  * Name: Consent Action Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Consent Action codes.
* Identity: [consentcategorycodes](CodeSystem-consentcategorycodes.md)
  * Name: Consent Category Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Consent Directive Type codes, including several consent directive re…
* Identity: [consentpolicycodes](CodeSystem-consentpolicycodes.md)
  * Name: Consent PolicyRule Codes
  * Version: 3.0.1
  * Status: active
  * Content: complete
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Regulatory consent policy types from the US and other regions.
* Identity: [consentscope](CodeSystem-consentscope.md)
  * Name: Consent Scope Codes
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes the four Consent scope codes.
* Identity: [consentverification](CodeSystem-consentverification.md)
  * Name: Consent Verification Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cbcc](http://www.hl7.org/Special/committees/cbcc)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes base Consent Verification codes.
* Identity: [contactentity-type](CodeSystem-contactentity-type.md)
  * Name: Contact entity type
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This example value set defines a set of codes that can be used to indicate the purpose for which yo…
* Identity: [container-cap](CodeSystem-container-cap.md)
  * Name: ContainerCap
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Color of the container cap.
* Identity: [contract-content-de…](CodeSystem-contract-content-derivative.md)
  * Name: Contract Content Derivation Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This is an example set of Content Derivative type codes, which represent the minimal content derive…
* Identity: [contract-data-meani…](CodeSystem-contract-data-meaning.md)
  * Name: ContractDataMeaning
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: How a resource reference is interpreted when evaluating contract offers.
* Identity: [contract-type](CodeSystem-contract-type.md)
  * Name: Contract Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Contract Type codes.
* Identity: [contractaction](CodeSystem-contractaction.md)
  * Name: Contract Action Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Contract Action codes.
* Identity: [contractactorrole](CodeSystem-contractactorrole.md)
  * Name: Contract Actor Role Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Contract Actor Role codes.
* Identity: [contractsignertypec…](CodeSystem-contractsignertypecodes.md)
  * Name: Contract Signer Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: other
  * Date: 2025-11-13
  * Description: This value set includes sample Contract Signer Type codes.
* Identity: [contractsubtypecodes](CodeSystem-contractsubtypecodes.md)
  * Name: Contract Subtype Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Contract Subtype codes.
* Identity: [contracttermsubtype…](CodeSystem-contracttermsubtypecodes.md)
  * Name: Contract Term Subtype Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Contract Term SubType codes.
* Identity: [contracttermtypecod…](CodeSystem-contracttermtypecodes.md)
  * Name: Contract Term Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Contract Term Type codes.
* Identity: [contributor-role](CodeSystem-contributor-role.md)
  * Name: Contributor Role
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to code the format of the display string.
* Identity: [contributor-summary…](CodeSystem-contributor-summary-source.md)
  * Name: Contributor Summary Source
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to code the producer or rule for creating the display string.
* Identity: [contributor-summary…](CodeSystem-contributor-summary-style.md)
  * Name: Contributor Summary Style
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to code the format of the display string.
* Identity: [contributor-summary…](CodeSystem-contributor-summary-type.md)
  * Name: Contributor Summary Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to code author list statement, contributorship statement, and such.
* Identity: [copy-number-event](CodeSystem-copy-number-event.md)
  * Name: CopyNumberEvent
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Copy Number Event.
* Identity: [coverage-class](CodeSystem-coverage-class.md)
  * Name: Coverage Class Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes Coverage Class codes.
* Identity: [coverage-copay-type](CodeSystem-coverage-copay-type.md)
  * Name: Coverage Copay Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Coverage Copayment Type codes.
* Identity: [coverage-selfpay](CodeSystem-coverage-selfpay.md)
  * Name: Coverage SelfPay Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes Coverage SelfPay codes.
* Identity: [coverageeligibility…](CodeSystem-coverageeligibilityresponse-ex-auth-support.md)
  * Name: CoverageEligibilityResponse Auth Support Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes CoverageEligibilityResponse Auth Support codes.
* Identity: [cql-access-modifier](CodeSystem-cql-access-modifier.md)
  * Name: CQL Access Modifier
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-02-16
  * Description: Access modifiers defined by the Clinical Quality Language (CQL) specification in the [Access Modifi…
* Identity: [data-absent-reason](CodeSystem-data-absent-reason.md)
  * Name: DataAbsentReason
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-11-01
  * Description: Used to specify why the normally expected content of the data element is missing.
* Identity: [definition-status](CodeSystem-definition-status.md)
  * Name: DefinitionStatus
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes identifying the lifecycle stage of a definition.
* Identity: [definition-topic](CodeSystem-definition-topic.md)
  * Name: DefinitionTopic
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: High-level categorization of the definition, used for searching, sorting, and filtering.
* Identity: [definition-use](CodeSystem-definition-use.md)
  * Name: Structure Definition Use Codes / Keywords
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Structure Definition Use Codes / Keywords
* Identity: [device-status-reason](CodeSystem-device-status-reason.md)
  * Name: FHIRDeviceStatusReason
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The availability status reason of the device.
* Identity: [devicealert-activat…](CodeSystem-devicealert-activationState.md)
  * Name: Device Alert Activation State
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [dev](http://www.hl7.org/Special/committees/healthcaredevices)
  * Copyright: n/a
  * Date: 2023-12-10
  * Description: Describes the activation state of a DeviceAlert.
* Identity: [devicealert-priority](CodeSystem-devicealert-priority.md)
  * Name: Device Alert Priority
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [dev](http://www.hl7.org/Special/committees/healthcaredevices)
  * Copyright: n/a
  * Date: 2023-12-10
  * Description: Describes the priority of a DeviceAlert.
* Identity: [diagnosis-role](CodeSystem-diagnosis-role.md)
  * Name: Diagnosis Role
  * Version: 1.1.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines a set of codes that can be used to express the role of a diagnosis on the En…
* Identity: [diagnosistype](CodeSystem-diagnosistype.md)
  * Name: Diagnosis Type Codes
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes Diagnosis Type codes.
* Identity: [dicom-audit-lifecyc…](CodeSystem-dicom-audit-lifecycle.md)
  * Name: DICOM Audit Message Record Lifecycle Events
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: DICOM
  * Date: 2025-11-13
  * Description: Attached is vocabulary for the record lifecycle events, as per DICOM Audit Message,
* Identity: [diet](CodeSystem-diet.md)
  * Name: Diet
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines a set of codes that can be used to indicate dietary preferences or restricti…
* Identity: [directness](CodeSystem-directness.md)
  * Name: EvidenceDirectness
  * Version: 2.0.0
  * Status: draft
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The quality of how direct the match is.
* Identity: [discharge-dispositi…](CodeSystem-discharge-disposition.md)
  * Name: Discharge disposition
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines a set of codes that can be used to where the patient left the hospital.
* Identity: [dose-rate-type](CodeSystem-dose-rate-type.md)
  * Name: DoseAndRateType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The kind of dose or rate specified.
* Identity: [encounter-special-a…](CodeSystem-encounter-special-arrangements.md)
  * Name: Special arrangements
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines a set of codes that can be used to indicate the kinds of special arrangement…
* Identity: [encounter-subject-s…](CodeSystem-encounter-subject-status.md)
  * Name: Encounter subject status
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This example value set defines a set of codes that can be used to indicate the status of the subjec…
* Identity: [encounter-type](CodeSystem-encounter-type.md)
  * Name: Encounter type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This example value set defines a set of codes that can be used to indicate the type of encounter: a…
* Identity: [endpoint-connection…](CodeSystem-endpoint-connection-type.md)
  * Name: Endpoint Connection Type
  * Version: 2.1.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This is an example value set defined by the FHIR project, that could be used to represent possible …
* Identity: [endpoint-payload-ty…](CodeSystem-endpoint-payload-type.md)
  * Name: Endpoint Payload Type
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This is an example value set defined by the FHIR project, that could be used to represent possible …
* Identity: [entformula-additive](CodeSystem-entformula-additive.md)
  * Name: Enteral Formula Additive Type Code
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: EnteralFormulaAdditiveType: Codes for the type of modular component such as protein, carbohydrate o…
* Identity: [episodeofcare-type](CodeSystem-episodeofcare-type.md)
  * Name: Episode of care type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This example value set defines a set of codes that can be used to express the usage type of an Epis…
* Identity: [evidence-quality](CodeSystem-evidence-quality.md)
  * Name: QualityOfEvidenceRating
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: A rating system that describes the quality of evidence such as the GRADE, DynaMed, or Oxford CEBM s…
* Identity: [ex-USCLS](CodeSystem-ex-USCLS.md)
  * Name: USCLS Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes a smattering of USCLS codes.
* Identity: [ex-benefitcategory](CodeSystem-ex-benefitcategory.md)
  * Name: Benefit Category Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes examples of Benefit Category codes.
* Identity: [ex-claimsubtype](CodeSystem-ex-claimsubtype.md)
  * Name: Example Claim SubType Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Claim SubType codes which are used to distinguish the claim types fo…
* Identity: [ex-coverage-financi…](CodeSystem-ex-coverage-financial-exception.md)
  * Name: Example Coverage Financial Exception Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes Example Coverage Financial Exception Codes.
* Identity: [ex-diagnosis-on-adm…](CodeSystem-ex-diagnosis-on-admission.md)
  * Name: Example Diagnosis on Admission Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes example Diagnosis on Admission codes.
* Identity: [ex-diagnosisrelated…](CodeSystem-ex-diagnosisrelatedgroup.md)
  * Name: Example Diagnosis Related Group Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes example Diagnosis Related Group codes.
* Identity: [ex-diagnosistype](CodeSystem-ex-diagnosistype.md)
  * Name: Example Diagnosis Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes example Diagnosis Type codes.
* Identity: [ex-payee-resource-t…](CodeSystem-ex-payee-resource-type.md)
  * Name: ClaimPayeeResourceType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The type of Claim payee Resource.
* Identity: [ex-paymenttype](CodeSystem-ex-paymenttype.md)
  * Name: Example Payment Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes example Payment Type codes.
* Identity: [ex-procedure-type](CodeSystem-ex-procedure-type.md)
  * Name: Example Procedure Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes example Procedure Type codes.
* Identity: [ex-programcode](CodeSystem-ex-programcode.md)
  * Name: Example Program Reason Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Program Reason Span codes.
* Identity: [ex-providerqualific…](CodeSystem-ex-providerqualification.md)
  * Name: Example Provider Qualification Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Provider Qualification codes.
* Identity: [ex-relatedclaimrela…](CodeSystem-ex-relatedclaimrelationship.md)
  * Name: Example Related Claim Relationship Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Related Claim Relationship codes.
* Identity: [ex-revenue-center](CodeSystem-ex-revenue-center.md)
  * Name: Example Revenue Center Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Revenue Center codes.
* Identity: [ex-serviceplace](CodeSystem-ex-serviceplace.md)
  * Name: Example Service Place Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes a smattering of Service Place codes.
* Identity: [ex-tooth](CodeSystem-ex-tooth.md)
  * Name: Oral Site Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes a smattering of FDI oral site codes.
* Identity: [ex-visionprescripti…](CodeSystem-ex-visionprescriptionproduct.md)
  * Name: Example Vision Prescription Product Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes a smattering of Prescription Product codes.
* Identity: [expansion-parameter…](CodeSystem-expansion-parameter-source.md)
  * Name: ExpansionParameterSource
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Declares what the source of a parameter is.
* Identity: [expansion-processin…](CodeSystem-expansion-processing-rule.md)
  * Name: ExpansionProcessingRule
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Defines how concepts are processed into the expansion when it's for UI presentation.
* Identity: [extra-security-role…](CodeSystem-extra-security-role-type.md)
  * Name: Security Role Type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: This CodeSystem contains Additional FHIR-defined Security Role types not defined elsewhere
* Identity: [failure-action](CodeSystem-failure-action.md)
  * Name: Failure-action
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The result if validation fails
* Identity: [financialtaskcode](CodeSystem-financialtaskcode.md)
  * Name: Financial Task Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes Financial Task codes.
* Identity: [financialtaskinputt…](CodeSystem-financialtaskinputtype.md)
  * Name: Financial Task Input Type Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes Financial Task Input Type codes.
* Identity: [flag-category](CodeSystem-flag-category.md)
  * Name: Flag Category
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Example list of general categories for flagged issues. (Not complete or necessarily appropriate.)
* Identity: [forms-codes](CodeSystem-forms-codes.md)
  * Name: Form Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes a sample set of Forms codes.
* Identity: [fundsreserve](CodeSystem-fundsreserve.md)
  * Name: Funds Reservation Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample funds reservation type codes.
* Identity: [goal-acceptance-sta…](CodeSystem-goal-acceptance-status.md)
  * Name: GoalAcceptanceStatus
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes indicating whether the goal has been accepted by a stakeholder.
* Identity: [goal-achievement](CodeSystem-goal-achievement.md)
  * Name: Goal achievement status
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Describes the progression, or lack thereof, towards the goal against the target.
* Identity: [goal-category](CodeSystem-goal-category.md)
  * Name: Goal category
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Codes for grouping goals to use for filtering or presentation.
* Identity: [goal-priority](CodeSystem-goal-priority.md)
  * Name: Goal priority
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Indicates the level of importance associated with reaching or sustaining a goal.
* Identity: [goal-relationship-t…](CodeSystem-goal-relationship-type.md)
  * Name: GoalRelationshipType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Types of relationships between two goals.
* Identity: [guide-parameter-code](CodeSystem-guide-parameter-code.md)
  * Name: GuideParameterCode
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Code of parameter that is input to the guide.
* Identity: [handling-condition](CodeSystem-handling-condition.md)
  * Name: HandlingConditionSet
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Set of handling instructions prior testing of the specimen.
* Identity: [history-absent-reas…](CodeSystem-history-absent-reason.md)
  * Name: FamilyHistoryAbsentReason
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes describing the reason why a family member's history is not available.
* Identity: [hl7-work-group](CodeSystem-hl7-work-group.md)
  * Name: HL7Workgroup
  * Version: 8.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org/)
  * Copyright: THO
  * Date: 2024-08-19
  * Description: An HL7 administrative unit that owns artifacts in the FHIR specification.
* Identity: [hl7TermMaintInfra](CodeSystem-hl7TermMaintInfra.md)
  * Name: HL7 Terminology Maintenance Infrastructure Vocabulary
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2018-12-15
  * Description: Codes that may have been strings or other types of data in pre-existing tooling for V3 and V2 termi…
* Identity: [immunization-evalua…](CodeSystem-immunization-evaluation-dose-status.md)
  * Name: Immunization Evaluation Dose Status codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-evalua…](CodeSystem-immunization-evaluation-dose-status-reason.md)
  * Name: Immunization Evaluation Dose Status Reason codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-fundin…](CodeSystem-immunization-funding-source.md)
  * Name: Immunization Funding Source
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-origin](CodeSystem-immunization-origin.md)
  * Name: Immunization Origin Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-progra…](CodeSystem-immunization-program-eligibility.md)
  * Name: Immunization Program Eligibility
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-recomm…](CodeSystem-immunization-recommendation-status.md)
  * Name: Immunization Recommendation Status Codes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [immunization-subpot…](CodeSystem-immunization-subpotent-reason.md)
  * Name: Immunization Subpotent Reason
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pher](http://www.hl7.org/Special/committees/pher)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: The value set to instantiate this attribute should be drawn from a terminologically robust code sys…
* Identity: [implantStatus](CodeSystem-implantStatus.md)
  * Name: Implant Status
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: A set codes that define the functional status of an implanted device.
* Identity: [insurance-coverage-…](CodeSystem-insurance-coverage-type.md)
  * Name: Insurance Coverage Type
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system defines a set of codes for Insurance CoverageType.
* Identity: [insurance-plan-type](CodeSystem-insurance-plan-type.md)
  * Name: Insurance plan type
  * Version: 2.0.1
  * Status: active
  * Content: fragment
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This example value set defines a set of codes that can be used to indicate a type of insurance plan.
* Identity: [insurance-product-t…](CodeSystem-insurance-product-type.md)
  * Name: Insurance Product Type
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system defines a set of codes for Insurance Product Type.
* Identity: [insuranceplan-plan-…](CodeSystem-insuranceplan-plan-type.md)
  * Name: Insuranceplan Plan Type
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system defines a set of codes for Insuranceplan Plan Type.
* Identity: [iso-21089-lifecycle](CodeSystem-iso-21089-lifecycle.md)
  * Name: ISO 21089 2017 Health Record Lifecycle Events
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: ISO
  * Date: 2025-11-13
  * Description: Attached is vocabulary for the 27 record lifecycle events, as per ISO TS 21089-2017, Health Informa…
* Identity: [library-type](CodeSystem-library-type.md)
  * Name: LibraryType
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of knowledge asset this library contains.
* Identity: [list-empty-reason](CodeSystem-list-empty-reason.md)
  * Name: List Empty Reasons
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: General reasons for a list to be empty. Reasons are either related to a summary list (i.e. problem …
* Identity: [list-example-use-co…](CodeSystem-list-example-use-codes.md)
  * Name: Example Use Codes for List
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Example use codes for the List resource - typical kinds of use.
* Identity: [list-order](CodeSystem-list-order.md)
  * Name: List Order Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Base values for the order of the items in a list resource.
* Identity: [location-physical-t…](CodeSystem-location-physical-type.md)
  * Name: Location type
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This example value set defines a set of codes that can be used to indicate the physical form of the…
* Identity: [match-grade](CodeSystem-match-grade.md)
  * Name: MatchGrade
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: A Master Patient Index (MPI) assessment of whether a candidate patient record is a match or not.
* Identity: [measure-aggregate-m…](CodeSystem-measure-aggregate-method.md)
  * Name: Measure Aggregate Method
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2023-02-08
  * Description: Aggregation method for a measure (e.g. sum, average, median, minimum, maximum, count)
* Identity: [measure-data-usage](CodeSystem-measure-data-usage.md)
  * Name: MeasureDataUsage
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The intended usage for supplemental data elements in the measure.
* Identity: [measure-improvement…](CodeSystem-measure-improvement-notation.md)
  * Name: MeasureImprovementNotation
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Observation values that indicate what change in a measurement value or score is indicative of an im…
* Identity: [measure-population](CodeSystem-measure-population.md)
  * Name: Measure Population Type
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The type of population.
* Identity: [measure-scoring](CodeSystem-measure-scoring.md)
  * Name: Measure Scoring
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2021-03-26
  * Description: The scoring type of the measure.
* Identity: [measure-supplementa…](CodeSystem-measure-supplemental-data.md)
  * Name: Measure Supplemental Data
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2023-02-06
  * Description: Identifier supplemental data in a population for measuring purposes.
* Identity: [measure-type](CodeSystem-measure-type.md)
  * Name: MeasureType
  * Version: 3.0.1
  * Status: active
  * Content: complete
  * Owner: [cqi](http://www.hl7.org/Special/committees/cqi)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of measure (includes codes from 2.16.840.1.113883.1.11.20368).
* Identity: [med-admin-perform-f…](CodeSystem-med-admin-perform-function.md)
  * Name: MedicationAdministration Performer Function Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: MedicationAdministration Performer Function Codes
* Identity: [media-category](CodeSystem-media-category.md)
  * Name: Digital Media Category
  * Version: 4.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-05-17
  * Description: Codes for high level media types - whether the media is an image, video, or audio.
* Identity: [medical-management-…](CodeSystem-medical-management-type.md)
  * Name: Medical Management Type
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Types of medical management requirements or processes used by health insurers (payers) that may imp…
* Identity: [medication-admin-lo…](CodeSystem-medication-admin-location.md)
  * Name: MedicationAdministration Location Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: MedicationAdministration Location Codes
* Identity: [medication-usage-ad…](CodeSystem-medication-usage-admin-location.md)
  * Name: MedicationUsage Administration Location Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: MedicationUsage Administration Location Codes
* Identity: [medicationdispense-…](CodeSystem-medicationdispense-performer-function.md)
  * Name: MedicationDispense Performer Function Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: MedicationDispense Performer Function Codes
* Identity: [medicationknowledge…](CodeSystem-medicationknowledge-characteristic.md)
  * Name: MedicationKnowledge Characteristic Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: MedicationKnowledge Characteristic Codes
* Identity: [medicationknowledge…](CodeSystem-medicationknowledge-package-type.md)
  * Name: MedicationKnowledge Package Type Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: MedicationKnowledge Package Type Codes
* Identity: [medicationknowledge…](CodeSystem-medicationknowledge-status.md)
  * Name: MedicationKnowledge Status Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: MedicationKnowledge Status Codes
* Identity: [medicationrequest-a…](CodeSystem-medicationrequest-admin-location.md)
  * Name: Medication request administration location codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: MedicationRequest Administration Location Codes
* Identity: [medicationrequest-c…](CodeSystem-medicationrequest-category.md)
  * Name: MedicationRequest Category Codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [pc](http://www.hl7.org/Special/committees/patientcare)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: MedicationRequest Category Codes
* Identity: [medicationrequest-c…](CodeSystem-medicationrequest-course-of-therapy.md)
  * Name: MedicationRequest Course of Therapy Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: MedicationRequest Course of Therapy Codes
* Identity: [medicationrequest-s…](CodeSystem-medicationrequest-status-reason.md)
  * Name: MedicationRequest Status Reason Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: MedicationRequest Status Reason Codes
* Identity: [message-reasons-enc…](CodeSystem-message-reasons-encounter.md)
  * Name: Example Message Reason Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Example Message Reasons. These are the set of codes that might be used an updating an encounter usi…
* Identity: [missingtoothreason](CodeSystem-missingtoothreason.md)
  * Name: Missing Tooth Reason Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Missing Tooth Reason codes.
* Identity: [modifiers](CodeSystem-modifiers.md)
  * Name: Modifier type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Modifier type codes.
* Identity: [name-assembly-order](CodeSystem-name-assembly-order.md)
  * Name: HumanNameAssemblyOrder
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: A code that represents the preferred display order of the components of a human name.
* Identity: [ndh-healthcare-serv…](CodeSystem-ndh-healthcare-service-category.md)
  * Name: NDH Healthcare Service Category
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system defines a set of codes for NDH Healthcare Service Category used in the National Di…
* Identity: [need](CodeSystem-need.md)
  * Name: Need
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The frequency with which the target must be validated
* Identity: [nutrition-intake-ca…](CodeSystem-nutrition-intake-category.md)
  * Name: Nutrition intake category codes
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: NutritionIntake Category Codes
* Identity: [object-role](CodeSystem-object-role.md)
  * Name: AuditEventEntityRole
  * Version: 1.1.0
  * Status: active
  * Content: complete
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2025-05-13
  * Description: Code representing the role the entity played in the audit event.
* Identity: [observation-category](CodeSystem-observation-category.md)
  * Name: Observation Category Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Observation Category codes.
* Identity: [observation-statist…](CodeSystem-observation-statistics.md)
  * Name: StatisticsCode
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The statistical operation parameter -"statistic" codes.
* Identity: [operation-outcome](CodeSystem-operation-outcome.md)
  * Name: Operation Outcome Codes
  * Version: 3.0.0
  * Status: draft
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Operation Outcome codes used by FHIR test servers (see Implementation file translations.xml)
* Identity: [organization-affili…](CodeSystem-organization-affiliation-role.md)
  * Name: Organization Affiliation Role
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system defines a set of codes that can be used to indicate an organization affiliation ro…
* Identity: [organization-affili…](CodeSystem-organization-affiliation-role-for-hie.md)
  * Name: Organization Affiliation Role for HIE
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system defines a set of codes that can be used to indicate an organization affiliation ro…
* Identity: [organization-alias-…](CodeSystem-organization-alias-type.md)
  * Name: Organization Alias Type
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system defines a set of codes for indicating oranization alias type.
* Identity: [organization-type](CodeSystem-organization-type.md)
  * Name: Organization type
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This example value set defines a set of codes that can be used to indicate a type of organization.
* Identity: [parameter-group](CodeSystem-parameter-group.md)
  * Name: DeviceDefinitionParameterGroup
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes identifying groupings of parameters; e.g. Cardiovascular.
* Identity: [participant-type](CodeSystem-participant-type.md)
  * Name: Participant type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines a set of codes that can be used to indicate how an individual participates i…
* Identity: [payeetype](CodeSystem-payeetype.md)
  * Name: Payee Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Codes indicating the type of party to be reimbursed for cost of products and services.
* Identity: [payment-adjustment-…](CodeSystem-payment-adjustment-reason.md)
  * Name: Payment Adjustment Reason Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes smattering of Payment Adjustment Reason codes.
* Identity: [payment-type](CodeSystem-payment-type.md)
  * Name: Payment Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes sample Payment Type codes.
* Identity: [paymentstatus](CodeSystem-paymentstatus.md)
  * Name: Payment Status Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes a sample set of Payment Status codes.
* Identity: [plan-definition-type](CodeSystem-plan-definition-type.md)
  * Name: PlanDefinitionType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of PlanDefinition.
* Identity: [practitioner-role](CodeSystem-practitioner-role.md)
  * Name: Practitioner role
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This example value set defines a set of codes that can be used to indicate the role of a Practition…
* Identity: [primary-source-type](CodeSystem-primary-source-type.md)
  * Name: Primary-source-type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Type of the validation primary source
* Identity: [procedure-type](CodeSystem-procedure-type.md)
  * Name: Procedure Type Codes
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes Procedure Type codes.
* Identity: [processpriority](CodeSystem-processpriority.md)
  * Name: Process Priority Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes the financial processing priority codes.
* Identity: [professional-creden…](CodeSystem-professional-credential-status.md)
  * Name: Professional Credential Status
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system establishes a series of codes designed to represent the status of professional cre…
* Identity: [program](CodeSystem-program.md)
  * Name: Program
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines an example set of codes that could be can be used to classify groupings of s…
* Identity: [provenance-particip…](CodeSystem-provenance-participant-type.md)
  * Name: Provenance participant type
  * Version: 1.1.0
  * Status: active
  * Content: complete
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2024-06-28
  * Description: These codes define the type of participation by an agent in a provenance activity. An agent is some…
* Identity: [published-in-type](CodeSystem-published-in-type.md)
  * Name: Published In Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: The type of publication such as book, database, or journal.
* Identity: [push-type-available](CodeSystem-push-type-available.md)
  * Name: Push-type-available
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Type of alerts/updates the primary source can send
* Identity: [question-max-occurs](CodeSystem-question-max-occurs.md)
  * Name: MaxOccurs
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Flags an element as having unlimited repetitions.
* Identity: [questionnaire-usage…](CodeSystem-questionnaire-usage-mode.md)
  * Name: QuestionnaireItemUsageMode
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Identifies the modes of usage of a questionnaire that should enable a particular questionnaire item.
* Identity: [reaction-event-cert…](CodeSystem-reaction-event-certainty.md)
  * Name: AllergyIntoleranceCertainty
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Statement about the degree of clinical certainty that a specific substance was the cause of the man…
* Identity: [reason-medication-g…](CodeSystem-reason-medication-given.md)
  * Name: Reason Medication Given Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [phx](http://www.hl7.org/Special/committees/medication)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set is provided as an example. The value set to instantiate this attribute should be dra…
* Identity: [recommendation-stre…](CodeSystem-recommendation-strength.md)
  * Name: StrengthOfRecommendationRating
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: A rating system that describes the strength of the recommendation, such as the GRADE, DynaMed, or H…
* Identity: [referencerange-mean…](CodeSystem-referencerange-meaning.md)
  * Name: Observation Reference Range Meaning Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines a set of codes that can be used to indicate the meaning/use of a reference r…
* Identity: [rejection-criteria](CodeSystem-rejection-criteria.md)
  * Name: RejectionCriterion
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Criterion for rejection of the specimen by laboratory.
* Identity: [research-study-obje…](CodeSystem-research-study-objective-type.md)
  * Name: ResearchStudyObjectiveType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes for the kind of study objective.
* Identity: [research-study-phase](CodeSystem-research-study-phase.md)
  * Name: ResearchStudyPhase
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes for the stage in the progression of a therapy from initial experimental use in humans in clin…
* Identity: [research-study-prim…](CodeSystem-research-study-prim-purp-type.md)
  * Name: ResearchStudyPrimaryPurposeType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes for the main intent of the study.
* Identity: [research-study-reas…](CodeSystem-research-study-reason-stopped.md)
  * Name: ResearchStudyReasonStopped
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes for why the study ended prematurely.
* Identity: [research-subject-mi…](CodeSystem-research-subject-milestone.md)
  * Name: ResearchSubjectMilestone
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Indicates the progression of a study subject through the study milestones.
* Identity: [research-subject-st…](CodeSystem-research-subject-state.md)
  * Name: ResearchSubjectState
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Indicates the progression of a study subject through a study.
* Identity: [research-subject-st…](CodeSystem-research-subject-state-type.md)
  * Name: ResearchSubjectStateType
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Identifies the kind of state being refered to.
* Identity: [resource-security-c…](CodeSystem-resource-security-category.md)
  * Name: ResourceSecurityCategory
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Provides general guidance around the kind of access Control to Read, Search, Create, Update, or Del…
* Identity: [resource-type-link](CodeSystem-resource-type-link.md)
  * Name: PayeeResourceType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The type of payee Resource.
* Identity: [risk-probability](CodeSystem-risk-probability.md)
  * Name: Risk Probability
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Codes representing the likelihood of a particular outcome in a risk assessment.
* Identity: [security-source-type](CodeSystem-security-source-type.md)
  * Name: Audit Event Source Type
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [sec](http://www.hl7.org/Special/committees/secure)
  * Copyright: THO
  * Date: 2010-08-26
  * Description: The type of process where the audit event originated from.
* Identity: [service-category](CodeSystem-service-category.md)
  * Name: Service category
  * Version: 1.1.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines an example set of codes that can be used to classify groupings of service-ty…
* Identity: [service-delivery-me…](CodeSystem-service-delivery-method.md)
  * Name: Service Delivery Method
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system defines a set of codes that can be used to indicate service delivery method
* Identity: [service-provision-c…](CodeSystem-service-provision-conditions.md)
  * Name: ServiceProvisionConditions
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The code(s) that detail the conditions under which the healthcare service is available/offered.
* Identity: [service-referral-me…](CodeSystem-service-referral-method.md)
  * Name: ReferralMethod
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The methods of referral can be used when referring to a specific HealthCareService resource.
* Identity: [service-type](CodeSystem-service-type.md)
  * Name: Service type
  * Version: 1.1.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines an example set of codes of service-types.
* Identity: [sex-parameter-for-c…](CodeSystem-sex-parameter-for-clinical-use.md)
  * Name: Sex Parameter For Clinical Use
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: A summary parameter that provides guidance on how a receiver should apply settings or reference ran…
* Identity: [smart-capabilities](CodeSystem-smart-capabilities.md)
  * Name: SmartCapabilities
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Codes that define what the server is capable of.
* Identity: [software-system-typ…](CodeSystem-software-system-type-codes.md)
  * Name: Software System Type Codes
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-02-16
  * Description: Types of software systems that support knowledge artifact authoring and evaluation (authoring, test…
* Identity: [special-values](CodeSystem-special-values.md)
  * Name: SpecialValues
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: A set of generally useful codes defined so they can be included in value sets.
* Identity: [standards-status](CodeSystem-standards-status.md)
  * Name: StandardsStatus
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: HL7 Ballot/Standards status of artifact.
* Identity: [state-change-reason](CodeSystem-state-change-reason.md)
  * Name: StateChangeReason
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [brr](http://www.hl7.org/Special/committees/rcrim)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Indicates why the state of the subject changed.
* Identity: [statistic-model-code](CodeSystem-statistic-model-code.md)
  * Name: Statistic Model Code
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: The role that the assertion variable plays.
* Identity: [statistic-type](CodeSystem-statistic-type.md)
  * Name: StatisticStatisticType
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The type of a specific statistic.
* Identity: [study-type](CodeSystem-study-type.md)
  * Name: StatisticStudyType
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: The type of study a statistic was derived from.
* Identity: [subscriber-relation…](CodeSystem-subscriber-relationship.md)
  * Name: SubscriberPolicyholder Relationship Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set includes codes for the relationship between the Subscriber and the Beneficiary (insu…
* Identity: [subscription-channe…](CodeSystem-subscription-channel-type.md)
  * Name: SubscriptionChannel Type Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: The type of method used to execute a subscription
* Identity: [subscription-error](CodeSystem-subscription-error.md)
  * Name: Subscription Error Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Codes to represent subscription error details
* Identity: [subscription-status…](CodeSystem-subscription-status-at-event.md)
  * Name: SubscriptionStatusAtEvent
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: A status code for the state of the Subscription.
* Identity: [subscription-tag](CodeSystem-subscription-tag.md)
  * Name: SubscriptionTag
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Tags to put on a resource after subscriptions have been sent.
* Identity: [substance-category](CodeSystem-substance-category.md)
  * Name: Substance Category Codes
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: Substance category codes
* Identity: [supply-item-type](CodeSystem-supply-item-type.md)
  * Name: Supply Item Type
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value sets refers to a specific supply item.
* Identity: [supply-kind](CodeSystem-supply-kind.md)
  * Name: Supply Type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value sets refers to a Category of supply.
* Identity: [supplyrequest-reason](CodeSystem-supplyrequest-reason.md)
  * Name: SupplyRequestReason
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The reason why the supply item was requested.
* Identity: [synthesis-type](CodeSystem-synthesis-type.md)
  * Name: StatisticSynthesisType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Types of combining results from a body of evidence (eg. summary data meta-analysis).
* Identity: [testscript-operatio…](CodeSystem-testscript-operation-codes.md)
  * Name: Test script operation code
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines a set of codes that are used to indicate the supported operations of a testi…
* Identity: [testscript-profile-…](CodeSystem-testscript-profile-destination-types.md)
  * Name: Test script profile destination type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines a set of codes that are used to indicate the profile type of a test system w…
* Identity: [testscript-profile-…](CodeSystem-testscript-profile-origin-types.md)
  * Name: Test script profile origin type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This value set defines a set of codes that are used to indicate the profile type of a test system w…
* Identity: [title-type](CodeSystem-title-type.md)
  * Name: Title Type
  * Version: 1.0.0
  * Status: trial-use
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: n/a
  * Date: 2025-01-20
  * Description: Used to express the reason and specific aspect for the variant title, such as language and specific…
* Identity: [triggerEventID](CodeSystem-triggerEventID.md)
  * Name: Trigger Event ID
  * Version: 3.0.0
  * Status: active
  * Content: fragment
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**This code system contains all HL7 artifacts of type TE (Trigger Event) that are cr…
* Identity: [usage-context-type](CodeSystem-usage-context-type.md)
  * Name: UsageContextType
  * Version: 2.0.1
  * Status: active
  * Content: complete
  * Owner: [fhir](http://www.hl7.org/Special/committees/fiwg)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: A code that specifies a type of context being specified by a usage context.
* Identity: [utg-concept-propert…](CodeSystem-utg-concept-properties.md)
  * Name: UTG Specific Concept Properties
  * Version: 3.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: A set of concept properties used by UTG to maintain legacy terminology distribution systems
* Identity: [v2-0001](CodeSystem-v2-0001.md)
  * Name: administrativeSex
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a patient's sex for administrative purposes. Used in HL7 Versio…
* Identity: [v2-0002](CodeSystem-v2-0002.md)
  * Name: maritalStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a person's marital (civil/legal) status. Used in HL7 Version 2.…
* Identity: [v2-0003](CodeSystem-v2-0003.md)
  * Name: eventType
  * Version: 2.13.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages…
* Identity: [v2-0004](CodeSystem-v2-0004.md)
  * Name: patientClass
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used by systems to categorize patients by site in HL7 Version 2.x interface…
* Identity: [v2-0006](CodeSystem-v2-0006.md)
  * Name: religion2
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a person's religion. Used in HL7 Version 2.x messaging in the…
* Identity: [v2-0007](CodeSystem-v2-0007.md)
  * Name: admissionType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the circumstances under which the patient was or will be admitte…
* Identity: [v2-0008](CodeSystem-v2-0008.md)
  * Name: acknowledgmentCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying acknowledgment codes. For details of usage, see mes…
* Identity: [v2-0009](CodeSystem-v2-0009.md)
  * Name: ambulatoryStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying permanent or transient handicapped conditions of a person. Used…
* Identity: [v2-0012](CodeSystem-v2-0012.md)
  * Name: stockLocation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a stock location for older Version 2 messaging systems; not used…
* Identity: [v2-0017](CodeSystem-v2-0017.md)
  * Name: transactionType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a type of financial transaction. Used in HL7 Version 2.x messag…
* Identity: [v2-0027](CodeSystem-v2-0027.md)
  * Name: priority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the allowed priorities for obtaining the specimen. …
* Identity: [v2-0033](CodeSystem-v2-0033.md)
  * Name: route
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that indicate a means of administrating a medication dose. Use…
* Identity: [v2-0034](CodeSystem-v2-0034.md)
  * Name: siteAdministered
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used for medication administration sites. Used only in HL7 re…
* Identity: [v2-0038](CodeSystem-v2-0038.md)
  * Name: orderStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the status of an order. The purpose of these values …
* Identity: [v2-0048](CodeSystem-v2-0048.md)
  * Name: whatSubjectFilter
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the kind of information that is required to satis…
* Identity: [v2-0052](CodeSystem-v2-0052.md)
  * Name: diagnosisType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a type of diagnosis being sent. Used in HL7 Version 2.x messagi…
* Identity: [v2-0061](CodeSystem-v2-0061.md)
  * Name: checkDigitScheme
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the check digit scheme employed. Used in HL7 Versi…
* Identity: [v2-0062](CodeSystem-v2-0062.md)
  * Name: eventReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the reason for an event. Used in HL7 Version 2.x messaging i…
* Identity: [v2-0063](CodeSystem-v2-0063.md)
  * Name: relationship
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying an actual personal relationship that the next of kin…
* Identity: [v2-0065](CodeSystem-v2-0065.md)
  * Name: specimenAction
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify actions to be taken with respect to the specimens…
* Identity: [v2-0066](CodeSystem-v2-0066.md)
  * Name: employmentStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify an employment status of a person. Used in HL7 Ver…
* Identity: [v2-0069](CodeSystem-v2-0069.md)
  * Name: hospitalService
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the treatment or type of surgery the patient is scheduled to rec…
* Identity: [v2-0070](CodeSystem-v2-0070.md)
  * Name: specimenSourceCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify sources for speciments for clinical testing. The…
* Identity: [v2-0074](CodeSystem-v2-0074.md)
  * Name: diagnosticServiceSectionId
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a section of a diagnostic service where the obser…
* Identity: [v2-0076](CodeSystem-v2-0076.md)
  * Name: messageType
  * Version: 2.12.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify message types. Used in HL7 Version 2.x messaging…
* Identity: [v2-0080](CodeSystem-v2-0080.md)
  * Name: natureOfAbnormalTesting
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the nature of an abnormal test. Used in HL7 Version…
* Identity: [v2-0083](CodeSystem-v2-0083.md)
  * Name: outlierType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the type of outlier (i.e. period of care beyond DRG-…
* Identity: [v2-0085](CodeSystem-v2-0085.md)
  * Name: observationResultStatusCodesInterpretation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify observation result status. These codes reflect th…
* Identity: [v2-0091](CodeSystem-v2-0091.md)
  * Name: queryPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a time frame in which a querry response is expect…
* Identity: [v2-0092](CodeSystem-v2-0092.md)
  * Name: re-admissionIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which are used to specify that a patient is being re admitted to a healthca…
* Identity: [v2-0098](CodeSystem-v2-0098.md)
  * Name: typeOfAgreement
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify codes to further identify an insurance plan. Used in HL7 Ver…
* Identity: [v2-0100](CodeSystem-v2-0100.md)
  * Name: invocationEvent
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify codes for an event precipitating/triggering a cha…
* Identity: [v2-0102](CodeSystem-v2-0102.md)
  * Name: delayedAcknowledgmentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a response type used in deferred processing two p…
* Identity: [v2-0103](CodeSystem-v2-0103.md)
  * Name: processingId
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify whether the message is part of a production, trai…
* Identity: [v2-0104](CodeSystem-v2-0104.md)
  * Name: versionId
  * Version: 2.12.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which are used to identify an HL7 version in the Version 2.x fa…
* Identity: [v2-0105](CodeSystem-v2-0105.md)
  * Name: sourceOfComment
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which are used to specify the source of a comment. Used in HL7…
* Identity: [v2-0106](CodeSystem-v2-0106.md)
  * Name: queryResponseFormat
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify which of several types of formats for data to be …
* Identity: [v2-0107](CodeSystem-v2-0107.md)
  * Name: deferredResponseType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify which type of deferred query resonse is desired, …
* Identity: [v2-0108](CodeSystem-v2-0108.md)
  * Name: queryResultsLevel
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which are used to control level of detail in query results. U…
* Identity: [v2-0109](CodeSystem-v2-0109.md)
  * Name: reportPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the priority associated with a report or update r…
* Identity: [v2-0116](CodeSystem-v2-0116.md)
  * Name: bedStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the state of a bed in an inpatient setting, and is used to de…
* Identity: [v2-0119](CodeSystem-v2-0119.md)
  * Name: orderControlCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which are used to determine the function of the order segment. …
* Identity: [v2-0121](CodeSystem-v2-0121.md)
  * Name: responseFlag
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts allowing the placer (sending) application to determine the amou…
* Identity: [v2-0122](CodeSystem-v2-0122.md)
  * Name: chargeType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify someone or something other than the patient to be…
* Identity: [v2-0123](CodeSystem-v2-0123.md)
  * Name: resultStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a status of results for an order. Used in HL7 Ve…
* Identity: [v2-0124](CodeSystem-v2-0124.md)
  * Name: transportationMode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify how (or whether) to transport a patient, when app…
* Identity: [v2-0126](CodeSystem-v2-0126.md)
  * Name: quantityLimitedRequest
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the maximum length of a query response that can b…
* Identity: [v2-0127](CodeSystem-v2-0127.md)
  * Name: allergenType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts speciying a classification of general allergy categories (drug, food, polle…
* Identity: [v2-0128](CodeSystem-v2-0128.md)
  * Name: allergySeverity
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the general severity of an allergy. Used in HL7 Version 2.x …
* Identity: [v2-0130](CodeSystem-v2-0130.md)
  * Name: visitUserCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify categories of a patient's visit with respect to an individual…
* Identity: [v2-0131](CodeSystem-v2-0131.md)
  * Name: contactRole2
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify a relationship role that the next of kin/associated parties p…
* Identity: [v2-0133](CodeSystem-v2-0133.md)
  * Name: procedurePractitionerIdentifierCodeType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined table of concepts which specify the different types of practitioners associated with th…
* Identity: [v2-0135](CodeSystem-v2-0135.md)
  * Name: assignmentOfBenefits
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which indicate whether an insured person agreed to assign the insurance ben…
* Identity: [v2-0137](CodeSystem-v2-0137.md)
  * Name: mailClaimParty
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify a party to which a claim should be mailed when claims are sen…
* Identity: [v2-0140](CodeSystem-v2-0140.md)
  * Name: militaryService
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the military branch. This field is defined by CMS or other r…
* Identity: [v2-0142](CodeSystem-v2-0142.md)
  * Name: militaryStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the military status of the patient. This field is defined b…
* Identity: [v2-0144](CodeSystem-v2-0144.md)
  * Name: eligibilitySource
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the source of information about the insured's eligibility fo…
* Identity: [v2-0145](CodeSystem-v2-0145.md)
  * Name: roomType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the room type. Used in HL7 Version 2.x messaging in the RMC…
* Identity: [v2-0146](CodeSystem-v2-0146.md)
  * Name: amountType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify amount quantity type. Used in HL7 Version 2.x messaging in …
* Identity: [v2-0147](CodeSystem-v2-0147.md)
  * Name: policyType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the policy type. Used in HL7 Version 2.x messaging in the PT…
* Identity: [v2-0148](CodeSystem-v2-0148.md)
  * Name: moneyOrPercentageIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify whether the amount is currency or a percentage. …
* Identity: [v2-0149](CodeSystem-v2-0149.md)
  * Name: dayType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify whether the days are denied, pending or approved. Used in H…
* Identity: [v2-0150](CodeSystem-v2-0150.md)
  * Name: certificationPatientType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the category or type of patient for which this certification…
* Identity: [v2-0155](CodeSystem-v2-0155.md)
  * Name: accept-applicationAcknowledgmentConditions
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which identify conditions under which accept acknowledgments ar…
* Identity: [v2-0156](CodeSystem-v2-0156.md)
  * Name: whichDate-timeQualifier
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that specify a type of date referred to in query specifications…
* Identity: [v2-0157](CodeSystem-v2-0157.md)
  * Name: whichDate-timeStatusQualifier
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that specify the status type of objects selected in a date rang…
* Identity: [v2-0158](CodeSystem-v2-0158.md)
  * Name: date-timeSelectionQualifier
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of conceptss that allow the specification of certain types of values within…
* Identity: [v2-0159](CodeSystem-v2-0159.md)
  * Name: dietCodeSpecificationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify whether the type of diet. Used in HL7 Version…
* Identity: [v2-0160](CodeSystem-v2-0160.md)
  * Name: trayType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify whether the type of diet. Used in HL7 Version…
* Identity: [v2-0161](CodeSystem-v2-0161.md)
  * Name: allowSubstitution
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify whether substitutions are allowed and, if so, th…
* Identity: [v2-0162](CodeSystem-v2-0162.md)
  * Name: routeOfAdministration
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the route of administration. Used in HL7 Version 2.x messag…
* Identity: [v2-0163](CodeSystem-v2-0163.md)
  * Name: bodySite
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that specify a body site from which a specimen is obtained. Us…
* Identity: [v2-0164](CodeSystem-v2-0164.md)
  * Name: administrationDevice
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the mechanical device used to aid in the administration of t…
* Identity: [v2-0165](CodeSystem-v2-0165.md)
  * Name: administrationMethod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the specific method requested for the administration of the …
* Identity: [v2-0166](CodeSystem-v2-0166.md)
  * Name: rxComponentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the RX component type. Used in HL7 Version 2.x …
* Identity: [v2-0167](CodeSystem-v2-0167.md)
  * Name: substitutionStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the substitution status. Used in HL7 Version 2.…
* Identity: [v2-0168](CodeSystem-v2-0168.md)
  * Name: processingPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify one or more available priorities for performing …
* Identity: [v2-0169](CodeSystem-v2-0169.md)
  * Name: reportingPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the available priorities reporting the test resu…
* Identity: [v2-0170](CodeSystem-v2-0170.md)
  * Name: derivedSpecimen
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the parents and children for diagnostic studies,…
* Identity: [v2-0173](CodeSystem-v2-0173.md)
  * Name: coordinationOfBenefits
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying whether this insurance works in conjunction with other insurance…
* Identity: [v2-0174](CodeSystem-v2-0174.md)
  * Name: natureOfServiceTestObservation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying an identification of a test battery, an entire functional proced…
* Identity: [v2-0175](CodeSystem-v2-0175.md)
  * Name: masterFileIdentifierCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which are represented by codes identifying HL7 Versions 2.x Mas…
* Identity: [v2-0177](CodeSystem-v2-0177.md)
  * Name: confidentialityCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the degree to which special confidentiality protection should be…
* Identity: [v2-0178](CodeSystem-v2-0178.md)
  * Name: file-levelEvent
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying file-level events for master files. Used in HL7 Ver…
* Identity: [v2-0179](CodeSystem-v2-0179.md)
  * Name: responseLevel
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying application response levels defined for a given Mast…
* Identity: [v2-0180](CodeSystem-v2-0180.md)
  * Name: masterfileActionCode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying an action for a master file record. Used in HL7 Vers…
* Identity: [v2-0181](CodeSystem-v2-0181.md)
  * Name: mfnRecord-levelErrorReturn
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the requested update. Site-defined table, specifi…
* Identity: [v2-0183](CodeSystem-v2-0183.md)
  * Name: active-inactive
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying whether a person is currently a valid staff member. …
* Identity: [v2-0185](CodeSystem-v2-0185.md)
  * Name: preferredMethodOfContact
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying which of a group of multiple phone numbers is the pr…
* Identity: [v2-0187](CodeSystem-v2-0187.md)
  * Name: providerBilling
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying how provider services are billed. Used in HL7 Versi…
* Identity: [v2-0189](CodeSystem-v2-0189.md)
  * Name: ethnicGroup
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts further defining a patient's ancestry. In the US, a current use is to use …
* Identity: [v2-0190](CodeSystem-v2-0190.md)
  * Name: addressType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying types or kinds of addresses. Used in HL7 Version 2.…
* Identity: [v2-0191](CodeSystem-v2-0191.md)
  * Name: typeOfReferencedData
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts declaring the general type of media data that is encoded. Used…
* Identity: [v2-0193](CodeSystem-v2-0193.md)
  * Name: amountClass
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the amount quantity class. Used in HL7 Version 2.x messaging in…
* Identity: [v2-0200](CodeSystem-v2-0200.md)
  * Name: nameType2
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts for types of names for persons. Used in HL7 Version 2.x messag…
* Identity: [v2-0201](CodeSystem-v2-0201.md)
  * Name: telecommunicationUse
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts for specifying a specific use of a telecommunication number. B…
* Identity: [v2-0202](CodeSystem-v2-0202.md)
  * Name: telecommunicationEquipmentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts for specifying a type of telecommunication equipment. Best pr…
* Identity: [v2-0203](CodeSystem-v2-0203.md)
  * Name: identifierType
  * Version: 5.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2022-12-07
  * Description: HL7-defined code system of concepts specifying type of identifier. Used in HL7 Version 2.x messagin…
* Identity: [v2-0204](CodeSystem-v2-0204.md)
  * Name: organizationalNameType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the type of name for an organization i.e., legal name, disp…
* Identity: [v2-0205](CodeSystem-v2-0205.md)
  * Name: priceType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to identify the intent for the dollar amount on a pricing …
* Identity: [v2-0206](CodeSystem-v2-0206.md)
  * Name: segmentAction
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying actions to be applied for segments when an HL7 versi…
* Identity: [v2-0207](CodeSystem-v2-0207.md)
  * Name: processingMode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that indicate an archival process or an initial load process. …
* Identity: [v2-0208](CodeSystem-v2-0208.md)
  * Name: queryResponseStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts defining precise response status concepts in support of HL7 Ver…
* Identity: [v2-0209](CodeSystem-v2-0209.md)
  * Name: relationalOperator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to define the relationship between HL7 segment field names…
* Identity: [v2-0210](CodeSystem-v2-0210.md)
  * Name: relationalConjunction
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used with relationalOperator values to group more than one segm…
* Identity: [v2-0211](CodeSystem-v2-0211.md)
  * Name: alternateCharacterSets
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the character set(s) in use. Includes both sin…
* Identity: [v2-0213](CodeSystem-v2-0213.md)
  * Name: purgeStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define the state of a visit relative to its place in a purge workfl…
* Identity: [v2-0214](CodeSystem-v2-0214.md)
  * Name: specialProgram
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to record a health insurance program required for healthcare visit rei…
* Identity: [v2-0215](CodeSystem-v2-0215.md)
  * Name: publicity
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a level of publicity of information about a patient for a specif…
* Identity: [v2-0216](CodeSystem-v2-0216.md)
  * Name: patientStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define the state of a care episode for a patient. Used in HL7 Vers…
* Identity: [v2-0217](CodeSystem-v2-0217.md)
  * Name: visitPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define a relative level of urgency applied to a patient visit. Use…
* Identity: [v2-0220](CodeSystem-v2-0220.md)
  * Name: livingArrangement
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts characterizing the situation that patient-associated parties live in at the…
* Identity: [v2-0223](CodeSystem-v2-0223.md)
  * Name: livingDependency2
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify specific living conditions (e.g., spouse dependen…
* Identity: [v2-0224](CodeSystem-v2-0224.md)
  * Name: transportArranged
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts defining whether patient transportation preparations are in pla…
* Identity: [v2-0225](CodeSystem-v2-0225.md)
  * Name: escortRequired
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts defining whether patient transportation preparations are in pla…
* Identity: [v2-0228](CodeSystem-v2-0228.md)
  * Name: diagnosisClassification
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to classify whether a patient visit can be related to a diagnosis. Us…
* Identity: [v2-0230](CodeSystem-v2-0230.md)
  * Name: procedureFunctionalType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to classify a procedure. Used in HL7 Version 2.x messaging in the PR1…
* Identity: [v2-0231](CodeSystem-v2-0231.md)
  * Name: studentStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to designate whether a guarantor is a full or part time student. Used…
* Identity: [v2-0232](CodeSystem-v2-0232.md)
  * Name: insuranceCompanyContactReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to describe why an insurance company has been contacted. Used in HL7 …
* Identity: [v2-0234](CodeSystem-v2-0234.md)
  * Name: reportTiming
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to identify the time span of a report or the reason for a …
* Identity: [v2-0235](CodeSystem-v2-0235.md)
  * Name: reportSource
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to identify where a report sender learned about an event. …
* Identity: [v2-0236](CodeSystem-v2-0236.md)
  * Name: eventReportedTo
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to identify the type of entity to which the even has been …
* Identity: [v2-0237](CodeSystem-v2-0237.md)
  * Name: eventQualification
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to qualify an event related to a product experience. Used…
* Identity: [v2-0238](CodeSystem-v2-0238.md)
  * Name: eventSeriousness
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used by a sender to designate an event as serious or significan…
* Identity: [v2-0239](CodeSystem-v2-0239.md)
  * Name: eventExpected
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to communicate whether an event has been judged to be expe…
* Identity: [v2-0240](CodeSystem-v2-0240.md)
  * Name: eventConsequence
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to describe the impact of an event on a patient. Used in …
* Identity: [v2-0241](CodeSystem-v2-0241.md)
  * Name: patientOutcome
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to describe the overall state of a patient as a result of …
* Identity: [v2-0242](CodeSystem-v2-0242.md)
  * Name: primaryObserverQualification
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to provide a general description of the kind of health car…
* Identity: [v2-0243](CodeSystem-v2-0243.md)
  * Name: identityMayBeDivulged
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to define whether the primary observer has given permissio…
* Identity: [v2-0247](CodeSystem-v2-0247.md)
  * Name: statusOfEvaluation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that describes the status of product evaluation. Used in HL7 V…
* Identity: [v2-0248](CodeSystem-v2-0248.md)
  * Name: productSource
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to describe the evaluation state of a product identified i…
* Identity: [v2-0250](CodeSystem-v2-0250.md)
  * Name: relatednessAssessment
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to provide an estimate of whether an issue with a product…
* Identity: [v2-0251](CodeSystem-v2-0251.md)
  * Name: actionTakenInResponseToTheEvent
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to define the action taken as a result of an event related…
* Identity: [v2-0252](CodeSystem-v2-0252.md)
  * Name: causalityObservations
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to record event observations regarding what may have cause…
* Identity: [v2-0253](CodeSystem-v2-0253.md)
  * Name: indirectExposureMechanism
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to identify the mechanism of product transmission when the…
* Identity: [v2-0254](CodeSystem-v2-0254.md)
  * Name: kindOfQuantity
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7 published code system of concepts that describe categories of an underlying kind of property re…
* Identity: [v2-0255](CodeSystem-v2-0255.md)
  * Name: durationCategories
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to classify an observation definition as intended to measure a patient…
* Identity: [v2-0256](CodeSystem-v2-0256.md)
  * Name: timeDelayPostChallenge
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to classify an observation definition as being a component…
* Identity: [v2-0257](CodeSystem-v2-0257.md)
  * Name: natureOfChallenge
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to further describe an observation definition that is char…
* Identity: [v2-0258](CodeSystem-v2-0258.md)
  * Name: relationshipModifier
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used in an observation definition to describe the subject of an…
* Identity: [v2-0260](CodeSystem-v2-0260.md)
  * Name: patientLocationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the kind of location described in the location definition.…
* Identity: [v2-0261](CodeSystem-v2-0261.md)
  * Name: locationEquipment
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the equipment available in a location definition identifie…
* Identity: [v2-0262](CodeSystem-v2-0262.md)
  * Name: privacyLevel
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the level of privacy a patient will be afforded when assig…
* Identity: [v2-0263](CodeSystem-v2-0263.md)
  * Name: levelOfCare
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the level of care a patient may be afforded when assigned …
* Identity: [v2-0265](CodeSystem-v2-0265.md)
  * Name: specialtyType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the specialty of the care professional who is supported wh…
* Identity: [v2-0267](CodeSystem-v2-0267.md)
  * Name: daysOfTheWeek
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to identify the day(s) of the week when a location may be …
* Identity: [v2-0268](CodeSystem-v2-0268.md)
  * Name: override
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define whether a Charge Description Master description may be overr…
* Identity: [v2-0269](CodeSystem-v2-0269.md)
  * Name: chargeOnIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define the event upon which a charge should be generated. Used in …
* Identity: [v2-0270](CodeSystem-v2-0270.md)
  * Name: documentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the kind of patient document. Used in HL7 Version 2.x mes…
* Identity: [v2-0271](CodeSystem-v2-0271.md)
  * Name: documentCompletionStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to record the state of a document in a workflow. Used in …
* Identity: [v2-0272](CodeSystem-v2-0272.md)
  * Name: documentConfidentialityStatus2
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concetps used to identify the degree to which special confidentiality pr…
* Identity: [v2-0273](CodeSystem-v2-0273.md)
  * Name: documentAvailabilityStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to define whether a patient document is appropriate or ava…
* Identity: [v2-0275](CodeSystem-v2-0275.md)
  * Name: documentStorageStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to describe the availability of a document in relation to …
* Identity: [v2-0276](CodeSystem-v2-0276.md)
  * Name: appointmentReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to describe the kind of appointment or the reason why an appointment h…
* Identity: [v2-0277](CodeSystem-v2-0277.md)
  * Name: appointmentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used in an appointment request to describe the kind of appointment. Used i…
* Identity: [v2-0278](CodeSystem-v2-0278.md)
  * Name: fillerStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to describe an appointment status from the perspective of the entity a…
* Identity: [v2-0279](CodeSystem-v2-0279.md)
  * Name: allowSubstitution
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to indicate whether the appointment resource may be substituted for an…
* Identity: [v2-0280](CodeSystem-v2-0280.md)
  * Name: referralPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to designate the urgency of a referral. Used in HL7 Version 2.x mess…
* Identity: [v2-0281](CodeSystem-v2-0281.md)
  * Name: referralType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the general category of healthcare professional desired to…
* Identity: [v2-0282](CodeSystem-v2-0282.md)
  * Name: referralDisposition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the expected response from the healthcare professional rec…
* Identity: [v2-0283](CodeSystem-v2-0283.md)
  * Name: referralStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define the state of a referral. Used in HL7 Version 2.x messaging…
* Identity: [v2-0284](CodeSystem-v2-0284.md)
  * Name: referralCategory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to describe the patient care setting where a referral should take plac…
* Identity: [v2-0286](CodeSystem-v2-0286.md)
  * Name: providerRole
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define the relationship between a referral recipient and a patient …
* Identity: [v2-0287](CodeSystem-v2-0287.md)
  * Name: problem-goalAction
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used in Patient Care for the intent of a problem or goal. Used…
* Identity: [v2-0290](CodeSystem-v2-0290.md)
  * Name: mimeBase64EncodingCharacters
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the characters used in the MIME Base 64 encoding mec…
* Identity: [v2-0291](CodeSystem-v2-0291.md)
  * Name: subtypeOfReferencedData
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of a subset of the media subtypes of binary data that are encoded in an ascii structure…
* Identity: [v2-0294](CodeSystem-v2-0294.md)
  * Name: timeSelectionCriteriaParameterClass
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to describe acceptable start and end times, as well as days of the wee…
* Identity: [v2-0298](CodeSystem-v2-0298.md)
  * Name: cpRangeType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to define a type of range used in composite pricing in fin…
* Identity: [v2-0299](CodeSystem-v2-0299.md)
  * Name: encoding
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concept identifying the type of encoding used to represent successive oc…
* Identity: [v2-0301](CodeSystem-v2-0301.md)
  * Name: universalIdType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of types of UID (Universal Identifiers). Used in HL7 Version 2.x messagin…
* Identity: [v2-0305](CodeSystem-v2-0305.md)
  * Name: personLocationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the categorization of the person's location. Used in HL7 Versio…
* Identity: [v2-0309](CodeSystem-v2-0309.md)
  * Name: coverageType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the type of insurance coverage or what types of services are cov…
* Identity: [v2-0311](CodeSystem-v2-0311.md)
  * Name: jobStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the next of kin/associated party's job status. Used…
* Identity: [v2-0315](CodeSystem-v2-0315.md)
  * Name: livingWillCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying whether or not the patient has a living will and, if so, whether…
* Identity: [v2-0316](CodeSystem-v2-0316.md)
  * Name: organDonorCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying whether the patient wants to donate his/her organs and whether a…
* Identity: [v2-0317](CodeSystem-v2-0317.md)
  * Name: annotations
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the coded entry associated with a given point in time during the…
* Identity: [v2-0321](CodeSystem-v2-0321.md)
  * Name: dispenseMethod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-definde code system of concepts specifying the method by which treatment is dispensed. Used in…
* Identity: [v2-0322](CodeSystem-v2-0322.md)
  * Name: completionStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the status of the treatment administration event seg…
* Identity: [v2-0323](CodeSystem-v2-0323.md)
  * Name: actionCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system ofstatus codes of record operation. Used in Version 2 messaging, these are …
* Identity: [v2-0324](CodeSystem-v2-0324.md)
  * Name: locationCharacteristic
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying an identifier code to show which characteristic is being communi…
* Identity: [v2-0325](CodeSystem-v2-0325.md)
  * Name: locationRelationship
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying an identifier code to show which relationship is being communica…
* Identity: [v2-0326](CodeSystem-v2-0326.md)
  * Name: visitIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the level on which data are being sent. It is the indicator use…
* Identity: [v2-0329](CodeSystem-v2-0329.md)
  * Name: quantityMethod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the method by which the quantity distributed is…
* Identity: [v2-0330](CodeSystem-v2-0330.md)
  * Name: marketingBasis
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the basis for marketing approval. Used in HL7…
* Identity: [v2-0331](CodeSystem-v2-0331.md)
  * Name: facilityType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the type of facility. Used in HL7 Version 2.x…
* Identity: [v2-0332](CodeSystem-v2-0332.md)
  * Name: sourceType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the type of facility. Used in HL7 Version 2.x…
* Identity: [v2-0334](CodeSystem-v2-0334.md)
  * Name: disabilityInformationRelationship
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify to which person the disability information relates in the m…
* Identity: [v2-0335](CodeSystem-v2-0335.md)
  * Name: repeatPattern
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the interval between repeated services. Used in HL7 Versio…
* Identity: [v2-0336](CodeSystem-v2-0336.md)
  * Name: referralReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the reason for which the referral will take place. Used in…
* Identity: [v2-0337](CodeSystem-v2-0337.md)
  * Name: certificationStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the status of the practitioner's speciality cer…
* Identity: [v2-0339](CodeSystem-v2-0339.md)
  * Name: advancedBeneficiaryNotice
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the patient's or the patient's representative's co…
* Identity: [v2-0344](CodeSystem-v2-0344.md)
  * Name: patientsRelationshipToInsured
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the relationship of the patient to the insured, as defined …
* Identity: [v2-0353](CodeSystem-v2-0353.md)
  * Name: cweStatuses
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of comcepts that represent an exception identifier code; that is, a code th…
* Identity: [v2-0354](CodeSystem-v2-0354.md)
  * Name: messageStructure
  * Version: 2.10.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of abstract message structure codes. Each code identifies a specific messag…
* Identity: [v2-0355](CodeSystem-v2-0355.md)
  * Name: primaryKeyValueType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the type for the master file record identifier.…
* Identity: [v2-0356](CodeSystem-v2-0356.md)
  * Name: alternateCharacterSetHandlingScheme
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concept that specify the scheme used when any alternative character sets…
* Identity: [v2-0357](CodeSystem-v2-0357.md)
  * Name: messageErrorCondition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the HL7 (communications) error code. Used in the ER…
* Identity: [v2-0359](CodeSystem-v2-0359.md)
  * Name: diagnosisPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the significance or priority of the diagnosis code. Note tha…
* Identity: [v2-0360](CodeSystem-v2-0360.md)
  * Name: degreeLicenseCertificate
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying an educational degree (e.g., MD). Used in the CNN datatype (nam…
* Identity: [v2-0364](CodeSystem-v2-0364.md)
  * Name: commentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the type of comment text being sent in the specific comment r…
* Identity: [v2-0365](CodeSystem-v2-0365.md)
  * Name: equipmentState
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify the status the equipment was in at the time the t…
* Identity: [v2-0366](CodeSystem-v2-0366.md)
  * Name: local-remoteControlState
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify the current state of control associated with the …
* Identity: [v2-0367](CodeSystem-v2-0367.md)
  * Name: alertLevel
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify the highest level of the alert state (e.g.,highes…
* Identity: [v2-0368](CodeSystem-v2-0368.md)
  * Name: remoteControlCommand
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the comment the component is to initiate. Used in the Equipm…
* Identity: [v2-0369](CodeSystem-v2-0369.md)
  * Name: specimenRole
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify the role of a sample. Used in HL7 Version 2.x me…
* Identity: [v2-0370](CodeSystem-v2-0370.md)
  * Name: containerStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify the status of the unique container in which the …
* Identity: [v2-0371](CodeSystem-v2-0371.md)
  * Name: additivePreservative
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying any additive introduced to the specimen before or at…
* Identity: [v2-0372](CodeSystem-v2-0372.md)
  * Name: specimenComponent
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the specimen component, e.g., supernatant, sediment, etc. Us…
* Identity: [v2-0373](CodeSystem-v2-0373.md)
  * Name: treatment
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the specimen treatment performed during lab processing. Used…
* Identity: [v2-0374](CodeSystem-v2-0374.md)
  * Name: systemInducedContaminants
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the specimen contaminant identifier associated with the speci…
* Identity: [v2-0375](CodeSystem-v2-0375.md)
  * Name: artificialBlood
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the artificial blood identifier associated with the specimen.…
* Identity: [v2-0376](CodeSystem-v2-0376.md)
  * Name: specialHandling
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts describing how a specimen and/or container needs to be handled from the tim…
* Identity: [v2-0377](CodeSystem-v2-0377.md)
  * Name: environmentalFactors
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the other environmental factors associated with the specimen …
* Identity: [v2-0383](CodeSystem-v2-0383.md)
  * Name: substanceStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying the status of the inventoried item. The status ind…
* Identity: [v2-0384](CodeSystem-v2-0384.md)
  * Name: substanceType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying the type of substance. Used in HL7 Version 2.x me…
* Identity: [v2-0387](CodeSystem-v2-0387.md)
  * Name: commandResponse
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts identifying the response of the previously issued command. Used in HL7 Ver…
* Identity: [v2-0388](CodeSystem-v2-0388.md)
  * Name: processingType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying the processing type that applies to the test code. …
* Identity: [v2-0389](CodeSystem-v2-0389.md)
  * Name: analyteRepeatStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying the repeat status for the analyte/result (e.g. orig…
* Identity: [v2-0391](CodeSystem-v2-0391.md)
  * Name: segmentGroup
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the optional segment groups which are to be included…
* Identity: [v2-0392](CodeSystem-v2-0392.md)
  * Name: matchReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts identifying what search components (e.g., name, birthdate, social security …
* Identity: [v2-0393](CodeSystem-v2-0393.md)
  * Name: matchAlgorithms
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts identifying the name or identity of the specific search algorithm to which …
* Identity: [v2-0394](CodeSystem-v2-0394.md)
  * Name: responseModality
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying the timing and grouping of the response message(s).…
* Identity: [v2-0395](CodeSystem-v2-0395.md)
  * Name: modifyIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying whether the subscription is new or is being modifie…
* Identity: [v2-0396](CodeSystem-v2-0396.md)
  * Name: codingSystem
  * Version: 4.1.0
  * Status: active
  * Content: complete
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: THO
  * Date: 2024-01-26
  * Description: HL7-defined code system of concepts specifying the coding system. This table is maintained outside…
* Identity: [v2-0397](CodeSystem-v2-0397.md)
  * Name: sequencing
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying how the field or parameter will be sorted and, if s…
* Identity: [v2-0398](CodeSystem-v2-0398.md)
  * Name: continuationStyle
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying whether it is a fragmented message or part of an in…
* Identity: [v2-0401](CodeSystem-v2-0401.md)
  * Name: governmentReimbursementProgram
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify codes that indicate an agency that the practitioner is author…
* Identity: [v2-0402](CodeSystem-v2-0402.md)
  * Name: schoolType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify a categorization of an academic institution that grants a deg…
* Identity: [v2-0403](CodeSystem-v2-0403.md)
  * Name: languageAbility
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify codes that indicate the ability that a Staff Member possesses…
* Identity: [v2-0404](CodeSystem-v2-0404.md)
  * Name: languageProficiency
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a level of knowledge that a Staff Member possesse…
* Identity: [v2-0406](CodeSystem-v2-0406.md)
  * Name: organizationUnitType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which identify an environment in which a provider acts in a spe…
* Identity: [v2-0409](CodeSystem-v2-0409.md)
  * Name: applicationChangeType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the type of change being requested (if NMR query)…
* Identity: [v2-0415](CodeSystem-v2-0415.md)
  * Name: drgTransferType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a type of hospital receiving a transfer patient, …
* Identity: [v2-0416](CodeSystem-v2-0416.md)
  * Name: procedureDrgType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a procedure’s priority ranking relative to its DR…
* Identity: [v2-0417](CodeSystem-v2-0417.md)
  * Name: tissueType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a type of tissue removed from a patient during a …
* Identity: [v2-0418](CodeSystem-v2-0418.md)
  * Name: procedurePriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the significance or priority of a procedure code.…
* Identity: [v2-0421](CodeSystem-v2-0421.md)
  * Name: severityOfIllness
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the ranking of a patient’s illness. Used in HL7 …
* Identity: [v2-0422](CodeSystem-v2-0422.md)
  * Name: triageType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a patient’s prioritization within the context of …
* Identity: [v2-0423](CodeSystem-v2-0423.md)
  * Name: caseCategory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify reasons that a non-urgent patient presents to the…
* Identity: [v2-0424](CodeSystem-v2-0424.md)
  * Name: gestationCategory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the status of a birth in relation to the gestatio…
* Identity: [v2-0425](CodeSystem-v2-0425.md)
  * Name: newbornType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify whether the baby was born in or out of a specifie…
* Identity: [v2-0426](CodeSystem-v2-0426.md)
  * Name: bloodProduct
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a type of blood product. Used in HL7 Version 2 m…
* Identity: [v2-0427](CodeSystem-v2-0427.md)
  * Name: riskManagementIncident
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a type of incident that occurs during a patient’s…
* Identity: [v2-0428](CodeSystem-v2-0428.md)
  * Name: incidentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a classification of types of incidents. Used in …
* Identity: [v2-0429](CodeSystem-v2-0429.md)
  * Name: productionClass
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the code and/or text indicating the primary use for which the l…
* Identity: [v2-0430](CodeSystem-v2-0430.md)
  * Name: arrivalMode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying how the patient was brought to the healthcare facility. Used in…
* Identity: [v2-0431](CodeSystem-v2-0431.md)
  * Name: recreationalDrugType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying what recreational drugs the patient uses. Used in HL7 Version 2…
* Identity: [v2-0432](CodeSystem-v2-0432.md)
  * Name: admissionLevelOfCare
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the acuity level assigned to the patient at the time of admissi…
* Identity: [v2-0433](CodeSystem-v2-0433.md)
  * Name: precaution
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying non-clincal precautions that need to be taken with the patient.…
* Identity: [v2-0434](CodeSystem-v2-0434.md)
  * Name: patientCondition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the patient's current medical condition for the purpose of commu…
* Identity: [v2-0435](CodeSystem-v2-0435.md)
  * Name: advanceDirective
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the patient's instructions to the healthcare facility. Used in …
* Identity: [v2-0436](CodeSystem-v2-0436.md)
  * Name: sensitivityToCausativeAgent
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the reason the patient should not be exposed to a substance. Us…
* Identity: [v2-0437](CodeSystem-v2-0437.md)
  * Name: alertDevice
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying any type of allergy alert device the patient may be carrying or …
* Identity: [v2-0438](CodeSystem-v2-0438.md)
  * Name: allergyClinicalStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the verification status for the allergy. Used in HL7 Version 2.…
* Identity: [v2-0440](CodeSystem-v2-0440.md)
  * Name: dataTypes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the format of the observation value in the Observati…
* Identity: [v2-0441](CodeSystem-v2-0441.md)
  * Name: immunizationRegistryStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the immunization registry status of the patient. Used in HL7 Ve…
* Identity: [v2-0442](CodeSystem-v2-0442.md)
  * Name: locationServiceType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the types of services provided by the location. Used in HL7 Ve…
* Identity: [v2-0443](CodeSystem-v2-0443.md)
  * Name: providerRole
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the functional involvement with the activity being transmitted (…
* Identity: [v2-0444](CodeSystem-v2-0444.md)
  * Name: nameAssemblyOrder
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the preferred display order of the components of this person nam…
* Identity: [v2-0445](CodeSystem-v2-0445.md)
  * Name: identityReliability
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the reliability of patient/person identifying data transmitted v…
* Identity: [v2-0450](CodeSystem-v2-0450.md)
  * Name: eventType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the type of event of the message. Used in HL7 Versi…
* Identity: [v2-0457](CodeSystem-v2-0457.md)
  * Name: overallClaimDisposition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the final status of the claim. Used in HL7 Version 2.x messagin…
* Identity: [v2-0465](CodeSystem-v2-0465.md)
  * Name: name-addressRepresentation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying an indication of the representation provided by the …
* Identity: [v2-0466](CodeSystem-v2-0466.md)
  * Name: ambulatoryPaymentClassification
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the derived Ambulatory Payment Classification (APC) code. Used …
* Identity: [v2-0468](CodeSystem-v2-0468.md)
  * Name: paymentAdjustmentInformation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying any payment adjustment due to drugs or medical devices. Used in…
* Identity: [v2-0469](CodeSystem-v2-0469.md)
  * Name: packagingStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the packaging status of the service. Used in HL7 Version 2.x me…
* Identity: [v2-0470](CodeSystem-v2-0470.md)
  * Name: reimbursementType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the fee schedule reimbursement type applied to the line item. U…
* Identity: [v2-0472](CodeSystem-v2-0472.md)
  * Name: tqConjunctionId
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying that a second timing specification is to follow usin…
* Identity: [v2-0473](CodeSystem-v2-0473.md)
  * Name: formularyStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying whether or not the service (pharmaceutical) is in the formulary.…
* Identity: [v2-0474](CodeSystem-v2-0474.md)
  * Name: organizationUnitType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the classification of the organization unit. Used in HL7 Versio…
* Identity: [v2-0475](CodeSystem-v2-0475.md)
  * Name: chargeTypeReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the choice of, and providing the clinical rationale for, a selec…
* Identity: [v2-0477](CodeSystem-v2-0477.md)
  * Name: controlledSubstanceSchedule
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the class of the drug or other substance if its usage is control…
* Identity: [v2-0478](CodeSystem-v2-0478.md)
  * Name: formularyStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying whether or not the pharmaceutical substance is part …
* Identity: [v2-0480](CodeSystem-v2-0480.md)
  * Name: pharmacyOrderTypes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the general category of pharmacy order which may be …
* Identity: [v2-0482](CodeSystem-v2-0482.md)
  * Name: orderType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying whether the order is to be executed in an inpatient …
* Identity: [v2-0483](CodeSystem-v2-0483.md)
  * Name: authorizationMode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts of forms of authorization a recorder may receive from the respo…
* Identity: [v2-0484](CodeSystem-v2-0484.md)
  * Name: dispenseType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the type of dispensing event that occurred. Used in HL7 Version…
* Identity: [v2-0485](CodeSystem-v2-0485.md)
  * Name: extendedPriorityCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts describing the urgency of a request carried in an order. Used in HL7 Versi…
* Identity: [v2-0487](CodeSystem-v2-0487.md)
  * Name: specimenType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that describe the precise nature of an entity that may be used …
* Identity: [v2-0488](CodeSystem-v2-0488.md)
  * Name: specimenCollectionMethod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the specimen collection method. Used in HL7 Version…
* Identity: [v2-0489](CodeSystem-v2-0489.md)
  * Name: risks
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying any known or suspected specimen hazards, e.g., exceptionally inf…
* Identity: [v2-0490](CodeSystem-v2-0490.md)
  * Name: specimenRejectReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of reasons a specimen may be rejected for a specified observation/result/an…
* Identity: [v2-0491](CodeSystem-v2-0491.md)
  * Name: specimenQuality
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the degree or grade of excellence of the specimen at receipt. U…
* Identity: [v2-0492](CodeSystem-v2-0492.md)
  * Name: specimenAppropriateness
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the suitability of the specimen for the particular planned use a…
* Identity: [v2-0493](CodeSystem-v2-0493.md)
  * Name: specimenCondition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a mode or state of being that describes the nature of the specim…
* Identity: [v2-0494](CodeSystem-v2-0494.md)
  * Name: specimenChildRole
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying for child specimens the relationship between this sp…
* Identity: [v2-0495](CodeSystem-v2-0495.md)
  * Name: bodySiteModifier
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the modifier for the body site. Used in HL7 Version…
* Identity: [v2-0496](CodeSystem-v2-0496.md)
  * Name: consentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying to what the subject is consenting, i.e. what type of service, su…
* Identity: [v2-0497](CodeSystem-v2-0497.md)
  * Name: consentMode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the method in which a subject provides consent. Use…
* Identity: [v2-0498](CodeSystem-v2-0498.md)
  * Name: consentStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-code system of concepts specifying whether the consent has been sought and granted. Used in HL…
* Identity: [v2-0499](CodeSystem-v2-0499.md)
  * Name: consentBypassReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the reason the subject's consent was not sought. Used in HL7 Ve…
* Identity: [v2-0500](CodeSystem-v2-0500.md)
  * Name: consentDisclosureLevel
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying how much information was disclosed to the subject as…
* Identity: [v2-0501](CodeSystem-v2-0501.md)
  * Name: consentNon-disclosureReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify a reason the subject did not receive full disclosure. Used…
* Identity: [v2-0502](CodeSystem-v2-0502.md)
  * Name: non-subjectConsenterReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify a reason consent was granted by a person other…
* Identity: [v2-0503](CodeSystem-v2-0503.md)
  * Name: sequenceResultsFlag
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the sequencing relationship between the curren…
* Identity: [v2-0504](CodeSystem-v2-0504.md)
  * Name: sequenceCondition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the relationship between the start/end of the r…
* Identity: [v2-0505](CodeSystem-v2-0505.md)
  * Name: cyclicEntryExitIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify if this service request is the first or last se…
* Identity: [v2-0506](CodeSystem-v2-0506.md)
  * Name: serviceRequestRelationship
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify an additional or alternate relationship between…
* Identity: [v2-0507](CodeSystem-v2-0507.md)
  * Name: observationResultHandling
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts regarding the handling of a result. For example, an order may specify that…
* Identity: [v2-0508](CodeSystem-v2-0508.md)
  * Name: bloodProductProcessingRequirements
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify additional information about the blood component class asso…
* Identity: [v2-0510](CodeSystem-v2-0510.md)
  * Name: bloodProductDispenseStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the current status of the specified blood produ…
* Identity: [v2-0511](CodeSystem-v2-0511.md)
  * Name: bpObservationStatusCodesInterpretation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the interpretation for the blood product observ…
* Identity: [v2-0513](CodeSystem-v2-0513.md)
  * Name: bloodProductTransfusion-dispositionStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the current status of the specified blood produ…
* Identity: [v2-0514](CodeSystem-v2-0514.md)
  * Name: transfusionAdverseReaction
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the type of adverse reaction that the recipient of the bloo…
* Identity: [v2-0516](CodeSystem-v2-0516.md)
  * Name: errorSeverity
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the severity of an application error as reported dur…
* Identity: [v2-0517](CodeSystem-v2-0517.md)
  * Name: informInstructions
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying who (if anyone) should or should not be informed of an error. U…
* Identity: [v2-0518](CodeSystem-v2-0518.md)
  * Name: overrideType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify what type of override can be used to override the specific …
* Identity: [v2-0520](CodeSystem-v2-0520.md)
  * Name: messageWaitingPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the disposition of the patient at time of dischar…
* Identity: [v2-0523](CodeSystem-v2-0523.md)
  * Name: computationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify if the change is computed as a percent change o…
* Identity: [v2-0524](CodeSystem-v2-0524.md)
  * Name: sequenceCondition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify whether sequence conditions or a repeating cycle …
* Identity: [v2-0527](CodeSystem-v2-0527.md)
  * Name: calendarAlignment
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify an alignment of the repetition to a calendar (e…
* Identity: [v2-0528](CodeSystem-v2-0528.md)
  * Name: eventRelatedPeriod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying a common (periodical) activity of daily living. Use…
* Identity: [v2-0529](CodeSystem-v2-0529.md)
  * Name: precision
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the degree of precision of the time stamp (Y = year,…
* Identity: [v2-0530](CodeSystem-v2-0530.md)
  * Name: organization-Agency-Department
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the agency or department that assigned the identifier in co…
* Identity: [v2-0532](CodeSystem-v2-0532.md)
  * Name: expandedYes-NoIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify an expansion on the original Yes/No indicator t…
* Identity: [v2-0534](CodeSystem-v2-0534.md)
  * Name: clergyNotificationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying whether the clergy should be notified. Used in HL7 Version 2 me…
* Identity: [v2-0535](CodeSystem-v2-0535.md)
  * Name: signatureType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that indicate how a patient/subscriber authorization signature is obtained …
* Identity: [v2-0536](CodeSystem-v2-0536.md)
  * Name: certificateStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the certificate held by the health professional. …
* Identity: [v2-0538](CodeSystem-v2-0538.md)
  * Name: institutionRelationshipType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the relationship the staff person has with the institution for w…
* Identity: [v2-0540](CodeSystem-v2-0540.md)
  * Name: inactiveReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the reason the staff member is inactive. Used in HL7 Version 2 …
* Identity: [v2-0544](CodeSystem-v2-0544.md)
  * Name: containerCondition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify at each receipt the status of the container in…
* Identity: [v2-0547](CodeSystem-v2-0547.md)
  * Name: jurisdictionalBreadth
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the breadth/extent of the jurisdiction where the qualification i…
* Identity: [v2-0548](CodeSystem-v2-0548.md)
  * Name: signatorysRelationshipToSubject
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the relationship of the consenter to the subject. Used in HL7 V…
* Identity: [v2-0550](CodeSystem-v2-0550.md)
  * Name: bodyParts
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the part of the body. Used in HL7 Version 2 messagi…
* Identity: [v2-0553](CodeSystem-v2-0553.md)
  * Name: invoiceControl
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify what action is being performed by this message. Used in th…
* Identity: [v2-0554](CodeSystem-v2-0554.md)
  * Name: invoiceReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the reason for this invoice. Used in the Invoice (IVC) seg…
* Identity: [v2-0555](CodeSystem-v2-0555.md)
  * Name: invoiceType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the type of invoice. Used in the Invoice (IVC) segment in …
* Identity: [v2-0556](CodeSystem-v2-0556.md)
  * Name: benefitGroup
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the benefit group. Used in the Invoice (IVC) segment in HL…
* Identity: [v2-0557](CodeSystem-v2-0557.md)
  * Name: payeeType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the type of payee (e.g., organization, person). Used in th…
* Identity: [v2-0558](CodeSystem-v2-0558.md)
  * Name: payeeRelationshipToInvoice
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the relationship to the invoice for Person Payee Types. Us…
* Identity: [v2-0559](CodeSystem-v2-0559.md)
  * Name: product-serviceStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the processing status for the Product/Service Code. Used i…
* Identity: [v2-0560](CodeSystem-v2-0560.md)
  * Name: Quantity Units
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the adjustment quantity.
* Identity: [v2-0561](CodeSystem-v2-0561.md)
  * Name: product-servicesClarification
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the Product/Service Code. Used in the Product/Service Line…
* Identity: [v2-0562](CodeSystem-v2-0562.md)
  * Name: processingConsideration
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify special processing requested of Payer for this Product/Serv…
* Identity: [v2-0564](CodeSystem-v2-0564.md)
  * Name: adjustmentCategory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the category of adjustment and is used to assist in determi…
* Identity: [v2-0565](CodeSystem-v2-0565.md)
  * Name: providerAdjustmentReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the reason for this adjustment. Used in the Adjustment (AD…
* Identity: [v2-0566](CodeSystem-v2-0566.md)
  * Name: bloodUnitType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the type of blood unit. Used in the Blood Unit…
* Identity: [v2-0569](CodeSystem-v2-0569.md)
  * Name: adjustmentAction
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the action requested of the party that receives an adjustme…
* Identity: [v2-0570](CodeSystem-v2-0570.md)
  * Name: paymentMethod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the method for the movement of payment. Used in the Paymen…
* Identity: [v2-0571](CodeSystem-v2-0571.md)
  * Name: invoiceProcessingResultsStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the processing status for an Invoice Processing Result. Us…
* Identity: [v2-0572](CodeSystem-v2-0572.md)
  * Name: taxStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the tax status of the provider. Used in the Invoice (IVC) …
* Identity: [v2-0615](CodeSystem-v2-0615.md)
  * Name: userAuthenticationCredentialType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying a type of user authentication credential. Used in H…
* Identity: [v2-0616](CodeSystem-v2-0616.md)
  * Name: addressExpirationReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the reason this address was marked as "ended". Used in HL7 Vers…
* Identity: [v2-0617](CodeSystem-v2-0617.md)
  * Name: addressUsage
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying how an address is intended to be used. Used in HL7 …
* Identity: [v2-0618](CodeSystem-v2-0618.md)
  * Name: protection
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying that an address needs to be treated with special care or sensiti…
* Identity: [v2-0625](CodeSystem-v2-0625.md)
  * Name: itemStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the state of an inventory item within the context of an inven…
* Identity: [v2-0634](CodeSystem-v2-0634.md)
  * Name: itemImportance
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that denote a level or importance of an inventory item within the context o…
* Identity: [v2-0642](CodeSystem-v2-0642.md)
  * Name: reorderTheory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the calculation method used to determine the resupply schedul…
* Identity: [v2-0651](CodeSystem-v2-0651.md)
  * Name: laborCalculationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the method used to calculate employee labor and measure emplo…
* Identity: [v2-0653](CodeSystem-v2-0653.md)
  * Name: dateFormat
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the date format for a decontamination/sterilization instance.…
* Identity: [v2-0657](CodeSystem-v2-0657.md)
  * Name: deviceType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that idenfity the kind of device as defined by the manufacturer. Used in HL…
* Identity: [v2-0659](CodeSystem-v2-0659.md)
  * Name: lotControl
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that define whether the sterilization load for a device is built in the sub…
* Identity: [v2-0667](CodeSystem-v2-0667.md)
  * Name: deviceDataState
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that define the state of the data as provided from a device. Used in HL7 Ve…
* Identity: [v2-0669](CodeSystem-v2-0669.md)
  * Name: loadStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define the status of the information provided in a device steriliza…
* Identity: [v2-0682](CodeSystem-v2-0682.md)
  * Name: deviceStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that communicate the state of a device. Used in HL7 Version 2.x messaging i…
* Identity: [v2-0702](CodeSystem-v2-0702.md)
  * Name: cycleType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the type of cycle that is being executed. A cycle type is a sp…
* Identity: [v2-0717](CodeSystem-v2-0717.md)
  * Name: accessRestrictionValue
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the information to which access is restricted. Used in HL7 Vers…
* Identity: [v2-0728](CodeSystem-v2-0728.md)
  * Name: cclValue
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the clinical complexity level (CCL) value for the determined dia…
* Identity: [v2-0731](CodeSystem-v2-0731.md)
  * Name: drgDiagnosisDeterminationStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined cCode system of concepts specifying the status of a diagnosis for a diagnosis related g…
* Identity: [v2-0734](CodeSystem-v2-0734.md)
  * Name: grouperStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of a grouper in general. US Realm. Used in HL7 Versi…
* Identity: [v2-0739](CodeSystem-v2-0739.md)
  * Name: drgStatusPatient
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying whether the length of stay is normal or respectively shorter or …
* Identity: [v2-0742](CodeSystem-v2-0742.md)
  * Name: drgStatusFinancialCalculation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the diagnosis related group (DRG) calculation rega…
* Identity: [v2-0749](CodeSystem-v2-0749.md)
  * Name: drgGroupingStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the use of the gender information for diagnosis re…
* Identity: [v2-0755](CodeSystem-v2-0755.md)
  * Name: drgstatusWeightAtBirth
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the use of the weight at birth for diagnosis relat…
* Identity: [v2-0757](CodeSystem-v2-0757.md)
  * Name: drgStatusRespirationMinutes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the use of the respiration minutes information for…
* Identity: [v2-0759](CodeSystem-v2-0759.md)
  * Name: drgstatusAdmission
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the admission status for the diagnosis related group (DRG) deter…
* Identity: [v2-0761](CodeSystem-v2-0761.md)
  * Name: drgProcedureDeterminationStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the use of this particular procedure for the diagn…
* Identity: [v2-0763](CodeSystem-v2-0763.md)
  * Name: drgProcedureRelevance
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the relevance of this particular procedure for the diagnosis rel…
* Identity: [v2-0776](CodeSystem-v2-0776.md)
  * Name: itemStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [mnm](http://www.hl7.org/Special/committees/mnm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status (useful for reporting and item usage purposes) that a…
* Identity: [v2-0778](CodeSystem-v2-0778.md)
  * Name: itemType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a classification of material items into like groups as defined a…
* Identity: [v2-0790](CodeSystem-v2-0790.md)
  * Name: approvingRegulatoryAgency
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the regulatory agency by which the item has been approved, such …
* Identity: [v2-0793](CodeSystem-v2-0793.md)
  * Name: rulingAct
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying an act containing a rule that the item is legally required to be…
* Identity: [v2-0806](CodeSystem-v2-0806.md)
  * Name: sterilizationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the type of sterilization used for sterilizing the inventory sup…
* Identity: [v2-0818](CodeSystem-v2-0818.md)
  * Name: package
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the packaging unit in which this inventory supply item can be or…
* Identity: [v2-0834](CodeSystem-v2-0834.md)
  * Name: mimeTypes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the general type of data. Used in HL7 Version 2.x messaging in …
* Identity: [v2-0868](CodeSystem-v2-0868.md)
  * Name: telecommunicationExpirationReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the reason this contact number/email was marked as "ended". Use…
* Identity: [v2-0871](CodeSystem-v2-0871.md)
  * Name: supplyRisk
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying any known or suspected hazard associated with this material item…
* Identity: [v2-0881](CodeSystem-v2-0881.md)
  * Name: roleExecutingPhysician
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the account role of the physician, for example, only billing for…
* Identity: [v2-0882](CodeSystem-v2-0882.md)
  * Name: medicalRoleExecutingPhysician
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the role of the physician ("self-employed" or "employed"). Used…
* Identity: [v2-0894](CodeSystem-v2-0894.md)
  * Name: sideOfBody
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the side of the body ("left" or "right"). Used in HL7 Version 2…
* Identity: [v2-0904](CodeSystem-v2-0904.md)
  * Name: securityCheckScheme
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the scheme for the security check. Used in HL7 Vers…
* Identity: [v2-0905](CodeSystem-v2-0905.md)
  * Name: shipmentStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the status of the shipment. Used in HL7 Version 2.x…
* Identity: [v2-0906](CodeSystem-v2-0906.md)
  * Name: actpriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the priority for the shipment. Used in HL7 Version …
* Identity: [v2-0907](CodeSystem-v2-0907.md)
  * Name: confidentiality
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the confidentiality for the shipment. Used in HL7 V…
* Identity: [v2-0909](CodeSystem-v2-0909.md)
  * Name: patientResultsReleaseCategorizationScheme
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the scheme for the patient results release categoriz…
* Identity: [v2-0912](CodeSystem-v2-0912.md)
  * Name: participation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that represent functional involvement of a caregiver or member …
* Identity: [v2-0914](CodeSystem-v2-0914.md)
  * Name: rootCause
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the root cause. Used in HL7 Version 2.x messaging in the OBX se…
* Identity: [v2-0916](CodeSystem-v2-0916.md)
  * Name: relevantClincialInformation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying additional clinical information about the patient or specimen to…
* Identity: [v2-0917](CodeSystem-v2-0917.md)
  * Name: bolusType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the type of bolus. Used in HL7 Version 2.x messagin…
* Identity: [v2-0918](CodeSystem-v2-0918.md)
  * Name: pcaType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the type of PCA. Used in HL7 Version 2.x messaging …
* Identity: [v2-0919](CodeSystem-v2-0919.md)
  * Name: exclusiveTest
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that define if a test should be a specific event with no other …
* Identity: [v2-0920](CodeSystem-v2-0920.md)
  * Name: preferredSpecimen-AttributeStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that indicate whether a Specimen/Attribute is Preferred or Alte…
* Identity: [v2-0921](CodeSystem-v2-0921.md)
  * Name: certificationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the code for the certification type. Used in HL7 Version 2.x me…
* Identity: [v2-0922](CodeSystem-v2-0922.md)
  * Name: certificationCategory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the code for the certification category. Used in HL7 Version 2.…
* Identity: [v2-0923](CodeSystem-v2-0923.md)
  * Name: processInterruption
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying whether the process was interrrupted and whether the…
* Identity: [v2-0924](CodeSystem-v2-0924.md)
  * Name: cumulativeDosageLimitUom
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the unit of measure (UoM) for the cumulative dosage limit. Used…
* Identity: [v2-0925](CodeSystem-v2-0925.md)
  * Name: phlebotomyIssue
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the phlebotomy issue. Used in HL7 Version 2.x messa…
* Identity: [v2-0926](CodeSystem-v2-0926.md)
  * Name: phlebotomyStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the status of the phlebotomy. Used in HL7 Version 2…
* Identity: [v2-0927](CodeSystem-v2-0927.md)
  * Name: armStick
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the arm(s) receiving the stick. Used in HL7 Version…
* Identity: [v2-0933](CodeSystem-v2-0933.md)
  * Name: intendedProcedureType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the type of intended procedure. Used in HL7 Version…
* Identity: [v2-0935](CodeSystem-v2-0935.md)
  * Name: processInterruptionReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the reason for the process interruption. Used in HL…
* Identity: [v2-0936](CodeSystem-v2-0936.md)
  * Name: observationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying types of observations to enable systems to distingui…
* Identity: [v2-0937](CodeSystem-v2-0937.md)
  * Name: observationSubtype
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the observation sub-type. Used in HL7 Version 2.x m…
* Identity: [v2-0938](CodeSystem-v2-0938.md)
  * Name: collectionEvent
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the limit for the collection event or process step. …
* Identity: [v2-0939](CodeSystem-v2-0939.md)
  * Name: communicationLocation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the communication location. Used in HL7 Version 2.x…
* Identity: [v2-0940](CodeSystem-v2-0940.md)
  * Name: limitationTypeCode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the type of limitation. Used in HL7 Version 2.x mes…
* Identity: [v2-0942](CodeSystem-v2-0942.md)
  * Name: equipmentStateIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code sytem of cocepts that specify the type of measurement of the state of an automated…
* Identity: [v2-0945](CodeSystem-v2-0945.md)
  * Name: auto-DilutionType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of vendor-defined codes that specify the pre‑configured dilution to be applied on the i…
* Identity: [v2-0946](CodeSystem-v2-0946.md)
  * Name: supplierType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system that Identifies the type of supplier that will distribute the supply items associated t…
* Identity: [v2-0948](CodeSystem-v2-0948.md)
  * Name: v2CS-relationshipType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify the type of relationship identified by Relationsh…
* Identity: [v2-0949](CodeSystem-v2-0949.md)
  * Name: orderControlCodeReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that describe reasons for the chosen order control codes. Used …
* Identity: [v2-0950](CodeSystem-v2-0950.md)
  * Name: orderStatusModifier
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to further define the status identified in ORC-5. Used in…
* Identity: [v2-0951](CodeSystem-v2-0951.md)
  * Name: reasonForStudy
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that provide additional information to the universal service id…
* Identity: [v2-0970](CodeSystem-v2-0970.md)
  * Name: onlineVerificationResult
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code values used to indicate the result of an online verification of insurance data.
* Identity: [v2-0971](CodeSystem-v2-0971.md)
  * Name: onlineVerificationResultErrorCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code values representing a type of error from a failed operation to perform online verification of …
* Identity: [v2-4000](CodeSystem-v2-4000.md)
  * Name: name-addressRepresentation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined cdoe system of concepts that provide an indication of the kind of representation provid…
* Identity: [v3-AcknowledgementC…](CodeSystem-v3-AcknowledgementCondition.md)
  * Name: AcknowledgementCondition
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The codes identify the conditions under which accept acknowledgements are required to be returned i…
* Identity: [v3-AcknowledgementD…](CodeSystem-v3-AcknowledgementDetailCode.md)
  * Name: AcknowledgementDetailCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: *OpenIssue:*Missing description.
* Identity: [v3-AcknowledgementD…](CodeSystem-v3-AcknowledgementDetailType.md)
  * Name: AcknowledgementDetailType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code identifying the specific message to be provided.**Discussion:**A textual value may be spe…
* Identity: [v3-AcknowledgementT…](CodeSystem-v3-AcknowledgementType.md)
  * Name: AcknowledgementType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: This attribute contains an acknowledgement code as described in the HL7 message processing rules. …
* Identity: [v3-ActClass](CodeSystem-v3-ActClass.md)
  * Name: ActClass
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the major type of Act that this Act-instance represents.**Constraints:**The cl…
* Identity: [v3-ActCode](CodeSystem-v3-ActCode.md)
  * Name: ActCode
  * Version: 9.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-05-30
  * Description: A code specifying the particular kind of Act that the Act-instance represents within its class.…
* Identity: [v3-ActExposureLevel…](CodeSystem-v3-ActExposureLevelCode.md)
  * Name: ActExposureLevelCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A qualitative measure of the degree of exposure to the causative agent. This includes concepts such…
* Identity: [v3-ActInvoiceElemen…](CodeSystem-v3-ActInvoiceElementModifier.md)
  * Name: ActInvoiceElementModifier
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Processing consideration and clarification codes.
* Identity: [v3-ActMood](CodeSystem-v3-ActMood.md)
  * Name: ActMood
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-05-30
  * Description: OpenIssue: In Ballot 2009May, a strong Negative vote was lodged against several of the concept defi…
* Identity: [v3-ActPriority](CodeSystem-v3-ActPriority.md)
  * Name: ActPriority
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A set of codes (e.g., for routine, emergency), specifying the urgency under which the Act happened,…
* Identity: [v3-ActReason](CodeSystem-v3-ActReason.md)
  * Name: ActReason
  * Version: 3.1.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-02-28
  * Description: A set of codes specifying the motivation, cause, or rationale of an Act, when such rationale is not…
* Identity: [v3-ActRelationshipC…](CodeSystem-v3-ActRelationshipCheckpoint.md)
  * Name: ActRelationshipCheckpoint
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying when in the course of an Act a precondition for the Act is evaluated (e.g., befor…
* Identity: [v3-ActRelationshipJ…](CodeSystem-v3-ActRelationshipJoin.md)
  * Name: ActRelationshipJoin
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying how concurrent Acts are resynchronized in a parallel branch construct.*Discus…
* Identity: [v3-ActRelationshipS…](CodeSystem-v3-ActRelationshipSplit.md)
  * Name: ActRelationshipSplit
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying how branches in an action plan are selected among other branches.*Discussion:…
* Identity: [v3-ActRelationshipS…](CodeSystem-v3-ActRelationshipSubset.md)
  * Name: ActRelationshipSubset
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Used to indicate that the target of the relationship will be a filtered subset of the total related…
* Identity: [v3-ActRelationshipT…](CodeSystem-v3-ActRelationshipType.md)
  * Name: ActRelationshipType
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The source is an excerpt from the target.
* Identity: [v3-ActSite](CodeSystem-v3-ActSite.md)
  * Name: ActSite
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: An anatomical location on an organism which can be the focus of an act.
* Identity: [v3-ActStatus](CodeSystem-v3-ActStatus.md)
  * Name: ActStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes representing the defined possible states of an Act, as defined by the Act class state machine.
* Identity: [v3-ActUSPrivacyLaw](CodeSystem-v3-ActUSPrivacyLaw.md)
  * Name: ActUSPrivacyLaw
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A jurisdictional mandate in the US relating to privacy.****Deprecation Comment:****Content moved…
* Identity: [v3-ActUncertainty](CodeSystem-v3-ActUncertainty.md)
  * Name: ActUncertainty
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **OpenIssue:**Missing Description
* Identity: [v3-AddressPartType](CodeSystem-v3-AddressPartType.md)
  * Name: AddressPartType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Code that specifies whether an address part names the street, city, country, posta…
* Identity: [v3-AddressUse](CodeSystem-v3-AddressUse.md)
  * Name: AddressUse
  * Version: 3.0.1
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes that provide guidance around the circumstances in which a given address should be used.
* Identity: [v3-AdministrativeGe…](CodeSystem-v3-AdministrativeGender.md)
  * Name: AdministrativeGender
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The gender of a person used for adminstrative purposes (as opposed to clinical gender)
* Identity: [v3-AmericanIndianAl…](CodeSystem-v3-AmericanIndianAlaskaNativeLanguages.md)
  * Name: AmericanIndianAlaskaNativeLanguages
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: American Indian and Alaska Native languages currently being used in the United States.
* Identity: [v3-Calendar](CodeSystem-v3-Calendar.md)
  * Name: Calendar
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Code system for specifying a type of calendar
* Identity: [v3-CalendarCycle](CodeSystem-v3-CalendarCycle.md)
  * Name: Calendar Cycle Codes
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Calendar cycle identifiers
* Identity: [v3-CalendarType](CodeSystem-v3-CalendarType.md)
  * Name: CalendarType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Code system for specifying a type of calendar
* Identity: [v3-Charset](CodeSystem-v3-Charset.md)
  * Name: Charset
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Internet Assigned Numbers Authority (IANA) Charset Types
* Identity: [v3-CodingRationale](CodeSystem-v3-CodingRationale.md)
  * Name: CodingRationale
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies how to interpret the instance of the code, codeSystem value in a set of translations. Si…
* Identity: [v3-CommunicationFun…](CodeSystem-v3-CommunicationFunctionType.md)
  * Name: CommunicationFunctionType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Describes the type of communication function that the associated entity plays in the associated tra…
* Identity: [v3-CompressionAlgor…](CodeSystem-v3-CompressionAlgorithm.md)
  * Name: CompressionAlgorithm
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Type of compression algorithm used
* Identity: [v3-Confidentiality](CodeSystem-v3-Confidentiality.md)
  * Name: Confidentiality
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-05-30
  * Description: A set of codes specifying the security classification of acts and roles in accordance with the defi…
* Identity: [v3-ContainerCap](CodeSystem-v3-ContainerCap.md)
  * Name: ContainerCap
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The type of cap associated with a container
* Identity: [v3-ContainerSeparat…](CodeSystem-v3-ContainerSeparator.md)
  * Name: ContainerSeparator
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A material in a blood collection container that facilites the separation of of blood cells from ser…
* Identity: [v3-ContentProcessin…](CodeSystem-v3-ContentProcessingMode.md)
  * Name: ContentProcessingMode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Identifies the order in which content should be processed.
* Identity: [v3-ContextControl](CodeSystem-v3-ContextControl.md)
  * Name: ContextControl
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code that specifies how an ActRelationship or Participation contributes to the context of an Act,…
* Identity: [v3-DataOperation](CodeSystem-v3-DataOperation.md)
  * Name: DataOperation
  * Version: 5.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-Dentition](CodeSystem-v3-Dentition.md)
  * Name: Dentition
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-DeviceAlertLevel](CodeSystem-v3-DeviceAlertLevel.md)
  * Name: DeviceAlertLevel
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Domain values for the Device.Alert_levelCode
* Identity: [v3-DocumentCompleti…](CodeSystem-v3-DocumentCompletion.md)
  * Name: DocumentCompletion
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies the current completion state of a clinical document.
* Identity: [v3-DocumentStorage](CodeSystem-v3-DocumentStorage.md)
  * Name: DocumentStorage
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies the storage status of a document.
* Identity: [v3-EducationLevel](CodeSystem-v3-EducationLevel.md)
  * Name: Education Level
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Years of education that a person has completed
* Identity: [v3-EmployeeJobClass](CodeSystem-v3-EmployeeJobClass.md)
  * Name: EmployeeJobClass
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code qualifying the employment in various ways, such as, full-time vs. part time, etc.
* Identity: [v3-EncounterAdmissi…](CodeSystem-v3-EncounterAdmissionSource.md)
  * Name: EncounterAdmissionSource
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-EncounterSpecial…](CodeSystem-v3-EncounterSpecialCourtesy.md)
  * Name: EncounterSpecialCourtesy
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-EntityClass](CodeSystem-v3-EntityClass.md)
  * Name: EntityClass
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Classifies the Entity class and all of its subclasses. The terminology is hierarchical. At the top …
* Identity: [v3-EntityCode](CodeSystem-v3-EntityCode.md)
  * Name: EntityCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **OpenIssue:**Missing description.
* Identity: [v3-EntityDeterminer](CodeSystem-v3-EntityDeterminer.md)
  * Name: EntityDeterminer
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: EntityDeterminer in natural language grammar is the class of words that comprises articles, demonst…
* Identity: [v3-EntityHandling](CodeSystem-v3-EntityHandling.md)
  * Name: EntityHandling
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Special handling requirements for an Entity.*Example:*Keep at room temperature; Keep frozen bel…
* Identity: [v3-EntityNamePartQu…](CodeSystem-v3-EntityNamePartQualifier.md)
  * Name: EntityNamePartQualifier
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **OpenIssue:**Needs description
* Identity: [v3-EntityNamePartQu…](CodeSystem-v3-EntityNamePartQualifierR2.md)
  * Name: EntityNamePartQualifierR2
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**The qualifier is a set of codes each of which specifies a certain subcategory of th…
* Identity: [v3-EntityNamePartTy…](CodeSystem-v3-EntityNamePartType.md)
  * Name: EntityNamePartType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-EntityNamePartTy…](CodeSystem-v3-EntityNamePartTypeR2.md)
  * Name: EntityNamePartTypeR2
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Indicates whether the name part is a given name, family name, prefix, suffix, etc.
* Identity: [v3-EntityNameUse](CodeSystem-v3-EntityNameUse.md)
  * Name: EntityNameUse
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-EntityNameUseR2](CodeSystem-v3-EntityNameUseR2.md)
  * Name: EntityNameUseR2
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**A set of codes advising a system or user which name in a set of names to select for…
* Identity: [v3-EntityRisk](CodeSystem-v3-EntityRisk.md)
  * Name: EntityRisk
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Kinds of risks associated with the handling of the material..
* Identity: [v3-EntityStatus](CodeSystem-v3-EntityStatus.md)
  * Name: EntityStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes representing the defined possible states of an Entity, as defined by the Entity class state m…
* Identity: [v3-EquipmentAlertLe…](CodeSystem-v3-EquipmentAlertLevel.md)
  * Name: EquipmentAlertLevel
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-Ethnicity](CodeSystem-v3-Ethnicity.md)
  * Name: Ethnicity
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-01-30
  * Description: **Deprecation Information:**Deprecated due to UP-265. This code system in NOT the acknowledged sou…
* Identity: [v3-ExposureMode](CodeSystem-v3-ExposureMode.md)
  * Name: ExposureMode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Code for the mechanism by which the exposure agent was exchanged or potentially exchanged by the pa…
* Identity: [v3-GTSAbbreviation](CodeSystem-v3-GTSAbbreviation.md)
  * Name: GTSAbbreviation
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Open Issue:**It appears that the printnames are suboptimal and should be improved for many of the …
* Identity: [v3-GenderStatus](CodeSystem-v3-GenderStatus.md)
  * Name: GenderStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A value representing whether the primary reproductive organs of NonPersonLivingSubject are present.
* Identity: [v3-HL7ContextConduc…](CodeSystem-v3-HL7ContextConductionStyle.md)
  * Name: HL7ContextConductionStyle
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The styles of context conduction usable by relationships within a static model derived from tyhe HL…
* Identity: [v3-HL7DefinedRosePr…](CodeSystem-v3-HL7DefinedRoseProperty.md)
  * Name: HL7DefinedRoseProperty
  * Version: 3.0.0
  * Status: retired
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The property Ids that HL7 has defined for customizing Rational Rose.**Deprecation Comment:**De…
* Identity: [v3-HL7DocumentForma…](CodeSystem-v3-HL7DocumentFormatCodes.md)
  * Name: HL7 Document Format Codes
  * Version: 4.1.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-11-10
  * Description: This codeSystem contains codes which specify the technical format of a document. Each code provides…
* Identity: [v3-HL7StandardVersi…](CodeSystem-v3-HL7StandardVersionCode.md)
  * Name: HL7StandardVersionCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: This code system holds version codes for the Version 3 standards. Values are to be determined by HL…
* Identity: [v3-HL7UpdateMode](CodeSystem-v3-HL7UpdateMode.md)
  * Name: HL7UpdateMode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The possible modes of updating that occur when an attribute is received by a system that already co…
* Identity: [v3-HtmlLinkType](CodeSystem-v3-HtmlLinkType.md)
  * Name: HtmlLinkType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: HtmlLinkType values are drawn from HTML 4.0 and describe the relationship between the current docum…
* Identity: [v3-IdentifierReliab…](CodeSystem-v3-IdentifierReliability.md)
  * Name: IdentifierReliability
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Specifies the reliability with which the identifier is known. This attribute MAY be used to assist …
* Identity: [v3-IdentifierScope](CodeSystem-v3-IdentifierScope.md)
  * Name: IdentifierScope
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes to specify the scope in which the identifier applies to the object with whic…
* Identity: [v3-IntegrityCheckAl…](CodeSystem-v3-IntegrityCheckAlgorithm.md)
  * Name: IntegrityCheckAlgorithm
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-LanguageAbilityM…](CodeSystem-v3-LanguageAbilityMode.md)
  * Name: LanguageAbilityMode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A value representing the method of expression of the language.*Example:*Expressed spoken, expre…
* Identity: [v3-LanguageAbilityP…](CodeSystem-v3-LanguageAbilityProficiency.md)
  * Name: LanguageAbilityProficiency
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A value representing the level of proficiency in a language.*Example:*Excellent, good, fair, po…
* Identity: [v3-LivingArrangement](CodeSystem-v3-LivingArrangement.md)
  * Name: LivingArrangement
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code depicting the living arrangements of a person
* Identity: [v3-LocalMarkupIgnore](CodeSystem-v3-LocalMarkupIgnore.md)
  * Name: LocalMarkupIgnore
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Tells a receiver to ignore just the local markup tags (local_markup, local_header, local_attr) w…
* Identity: [v3-LocalRemoteContr…](CodeSystem-v3-LocalRemoteControlState.md)
  * Name: LocalRemoteControlState
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A value representing the current state of control associated with the device.**Examples:**A devi…
* Identity: [v3-ManagedParticipa…](CodeSystem-v3-ManagedParticipationStatus.md)
  * Name: ManagedParticipationStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes representing the defined possible states of a Managed Participation, as defined by the Manage…
* Identity: [v3-ManufacturerMode…](CodeSystem-v3-ManufacturerModelNameExample.md)
  * Name: ManufacturerModelNameExample
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-11
  * Description: This code system serves to capture the ManufacturerModelName concept domain used to convey a coded …
* Identity: [v3-MapRelationship](CodeSystem-v3-MapRelationship.md)
  * Name: MapRelationship
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The closeness or quality of the mapping between the HL7 concept (as represented by the HL7 concept …
* Identity: [v3-MaritalStatus](CodeSystem-v3-MaritalStatus.md)
  * Name: MaritalStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: * * * No description supplied * * ***Open Issue:**The specific meanings of these codes can…
* Identity: [v3-MessageWaitingPr…](CodeSystem-v3-MessageWaitingPriority.md)
  * Name: MessageWaitingPriority
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Indicates that the receiver has messages for the sender**OpenIssue:**Description does not make s…
* Identity: [v3-ModifyIndicator](CodeSystem-v3-ModifyIndicator.md)
  * Name: ModifyIndicator
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Indicates whether the subscription to a query is new or is being modified.
* Identity: [v3-NullFlavor](CodeSystem-v3-NullFlavor.md)
  * Name: NullFlavor
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A collection of codes specifying why a valid value is not present.
* Identity: [v3-ObservationCateg…](CodeSystem-v3-ObservationCategory.md)
  * Name: ObservationCategory
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: High level observation categories for the general type of observation being made.URL: http://hl…
* Identity: [v3-ObservationInter…](CodeSystem-v3-ObservationInterpretation.md)
  * Name: ObservationInterpretation
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: One or more codes providing a rough qualitative interpretation of the observation, such as "normal"…
* Identity: [v3-ObservationMethod](CodeSystem-v3-ObservationMethod.md)
  * Name: ObservationMethod
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code that provides additional detail about the means or technique used to ascertain the observati…
* Identity: [v3-ObservationValue](CodeSystem-v3-ObservationValue.md)
  * Name: ObservationValue
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-02-28
  * Description: This code system covers all concepts of HL7-defined values for the Observation value element, when …
* Identity: [v3-ParticipationFun…](CodeSystem-v3-ParticipationFunction.md)
  * Name: ParticipationFunction
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: This code is used to specify the exact function an actor had in a service in all necessary detail. …
* Identity: [v3-ParticipationMode](CodeSystem-v3-ParticipationMode.md)
  * Name: ParticipationMode
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2021-08-10
  * Description: A set of codes specifying the modality by which the Entity playing the Role is participating in the…
* Identity: [v3-ParticipationSig…](CodeSystem-v3-ParticipationSignature.md)
  * Name: ParticipationSignature
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A set of codes specifying whether and how the participant has attested his participation through a …
* Identity: [v3-ParticipationType](CodeSystem-v3-ParticipationType.md)
  * Name: ParticipationType
  * Version: 5.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the meaning and purpose of every Participation instance. Each of its values impli…
* Identity: [v3-PatientImportance](CodeSystem-v3-PatientImportance.md)
  * Name: PatientImportance
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Patient VIP code
* Identity: [v3-PaymentTerms](CodeSystem-v3-PaymentTerms.md)
  * Name: PaymentTerms
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Describes payment terms for a financial transaction, used in an invoice.This is typically expre…
* Identity: [v3-PersonDisability…](CodeSystem-v3-PersonDisabilityType.md)
  * Name: PersonDisabilityType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code identifying a person's disability.
* Identity: [v3-ProbabilityDistr…](CodeSystem-v3-ProbabilityDistributionType.md)
  * Name: ProbabilityDistributionType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-ProcessingID](CodeSystem-v3-ProcessingID.md)
  * Name: ProcessingID
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes used to specify whether a message is part of a production, training, or debugging system.
* Identity: [v3-ProcessingMode](CodeSystem-v3-ProcessingMode.md)
  * Name: ProcessingMode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: This attribute defines whether the message is being sent in current processing, archive mode, initi…
* Identity: [v3-QueryParameterVa…](CodeSystem-v3-QueryParameterValue.md)
  * Name: QueryParameterValue
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The domain of coded values used as parameters within QueryByParameter queries.
* Identity: [v3-QueryPriority](CodeSystem-v3-QueryPriority.md)
  * Name: QueryPriority
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies the time frame in which the response is expected.
* Identity: [v3-QueryRequestLimit](CodeSystem-v3-QueryRequestLimit.md)
  * Name: QueryRequestLimit
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Definition:**Defines the units associated with the magnitude of the maximum size limit of a quer…
* Identity: [v3-QueryResponse](CodeSystem-v3-QueryResponse.md)
  * Name: QueryResponse
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code classifying the general nature of the response to a given query. Includes whether or not dat…
* Identity: [v3-QueryStatusCode](CodeSystem-v3-QueryStatusCode.md)
  * Name: QueryStatusCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the state of the Query.
* Identity: [v3-Race](CodeSystem-v3-Race.md)
  * Name: Race
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-01-05
  * Description: **Deprecation Information:**Deprecated per UP-263. This code system is NOT the acknowledged source…
* Identity: [v3-RelationalOperat…](CodeSystem-v3-RelationalOperator.md)
  * Name: RelationalOperator
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies common relational operators used in selection criteria.
* Identity: [v3-RelationshipConj…](CodeSystem-v3-RelationshipConjunction.md)
  * Name: RelationshipConjunction
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the logical conjunction of the criteria among all the condition-links of Acts (e.…
* Identity: [v3-ReligiousAffilia…](CodeSystem-v3-ReligiousAffiliation.md)
  * Name: Religious Affiliation
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Assigment of spiritual faith affiliation
* Identity: [v3-ResponseLevel](CodeSystem-v3-ResponseLevel.md)
  * Name: ResponseLevel
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Specifies whether a response is expected from the addressee of this interaction and what level of d…
* Identity: [v3-ResponseModality](CodeSystem-v3-ResponseModality.md)
  * Name: ResponseModality
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Defines the timing and grouping of the response instances.**OpenIssue:**Description copied from …
* Identity: [v3-ResponseMode](CodeSystem-v3-ResponseMode.md)
  * Name: ResponseMode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Specifies the mode, immediate versus deferred or queued, by which a receiver should communicate its…
* Identity: [v3-RoleClass](CodeSystem-v3-RoleClass.md)
  * Name: RoleClass
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes for the Role class hierarchy. The values in this hierarchy, represent a Role which is an asso…
* Identity: [v3-RoleCode](CodeSystem-v3-RoleCode.md)
  * Name: RoleCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-15
  * Description: A set of codes further specifying the kind of Role; specific classification codes for further quali…
* Identity: [v3-RoleLinkStatus](CodeSystem-v3-RoleLinkStatus.md)
  * Name: RoleLinkStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes representing possible states of a RoleLink, as defined by the RoleLink class …
* Identity: [v3-RoleLinkType](CodeSystem-v3-RoleLinkType.md)
  * Name: RoleLinkType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the meaning and purpose of every RoleLink instance. Each of its values implies sp…
* Identity: [v3-RoleStatus](CodeSystem-v3-RoleStatus.md)
  * Name: RoleStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes representing the defined possible states of an Role, as defined by the Role class state machi…
* Identity: [v3-RouteOfAdministr…](CodeSystem-v3-RouteOfAdministration.md)
  * Name: RouteOfAdministration
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The path the administered medication takes to get into the body or into contact with the body.
* Identity: [v3-Sequencing](CodeSystem-v3-Sequencing.md)
  * Name: Sequencing
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Specifies sequence of sort order.
* Identity: [v3-SetOperator](CodeSystem-v3-SetOperator.md)
  * Name: SetOperator
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-SoftwareNameExam…](CodeSystem-v3-SoftwareNameExample.md)
  * Name: SoftwareNameExample
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-11
  * Description: This code system serves to capture the SoftwareName concept domain used to convey a coded name for …
* Identity: [v3-SpecimenType](CodeSystem-v3-SpecimenType.md)
  * Name: SpecimenType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-SubstitutionCond…](CodeSystem-v3-SubstitutionCondition.md)
  * Name: SubstitutionCondition
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies what sort of change is permitted or has occurred between the item that was ordered/reque…
* Identity: [v3-TableCellHorizon…](CodeSystem-v3-TableCellHorizontalAlign.md)
  * Name: TableCellHorizontalAlign
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TableCellScope](CodeSystem-v3-TableCellScope.md)
  * Name: TableCellScope
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TableCellVertica…](CodeSystem-v3-TableCellVerticalAlign.md)
  * Name: TableCellVerticalAlign
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TableFrame](CodeSystem-v3-TableFrame.md)
  * Name: TableFrame
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TableRules](CodeSystem-v3-TableRules.md)
  * Name: TableRules
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: These values are defined within the XHTML 4.0 Table Model
* Identity: [v3-TargetAwareness](CodeSystem-v3-TargetAwareness.md)
  * Name: TargetAwareness
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the extent to which the Entity playing the participating Role (usually as a targe…
* Identity: [v3-Telecommunicatio…](CodeSystem-v3-TelecommunicationCapabilities.md)
  * Name: TelecommunicationCapabilities
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Concepts that define the telecommunication capabilities of a particular device. Us…
* Identity: [v3-TimingEvent](CodeSystem-v3-TimingEvent.md)
  * Name: TimingEvent
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DESCRIPTION ****
* Identity: [v3-TransmissionRela…](CodeSystem-v3-TransmissionRelationshipTypeCode.md)
  * Name: TransmissionRelationshipTypeCode
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**A code specifying the meaning and purpose of every TransmissionRelationship instanc…
* Identity: [v3-TribalEntityUS](CodeSystem-v3-TribalEntityUS.md)
  * Name: TribalEntityUS
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: INDIAN ENTITIES RECOGNIZED AND ELIGIBLE TO RECEIVE SERVICES FROM THE UNITED STATES BUREAU OF INDIAN…
* Identity: [v3-URLScheme](CodeSystem-v3-URLScheme.md)
  * Name: Universal Resource Locator Scheme
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A Universal Resource Locator (URL) is a type of telecommunications address specified as Internet st…
* Identity: [v3-VaccineManufactu…](CodeSystem-v3-VaccineManufacturer.md)
  * Name: VaccineManufacturer
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The manufacturer of a vaccine.
* Identity: [v3-VaccineType](CodeSystem-v3-VaccineType.md)
  * Name: VaccineType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The kind of vaccine.
* Identity: [v3-WorkClassificati…](CodeSystem-v3-WorkClassificationODH.md)
  * Name: Work Classification (Occupational Data for Health)
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Code system of concepts representing a person's job type as defined by compensation and sector (e.g…
* Identity: [v3-hl7ApprovalStatus](CodeSystem-v3-hl7ApprovalStatus.md)
  * Name: HL7ApprovalStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes for concepts describing the approval level of HL7 artifacts. This code syste…
* Identity: [v3-hl7CMETAttributi…](CodeSystem-v3-hl7CMETAttribution.md)
  * Name: HL7CMETAttribution
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **** MISSING DEFINITIONS ****
* Identity: [v3-hl7ITSType](CodeSystem-v3-hl7ITSType.md)
  * Name: HL7ITSType
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes identifying types of HL7 Implementation Technology Specifications
* Identity: [v3-hl7ITSVersionCode](CodeSystem-v3-hl7ITSVersionCode.md)
  * Name: HL7 ITS Version Code
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: HL7 implementation technology specification versions. These codes will document the ITS type and ve…
* Identity: [v3-hl7PublishingDom…](CodeSystem-v3-hl7PublishingDomain.md)
  * Name: HL7PublishingDomain
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes for HL7 publishing domains (specific content area)
* Identity: [v3-hl7PublishingSec…](CodeSystem-v3-hl7PublishingSection.md)
  * Name: HL7PublishingSection
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes for HL7 publishing sections (major business categories)
* Identity: [v3-hl7PublishingSub…](CodeSystem-v3-hl7PublishingSubSection.md)
  * Name: HL7PublishingSubSection
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Codes for HL7 publishing sub-sections (business sub-categories)
* Identity: [v3-hl7Realm](CodeSystem-v3-hl7Realm.md)
  * Name: HL7Realm
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Coded concepts representing Binding Realms (used for Context Binding of terminolog…
* Identity: [v3-hl7V3Conformance](CodeSystem-v3-hl7V3Conformance.md)
  * Name: HL7V3Conformance
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Identifies allowed codes for HL7aTMs v3 conformance property.
* Identity: [v3-hl7VoteResolution](CodeSystem-v3-hl7VoteResolution.md)
  * Name: HL7VoteResolution
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **Description:**Based on concepts for resolutions from HL7 ballot spreadsheet according to HL7's G…
* Identity: [v3-orderableDrugForm](CodeSystem-v3-orderableDrugForm.md)
  * Name: Orderable Drug Form
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: **OpenIssue:**Missing description.
* Identity: [v3-styleType](CodeSystem-v3-styleType.md)
  * Name: Style Type
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The style code is used within the CDA/SPL narrative block to give the instance author some control …
* Identity: [v3-substanceAdminSu…](CodeSystem-v3-substanceAdminSubstitution.md)
  * Name: Substance Admin Substitution
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Identifies what sort of change is permitted or has occurred between the therapy that was ordered an…
* Identity: [validation-process](CodeSystem-validation-process.md)
  * Name: Validation-process
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The primary process by which the target is validated
* Identity: [validation-status](CodeSystem-validation-status.md)
  * Name: Validation-status
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: Status of the validation of the target against the primary source
* Identity: [validation-type](CodeSystem-validation-type.md)
  * Name: Validation-type
  * Version: 1.0.1
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: What the target is validated against
* Identity: [variable-role](CodeSystem-variable-role.md)
  * Name: EvidenceVariableRole
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The role that the assertion variable plays.
* Identity: [variable-role-subty…](CodeSystem-variable-role-subtype.md)
  * Name: EvidenceVariableRoleSubtype
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [cds](http://www.hl7.org/Special/committees/dss)
  * Copyright: THO
  * Date: 2024-04-24
  * Description: The subclassification of the role that the assertion variable plays.
* Identity: [variant-state](CodeSystem-variant-state.md)
  * Name: sequenceStatus
  * Version: 1.0.0
  * Status: draft
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2020-04-09
  * Description: Codes providing the status of the variant test result.
* Identity: [verificationresult-…](CodeSystem-verificationresult-communication-method.md)
  * Name: VerificationResult Communication Method
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2018-10-31
  * Description: Attested information may be validated by process that are manual or automated. For automated proces…
* Identity: [virtual-healthcare-…](CodeSystem-virtual-healthcare-delivery-method.md)
  * Name: Virtual Healthcare Delivery Method
  * Version: 1.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2025-11-13
  * Description: This code system defines a set of codes for virtual healthcare service delivery method.

Showing 845 of 845 entries

