# CDA Code Systems - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**HL7 Code Systems**](codesystems.md)
* **CDA Code Systems**

## CDA Code Systems

 Code systems defined by HL7, and published in the CDA R2 Base Standard for use in the CDA product family. Note that all of these code systems have been defined in the Version 3 product family, from which CDA was derived. 

* Identity: 
  * Name: 
  * Version: 
  * Status: 
  * Content: 
  * Owner: 
  * Copyright: 
  * Date: 
  * Description: 
* Identity: [v3-ActClass](CodeSystem-v3-ActClass.md)
  * Name: ActClass
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the major type of Act that this Act-instance represents.**Constraints:**The cl…
* Identity: [v3-ActMood](CodeSystem-v3-ActMood.md)
  * Name: ActMood
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-05-30
  * Description: OpenIssue: In Ballot 2009May, a strong Negative vote was lodged against several of the concept defi…
* Identity: [v3-ActRelationshipT…](CodeSystem-v3-ActRelationshipType.md)
  * Name: ActRelationshipType
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: The source is an excerpt from the target.
* Identity: [v3-Confidentiality](CodeSystem-v3-Confidentiality.md)
  * Name: Confidentiality
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2023-05-30
  * Description: A set of codes specifying the security classification of acts and roles in accordance with the defi…
* Identity: [v3-ContextControl](CodeSystem-v3-ContextControl.md)
  * Name: ContextControl
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code that specifies how an ActRelationship or Participation contributes to the context of an Act,…
* Identity: [v3-EntityClass](CodeSystem-v3-EntityClass.md)
  * Name: EntityClass
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Classifies the Entity class and all of its subclasses. The terminology is hierarchical. At the top …
* Identity: [v3-EntityDeterminer](CodeSystem-v3-EntityDeterminer.md)
  * Name: EntityDeterminer
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: EntityDeterminer in natural language grammar is the class of words that comprises articles, demonst…
* Identity: [v3-HL7DocumentForma…](CodeSystem-v3-HL7DocumentFormatCodes.md)
  * Name: HL7 Document Format Codes
  * Version: 4.1.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2024-11-10
  * Description: This codeSystem contains codes which specify the technical format of a document. Each code provides…
* Identity: [v3-ManufacturerMode…](CodeSystem-v3-ManufacturerModelNameExample.md)
  * Name: ManufacturerModelNameExample
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-11
  * Description: This code system serves to capture the ManufacturerModelName concept domain used to convey a coded …
* Identity: [v3-NullFlavor](CodeSystem-v3-NullFlavor.md)
  * Name: NullFlavor
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A collection of codes specifying why a valid value is not present.
* Identity: [v3-ParticipationFun…](CodeSystem-v3-ParticipationFunction.md)
  * Name: ParticipationFunction
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: This code is used to specify the exact function an actor had in a service in all necessary detail. …
* Identity: [v3-ParticipationType](CodeSystem-v3-ParticipationType.md)
  * Name: ParticipationType
  * Version: 5.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: A code specifying the meaning and purpose of every Participation instance. Each of its values impli…
* Identity: [v3-RoleClass](CodeSystem-v3-RoleClass.md)
  * Name: RoleClass
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes for the Role class hierarchy. The values in this hierarchy, represent a Role which is an asso…
* Identity: [v3-RoleStatus](CodeSystem-v3-RoleStatus.md)
  * Name: RoleStatus
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-03-20
  * Description: Codes representing the defined possible states of an Role, as defined by the Role class state machi…
* Identity: [v3-SoftwareNameExam…](CodeSystem-v3-SoftwareNameExample.md)
  * Name: SoftwareNameExample
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2022-10-11
  * Description: This code system serves to capture the SoftwareName concept domain used to convey a coded name for …

Showing 15 of 15 entries

