# PurposeOfUse - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PurposeOfUse**

## ValueSet: PurposeOfUse 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-PurposeOfUse | *Version*:3.1.0 | |
| Active as of 2024-02-28 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PurposeOfUse |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20448 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Supports communication of purpose of use at a general level. 

 **References** 

* Included into [SecurityControlObservationValue](ValueSet-v3-SecurityControlObservationValue.md)
* [AuditEvent](http://hl7.org/fhir/R5/auditevent.html)
* [Consent](http://hl7.org/fhir/R5/consent.html)
* [Contract](http://hl7.org/fhir/R5/contract.html)
* [Permission](http://hl7.org/fhir/R5/permission.html)
* [Provenance](http://hl7.org/fhir/R5/provenance.html)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ActReason`](CodeSystem-v3-ActReason.md)version 📦3.1.0 where concept is-a [PurposeOfUse](CodeSystem-v3-ActReason.md#v3-ActReason-PurposeOfUse)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-PurposeOfUse",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-PurposeOfUse",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20448"
    }
  ],
  "version" : "3.1.0",
  "name" : "PurposeOfUse",
  "title" : "PurposeOfUse",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-02-28",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Supports communication of purpose of use at a general level.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "PurposeOfUse"
          }
        ]
      }
    ]
  }
}

```
