# EntityClassOrganization - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EntityClassOrganization**

## ValueSet: EntityClassOrganization 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-EntityClassOrganization | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EntityClassOrganization |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.10889 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A social or legal structure formed by human beings. 

 **References** 

* Included into [XEntityClassDocumentReceiving](ValueSet-v3-xEntityClassDocumentReceiving.md)
* Included into [XEntityClassPersonOrOrgReceiving](ValueSet-v3-xEntityClassPersonOrOrgReceiving.md)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-EntityClass`](CodeSystem-v3-EntityClass.md)version 📦3.0.0 where concept is-a [ORG](CodeSystem-v3-EntityClass.md#v3-EntityClass-ORG)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-EntityClassOrganization",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-EntityClassOrganization",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.10889"
    }
  ],
  "version" : "3.0.0",
  "name" : "EntityClassOrganization",
  "title" : "EntityClassOrganization",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A social or legal structure formed by human beings.",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityClass",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "ORG"
          }
        ]
      }
    ]
  }
}

```
