# CMS Place of Service Codes (POS) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CMS Place of Service Codes (POS)**

## ValueSet: CMS Place of Service Codes (POS) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/CMSPlaceOfServiceCodes | *Version*:1.0.0 | |
| Active as of 2024-07-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CMSPlaceOfServiceCodes |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This is the all codes value set for the CMS POS code system. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Last updated: 2020-02-24 12:41:39+1100

Profile: [Shareable ValueSet](http://hl7.org/fhir/R5/shareablevalueset.html)

* Include all codes defined in [`https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set`](CodeSystem-CMSPlaceofServiceCodes.md)version 📦20240502

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "CMSPlaceOfServiceCodes",
  "meta" : {
    "lastUpdated" : "2020-02-24T12:41:39.109+11:00",
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sd"
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/CMSPlaceOfServiceCodes",
  "version" : "1.0.0",
  "name" : "CMSPlaceOfServiceCodes",
  "title" : "CMS Place of Service Codes (POS)",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-07-01T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This is the all codes value set for the CMS POS code system.",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set"
      }
    ]
  }
}

```
