# Unified Code for Units of Measure (UCUM) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Unified Code for Units of Measure (UCUM)**

## NamingSystem: Unified Code for Units of Measure (UCUM) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-ucum | *Version*:3.0.0 | |
| Active as of 2020-11-03 | *Responsible:*Regenstrief | *Computable Name*:UCUM |
| **Copyright/Legal**: The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. https://ucum.org/trac/wiki/TermsOfUse | | |

 
The Unified Code for Units of Measure (UCUM) is a code system intended to include all units of measures being contemporarily used in international science, engineering, and business. The purpose is to facilitate unambiguous electronic communication of quantities together with their units. The focus is on electronic communication, as opposed to communication between humans. A typical application of The Unified Code for Units of Measure are electronic data interchange (EDI) protocols, but there is nothing that prevents it from being used in other types of machine communication. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-ucum |
| Version | 3.0.0 |
| Name | UCUM |
| Title | Unified Code for Units of Measure (UCUM) |
| Status | active |
| Definition | The Unified Code for Units of Measure (UCUM) is a code system intended to include all units of measures being contemporarily used in international science, engineering, and business. The purpose is to facilitate unambiguous electronic communication of quantities together with their units. The focus is on electronic communication, as opposed to communication between humans. A typical application of The Unified Code for Units of Measure are electronic data interchange (EDI) protocols, but there is nothing that prevents it from being used in other types of machine communication. |
| Publisher | Regenstrief |
| Copyright | The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. https://ucum.org/trac/wiki/TermsOfUse |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.8
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://unitsofmeasure.org
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-ucum",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-ucum",
  "version" : "3.0.0",
  "name" : "UCUM",
  "title" : "Unified Code for Units of Measure (UCUM)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2020-11-03",
  "publisher" : "Regenstrief",
  "contact" : [
    {
      "name" : "LOINC and Health Data Standards, Regenstrief Institute, Inc."
    }
  ],
  "responsible" : "LOINC and Health Data Standards, Regenstrief Institute, Inc.",
  "description" : "The Unified Code for Units of Measure (UCUM) is a code system intended to include all units of measures being contemporarily used in international science, engineering, and business. The purpose is to facilitate unambiguous electronic communication of quantities together with their units. The focus is on electronic communication, as opposed to communication between humans. A typical application of The Unified Code for Units of Measure are electronic data interchange (EDI) protocols, but there is nothing that prevents it from being used in other types of machine communication.",
  "copyright" : "The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. https://ucum.org/trac/wiki/TermsOfUse",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.8",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://unitsofmeasure.org",
      "preferred" : true
    }
  ]
}

```
