# American Dental Association Systematized Nomenclature of Dentistry (SNODENT) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **American Dental Association Systematized Nomenclature of Dentistry (SNODENT)**

## NamingSystem: American Dental Association Systematized Nomenclature of Dentistry (SNODENT) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-ada-snodent | *Version*:1.0.0 | |
| Active as of 2019-03-20 | *Responsible:*American Dental Association | *Computable Name*:AdaSnodent |
| **Copyright/Legal**: SNODENT is owned and maintained by the ADA. A (free of charge) license to use SNODENT content may be obtained from ADA at https://www.ada.org/resources/practice/dental-standards/snodent/snodent-license-application | | |

 
Systematized Nomenclature of Dentistry (SNODENT) is owned, maintained and distributed by the American Dental Association (ADA). SNODENT is a vocabulary designed for use in the electronic environment - for electronic health and dental records. The intended purpose is to: 
* Provide standardized terms for describing dental disease
* Capture clinical detail and patient characteristics
* Permit analysis of patient care services and outcomes
* To be interoperable with Electronic Health Records (EHR) and Electronic Dental Records (EDR)
 
SNODENT licensing information can be found at:[http://www.ada.org/8466.aspx](http://www.ada.org/8466.aspx) 
URL for Official Source:[http://www.ada.org/snodent.aspx](http://www.ada.org/snodent.aspx) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-ada-snodent |
| Version | 1.0.0 |
| Name | AdaSnodent |
| Title | American Dental Association Systematized Nomenclature of Dentistry (SNODENT) |
| Status | active |
| Definition | Systematized Nomenclature of Dentistry (SNODENT) is owned, maintained and distributed by the American Dental Association (ADA). SNODENT is a vocabulary designed for use in the electronic environment - for electronic health and dental records. The intended purpose is to:* Provide standardized terms for describing dental disease
* Capture clinical detail and patient characteristics
* Permit analysis of patient care services and outcomes
* To be interoperable with Electronic Health Records (EHR) and Electronic Dental Records (EDR)
SNODENT licensing information can be found at: [http://www.ada.org/8466.aspx](http://www.ada.org/8466.aspx)URL for Official Source: [http://www.ada.org/snodent.aspx](http://www.ada.org/snodent.aspx) |
| Publisher | American Dental Association |
| Copyright | SNODENT is owned and maintained by the ADA. A (free of charge) license to use SNODENT content may be obtained from ADA at https://www.ada.org/resources/practice/dental-standards/snodent/snodent-license-application |

### Identifiers

* **Type**: URI
  * **Value**: http://www.ada.org/snodent
  * **Preferred**: true
  * **Period**: 2024-08-28 --> (ongoing)
  * **Comment**: This is the URL endorsed by the TSMG and is considered authoritative.
* **Type**: OID
  * **Value**: 2.16.840.1.113883.3.3150
  * **Preferred**: true
  * **Period**: 
  * **Comment**: 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-ada-snodent",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-ada-snodent",
  "version" : "1.0.0",
  "name" : "AdaSnodent",
  "title" : "American Dental Association Systematized Nomenclature of Dentistry (SNODENT)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20",
  "publisher" : "American Dental Association",
  "contact" : [
    {
      "name" : "American Dental Association; 211 East Chicago Avenue Chicago, IL 60610-2678"
    }
  ],
  "description" : "Systematized Nomenclature of Dentistry (SNODENT) is owned, maintained and distributed by the American Dental Association (ADA). SNODENT is a vocabulary designed for use in the electronic environment - for electronic health and dental records. The intended purpose is to:\r\n\r\n *  Provide standardized terms for describing dental disease\r\n *  Capture clinical detail and patient characteristics\r\n *  Permit analysis of patient care services and outcomes\r\n *  To be interoperable with Electronic Health Records (EHR) and Electronic Dental Records (EDR)\r\n\r\nSNODENT licensing information can be found at: [http://www.ada.org/8466.aspx](http://www.ada.org/8466.aspx)\r\n\r\nURL for Official Source: [http://www.ada.org/snodent.aspx](http://www.ada.org/snodent.aspx)",
  "copyright" : "SNODENT is owned and maintained by the ADA.  A (free of charge) license to use SNODENT content may be obtained from ADA at https://www.ada.org/resources/practice/dental-standards/snodent/snodent-license-application",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://www.ada.org/snodent",
      "preferred" : true,
      "comment" : "This is the URL endorsed by the TSMG and is considered authoritative.",
      "period" : {
        "start" : "2024-08-28"
      }
    },
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.3.3150",
      "preferred" : true
    }
  ]
}

```
