# nubc-ServiceLineRevenue - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **nubc-ServiceLineRevenue**

## NamingSystem: nubc-ServiceLineRevenue 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v2-0456 | *Version*:1.0.0 | |
| Active as of 2019-12-01 | *Responsible:*HL7, Inc | *Computable Name*:NubcServiceLineRevenue |

 
Code system of concepts specifying a revenue code as specified in the National Uniform Billing Committee (NUBC) UB-04 manual, UB form locator 42, the service line revenue code. These are claim codes indicating the identifying number for the product or service provided. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the Revenue Code (GP1) value. Updated by NUBC annually; see the coding instructions for more detail. Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v2-0456 |
| Version | 1.0.0 |
| Name | NubcServiceLineRevenue |
| Title | nubc-ServiceLineRevenue |
| Status | active |
| Definition | Code system of concepts specifying a revenue code as specified in the National Uniform Billing Committee (NUBC) UB-04 manual, UB form locator 42, the service line revenue code. These are claim codes indicating the identifying number for the product or service provided. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the Revenue Code (GP1) value. Updated by NUBC annually; see the coding instructions for more detail. Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC. |
| Publisher | HL7, Inc |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.301.3
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/v2-0456
  * **Preferred**: true



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v2-0456",
  "url" : "http://terminology.hl7.org/NamingSystem/v2-0456",
  "version" : "1.0.0",
  "name" : "NubcServiceLineRevenue",
  "title" : "nubc-ServiceLineRevenue",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-12-01",
  "publisher" : "HL7, Inc",
  "contact" : [
    {
      "name" : "National Uniform Billing Committee (NUBC)"
    }
  ],
  "responsible" : "NUBC",
  "description" : "Code system of concepts specifying a revenue code as specified in the National Uniform Billing Committee (NUBC) UB-04 manual, UB form locator 42, the service line revenue code.  These are claim codes indicating the identifying number for the product or service provided. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html.  Used in HL7 Version 2.x messaging in the Revenue Code (GP1) value. Updated by NUBC annually; see the coding instructions for more detail.  Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.301.3",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v2-0456",
      "preferred" : true
    }
  ]
}

```
