# nubc-OccurrenceCode - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **nubc-OccurrenceCode**

## NamingSystem: nubc-OccurrenceCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v2-0350 | *Version*:1.0.0 | |
| Active as of 2019-12-01 | *Responsible:*HL7, Inc | *Computable Name*:NubcOccurrenceCode |

 
National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 31 - 34, Occurrence Codes and Amounts - code and associated date defining asignificant event relating to the bill that may affect payer processing the claim. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the OCD segment. Updated by NUBC annually; see the coding instructions for more detail. Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v2-0350 |
| Version | 1.0.0 |
| Name | NubcOccurrenceCode |
| Title | nubc-OccurrenceCode |
| Status | active |
| Definition | National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 31 - 34, Occurrence Codes and Amounts - code and associated date defining asignificant event relating to the bill that may affect payer processing the claim. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the OCD segment. Updated by NUBC annually; see the coding instructions for more detail. Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC. |
| Publisher | HL7, Inc |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.301.7
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/v2-0350
  * **Preferred**: true



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v2-0350",
  "url" : "http://terminology.hl7.org/NamingSystem/v2-0350",
  "version" : "1.0.0",
  "name" : "NubcOccurrenceCode",
  "title" : "nubc-OccurrenceCode",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-12-01",
  "publisher" : "HL7, Inc",
  "contact" : [
    {
      "name" : "National Uniform Billing Committee (NUBC)"
    }
  ],
  "responsible" : "NUBC",
  "description" : "National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 31 - 34, Occurrence Codes and Amounts - code and associated date defining asignificant event relating to the bill that may affect payer processing the claim. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html.  Used in HL7 Version 2.x messaging in the OCD segment. Updated by NUBC annually; see the coding instructions for more detail.  Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.301.7",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v2-0350",
      "preferred" : true
    }
  ]
}

```
