# USB VID and PID as a device identifier - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **USB VID and PID as a device identifier**

## NamingSystem: USB VID and PID as a device identifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/usb-address-identifier | *Version*:1.0.0 | |
| Active as of 2021-06-14 | *Responsible:*IHE Patient Care Devices (PCD) | *Computable Name*:USB_Address_Identifier |

 
A USB device that is plugged in identifies itself by its VID/PID combination. A VID is a 16-bit vendor number (Vendor ID). A PID is a 16-bit product number (Product ID). A host uses the VID/PID combination to find the drivers (if any) that are to be used for the USB device. For this to work, the VID/PID combination must be unique, in the sense that each USB device with the same VID/PID will use the same driver. So, whenever you need a specific driver for your USB product, you will need a unique VID/PID for that product. In that sense, the VID/PID combination does not really serve as a truly unique identifier of a single device instance. It is, however, useful to know for medical devices that communicate using USB. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/usb-address-identifier |
| Version | 1.0.0 |
| Name | USB_Address_Identifier |
| Title | USB VID and PID as a device identifier |
| Status | active |
| Definition | A USB device that is plugged in identifies itself by its VID/PID combination. A VID is a 16-bit vendor number (Vendor ID). A PID is a 16-bit product number (Product ID). A host uses the VID/PID combination to find the drivers (if any) that are to be used for the USB device. For this to work, the VID/PID combination must be unique, in the sense that each USB device with the same VID/PID will use the same driver. So, whenever you need a specific driver for your USB product, you will need a unique VID/PID for that product. In that sense, the VID/PID combination does not really serve as a truly unique identifier of a single device instance. It is, however, useful to know for medical devices that communicate using USB. |
| Publisher | IHE Patient Care Devices (PCD) |

### Identifiers

* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/usb
  * **Preferred**: true
  * **Comment**: USB VID (Vendor identifier) and PID (Product identifier) values

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "usb-address-identifier",
  "url" : "http://terminology.hl7.org/NamingSystem/usb-address-identifier",
  "version" : "1.0.0",
  "name" : "USB_Address_Identifier",
  "title" : "USB VID and PID as a device identifier",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2021-06-14T00:00:00-00:00",
  "publisher" : "IHE Patient Care Devices (PCD)",
  "contact" : [
    {
      "name" : "Devices on FHIR working group; IHE Patient Care Devices"
    }
  ],
  "responsible" : "IHE Patient Care Devices",
  "description" : "A USB device that is plugged in identifies itself by its VID/PID combination. A VID is a 16-bit vendor number (Vendor ID). A PID is a 16-bit product number (Product ID). A host uses the VID/PID combination to find the drivers (if any) that are to be used for the USB device. For this to work, the VID/PID combination must be unique, in the sense that each USB device with the same VID/PID will use the same driver. So, whenever you need a specific driver for your USB product, you will need a unique VID/PID for that product. In that sense, the VID/PID combination does not really serve as a truly unique identifier of a single device instance. It is, however, useful to know for medical devices that communicate using USB.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/usb",
      "preferred" : true,
      "comment" : "USB VID (Vendor identifier) and PID (Product identifier) values"
    }
  ]
}

```
