# Standard Occupation Code - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Standard Occupation Code**

## NamingSystem: Standard Occupation Code 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/soc | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*BLS | *Computable Name*:Soc |

 
The Standard Occupational Classification (SOC) system is used by Federal statistical agencies to classify workers into occupational categories for the purpose of collecting, calculating, or disseminating data. All workers are classified into one of over 820 occupations according to their occupational definition. To facilitate classification, occupations are combined to form 23 major groups, 96 minor groups, and 449 broad occupations. Each broad occupation includes detailed occupation(s) requiring similar job duties, skills, education, or experience. This code system replaced the older FIPSPUB92, which was withdrawn in February 2005. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/soc |
| Version | 2.1.0 |
| Name | Soc |
| Title | Standard Occupation Code |
| Status | retired |
| Definition | The Standard Occupational Classification (SOC) system is used by Federal statistical agencies to classify workers into occupational categories for the purpose of collecting, calculating, or disseminating data. All workers are classified into one of over 820 occupations according to their occupational definition. To facilitate classification, occupations are combined to form 23 major groups, 96 minor groups, and 449 broad occupations. Each broad occupation includes detailed occupation(s) requiring similar job duties, skills, education, or experience. This code system replaced the older FIPSPUB92, which was withdrawn in February 2005. |
| Publisher | BLS |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.243
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/soc
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "soc",
  "url" : "http://terminology.hl7.org/NamingSystem/soc",
  "version" : "2.1.0",
  "name" : "Soc",
  "title" : "Standard Occupation Code",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "BLS",
  "contact" : [
    {
      "name" : "U.S. Bureau of Labor Statistics"
    }
  ],
  "responsible" : "BLS",
  "description" : "The Standard Occupational Classification (SOC) system is used by Federal statistical agencies to classify workers into occupational categories for the purpose of collecting, calculating, or disseminating data. All workers are classified into one of over 820 occupations according to their occupational definition. To facilitate classification, occupations are combined to form 23 major groups, 96 minor groups, and 449 broad occupations. Each broad occupation includes detailed occupation(s) requiring similar job duties, skills, education, or experience. This code system replaced the older FIPSPUB92, which was withdrawn in February 2005.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.243",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/soc",
      "preferred" : true
    }
  ]
}

```
