# Passport Numbers Namespace for ZIMBABWE - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for ZIMBABWE**

## NamingSystem: Passport Numbers Namespace for ZIMBABWE 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-ZWE | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_ZWE |

 
Identifier of the namespace for Passport Numbers issued by the country of ZIMBABWE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-ZWE |
| Version | 1.0.0 |
| Name | PassportNumNS_ZWE |
| Title | Passport Numbers Namespace for ZIMBABWE |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of ZIMBABWE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.716
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-ZWE
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-ZWE",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-ZWE",
  "version" : "1.0.0",
  "name" : "PassportNumNS_ZWE",
  "title" : "Passport Numbers Namespace for ZIMBABWE",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of ZIMBABWE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.716",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-ZWE",
      "preferred" : true
    }
  ]
}

```
