# Passport Numbers Namespace for ZAMBIA - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for ZAMBIA**

## NamingSystem: Passport Numbers Namespace for ZAMBIA 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-ZMB | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_ZMB |

 
Identifier of the namespace for Passport Numbers issued by the country of ZAMBIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-ZMB |
| Version | 1.0.0 |
| Name | PassportNumNS_ZMB |
| Title | Passport Numbers Namespace for ZAMBIA |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of ZAMBIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.894
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-ZMB
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-ZMB",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-ZMB",
  "version" : "1.0.0",
  "name" : "PassportNumNS_ZMB",
  "title" : "Passport Numbers Namespace for ZAMBIA",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of ZAMBIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.894",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-ZMB",
      "preferred" : true
    }
  ]
}

```
