# Passport Numbers Namespace for SINGAPORE - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for SINGAPORE**

## NamingSystem: Passport Numbers Namespace for SINGAPORE 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-SGP | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_SGP |

 
Identifier of the namespace for Passport Numbers issued by the country of SINGAPORE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-SGP |
| Version | 1.0.0 |
| Name | PassportNumNS_SGP |
| Title | Passport Numbers Namespace for SINGAPORE |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of SINGAPORE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.702
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-SGP
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-SGP",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-SGP",
  "version" : "1.0.0",
  "name" : "PassportNumNS_SGP",
  "title" : "Passport Numbers Namespace for SINGAPORE",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of SINGAPORE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.702",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-SGP",
      "preferred" : true
    }
  ]
}

```
