# Passport Numbers Namespace for CAMBODIA - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for CAMBODIA**

## NamingSystem: Passport Numbers Namespace for CAMBODIA 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-KHM | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_KHM |

 
Identifier of the namespace for Passport Numbers issued by the country of CAMBODIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-KHM |
| Version | 1.0.0 |
| Name | PassportNumNS_KHM |
| Title | Passport Numbers Namespace for CAMBODIA |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of CAMBODIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.116
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-KHM
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-KHM",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-KHM",
  "version" : "1.0.0",
  "name" : "PassportNumNS_KHM",
  "title" : "Passport Numbers Namespace for CAMBODIA",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of CAMBODIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.116",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-KHM",
      "preferred" : true
    }
  ]
}

```
