# Passport Numbers Namespace for CZECH REPUBLIC - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for CZECH REPUBLIC**

## NamingSystem: Passport Numbers Namespace for CZECH REPUBLIC 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-CZE | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_CZE |

 
Identifier of the namespace for Passport Numbers issued by the country of CZECH REPUBLIC. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-CZE |
| Version | 1.0.0 |
| Name | PassportNumNS_CZE |
| Title | Passport Numbers Namespace for CZECH REPUBLIC |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of CZECH REPUBLIC. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.203
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-CZE
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-CZE",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-CZE",
  "version" : "1.0.0",
  "name" : "PassportNumNS_CZE",
  "title" : "Passport Numbers Namespace for CZECH REPUBLIC",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of CZECH REPUBLIC.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.203",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-CZE",
      "preferred" : true
    }
  ]
}

```
