# Medical Dictionary for Regulatory Activities - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medical Dictionary for Regulatory Activities**

## NamingSystem: Medical Dictionary for Regulatory Activities 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/mdr | *Version*:3.0.0 | |
| Active as of 2023-06-15 | *Responsible:*[MedDRA Maintenance and Support Services Organization (MedDRA MSSO); Mr. Patrick Revelle; MSSO Director](https://www.ich.org/page/contact) | *Computable Name*:MedDRA |

 
MedDRA is a multilingual standardised international medical terminology which can be used for regulatory communication and evaluation of data pertaining to medicinal products for human use. MedDRA is designed for use in the registration, documentation and safety monitoring of medicinal products through all phases of the development cycle (i.e., from clinical trials to post-marketing surveillance).#13; 
MedDRA is structured as a five level hierarchy. System Organ Classes (SOCs) are the broadest terms (e.g., Cardiac disorders, Investigations). The lowest level of the terminology is the Lowest Level Term (LLT) level. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/mdr |
| Version | 3.0.0 |
| Name | MedDRA |
| Title | Medical Dictionary for Regulatory Activities |
| Status | active |
| Definition | MedDRA is a multilingual standardised international medical terminology which can be used for regulatory communication and evaluation of data pertaining to medicinal products for human use. MedDRA is designed for use in the registration, documentation and safety monitoring of medicinal products through all phases of the development cycle (i.e., from clinical trials to post-marketing surveillance).#13;MedDRA is structured as a five level hierarchy. System Organ Classes (SOCs) are the broadest terms (e.g., Cardiac disorders, Investigations). The lowest level of the terminology is the Lowest Level Term (LLT) level. |
| Publisher | MedDRA Maintenance and Support Services Organization (MedDRA MSSO); Mr. Patrick Revelle; MSSO Director |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.163
  * **Preferred**: true
* **Type**: URI
  * **Value**: https://www.meddra.org
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/mdr
  * **Preferred**: false

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "mdr",
  "url" : "http://terminology.hl7.org/NamingSystem/mdr",
  "version" : "3.0.0",
  "name" : "MedDRA",
  "title" : "Medical Dictionary for Regulatory Activities",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2023-06-15T00:00:00-04:00",
  "publisher" : "MedDRA Maintenance and Support Services Organization (MedDRA MSSO); Mr. Patrick Revelle; MSSO Director",
  "contact" : [
    {
      "name" : "International Council for Harmonisation of Technical Requirements for Pharmaceuticals for Human Use (ICH)",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ich.org/page/contact"
        }
      ]
    }
  ],
  "responsible" : "MedDRA Maintenance and Support Services Organization (MedDRA MSSO)",
  "description" : "MedDRA is a multilingual standardised international medical terminology which can be used for regulatory communication and evaluation of data pertaining to medicinal products for human use.  MedDRA is designed for use in the registration, documentation and safety monitoring of medicinal products through all phases of the development cycle (i.e., from clinical trials to post-marketing surveillance).#13;\n\r\nMedDRA is structured as a five level hierarchy. System Organ Classes (SOCs) are the broadest terms (e.g., Cardiac disorders, Investigations). The lowest level of the terminology is the Lowest Level Term (LLT) level.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.163",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://www.meddra.org",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/mdr",
      "preferred" : false
    }
  ]
}

```
