# ISO 639-3 Language Codes Alpha 3 - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISO 639-3 Language Codes Alpha 3**

## NamingSystem: ISO 639-3 Language Codes Alpha 3 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/iso639-3 | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*ISO | *Computable Name*:Iso6393 |

 
**Description:**ISO 639-3 is a code that aims to define three-letter identifiers for all known human languages. At the core of ISO 639-3 are the individual languages already accounted for in ISO 639-2. The large number of living languages in the initial inventory of ISO 639-3 beyond those already included in ISO 639-2 was derived primarily from Ethnologue (15th edition). Additional extinct, ancient, historic, and constructed languages have been obtained from Linguist List. 
SIL International has been designated as the ISO 639-3/RA for the purpose of processing requests for alpha-3 language codes comprising the International Standard, Codes for the representation of names of languages - Part 3: Alpha-3 code for comprehensive coverage of languages. The ISO 639-3/RA receives and reviews applications for requesting new language codes and for the change of existing ones according to criteria indicated in the standard. It maintains an accurate list of information associated with registered language codes which can be viewed on or downloaded from this website, and processes updates of registered language codes. Notification of pending and adopted updates are also distributed on a regular basis to subscribers and other parties. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/iso639-3 |
| Version | 2.1.0 |
| Name | Iso6393 |
| Title | ISO 639-3 Language Codes Alpha 3 |
| Status | retired |
| Definition | **Description:** ISO 639-3 is a code that aims to define three-letter identifiers for all known human languages. At the core of ISO 639-3 are the individual languages already accounted for in ISO 639-2. The large number of living languages in the initial inventory of ISO 639-3 beyond those already included in ISO 639-2 was derived primarily from Ethnologue (15th edition). Additional extinct, ancient, historic, and constructed languages have been obtained from Linguist List.SIL International has been designated as the ISO 639-3/RA for the purpose of processing requests for alpha-3 language codes comprising the International Standard, Codes for the representation of names of languages - Part 3: Alpha-3 code for comprehensive coverage of languages. The ISO 639-3/RA receives and reviews applications for requesting new language codes and for the change of existing ones according to criteria indicated in the standard. It maintains an accurate list of information associated with registered language codes which can be viewed on or downloaded from this website, and processes updates of registered language codes. Notification of pending and adopted updates are also distributed on a regular basis to subscribers and other parties. |
| Publisher | ISO |

### Identifiers

* **Type**: OID
  * **Value**: 1.0.639.3
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/iso639-3
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "iso639-3",
  "url" : "http://terminology.hl7.org/NamingSystem/iso639-3",
  "version" : "2.1.0",
  "name" : "Iso6393",
  "title" : "ISO 639-3 Language Codes Alpha 3",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "ISO",
  "contact" : [
    {
      "name" : "SIL International"
    }
  ],
  "responsible" : "ISO",
  "description" : "**Description:** ISO 639-3 is a code that aims to define three-letter identifiers for all known human languages. At the core of ISO 639-3 are the individual languages already accounted for in ISO 639-2. The large number of living languages in the initial inventory of ISO 639-3 beyond those already included in ISO 639-2 was derived primarily from Ethnologue (15th edition). Additional extinct, ancient, historic, and constructed languages have been obtained from Linguist List.\r\n\r\nSIL International has been designated as the ISO 639-3/RA for the purpose of processing requests for alpha-3 language codes comprising the International Standard, Codes for the representation of names of languages - Part 3: Alpha-3 code for comprehensive coverage of languages. The ISO 639-3/RA receives and reviews applications for requesting new language codes and for the change of existing ones according to criteria indicated in the standard. It maintains an accurate list of information associated with registered language codes which can be viewed on or downloaded from this website, and processes updates of registered language codes. Notification of pending and adopted updates are also distributed on a regular basis to subscribers and other parties.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "1.0.639.3",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/iso639-3",
      "preferred" : true
    }
  ]
}

```
