# International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM)**

## NamingSystem: International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/icd10CM | *Version*:2.2.1 | |
| Active as of 2021-02-16 | *Responsible:*NCHS | *Computable Name*:Icd10CM |

 
The International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM), describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases. The ICD-10-CM codes can be used as the value of the Act.cd attribute. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/icd10CM |
| Version | 2.2.1 |
| Name | Icd10CM |
| Title | International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM) |
| Status | active |
| Definition | The International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM), describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases. The ICD-10-CM codes can be used as the value of the Act.cd attribute. |
| Publisher | NCHS |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.90
  * **Preferred**: true
  * **Comment**: 
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/icd10CM
  * **Preferred**: false
  * **Comment**: Published for many years in HL7 Standards, but has now been superceded. Retained here for backwards-compatibility and convenience.
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/icd-10-cm
  * **Preferred**: true
  * **Comment**: This is the URL as specified by the terminology owner, and is considereed authoritative.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "icd10CM",
  "url" : "http://terminology.hl7.org/NamingSystem/icd10CM",
  "version" : "2.2.1",
  "name" : "Icd10CM",
  "title" : "International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-02-16T00:00:00-04:00",
  "publisher" : "NCHS",
  "contact" : [
    {
      "name" : "National Center for Health Statistics/Centers for Disease Control and Prevention"
    }
  ],
  "responsible" : "NCHS",
  "description" : "The International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM), describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases. The ICD-10-CM codes can be used as the value of the Act.cd attribute.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.90",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/icd10CM",
      "preferred" : false,
      "comment" : "Published for many years in HL7 Standards, but has now been superceded.   Retained here for backwards-compatibility and convenience."
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/icd-10-cm",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considereed authoritative."
    }
  ]
}

```
