# PMIX Status Code - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PMIX Status Code**

## NamingSystem: PMIX Status Code 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/PMIXStatusCode | *Version*:1.0.0 | |
| Active as of 2024-06-03 | *Responsible:*[Prescription Monitoring Information eXchange (PMIX) Standards Organization](https://www.pdmpassist.org/PMIX) | *Computable Name*:PMIXStatusCode |
| **Copyright/Legal**: The owner of this code system has confirmed that it is open source and freely available. | | |

 
This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee. 
Chair:[Chad Garner](mailto:chad.garner@pharmacy.ohio.gov) 
Vice Chair:[Chelsea Townsend](mailto:townseca@dhec.sc.gov) 
Status Code: A code that indicates the status of the request to the PDMP (Prescription Drug Monitoring Program). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/PMIXStatusCode |
| Version | 1.0.0 |
| Name | PMIXStatusCode |
| Title | PMIX Status Code |
| Status | active |
| Definition | This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee.Chair: [Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)Vice Chair: [Chelsea Townsend](mailto:townseca@dhec.sc.gov)Status Code: A code that indicates the status of the request to the PDMP (Prescription Drug Monitoring Program). |
| Publisher | Prescription Monitoring Information eXchange (PMIX) Standards Organization |
| Copyright | The owner of this code system has confirmed that it is open source and freely available. |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/PMIXStatusCode
  * **Preferred**: true
  * **Period**: 2024-06-03 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "PMIXStatusCode",
  "url" : "http://terminology.hl7.org/NamingSystem/PMIXStatusCode",
  "version" : "1.0.0",
  "name" : "PMIXStatusCode",
  "title" : "PMIX Status Code",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-06-03T00:00:00-00:00",
  "publisher" : "Prescription Monitoring Information eXchange (PMIX) Standards Organization",
  "contact" : [
    {
      "name" : "Prescription Monitoring Information eXchange (PMIX) Standards Organization",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pdmpttac@iir.com"
        },
        {
          "system" : "url",
          "value" : "https://www.pdmpassist.org/PMIX"
        },
        {
          "system" : "phone",
          "value" : "1-850-481-PDMP"
        }
      ]
    }
  ],
  "description" : "This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee.\r\n\r\nChair: [Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)\r\n\r\nVice Chair: [Chelsea Townsend](mailto:townseca@dhec.sc.gov)\r\n\r\nStatus Code: A code that indicates the status of the request to the PDMP (Prescription Drug Monitoring Program).",
  "copyright" : "The owner of this code system has confirmed that it is open source and freely available.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/PMIXStatusCode",
      "preferred" : true,
      "period" : {
        "start" : "2024-06-03"
      }
    }
  ]
}

```
