# PMIX Method of Payment - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PMIX Method of Payment**

## NamingSystem: PMIX Method of Payment 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/PMIXMethodofPayment | *Version*:1.0.0 | |
| Active as of 2024-06-03 | *Responsible:*[Prescription Monitoring Information eXchange (PMIX) Standards Organization](https://www.pdmpassist.org/PMIX) | *Computable Name*:PMIXMethodofPayment |
| **Copyright/Legal**: The owner of this code system has confirmed that it is open source and freely available. | | |

 
This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee. 
Chair:[Chad Garner](mailto:chad.garner@pharmacy.ohio.gov) 
Vice Chair:[Chelsea Townsend](mailto:townseca@dhec.sc.gov) 
Method of Payment: The PMIX equivalent to the DSP16 field of the ASAP format which identifies the primary method of payment for the prescription, for use in PDMP (Prescription Drug Monitoring Program) data exchanges. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/PMIXMethodofPayment |
| Version | 1.0.0 |
| Name | PMIXMethodofPayment |
| Title | PMIX Method of Payment |
| Status | active |
| Definition | This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee.Chair: [Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)Vice Chair: [Chelsea Townsend](mailto:townseca@dhec.sc.gov)Method of Payment: The PMIX equivalent to the DSP16 field of the ASAP format which identifies the primary method of payment for the prescription, for use in PDMP (Prescription Drug Monitoring Program) data exchanges. |
| Publisher | Prescription Monitoring Information eXchange (PMIX) Standards Organization |
| Copyright | The owner of this code system has confirmed that it is open source and freely available. |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/PMIXMethodofPayment
  * **Preferred**: true
  * **Period**: 2024-06-03 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "PMIXMethodofPayment",
  "url" : "http://terminology.hl7.org/NamingSystem/PMIXMethodofPayment",
  "version" : "1.0.0",
  "name" : "PMIXMethodofPayment",
  "title" : "PMIX Method of Payment",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-06-03T00:00:00-00:00",
  "publisher" : "Prescription Monitoring Information eXchange (PMIX) Standards Organization",
  "contact" : [
    {
      "name" : "Prescription Monitoring Information eXchange (PMIX) Standards Organization",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pdmpttac@iir.com"
        },
        {
          "system" : "url",
          "value" : "https://www.pdmpassist.org/PMIX"
        },
        {
          "system" : "phone",
          "value" : "1-850-481-PDMP"
        }
      ]
    }
  ],
  "description" : "This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee.\r\n\r\nChair: [Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)\r\n\r\nVice Chair: [Chelsea Townsend](mailto:townseca@dhec.sc.gov)\r\n\r\nMethod of Payment: The PMIX equivalent to the DSP16 field of the ASAP format which identifies the primary method of payment for the prescription, for use in PDMP (Prescription Drug Monitoring Program) data exchanges.",
  "copyright" : "The owner of this code system has confirmed that it is open source and freely available.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/PMIXMethodofPayment",
      "preferred" : true,
      "period" : {
        "start" : "2024-06-03"
      }
    }
  ]
}

```
