# Manufacturers of Vaccines (MVX) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Manufacturers of Vaccines (MVX)**

## NamingSystem: Manufacturers of Vaccines (MVX) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/MVX | *Version*:3.0.1 | |
| Active as of 2024-10-24 | *Responsible:*[CDC, National Centers for Immunization and Respiratory Diseases; Immunization Information System Support Branch - Informatics](https://www.cdc.gov/iis/about/index.html?CDC_AAref_Val=https://www.cdc.gov/vaccines/programs/iis/index.html) | *Computable Name*:MVX |
| **Copyright/Legal**: "Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission."For information and exceptions regarding use of CDC material please see[here](https://www.cdc.gov/other/agencymaterials.html). | | |

 
"The CDC's National Center for Immunization and Respiratory Diseases ([NCIRD](https://www.cdc.gov/ncird/)) developed and maintains HL7 Table 0227, Manufacturers of Vaccines (MVX). It includes both active and inactive manufacturers of vaccines in the US. Inactive MVX codes allow transmission of historical immunization records. When MVX code is paired with a CVX (vaccine administered) code, the specific trade named vaccine may be indicated. MVX is the underlying Master Code System for V2 table 0227 (Manufacturers Of Vaccines (code=MVX)). The machine readable name for MVX in PHIN VADS is PH_VaccinesAdministeredCVX_CDC_NIP. 
Status indicates if the manufacturer is currently making vaccine for distribution in the United States. 
Last Updated indicates the last time this particular manufacturer code was updated in this table. 
Questions regarding MVX should be directed to the[IIS Technical Assistance Team](mailto:iisinfo@cdc.gov)(or use[mailing address](https://www2.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=mvx#addr))." 
For more information, please see[here](https://www2.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=mvx). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/MVX |
| Version | 3.0.1 |
| Name | MVX |
| Title | Manufacturers of Vaccines (MVX) |
| Status | active |
| Definition | "The CDC's National Center for Immunization and Respiratory Diseases ([NCIRD](https://www.cdc.gov/ncird/)) developed and maintains HL7 Table 0227, Manufacturers of Vaccines (MVX). It includes both active and inactive manufacturers of vaccines in the US. Inactive MVX codes allow transmission of historical immunization records. When MVX code is paired with a CVX (vaccine administered) code, the specific trade named vaccine may be indicated. MVX is the underlying Master Code System for V2 table 0227 (Manufacturers Of Vaccines (code=MVX)). The machine readable name for MVX in PHIN VADS is PH_VaccinesAdministeredCVX_CDC_NIP.Status indicates if the manufacturer is currently making vaccine for distribution in the United States.Last Updated indicates the last time this particular manufacturer code was updated in this table.Questions regarding MVX should be directed to the [IIS Technical Assistance Team](mailto:iisinfo@cdc.gov)(or use [mailing address](https://www2.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=mvx#addr))."For more information, please see [here](https://www2.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=mvx). |
| Publisher | CDC, National Centers for Immunization and Respiratory Diseases; Immunization Information System Support Branch - Informatics |
| Copyright | "Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission."For information and exceptions regarding use of CDC material please see [here](https://www.cdc.gov/other/agencymaterials.html). |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.12.227
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/mvx
  * **Preferred**: true
* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.60
  * **Preferred**: false
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/MVX
  * **Preferred**: false

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "MVX",
  "url" : "http://terminology.hl7.org/NamingSystem/MVX",
  "version" : "3.0.1",
  "name" : "MVX",
  "title" : "Manufacturers of Vaccines (MVX)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-10-24T00:00:00-04:00",
  "publisher" : "CDC, National Centers for Immunization and Respiratory Diseases; Immunization Information System Support Branch - Informatics",
  "contact" : [
    {
      "name" : "CDC, National Centers for Immunization and Respiratory Diseases; Immunization Information System Support Branch - Informatics; 1600 Clifton Road Mailstop: E-62; Atlanta, GA 30333",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.cdc.gov/iis/about/index.html?CDC_AAref_Val=https://www.cdc.gov/vaccines/programs/iis/index.html"
        },
        {
          "system" : "email",
          "value" : "iisinfo@cdc.gov"
        }
      ]
    }
  ],
  "responsible" : "CDC, National Centers for Immunization and Respiratory Diseases; Immunization Information System Support Branch - Informatics",
  "description" : "\"The CDC's National Center for Immunization and Respiratory Diseases ([NCIRD](https://www.cdc.gov/ncird/)) developed and maintains HL7 Table 0227, Manufacturers of Vaccines (MVX). It includes both active and inactive manufacturers of vaccines in the US. Inactive MVX codes allow transmission of historical immunization records. When MVX code is paired with a CVX (vaccine administered) code, the specific trade named vaccine may be indicated. MVX is the underlying Master Code System for V2 table 0227 (Manufacturers Of Vaccines (code=MVX)). The machine readable name for MVX in PHIN VADS is PH_VaccinesAdministeredCVX_CDC_NIP.\r\n\r\nStatus indicates if the manufacturer is currently making vaccine for distribution in the United States.\r\n\r\nLast Updated indicates the last time this particular manufacturer code was updated in this table.\r\n\r\nQuestions regarding MVX should be directed to the [IIS Technical Assistance Team](mailto:iisinfo@cdc.gov)(or use [mailing address](https://www2.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=mvx#addr)).\"\r\n\r\nFor more information, please see [here](https://www2.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=mvx).",
  "copyright" : "\"Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission.\"\r\n\r\nFor information and exceptions regarding use of CDC material please see [here](https://www.cdc.gov/other/agencymaterials.html).",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.12.227",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/mvx",
      "preferred" : true
    },
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.60",
      "preferred" : false
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/MVX",
      "preferred" : false
    }
  ]
}

```
