# International Classification of Primary Care - Third Revision - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **International Classification of Primary Care - Third Revision**

## NamingSystem: International Classification of Primary Care - Third Revision 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ICPC3 | *Version*:1.0.0 | |
| Active as of 2024-06-17 | *Responsible:*[WONCA ICPC Foundation](https://www.icpc-3.info/) | *Computable Name*:ICPC3 |
| **Copyright/Legal**: The copyright of ICPC-3, both in electronic form and hard copy, is owned by WONCA.WONCA offers three levels of licensing for:* High-income countries
* Middle-income countries
* Low-income countries
Country Income Level according to GNI per capita of World Bank (Atlas Method)Licensing includes a package of an Official License and support by the ICPC Foundation. For more information see the contacts below.Within all three forms of licensing the ICPC-3 is free to be used by any party under a Creative Commons License BY-ND. This includes the free use of ICPC-3 by commercial parties.A Research License is required in case a Research Institute or University resides in a country without an official License. The Research License can be obtained for free under the condition that, as soon as the ICPC-3 is embedded in information systems for other purposes then research an Official License needs to be in place.For more information, see[https://icpc-3.info](https://icpc-3.info) | | |

 
The International Classification of Primary Care (ICPC) is the most widely used international classification for systematically capturing and organising clinical information in primary care. It is a unifying language for Primary Care, supporting the coherent coding of reason(s) for encounter, symptoms and complaints, diagnoses, health problems, functioning, environmental factors, personal factors related to health and processes of care, all in only one classification. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ICPC3 |
| Version | 1.0.0 |
| Name | ICPC3 |
| Title | International Classification of Primary Care - Third Revision |
| Status | active |
| Definition | The International Classification of Primary Care (ICPC) is the most widely used international classification for systematically capturing and organising clinical information in primary care. It is a unifying language for Primary Care, supporting the coherent coding of reason(s) for encounter, symptoms and complaints, diagnoses, health problems, functioning, environmental factors, personal factors related to health and processes of care, all in only one classification. |
| Publisher | WONCA ICPC Foundation |
| Copyright | The copyright of ICPC-3, both in electronic form and hard copy, is owned by WONCA.WONCA offers three levels of licensing for:* High-income countries
* Middle-income countries
* Low-income countries
Country Income Level according to GNI per capita of World Bank (Atlas Method)Licensing includes a package of an Official License and support by the ICPC Foundation. For more information see the contacts below.Within all three forms of licensing the ICPC-3 is free to be used by any party under a Creative Commons License BY-ND. This includes the free use of ICPC-3 by commercial parties.A Research License is required in case a Research Institute or University resides in a country without an official License. The Research License can be obtained for free under the condition that, as soon as the ICPC-3 is embedded in information systems for other purposes then research an Official License needs to be in place.For more information, see [https://icpc-3.info](https://icpc-3.info) |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/ICPC-3
  * **Preferred**: true
  * **Period**: 2024-06-17 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ICPC3",
  "url" : "http://terminology.hl7.org/NamingSystem/ICPC3",
  "version" : "1.0.0",
  "name" : "ICPC3",
  "title" : "International Classification of Primary Care - Third Revision",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-06-17T00:00:00-00:00",
  "publisher" : "WONCA ICPC Foundation",
  "contact" : [
    {
      "name" : "WONCA ICPC Foundation; Avenue des Arts 7-8, 1210 Brussels, Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.icpc-3.info/"
        },
        {
          "system" : "email",
          "value" : "secretariat@icpc-3.info"
        },
        {
          "system" : "phone",
          "value" : "+32 (0) 2 329 00 75"
        }
      ]
    }
  ],
  "responsible" : "WONCA ICPC Foundation",
  "description" : "The International Classification of Primary Care (ICPC) is the most widely used international classification for systematically capturing and organising clinical information in primary care. It is a unifying language for Primary Care, supporting the coherent coding of reason(s) for encounter, symptoms and complaints, diagnoses, health problems, functioning, environmental factors, personal factors related to health and processes of care, all in only one classification.",
  "copyright" : "The copyright of ICPC-3, both in electronic form and hard copy, is owned by WONCA.\r\n\r\nWONCA offers three levels of licensing for:\r\n\r\n* High-income countries\r\n\r\n* Middle-income countries\r\n\r\n* Low-income countries\r\n\r\nCountry Income Level according to GNI per capita of World Bank (Atlas Method)\r\n\r\nLicensing includes a package of an Official License and support by the ICPC Foundation. For more information see the contacts below.\r\n\r\nWithin all three forms of licensing the ICPC-3 is free to be used by any party under a Creative Commons License BY-ND. This includes the free use of ICPC-3 by commercial parties.\r\n\r\nA Research License is required in case a Research Institute or University resides in a country without an official License. The Research License can be obtained for free under the condition that, as soon as the ICPC-3 is embedded in information systems for other purposes then research an Official License needs to be in place.\r\n\r\nFor more information, see [https://icpc-3.info](https://icpc-3.info)",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/ICPC-3",
      "preferred" : true,
      "period" : {
        "start" : "2024-06-17"
      }
    }
  ]
}

```
