# ICD-10 Dual Coding - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ICD-10 Dual Coding**

## NamingSystem: ICD-10 Dual Coding 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ICD-10DualCoding | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*HL7 | *Computable Name*:ICD10DualCoding |

 
ICD-10 allows dual coding. Refer to Section 3.1.3 of the ICD-10 Instruction Manual (2nd Edition, http://www.who.int/entity/classifications/icd/ICD-10_2nd_ed_volume2.pdf). 
This OID identifies the code system that describes how to encode Dual Coding in a CD compatible expression (for Datatypes R2 CD only). 
An ICD-10 dual code expression SHALL consist of two ICD-10 codes separated by space. This code system SHALL NOT be used for single ICD-10 codes; the normal ICD-10 code system oid which is 2.16.840.1.113883.6.3 should be used in this case. 
Dual code expressions SHALL only be used per the rules described in the ICD-10 instruction manual. 
**An example CD:** 

```
<example code="J21.8 B95.6" codeSystem="2.16.840.1.113883.6.260">
  <originalText value="Staph aureus bronchiolitis"/>
</example>

```

 
Where: 
* J21.8 is: Acute bronchiolitis due to other specified organisms
* B95.6 is: Staphylococcus aureus as the cause of diseases classified to other chapters
 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ICD-10DualCoding |
| Version | 2.1.0 |
| Name | ICD10DualCoding |
| Title | ICD-10 Dual Coding |
| Status | retired |
| Definition | ICD-10 allows dual coding. Refer to Section 3.1.3 of the ICD-10 Instruction Manual (2nd Edition, http://www.who.int/entity/classifications/icd/ICD-10_2nd_ed_volume2.pdf).This OID identifies the code system that describes how to encode Dual Coding in a CD compatible expression (for Datatypes R2 CD only).An ICD-10 dual code expression SHALL consist of two ICD-10 codes separated by space. This code system SHALL NOT be used for single ICD-10 codes; the normal ICD-10 code system oid which is 2.16.840.1.113883.6.3 should be used in this case.Dual code expressions SHALL only be used per the rules described in the ICD-10 instruction manual.**An example CD:**```
\<example code="J21.8 B95.6" codeSystem="2.16.840.1.113883.6.260">
  \<originalText value="Staph aureus bronchiolitis"/>
\</example>

```
Where:* J21.8 is: Acute bronchiolitis due to other specified organisms
* B95.6 is: Staphylococcus aureus as the cause of diseases classified to other chapters
 |
| Publisher | HL7 |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.260
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/ICD-10DualCoding
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ICD-10DualCoding",
  "url" : "http://terminology.hl7.org/NamingSystem/ICD-10DualCoding",
  "version" : "2.1.0",
  "name" : "ICD10DualCoding",
  "title" : "ICD-10 Dual Coding",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "HL7",
  "contact" : [
    {
      "name" : "HL7,HL7,HL7,HL7,HL7,HL7,HL7,HL7"
    }
  ],
  "responsible" : "HL7",
  "description" : "ICD-10 allows dual coding. Refer to Section 3.1.3 of the ICD-10 Instruction Manual (2nd Edition, http://www.who.int/entity/classifications/icd/ICD-10\\_2nd\\_ed\\_volume2.pdf).\r\n\r\nThis OID identifies the code system that describes how to encode Dual Coding in a CD compatible expression (for Datatypes R2 CD only).\r\n\r\nAn ICD-10 dual code expression SHALL consist of two ICD-10 codes separated by space. This code system SHALL NOT be used for single ICD-10 codes; the normal ICD-10 code system oid which is 2.16.840.1.113883.6.3 should be used in this case.\r\n\r\nDual code expressions SHALL only be used per the rules described in the ICD-10 instruction manual.\r\n\r\n**An example CD:**\r\n\r\n```\r\n<example code=\"J21.8 B95.6\" codeSystem=\"2.16.840.1.113883.6.260\">\r\n  <originalText value=\"Staph aureus bronchiolitis\"/>\r\n</example>\r\n```\r\nWhere:\r\n* J21.8 is: Acute bronchiolitis due to other specified organisms\r\n* B95.6 is: Staphylococcus aureus as the cause of diseases classified to other chapters",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.260",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/ICD-10DualCoding",
      "preferred" : true
    }
  ]
}

```
