# HUGO Gene Nomenclature Committee Gene Group - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HUGO Gene Nomenclature Committee Gene Group**

## NamingSystem: HUGO Gene Nomenclature Committee Gene Group 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/HGNCGeneGroup | *Version*:1.1.0 | |
| Active as of 2024-08-22 | *Responsible:*[HUGO Gene Nomenclature Committee](https://www.genenames.org/) | *Computable Name*:HGNCGeneGroup |
| **Copyright/Legal**: It is a condition of HGNC funding from NIH and the Welcome Trust that the nomenclature and information provided is freely available to all. Anyone may use the HGNC data, but we request that they reference the**"HUGO Gene Nomenclature Committee at the European Bioinformatics Institute"**and the website where possible. | | |

 
"The HGNC is responsible for approving unique symbols and names for human loci, including protein coding genes, ncRNA genes and pseudogenes, to allow unambiguous scientific communication." 
HGNC Gene Group is an index on gene families/groups. The numeric GeneGroup IDs should be used as codes. GeneGroup IDs do not begin with "HGNC:" (like the GeneIDs for genes in HGNC Genes), so care must be made to ensure alignment of concepts when viewing an HGNC ID from an older system that may be referring to the GeneID and not a gene group. For example, 588 refers to the HLA gene family, but HGNC:588 identifies the ATG12 gene. To provide clarity for systems that do not distinguish codes from genes and gene families, use "http://www.genenames.org" for genes and "http://www.genenames.org/genegroup" for gene families as code system URIs. 
"For each known human gene we approve a gene name and symbol (short-form abbreviation). All approved symbols are stored in the HGNC database,[www.genenames.org](https://www.genenames.org/tools/search), a curated online repository of HGNC-approved gene nomenclature, gene groups and associated resources including links to genomic, proteomic and phenotypic information. Each symbol is unique and we ensure that each gene is only given one approved gene symbol. It is necessary to provide a unique symbol for each gene so that we and others can talk about them, and this also facilitates electronic data retrieval from publications and databases." 
For more information on the use of HGNC Genes, see[https://terminology.hl7.org/CodeSystem-v3-hgnc.html](https://terminology.hl7.org/CodeSystem-v3-hgnc.html). 
HGNC is a free database for the public. 
Please see https://www.genenames.org/ for more info. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/HGNCGeneGroup |
| Version | 1.1.0 |
| Name | HGNCGeneGroup |
| Title | HUGO Gene Nomenclature Committee Gene Group |
| Status | active |
| Definition | "The HGNC is responsible for approving unique symbols and names for human loci, including protein coding genes, ncRNA genes and pseudogenes, to allow unambiguous scientific communication."HGNC Gene Group is an index on gene families/groups. The numeric GeneGroup IDs should be used as codes. GeneGroup IDs do not begin with "HGNC:" (like the GeneIDs for genes in HGNC Genes), so care must be made to ensure alignment of concepts when viewing an HGNC ID from an older system that may be referring to the GeneID and not a gene group. For example, 588 refers to the HLA gene family, but HGNC:588 identifies the ATG12 gene. To provide clarity for systems that do not distinguish codes from genes and gene families, use "http://www.genenames.org" for genes and "http://www.genenames.org/genegroup" for gene families as code system URIs."For each known human gene we approve a gene name and symbol (short-form abbreviation). All approved symbols are stored in the HGNC database,[www.genenames.org](https://www.genenames.org/tools/search), a curated online repository of HGNC-approved gene nomenclature, gene groups and associated resources including links to genomic, proteomic and phenotypic information. Each symbol is unique and we ensure that each gene is only given one approved gene symbol. It is necessary to provide a unique symbol for each gene so that we and others can talk about them, and this also facilitates electronic data retrieval from publications and databases."For more information on the use of HGNC Genes, see [https://terminology.hl7.org/CodeSystem-v3-hgnc.html](https://terminology.hl7.org/CodeSystem-v3-hgnc.html).HGNC is a free database for the public.Please see https://www.genenames.org/ for more info. |
| Publisher | HUGO Gene Nomenclature Committee |
| Copyright | It is a condition of HGNC funding from NIH and the Welcome Trust that the nomenclature and information provided is freely available to all. Anyone may use the HGNC data, but we request that they reference the **"HUGO Gene Nomenclature Committee at the European Bioinformatics Institute"** and the website where possible. |

### Identifiers

* **Type**: URI
  * **Value**: http://www.genenames.org/genegroup
  * **Preferred**: true
  * **Period**: 2022-08-25 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "HGNCGeneGroup",
  "url" : "http://terminology.hl7.org/NamingSystem/HGNCGeneGroup",
  "version" : "1.1.0",
  "name" : "HGNCGeneGroup",
  "title" : "HUGO Gene Nomenclature Committee Gene Group",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-08-22T00:00:00-00:00",
  "publisher" : "HUGO Gene Nomenclature Committee",
  "contact" : [
    {
      "name" : "HUGO Gene Nomenclature Committee",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.genenames.org/"
        },
        {
          "system" : "email",
          "value" : "hgnc@genenames.org"
        }
      ]
    }
  ],
  "responsible" : "HUGO Gene Nomenclature Committee",
  "description" : "\"The HGNC is responsible for approving unique symbols and names for human loci, including protein coding genes, ncRNA genes and pseudogenes, to allow unambiguous scientific communication.\"\r\n\r\nHGNC Gene Group is an index on gene families/groups. The numeric GeneGroup IDs should be used as codes. GeneGroup IDs do not begin with \"HGNC:\" (like the GeneIDs for genes in HGNC Genes), so care must be made to ensure alignment of concepts when viewing an HGNC ID from an older system that may be referring to the GeneID and not a gene group. For example, 588 refers to the HLA gene family, but HGNC:588 identifies the ATG12 gene. To provide clarity for systems that do not distinguish codes from genes and gene families, use \"http://www.genenames.org\" for genes and \"http://www.genenames.org/genegroup\" for gene families as code system URIs.\r\n\r\n\"For each known human gene we approve a gene name and symbol (short-form abbreviation). All approved symbols are stored in the HGNC database,[www.genenames.org](https://www.genenames.org/tools/search), a curated online repository of HGNC-approved gene nomenclature, gene groups and associated resources including links to genomic, proteomic and phenotypic information. Each symbol is unique and we ensure that each gene is only given one approved gene symbol. It is necessary to provide a unique symbol for each gene so that we and others can talk about them, and this also facilitates electronic data retrieval from publications and databases.\"\r\n\r\nFor more information on the use of HGNC Genes, see [https://terminology.hl7.org/CodeSystem-v3-hgnc.html](https://terminology.hl7.org/CodeSystem-v3-hgnc.html).\r\n\r\nHGNC is a free database for the public.\r\n\r\nPlease see https://www.genenames.org/ for more info.",
  "copyright" : "It is a condition of HGNC funding from NIH and the Welcome Trust that the nomenclature and information provided is freely available to all. Anyone may use the HGNC data, but we request that they reference the *\"HUGO Gene Nomenclature Committee at the European Bioinformatics Institute\"* and the website where possible.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://www.genenames.org/genegroup",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2022-08-25"
      }
    }
  ]
}

```
