# Genetic Testing Registry - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Genetic Testing Registry**

## NamingSystem: Genetic Testing Registry 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/GTR | *Version*:1.0.0 | |
| Active as of 2022-02-03 | *Responsible:*[National Center for Biotechnology Information, U.S. National Library of Medicine](https://www.ncbi.nlm.nih.gov/) | *Computable Name*:GTR |
| **Copyright/Legal**: NCBI's Disclaimer and Copyright notice must be evident to users of your service.Information that is created by or for the US government on this site is within the public domain. Public domain information on the National Library of Medicine (NLM) Web pages may be freely distributed and copied. However, it is requested that in any subsequent use of this work, NLM be given appropriate acknowledgment.NOTE: This site contains resources which incorporate material contributed or licensed by individuals, companies, or organizations that may be protected by U.S. and foreign copyright laws. These include, but are not limited to PubMed Central (PMC) (see PMC Copyright Notice at https://www.ncbi.nlm.nih.gov/pmc/about/copyright/), Bookshelf (see Bookshelf Copyright Notice at https://www.ncbi.nlm.nih.gov/books/about/copyright/), OMIM (see OMIM Copyright Status at https://omim.org/help/copyright), and PubChem. All persons reproducing, redistributing, or making commercial use of this information are expected to adhere to the terms and conditions asserted by the copyright holder. Transmission or reproduction of protected items beyond that allowed by fair use (https://www.copyright.gov/fls/fl102.html)(PDF) as defined in the copyright laws requires the written permission of the copyright owners.General copyright, as stated on NCBI's GTR site (https://www.ncbi.nlm.nih.gov/gtr/), is as included in the Copyright Statement. | | |

 
The Genetic Testing Registry (GTR) provides a central location for voluntary submission of genetic test information by providers. The scope includes the test's purpose, methodology, validity, evidence of the test's usefulness, and laboratory contacts and credentials. The overarching goal of the GTR is to advance the public health and research into the genetic basis of health and disease. 
Each Test is a specific, orderable test from a particular laboratory, and is assigned a unique GTR accession number. The format is GTR00000001.1, with a leading prefix "GTR" followed by 8 digits, a period, then 1 or more digits representing the version. When a laboratory updates a registered test, a new version number is assigned. 
To find all laboratories in GTR and all registered tests, see here https://www.ncbi.nlm.nih.gov/gtr/all/tests/?term=all%5Bsb%5D 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/GTR |
| Version | 1.0.0 |
| Name | GTR |
| Title | Genetic Testing Registry |
| Status | active |
| Definition | The Genetic Testing Registry (GTR) provides a central location for voluntary submission of genetic test information by providers. The scope includes the test's purpose, methodology, validity, evidence of the test's usefulness, and laboratory contacts and credentials. The overarching goal of the GTR is to advance the public health and research into the genetic basis of health and disease.Each Test is a specific, orderable test from a particular laboratory, and is assigned a unique GTR accession number. The format is GTR00000001.1, with a leading prefix "GTR" followed by 8 digits, a period, then 1 or more digits representing the version. When a laboratory updates a registered test, a new version number is assigned.To find all laboratories in GTR and all registered tests, see here https://www.ncbi.nlm.nih.gov/gtr/all/tests/?term=all%5Bsb%5D |
| Publisher | National Center for Biotechnology Information, U.S. National Library of Medicine |
| Copyright | NCBI's Disclaimer and Copyright notice must be evident to users of your service.Information that is created by or for the US government on this site is within the public domain. Public domain information on the National Library of Medicine (NLM) Web pages may be freely distributed and copied. However, it is requested that in any subsequent use of this work, NLM be given appropriate acknowledgment.NOTE: This site contains resources which incorporate material contributed or licensed by individuals, companies, or organizations that may be protected by U.S. and foreign copyright laws. These include, but are not limited to PubMed Central (PMC) (see PMC Copyright Notice at https://www.ncbi.nlm.nih.gov/pmc/about/copyright/), Bookshelf (see Bookshelf Copyright Notice at https://www.ncbi.nlm.nih.gov/books/about/copyright/), OMIM (see OMIM Copyright Status at https://omim.org/help/copyright), and PubChem. All persons reproducing, redistributing, or making commercial use of this information are expected to adhere to the terms and conditions asserted by the copyright holder. Transmission or reproduction of protected items beyond that allowed by fair use (https://www.copyright.gov/fls/fl102.html)(PDF) as defined in the copyright laws requires the written permission of the copyright owners.General copyright, as stated on NCBI's GTR site (https://www.ncbi.nlm.nih.gov/gtr/), is as included in the Copyright Statement. |

### Identifiers

* **Type**: URI
  * **Value**: https://www.ncbi.nlm.nih.gov/gtr/
  * **Preferred**: true
  * **Period**: 2021-01-27 --> (ongoing)
  * **Comment**: Official canonical URL going forward.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "GTR",
  "url" : "http://terminology.hl7.org/NamingSystem/GTR",
  "version" : "1.0.0",
  "name" : "GTR",
  "title" : "Genetic Testing Registry",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-02-03T00:00:00-00:00",
  "publisher" : "National Center for Biotechnology Information, U.S. National Library of Medicine",
  "contact" : [
    {
      "name" : "National Center for Biotechnology Information, U.S. National Library of Medicine; 8600 Rockville Pike, Bethesda MD, 20894 USA",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ncbi.nlm.nih.gov/"
        }
      ]
    }
  ],
  "description" : "The Genetic Testing Registry (GTR) provides a central location for voluntary submission of genetic test information by providers. The scope includes the test's purpose, methodology, validity, evidence of the test's usefulness, and laboratory contacts and credentials. The overarching goal of the GTR is to advance the public health and research into the genetic basis of health and disease.\r\n\r\nEach Test is a specific, orderable test from a particular laboratory, and is assigned a unique GTR accession number. The format is GTR00000001.1, with a leading prefix \"GTR\" followed by 8 digits, a period, then 1 or more digits representing the version. When a laboratory updates a registered test, a new version number is assigned.\r\n\r\nTo find all laboratories in GTR and all registered tests, see here https://www.ncbi.nlm.nih.gov/gtr/all/tests/?term=all%5Bsb%5D",
  "copyright" : "NCBI's Disclaimer and Copyright notice must be evident to users of your service.\r\n\r\nInformation that is created by or for the US government on this site is within the public domain. Public domain information on the National Library of Medicine (NLM) Web pages may be freely distributed and copied. However, it is requested that in any subsequent use of this work, NLM be given appropriate acknowledgment.\r\n\r\nNOTE: This site contains resources which incorporate material contributed or licensed by individuals, companies, or organizations that may be protected by U.S. and foreign copyright laws. These include, but are not limited to PubMed Central (PMC) (see PMC Copyright Notice at https://www.ncbi.nlm.nih.gov/pmc/about/copyright/), Bookshelf (see Bookshelf Copyright Notice at https://www.ncbi.nlm.nih.gov/books/about/copyright/), OMIM (see OMIM Copyright Status at https://omim.org/help/copyright), and PubChem. All persons reproducing, redistributing, or making commercial use of this information are expected to adhere to the terms and conditions asserted by the copyright holder. Transmission or reproduction of protected items beyond that allowed by fair use (https://www.copyright.gov/fls/fl102.html)(PDF) as defined in the copyright laws requires the written permission of the copyright owners.\r\n\r\nGeneral copyright, as stated on NCBI's GTR site (https://www.ncbi.nlm.nih.gov/gtr/), is as included in the Copyright Statement.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://www.ncbi.nlm.nih.gov/gtr/",
      "preferred" : true,
      "comment" : "Official canonical URL going forward.",
      "period" : {
        "start" : "2021-01-27"
      }
    }
  ]
}

```
