# GCDF - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **GCDF**

## NamingSystem: GCDF 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/GCDF | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*HL7 | *Computable Name*:GCDF |

 
GCDF 
Dosage Form Code (2-character) 
a two-character alphanumeric column that represents a dosage form. The dosage form of a generic drug formulation describes the physical presentation of a drug, such as tablet, capsule, or liquid. It may also incorporate the delivery and release mechanism of the drug. A GCDF is associated to each GCN_SEQNO to identify that component of the generic drug formulation. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/GCDF |
| Version | 2.1.0 |
| Name | GCDF |
| Title | GCDF |
| Status | retired |
| Definition | GCDFDosage Form Code (2-character)a two-character alphanumeric column that represents a dosage form. The dosage form of a generic drug formulation describes the physical presentation of a drug, such as tablet, capsule, or liquid. It may also incorporate the delivery and release mechanism of the drug. A GCDF is associated to each GCN_SEQNO to identify that component of the generic drug formulation. |
| Publisher | HL7 |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.79
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/GCDF
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "GCDF",
  "url" : "http://terminology.hl7.org/NamingSystem/GCDF",
  "version" : "2.1.0",
  "name" : "GCDF",
  "title" : "GCDF",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "HL7",
  "contact" : [
    {
      "name" : "First DataBank, Inc,First DataBank, Inc,First DataBank, Inc,First DataBank, Inc,First DataBank, Inc,"
    }
  ],
  "responsible" : "HL7",
  "description" : "GCDF\r\n\r\nDosage Form Code (2-character)\r\n\r\na two-character alphanumeric column that represents a dosage form. The dosage form of a generic drug formulation describes the physical presentation of a drug, such as tablet, capsule, or liquid. It may also incorporate the delivery and release mechanism of the drug. A GCDF is associated to each GCN\\_SEQNO to identify that component of the generic drug formulation.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.79",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/GCDF",
      "preferred" : true
    }
  ]
}

```
