# Vaccine Information Statements (VIS) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Vaccine Information Statements (VIS)**

## NamingSystem: Vaccine Information Statements (VIS) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/CDCVIS | *Version*:1.0.0 | |
| Active as of 2025-02-20 | *Responsible:*[CDC, National Centers for Immunization and Respiratory Diseases Immunization Information System Support Branch - Informatics](https://www.cdc.gov/vaccines/programs/iis/index.html) | *Computable Name*:CDCVIS |
| **Copyright/Legal**: "Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission."For information and exceptions regarding use of CDC material please see[here](https://www.cdc.gov/other/agencymaterials.html) | | |

 
"A VIS or Vaccine Information Statement is a document, produced by CDC, that informs vaccine recipients – or their parents or legal representatives - about the benefits and risks of a vaccine they are receiving." 
A lookup table of current VIS concept names and codes can be found here:[https://www.cdc.gov/iis/code-sets/vis-barcode-lookup-table.html](https://www.cdc.gov/iis/code-sets/vis-barcode-lookup-table.html) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/CDCVIS |
| Version | 1.0.0 |
| Name | CDCVIS |
| Title | Vaccine Information Statements (VIS) |
| Status | active |
| Definition | "A VIS or Vaccine Information Statement is a document, produced by CDC, that informs vaccine recipients – or their parents or legal representatives - about the benefits and risks of a vaccine they are receiving."A lookup table of current VIS concept names and codes can be found here: [https://www.cdc.gov/iis/code-sets/vis-barcode-lookup-table.html](https://www.cdc.gov/iis/code-sets/vis-barcode-lookup-table.html) |
| Publisher | CDC, National Centers for Immunization and Respiratory Diseases Immunization Information System Support Branch - Informatics |
| Copyright | "Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission."For information and exceptions regarding use of CDC material please see [here](https://www.cdc.gov/other/agencymaterials.html) |

### Identifiers

* **Type**: URI
  * **Value**: https://www.cdc.gov/vaccines/hcp/vis/index.html
  * **Preferred**: true
  * **Period**: 2024-02-20 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "CDCVIS",
  "url" : "http://terminology.hl7.org/NamingSystem/CDCVIS",
  "version" : "1.0.0",
  "name" : "CDCVIS",
  "title" : "Vaccine Information Statements (VIS)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2025-02-20T00:00:00-04:00",
  "publisher" : "CDC, National Centers for Immunization and Respiratory Diseases Immunization Information System Support Branch - Informatics",
  "contact" : [
    {
      "name" : "CDC, National Centers for Immunization and Respiratory Diseases Immunization Information System Support Branch - Informatics; 1600 Clifton Road, Mailstop: E-62, Atlanta, GA 30333",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.cdc.gov/vaccines/programs/iis/index.html"
        },
        {
          "system" : "email",
          "value" : "iisinfo@cdc.gov"
        }
      ]
    }
  ],
  "responsible" : "CDC, National Centers for Immunization and Respiratory Diseases Immunization Information System Support Branch - Informatics",
  "description" : "\"A VIS or Vaccine Information Statement is a document, produced by CDC, that informs vaccine recipients – or their parents or legal representatives - about the benefits and risks of a vaccine they are receiving.\"\r\n\r\nA lookup table of current VIS concept names and codes can be found here: [https://www.cdc.gov/iis/code-sets/vis-barcode-lookup-table.html](https://www.cdc.gov/iis/code-sets/vis-barcode-lookup-table.html)",
  "copyright" : "\"Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission.\"\r\n\r\nFor information and exceptions regarding use of CDC material please see [here](https://www.cdc.gov/other/agencymaterials.html)",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://www.cdc.gov/vaccines/hcp/vis/index.html",
      "preferred" : true,
      "period" : {
        "start" : "2024-02-20"
      }
    }
  ]
}

```
