# Work Classification (Occupational Data for Health) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Work Classification (Occupational Data for Health)**

## CodeSystem: Work Classification (Occupational Data for Health) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-WorkClassificationODH | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:WorkClassificationODH |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1139 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts representing a person's job type as defined by compensation and sector (e.g. paid vs. unpaid, self-employed vs. not self-employed, government vs. private, etc.). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [WorkClassificationODH](ValueSet-v2-0959.md)
* [WorkClassificationODH](ValueSet-v3-WorkClassificationODH.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-WorkClassificationODH",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-WorkClassificationODH",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1139"
    }
  ],
  "version" : "3.0.0",
  "name" : "WorkClassificationODH",
  "title" : "Work Classification (Occupational Data for Health)",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts representing a person's job type as defined by compensation and sector (e.g. paid vs. unpaid, self-employed vs. not self-employed, government vs. private, etc.).",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "PWAF",
      "display" : "Paid work, Armed Forces",
      "definition" : "A situation in which an individual serves in a government-sponsored military force.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23905"
        }
      ]
    },
    {
      "code" : "PWFG",
      "display" : "Paid work, national government, not armed forces",
      "definition" : "A situation in which an individual works for a national government organization, not including armed forces, and receives a paid salary or wage.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23904"
        }
      ]
    },
    {
      "code" : "PWLG",
      "display" : "Paid work, local government, not armed forces",
      "definition" : "A situation in which an individual works for a government organization with jurisdiction below the level of state/provincial/territorial/tribal government (e.g., city, town, township), not armed forces, and receives a paid salary or wage.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23902"
        }
      ]
    },
    {
      "code" : "PWNSE",
      "display" : "Paid non-governmental work, not self-employed",
      "definition" : "A situation in which an individual works for a business (not government) that they do not own and receives a paid salary or wage.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23899"
        }
      ]
    },
    {
      "code" : "PWSE",
      "display" : "Paid work, self-employed",
      "definition" : "A situation in which an individual earns a salary or wage working for himself or herself instead of working for an employer.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23898"
        }
      ]
    },
    {
      "code" : "PWSG",
      "display" : "Paid work, state government, not armed forces",
      "definition" : "A situation in which an individual works for a government organization with jurisdiction immediately below the level of national government (between national government and local government), not armed forces and receives a paid salary or wage. Often called a state, provincial, territorial, or tribal government.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23903"
        }
      ]
    },
    {
      "code" : "UWNSE",
      "display" : "Unpaid non-governmental work, not self-employed",
      "definition" : "A situation in which an individual works for a business (not government) that they do not own without receiving a paid salary or wage.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23900"
        }
      ]
    },
    {
      "code" : "UWSE",
      "display" : "Unpaid work, self-employed",
      "definition" : "A situation in which an individual works for himself or herself without receiving a paid salary or wage.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23901"
        }
      ]
    },
    {
      "code" : "VW",
      "display" : "Volunteer work (20 or more hours/week and not Disaster Response/ First Responder)",
      "definition" : "A situation in which an individual chooses to do something, especially for other people or for an organization, willingly and without being forced or compensated to do it. This can include formal activity undertaken through public, private and voluntary organizations as well as informal community participation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23906"
        }
      ]
    },
    {
      "code" : "VWDR",
      "display" : "Voluntary Disaster Response/First Responder",
      "definition" : "A situation in which an individual chooses to donate their time to perform activities (work) in disaster response or as a first responder, without being forced and with no expectation of compensation. This can include formal activity undertaken through a government agency or a public or private organization, as well as informal community participation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "239060"
        }
      ]
    }
  ]
}

```
