# TribalEntityUS - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **TribalEntityUS**

## CodeSystem: TribalEntityUS 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-TribalEntityUS | *Version*:4.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:TribalEntityUS |
| *Other Identifiers:*OID:2.16.840.1.113883.5.140 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
INDIAN ENTITIES RECOGNIZED AND ELIGIBLE TO RECEIVE SERVICES FROM THE UNITED STATES BUREAU OF INDIAN AFFAIRS 

 This Code system is referenced in the content logical definition of the following value sets: 

* [NativeEntityAlaska](ValueSet-v3-NativeEntityAlaska.md)
* [NativeEntityContiguous](ValueSet-v3-NativeEntityContiguous.md)
* [TribalEntityUS](ValueSet-v3-TribalEntityUS.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-TribalEntityUS",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-TribalEntityUS",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.140"
    }
  ],
  "version" : "4.0.0",
  "name" : "TribalEntityUS",
  "title" : "TribalEntityUS",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "INDIAN ENTITIES RECOGNIZED AND ELIGIBLE TO RECEIVE SERVICES FROM THE UNITED STATES BUREAU OF INDIAN AFFAIRS",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_NativeEntityAlaska",
      "display" : "NativeEntityAlaska",
      "definition" : "NATIVE ENTITIES WITHIN THE STATE OF ALASKA RECOGNIZED AND ELIGIBLE TO RECEIVE SERVICES FROM THE UNITED STATES BUREAU OF INDIAN AFFAIRS",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21286"
        }
      ],
      "concept" : [
        {
          "code" : "338",
          "display" : "Native Village of Afognak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11970"
            }
          ]
        },
        {
          "code" : "339",
          "display" : "Agdaagux Tribe of King Cove",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11971"
            }
          ]
        },
        {
          "code" : "340",
          "display" : "Native Village of Akhiok",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11972"
            }
          ]
        },
        {
          "code" : "341",
          "display" : "Akiachak Native Community",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11973"
            }
          ]
        },
        {
          "code" : "342",
          "display" : "Akiak Native Community",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11974"
            }
          ]
        },
        {
          "code" : "343",
          "display" : "Native Village of Akutan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11975"
            }
          ]
        },
        {
          "code" : "344",
          "display" : "Village of Alakanuk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11976"
            }
          ]
        },
        {
          "code" : "345",
          "display" : "Alatna Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11977"
            }
          ]
        },
        {
          "code" : "346",
          "display" : "Native Village of Aleknagik",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11978"
            }
          ]
        },
        {
          "code" : "347",
          "display" : "Algaaciq Native Village (St. Mary's)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11979"
            }
          ]
        },
        {
          "code" : "348",
          "display" : "Allakaket Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11980"
            }
          ]
        },
        {
          "code" : "349",
          "display" : "Native Village of Ambler",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11981"
            }
          ]
        },
        {
          "code" : "350",
          "display" : "Village of Anaktuvuk Pass",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11982"
            }
          ]
        },
        {
          "code" : "351",
          "display" : "Yupiit of Andreafski",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11983"
            }
          ]
        },
        {
          "code" : "352",
          "display" : "Angoon Community Association",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11984"
            }
          ]
        },
        {
          "code" : "353",
          "display" : "Village of Aniak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11985"
            }
          ]
        },
        {
          "code" : "354",
          "display" : "Anvik Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11986"
            }
          ]
        },
        {
          "code" : "355",
          "display" : "Arctic Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11987"
            }
          ]
        },
        {
          "code" : "356",
          "display" : "Asa'carsarmiut Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11988"
            }
          ]
        },
        {
          "code" : "357",
          "display" : "Native Village of Atka",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11989"
            }
          ]
        },
        {
          "code" : "358",
          "display" : "Village of Atmautluak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11990"
            }
          ]
        },
        {
          "code" : "359",
          "display" : "Native Village of Atqasuk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11991"
            }
          ]
        },
        {
          "code" : "360",
          "display" : "Native Village of Barrow Inupiat Traditional Government",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11992"
            }
          ]
        },
        {
          "code" : "361",
          "display" : "Beaver Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11993"
            }
          ]
        },
        {
          "code" : "362",
          "display" : "Native Village of Belkofski",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11994"
            }
          ]
        },
        {
          "code" : "363",
          "display" : "Village of Bill Moore's Slough",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11995"
            }
          ]
        },
        {
          "code" : "364",
          "display" : "Birch Creek Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11996"
            }
          ]
        },
        {
          "code" : "365",
          "display" : "Native Village of Brevig Mission",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11997"
            }
          ]
        },
        {
          "code" : "366",
          "display" : "Native Village of Buckland",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11998"
            }
          ]
        },
        {
          "code" : "367",
          "display" : "Native Village of Cantwell",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11999"
            }
          ]
        },
        {
          "code" : "368",
          "display" : "Native Village of Chenega (aka Chanega)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12000"
            }
          ]
        },
        {
          "code" : "369",
          "display" : "Chalkyitsik Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12001"
            }
          ]
        },
        {
          "code" : "370",
          "display" : "Village of Chefornak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12002"
            }
          ]
        },
        {
          "code" : "371",
          "display" : "Chevak Native Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12003"
            }
          ]
        },
        {
          "code" : "372",
          "display" : "Chickaloon Native Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12004"
            }
          ]
        },
        {
          "code" : "373",
          "display" : "Chignik Bay Tribal Council",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12005"
            }
          ]
        },
        {
          "code" : "374",
          "display" : "Native Village of Chignik Lagoon",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12006"
            }
          ]
        },
        {
          "code" : "375",
          "display" : "Chignik Lake Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12007"
            }
          ]
        },
        {
          "code" : "376",
          "display" : "Chilkat Indian Village (Klukwan)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12008"
            }
          ]
        },
        {
          "code" : "377",
          "display" : "Chilkoot Indian Association (Haines)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12009"
            }
          ]
        },
        {
          "code" : "378",
          "display" : "Chinik Eskimo Community (Golovin)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12010"
            }
          ]
        },
        {
          "code" : "379",
          "display" : "Cheesh-Na Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12011"
            }
          ]
        },
        {
          "code" : "380",
          "display" : "Native Village of Chitina",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12012"
            }
          ]
        },
        {
          "code" : "381",
          "display" : "Native Village of Chuathbaluk (Russian Mission, Kuskokwim)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12013"
            }
          ]
        },
        {
          "code" : "382",
          "display" : "Chuloonawick Native Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12014"
            }
          ]
        },
        {
          "code" : "383",
          "display" : "Circle Native Community",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12015"
            }
          ]
        },
        {
          "code" : "384",
          "display" : "Village of Clarks Point",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12016"
            }
          ]
        },
        {
          "code" : "385",
          "display" : "Native Village of Council",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12017"
            }
          ]
        },
        {
          "code" : "386",
          "display" : "Craig Tribal Association",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12018"
            }
          ]
        },
        {
          "code" : "387",
          "display" : "Village of Crooked Creek",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12019"
            }
          ]
        },
        {
          "code" : "388",
          "display" : "Curyung Tribal Council",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12020"
            }
          ]
        },
        {
          "code" : "389",
          "display" : "Native Village of Deering",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12021"
            }
          ]
        },
        {
          "code" : "390",
          "display" : "Native Village of Diomede (aka Inalik)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12022"
            }
          ]
        },
        {
          "code" : "391",
          "display" : "Village of Dot Lake",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12023"
            }
          ]
        },
        {
          "code" : "392",
          "display" : "Douglas Indian Association",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12024"
            }
          ]
        },
        {
          "code" : "393",
          "display" : "Native Village of Eagle",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12025"
            }
          ]
        },
        {
          "code" : "394",
          "display" : "Native Village of Eek",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12026"
            }
          ]
        },
        {
          "code" : "395",
          "display" : "Egegik Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12027"
            }
          ]
        },
        {
          "code" : "396",
          "display" : "Eklutna Native Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12028"
            }
          ]
        },
        {
          "code" : "397",
          "display" : "Native Village of Ekuk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12029"
            }
          ]
        },
        {
          "code" : "398",
          "display" : "Native Village of Ekwok",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12030"
            }
          ]
        },
        {
          "code" : "399",
          "display" : "Native Village of Elim",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12031"
            }
          ]
        },
        {
          "code" : "400",
          "display" : "Emmonak Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12032"
            }
          ]
        },
        {
          "code" : "401",
          "display" : "Evansville Village (aka Bettles Field)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12033"
            }
          ]
        },
        {
          "code" : "402",
          "display" : "Native Village of Eyak (Cordova)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12034"
            }
          ]
        },
        {
          "code" : "403",
          "display" : "Native Village of False Pass",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12035"
            }
          ]
        },
        {
          "code" : "404",
          "display" : "Native Village of Fort Yukon",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12036"
            }
          ]
        },
        {
          "code" : "405",
          "display" : "Native Village of Gakona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12037"
            }
          ]
        },
        {
          "code" : "406",
          "display" : "Galena Village (aka Louden Village)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12038"
            }
          ]
        },
        {
          "code" : "407",
          "display" : "Native Village of Gambell",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12039"
            }
          ]
        },
        {
          "code" : "408",
          "display" : "Native Village of Georgetown",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12040"
            }
          ]
        },
        {
          "code" : "409",
          "display" : "Native Village of Goodnews Bay",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12041"
            }
          ]
        },
        {
          "code" : "410",
          "display" : "Organized Village of Grayling (aka Holikachuk)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12042"
            }
          ]
        },
        {
          "code" : "411",
          "display" : "Gulkana Village Council",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12043"
            }
          ]
        },
        {
          "code" : "412",
          "display" : "Native Village of Hamilton",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12044"
            }
          ]
        },
        {
          "code" : "413",
          "display" : "Healy Lake Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12045"
            }
          ]
        },
        {
          "code" : "414",
          "display" : "Holy Cross Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12046"
            }
          ]
        },
        {
          "code" : "415",
          "display" : "Hoonah Indian Association",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12047"
            }
          ]
        },
        {
          "code" : "416",
          "display" : "Native Village of Hooper Bay",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12048"
            }
          ]
        },
        {
          "code" : "417",
          "display" : "Hughes Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12049"
            }
          ]
        },
        {
          "code" : "418",
          "display" : "Huslia Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12050"
            }
          ]
        },
        {
          "code" : "419",
          "display" : "Hydaburg Cooperative Association",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12051"
            }
          ]
        },
        {
          "code" : "420",
          "display" : "Igiugig Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12052"
            }
          ]
        },
        {
          "code" : "421",
          "display" : "Village of Iliamna",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12053"
            }
          ]
        },
        {
          "code" : "422",
          "display" : "Inupiat Community of the Arctic Slope",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12054"
            }
          ]
        },
        {
          "code" : "423",
          "display" : "Iqugmiut Traditional Council",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12055"
            }
          ]
        },
        {
          "code" : "424",
          "display" : "Ivanof Bay Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12056"
            }
          ]
        },
        {
          "code" : "425",
          "display" : "Kaguyak Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12057"
            }
          ]
        },
        {
          "code" : "426",
          "display" : "Organized Village of Kake",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12058"
            }
          ]
        },
        {
          "code" : "427",
          "display" : "Kaktovik Village (aka Barter Island)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12059"
            }
          ]
        },
        {
          "code" : "428",
          "display" : "Village of Kalskag",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12060"
            }
          ]
        },
        {
          "code" : "429",
          "display" : "Village of Kaltag",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12061"
            }
          ]
        },
        {
          "code" : "430",
          "display" : "Native Village of Kanatak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12062"
            }
          ]
        },
        {
          "code" : "431",
          "display" : "Native Village of Karluk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12063"
            }
          ]
        },
        {
          "code" : "432",
          "display" : "Organized Village of Kasaan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12064"
            }
          ]
        },
        {
          "code" : "433",
          "display" : "Kasigluk Traditional Elders Council",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12065"
            }
          ]
        },
        {
          "code" : "434",
          "display" : "Kenaitze Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12066"
            }
          ]
        },
        {
          "code" : "435",
          "display" : "Ketchikan Indian Community",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12067"
            }
          ]
        },
        {
          "code" : "436",
          "display" : "Native Village of Kiana",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12068"
            }
          ]
        },
        {
          "code" : "437",
          "display" : "King Island Native Community",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12069"
            }
          ]
        },
        {
          "code" : "438",
          "display" : "King Salmon Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12070"
            }
          ]
        },
        {
          "code" : "439",
          "display" : "Native Village of Kipnuk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12071"
            }
          ]
        },
        {
          "code" : "440",
          "display" : "Native Village of Kivalina",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12072"
            }
          ]
        },
        {
          "code" : "441",
          "display" : "Klawock Cooperative Association",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12073"
            }
          ]
        },
        {
          "code" : "442",
          "display" : "Native Village of Kluti Kaah (aka Copper Center)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12074"
            }
          ]
        },
        {
          "code" : "443",
          "display" : "Knik Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12075"
            }
          ]
        },
        {
          "code" : "444",
          "display" : "Native Village of Kobuk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12076"
            }
          ]
        },
        {
          "code" : "445",
          "display" : "Kokhanok Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12077"
            }
          ]
        },
        {
          "code" : "446",
          "display" : "Native Village of Kongiganak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12078"
            }
          ]
        },
        {
          "code" : "447",
          "display" : "Village of Kotlik",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12079"
            }
          ]
        },
        {
          "code" : "448",
          "display" : "Native Village of Kotzebue",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12080"
            }
          ]
        },
        {
          "code" : "449",
          "display" : "Native Village of Koyuk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12081"
            }
          ]
        },
        {
          "code" : "450",
          "display" : "Koyukuk Native Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12082"
            }
          ]
        },
        {
          "code" : "451",
          "display" : "Organized Village of Kwethluk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12083"
            }
          ]
        },
        {
          "code" : "452",
          "display" : "Native Village of Kwigillingok",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12084"
            }
          ]
        },
        {
          "code" : "453",
          "display" : "Native Village of Kwinhagak (aka Quinhagak)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12085"
            }
          ]
        },
        {
          "code" : "454",
          "display" : "Native Village of Larsen Bay",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12086"
            }
          ]
        },
        {
          "code" : "455",
          "display" : "Levelock Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12087"
            }
          ]
        },
        {
          "code" : "456",
          "display" : "Tangirnaq Native Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12088"
            }
          ]
        },
        {
          "code" : "457",
          "display" : "Lime Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12089"
            }
          ]
        },
        {
          "code" : "458",
          "display" : "Village of Lower Kalskag",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12090"
            }
          ]
        },
        {
          "code" : "459",
          "display" : "Manley Hot Springs Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12091"
            }
          ]
        },
        {
          "code" : "460",
          "display" : "Manokotak Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12092"
            }
          ]
        },
        {
          "code" : "461",
          "display" : "Native Village of Marshall (aka Fortuna Ledge)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12093"
            }
          ]
        },
        {
          "code" : "462",
          "display" : "Native Village of Mary's Igloo",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12094"
            }
          ]
        },
        {
          "code" : "463",
          "display" : "McGrath Native Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12095"
            }
          ]
        },
        {
          "code" : "464",
          "display" : "Native Village of Mekoryuk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12096"
            }
          ]
        },
        {
          "code" : "465",
          "display" : "Mentasta Traditional Council",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12097"
            }
          ]
        },
        {
          "code" : "466",
          "display" : "Metlakatla Indian Community, Annette Island Reserve",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12098"
            }
          ]
        },
        {
          "code" : "467",
          "display" : "Native Village of Minto",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12099"
            }
          ]
        },
        {
          "code" : "468",
          "display" : "Naknek Native Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12100"
            }
          ]
        },
        {
          "code" : "469",
          "display" : "Native Village of Nanwalek (aka English Bay)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12101"
            }
          ]
        },
        {
          "code" : "470",
          "display" : "Native Village of Napaimute",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12102"
            }
          ]
        },
        {
          "code" : "471",
          "display" : "Native Village of Napakiak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12103"
            }
          ]
        },
        {
          "code" : "472",
          "display" : "Native Village of Napaskiak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12104"
            }
          ]
        },
        {
          "code" : "473",
          "display" : "Native Village of Nelson Lagoon",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12105"
            }
          ]
        },
        {
          "code" : "474",
          "display" : "Nenana Native Association",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12106"
            }
          ]
        },
        {
          "code" : "475",
          "display" : "New Koliganek Village Council",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12107"
            }
          ]
        },
        {
          "code" : "476",
          "display" : "New Stuyahok Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12108"
            }
          ]
        },
        {
          "code" : "477",
          "display" : "Newhalen Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12109"
            }
          ]
        },
        {
          "code" : "478",
          "display" : "Newtok Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12110"
            }
          ]
        },
        {
          "code" : "479",
          "display" : "Native Village of Nightmute",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12111"
            }
          ]
        },
        {
          "code" : "480",
          "display" : "Nikolai Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12112"
            }
          ]
        },
        {
          "code" : "481",
          "display" : "Native Village of Nikolski",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12113"
            }
          ]
        },
        {
          "code" : "482",
          "display" : "Ninilchik Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12114"
            }
          ]
        },
        {
          "code" : "483",
          "display" : "Native Village of Noatak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12115"
            }
          ]
        },
        {
          "code" : "484",
          "display" : "Nome Eskimo Community",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12116"
            }
          ]
        },
        {
          "code" : "485",
          "display" : "Nondalton Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12117"
            }
          ]
        },
        {
          "code" : "486",
          "display" : "Noorvik Native Community",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12118"
            }
          ]
        },
        {
          "code" : "487",
          "display" : "Northway Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12119"
            }
          ]
        },
        {
          "code" : "488",
          "display" : "Native Village of Nuiqsut (aka Nooiksut)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12120"
            }
          ]
        },
        {
          "code" : "489",
          "display" : "Nulato Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12121"
            }
          ]
        },
        {
          "code" : "490",
          "display" : "Nunakauyarmiut Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12122"
            }
          ]
        },
        {
          "code" : "491",
          "display" : "Native Village of Nunapitchuk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12123"
            }
          ]
        },
        {
          "code" : "492",
          "display" : "Village of Ohogamiut",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12124"
            }
          ]
        },
        {
          "code" : "493",
          "display" : "Alutiiq Tribe of Old Harbor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12125"
            }
          ]
        },
        {
          "code" : "494",
          "display" : "Orutsararmiut Traditional Native Council",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12126"
            }
          ]
        },
        {
          "code" : "495",
          "display" : "Oscarville Traditional Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12127"
            }
          ]
        },
        {
          "code" : "496",
          "display" : "Native Village of Ouzinkie",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12128"
            }
          ]
        },
        {
          "code" : "497",
          "display" : "Native Village of Paimiut",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12129"
            }
          ]
        },
        {
          "code" : "498",
          "display" : "Pauloff Harbor Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12130"
            }
          ]
        },
        {
          "code" : "499",
          "display" : "Pedro Bay Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12131"
            }
          ]
        },
        {
          "code" : "500",
          "display" : "Native Village of Perryville",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12132"
            }
          ]
        },
        {
          "code" : "501",
          "display" : "Petersburg Indian Association",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12133"
            }
          ]
        },
        {
          "code" : "502",
          "display" : "Native Village of Pilot Point",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12134"
            }
          ]
        },
        {
          "code" : "503",
          "display" : "Pilot Station Traditional Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12135"
            }
          ]
        },
        {
          "code" : "504",
          "display" : "Pitka's Point Traditional Council",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12136"
            }
          ]
        },
        {
          "code" : "505",
          "display" : "Platinum Traditional Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12137"
            }
          ]
        },
        {
          "code" : "506",
          "display" : "Native Village of Point Hope",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12138"
            }
          ]
        },
        {
          "code" : "507",
          "display" : "Native Village of Point Lay",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12139"
            }
          ]
        },
        {
          "code" : "508",
          "display" : "Native Village of Port Graham",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12140"
            }
          ]
        },
        {
          "code" : "509",
          "display" : "Native Village of Port Heiden",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12141"
            }
          ]
        },
        {
          "code" : "510",
          "display" : "Native Village of Port Lions",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12142"
            }
          ]
        },
        {
          "code" : "511",
          "display" : "Portage Creek Village (aka Ohgsenakale)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12143"
            }
          ]
        },
        {
          "code" : "512",
          "display" : "Pribilof Islands Aleut Communities of St. Paul & St. George Islands (Saint George Island and Saint Paul Island)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "12144"
            }
          ]
        },
        {
          "code" : "513",
          "display" : "Qagan Tayagungin Tribe of Sand Point",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12145"
            }
          ]
        },
        {
          "code" : "514",
          "display" : "Qawalangin Tribe of Unalaska",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12146"
            }
          ]
        },
        {
          "code" : "515",
          "display" : "Rampart Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12147"
            }
          ]
        },
        {
          "code" : "516",
          "display" : "Village of Red Devil",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12148"
            }
          ]
        },
        {
          "code" : "517",
          "display" : "Native Village of Ruby",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12149"
            }
          ]
        },
        {
          "code" : "518",
          "display" : "Saint George Island",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12150"
            }
          ]
        },
        {
          "code" : "519",
          "display" : "Native Village of Saint Michael",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12151"
            }
          ]
        },
        {
          "code" : "520",
          "display" : "Saint Paul Island",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12152"
            }
          ]
        },
        {
          "code" : "521",
          "display" : "Salamatof Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12153"
            }
          ]
        },
        {
          "code" : "522",
          "display" : "Native Village of Savoonga",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12154"
            }
          ]
        },
        {
          "code" : "523",
          "display" : "Organized Village of Saxman",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12155"
            }
          ]
        },
        {
          "code" : "524",
          "display" : "Native Village of Scammon Bay",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12156"
            }
          ]
        },
        {
          "code" : "525",
          "display" : "Native Village of Selawik",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12157"
            }
          ]
        },
        {
          "code" : "526",
          "display" : "Seldovia Village Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12158"
            }
          ]
        },
        {
          "code" : "527",
          "display" : "Shageluk Native Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12159"
            }
          ]
        },
        {
          "code" : "528",
          "display" : "Native Village of Shaktoolik",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12160"
            }
          ]
        },
        {
          "code" : "529",
          "display" : "Native Village of Nunam Iqua",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12161"
            }
          ]
        },
        {
          "code" : "530",
          "display" : "Native Village of Shishmaref",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12162"
            }
          ]
        },
        {
          "code" : "531",
          "display" : "Sun'aq Tribe of Kodiak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12163"
            }
          ]
        },
        {
          "code" : "532",
          "display" : "Native Village of Shungnak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12164"
            }
          ]
        },
        {
          "code" : "533",
          "display" : "Sitka Tribe of Alaska",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12165"
            }
          ]
        },
        {
          "code" : "534",
          "display" : "Skagway Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12166"
            }
          ]
        },
        {
          "code" : "535",
          "display" : "Village of Sleetmute",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12167"
            }
          ]
        },
        {
          "code" : "536",
          "display" : "Village of Solomon",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12168"
            }
          ]
        },
        {
          "code" : "537",
          "display" : "South Naknek Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12169"
            }
          ]
        },
        {
          "code" : "538",
          "display" : "Stebbins Community Association",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12170"
            }
          ]
        },
        {
          "code" : "539",
          "display" : "Native Village of Stevens",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12171"
            }
          ]
        },
        {
          "code" : "540",
          "display" : "Village of Stony River",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12172"
            }
          ]
        },
        {
          "code" : "541",
          "display" : "Takotna Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12173"
            }
          ]
        },
        {
          "code" : "542",
          "display" : "Native Village of Tanacross",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12174"
            }
          ]
        },
        {
          "code" : "543",
          "display" : "Native Village of Tanana",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12175"
            }
          ]
        },
        {
          "code" : "544",
          "display" : "Native Village of Tatitlek",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12176"
            }
          ]
        },
        {
          "code" : "545",
          "display" : "Native Village of Tazlina",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12177"
            }
          ]
        },
        {
          "code" : "546",
          "display" : "Telida Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12178"
            }
          ]
        },
        {
          "code" : "547",
          "display" : "Native Village of Teller",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12179"
            }
          ]
        },
        {
          "code" : "548",
          "display" : "Native Village of Tetlin",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12180"
            }
          ]
        },
        {
          "code" : "549",
          "display" : "Central Council of the Tlingit & Haida Indian Tribes",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12181"
            }
          ]
        },
        {
          "code" : "550",
          "display" : "Traditional Village of Togiak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12182"
            }
          ]
        },
        {
          "code" : "551",
          "display" : "Tuluksak Native Community",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12183"
            }
          ]
        },
        {
          "code" : "552",
          "display" : "Native Village of Tuntutuliak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12184"
            }
          ]
        },
        {
          "code" : "553",
          "display" : "Native Village of Tununak",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12185"
            }
          ]
        },
        {
          "code" : "554",
          "display" : "Twin Hills Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12186"
            }
          ]
        },
        {
          "code" : "555",
          "display" : "Native Village of Tyonek",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12187"
            }
          ]
        },
        {
          "code" : "556",
          "display" : "Ugashik Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12188"
            }
          ]
        },
        {
          "code" : "557",
          "display" : "Umkumiut Native Village",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12189"
            }
          ]
        },
        {
          "code" : "558",
          "display" : "Native Village of Unalakleet",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12190"
            }
          ]
        },
        {
          "code" : "559",
          "display" : "Native Village of Unga",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12191"
            }
          ]
        },
        {
          "code" : "560",
          "display" : "Village of Venetie",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12192"
            }
          ]
        },
        {
          "code" : "561",
          "display" : "Native Village of Venetie Tribal Government (Arctic Village and Village of Venetie)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "12193"
            }
          ]
        },
        {
          "code" : "562",
          "display" : "Village of Wainwright",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12194"
            }
          ]
        },
        {
          "code" : "563",
          "display" : "Native Village of Wales",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12195"
            }
          ]
        },
        {
          "code" : "564",
          "display" : "Native Village of White Mountain",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12196"
            }
          ]
        },
        {
          "code" : "565",
          "display" : "Wrangell Cooperative Association",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12197"
            }
          ]
        },
        {
          "code" : "566",
          "display" : "Yakutat Tlingit Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12198"
            }
          ]
        }
      ]
    },
    {
      "code" : "_NativeEntityContiguous",
      "display" : "NativeEntityContiguous",
      "definition" : "NATIVE ENTITIES WITHIN THE CONTIGUOUS 48 STATES",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21287"
        }
      ],
      "concept" : [
        {
          "code" : "1",
          "display" : "Absentee-Shawnee Tribe of Indians of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11632"
            }
          ]
        },
        {
          "code" : "2",
          "display" : "Agua Caliente Band of Cahuilla Indians of the Agua Caliente Indian Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11633"
            }
          ]
        },
        {
          "code" : "3",
          "display" : "Ak-Chin Indian Community",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11634"
            }
          ]
        },
        {
          "code" : "4",
          "display" : "Alabama-Coushatta Tribe of Texas",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11635"
            }
          ]
        },
        {
          "code" : "5",
          "display" : "Alabama-Quassarte Tribal Town",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11636"
            }
          ]
        },
        {
          "code" : "6",
          "display" : "Alturas Indian Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11637"
            }
          ]
        },
        {
          "code" : "7",
          "display" : "Apache Tribe of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11638"
            }
          ]
        },
        {
          "code" : "8",
          "display" : "Northern Arapaho Tribe of the Wind River Reservation, Wyoming",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11639"
            }
          ]
        },
        {
          "code" : "9",
          "display" : "Mi'kmaq Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11640"
            }
          ]
        },
        {
          "code" : "10",
          "display" : "Assiniboine and Sioux Tribes of the Fort Peck Indian Reservation, Montana",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11641"
            }
          ]
        },
        {
          "code" : "11",
          "display" : "Augustine Band of Cahuilla Indians, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11642"
            }
          ]
        },
        {
          "code" : "12",
          "display" : "Bad River Band of the Lake Superior Tribe of Chippewa Indians of the Bad River Reservation, Wisconsin",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11643"
            }
          ]
        },
        {
          "code" : "33",
          "display" : "Barona Group of Capitan Grande Band of Mission Ind",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "11664"
            }
          ]
        },
        {
          "code" : "13",
          "display" : "Bay Mills Indian Community, Michigan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11644"
            }
          ]
        },
        {
          "code" : "14",
          "display" : "Bear River Band of the Rohnerville Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11645"
            }
          ]
        },
        {
          "code" : "15",
          "display" : "Berry Creek Rancheria of Maidu Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11646"
            }
          ]
        },
        {
          "code" : "16",
          "display" : "Big Lagoon Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11647"
            }
          ]
        },
        {
          "code" : "17",
          "display" : "Big Pine Paiute Tribe of the Owens Valley",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11648"
            }
          ]
        },
        {
          "code" : "18",
          "display" : "Big Sandy Rancheria of Western Mono Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11649"
            }
          ]
        },
        {
          "code" : "19",
          "display" : "Big Valley Band of Pomo Indians of the Big Valley Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11650"
            }
          ]
        },
        {
          "code" : "20",
          "display" : "Blackfeet Tribe of the Blackfeet Indian Reservation of Montana",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11651"
            }
          ]
        },
        {
          "code" : "21",
          "display" : "Blue Lake Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11652"
            }
          ]
        },
        {
          "code" : "160",
          "display" : "Bois Forte Band (Nett Lake); Fond du Lac Band; Gra",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "11791"
            }
          ]
        },
        {
          "code" : "22",
          "display" : "Bridgeport Indian Colony",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11653"
            }
          ]
        },
        {
          "code" : "23",
          "display" : "Buena Vista Rancheria of Me-Wuk Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11654"
            }
          ]
        },
        {
          "code" : "24",
          "display" : "Burns Paiute Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11655"
            }
          ]
        },
        {
          "code" : "25",
          "display" : "Cabazon Band of Cahuilla Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11656"
            }
          ]
        },
        {
          "code" : "26",
          "display" : "Cachil DeHe Band of Wintun Indians of the Colusa Indian Community of the Colusa Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11657"
            }
          ]
        },
        {
          "code" : "27",
          "display" : "Caddo Nation of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11658"
            }
          ]
        },
        {
          "code" : "29",
          "display" : "Cahto Tribe of the Laytonville Rancheria",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11660"
            }
          ]
        },
        {
          "code" : "28",
          "display" : "Cahuilla Band of Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11659"
            }
          ]
        },
        {
          "code" : "30",
          "display" : "California Valley Miwok Tribe, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11661"
            }
          ]
        },
        {
          "code" : "31",
          "display" : "Campo Band of Diegueno Mission Indians of the Campo Indian Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11662"
            }
          ]
        },
        {
          "code" : "32",
          "display" : "Capitan Grande Band of Diegueno Mission Indians of California",
          "definition" : "Capitan Grande Band of Diegueno Mission Indians of California (Barona Group of Capitan Grande Band of Mission Indians of the Barona Reservation, California; Viejas (Baron Long) Group of Capitan Grande Band of Mission Indians of the Viejas Reservation, California)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11663"
            }
          ]
        },
        {
          "code" : "35",
          "display" : "Catawba Indian Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11666"
            }
          ]
        },
        {
          "code" : "36",
          "display" : "Cayuga Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11667"
            }
          ]
        },
        {
          "code" : "37",
          "display" : "Cedarville Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11668"
            }
          ]
        },
        {
          "code" : "38",
          "display" : "Chemehuevi Indian Tribe of the Chemehuevi Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11669"
            }
          ]
        },
        {
          "code" : "39",
          "display" : "Cher-Ae Heights Indian Community of the Trinidad Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11670"
            }
          ]
        },
        {
          "code" : "40",
          "display" : "Cherokee Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11671"
            }
          ]
        },
        {
          "code" : "42",
          "display" : "Cheyenne River Sioux Tribe of the Cheyenne River Reservation, South Dakota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11673"
            }
          ]
        },
        {
          "code" : "41",
          "display" : "Cheyenne and Arapaho Tribes, Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11672"
            }
          ]
        },
        {
          "code" : "43",
          "display" : "The Chickasaw Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11674"
            }
          ]
        },
        {
          "code" : "44",
          "display" : "Chicken Ranch Rancheria of Me-Wuk Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11675"
            }
          ]
        },
        {
          "code" : "45",
          "display" : "Chippewa Cree Indians of the Rocky Boy's Reservation, Montana",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11676"
            }
          ]
        },
        {
          "code" : "46",
          "display" : "Chitimacha Tribe of Louisiana",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11677"
            }
          ]
        },
        {
          "code" : "47",
          "display" : "The Choctaw Nation of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11678"
            }
          ]
        },
        {
          "code" : "48",
          "display" : "Citizen Potawatomi Nation, Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11679"
            }
          ]
        },
        {
          "code" : "49",
          "display" : "Cloverdale Rancheria of Pomo Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11680"
            }
          ]
        },
        {
          "code" : "50",
          "display" : "Cocopah Tribe of Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11681"
            }
          ]
        },
        {
          "code" : "51",
          "display" : "Coeur D'Alene Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11682"
            }
          ]
        },
        {
          "code" : "52",
          "display" : "Cold Springs Rancheria of Mono Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11683"
            }
          ]
        },
        {
          "code" : "53",
          "display" : "Colorado River Indian Tribes of the Colorado River Indian Reservation, Arizona and California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11684"
            }
          ]
        },
        {
          "code" : "54",
          "display" : "Comanche Nation, Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11685"
            }
          ]
        },
        {
          "code" : "55",
          "display" : "Confederated Salish and Kootenai Tribes of the Flathead Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11686"
            }
          ]
        },
        {
          "code" : "64",
          "display" : "Confederated Tribes and Bands of the Yakama Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11695"
            }
          ]
        },
        {
          "code" : "56",
          "display" : "Confederated Tribes of the Chehalis Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11687"
            }
          ]
        },
        {
          "code" : "57",
          "display" : "Confederated Tribes of the Colville Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11688"
            }
          ]
        },
        {
          "code" : "58",
          "display" : "Confederated Tribes of the Coos, Lower Umpqua and Siuslaw Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11689"
            }
          ]
        },
        {
          "code" : "59",
          "display" : "Confederated Tribes of the Goshute Reservation, Nevada and Utah",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11690"
            }
          ]
        },
        {
          "code" : "60",
          "display" : "Confederated Tribes of the Grand Ronde Community of Oregon",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11691"
            }
          ]
        },
        {
          "code" : "61",
          "display" : "Confederated Tribes of Siletz Indians of Oregon",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11692"
            }
          ]
        },
        {
          "code" : "62",
          "display" : "Confederated Tribes of the Umatilla Indian Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11693"
            }
          ]
        },
        {
          "code" : "63",
          "display" : "Confederated Tribes of the Warm Springs Reservation of Oregon",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11694"
            }
          ]
        },
        {
          "code" : "65",
          "display" : "Coquille Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11696"
            }
          ]
        },
        {
          "code" : "66",
          "display" : "Kletsel Dehe Wintun Nation of the Cortina Rancheria",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11697"
            }
          ]
        },
        {
          "code" : "67",
          "display" : "Coushatta Tribe of Louisiana",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11698"
            }
          ]
        },
        {
          "code" : "68",
          "display" : "Cow Creek Band of Umpqua Tribe of Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11699"
            }
          ]
        },
        {
          "code" : "69",
          "display" : "Coyote Valley Band of Pomo Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11700"
            }
          ]
        },
        {
          "code" : "71",
          "display" : "Crow Creek Sioux Tribe of the Crow Creek Reservation, South Dakota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11702"
            }
          ]
        },
        {
          "code" : "70",
          "display" : "Crow Tribe of Montana",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11701"
            }
          ]
        },
        {
          "code" : "72",
          "display" : "Ewiiaapaayp Band of Kumeyaay Indians, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11703"
            }
          ]
        },
        {
          "code" : "73",
          "display" : "Timbisha Shoshone Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11704"
            }
          ]
        },
        {
          "code" : "74",
          "display" : "Delaware Nation, Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11705"
            }
          ]
        },
        {
          "code" : "75",
          "display" : "Delaware Tribe of Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11706"
            }
          ]
        },
        {
          "code" : "76",
          "display" : "Dry Creek Rancheria Band of Pomo Indians, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11707"
            }
          ]
        },
        {
          "code" : "77",
          "display" : "Duckwater Shoshone Tribe of the Duckwater Reservation, Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11708"
            }
          ]
        },
        {
          "code" : "78",
          "display" : "Eastern Band of Cherokee Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11709"
            }
          ]
        },
        {
          "code" : "79",
          "display" : "Eastern Shawnee Tribe of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11710"
            }
          ]
        },
        {
          "code" : "80",
          "display" : "Elem Indian Colony of Pomo Indians of the Sulphur Bank Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11711"
            }
          ]
        },
        {
          "code" : "81",
          "display" : "Elk Valley Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11712"
            }
          ]
        },
        {
          "code" : "82",
          "display" : "Ely Shoshone Tribe of Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11713"
            }
          ]
        },
        {
          "code" : "83",
          "display" : "Enterprise Rancheria of Maidu Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11714"
            }
          ]
        },
        {
          "code" : "84",
          "display" : "Flandreau Santee Sioux Tribe of South Dakota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11715"
            }
          ]
        },
        {
          "code" : "85",
          "display" : "Forest County Potawatomi Community, Wisconsin",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11716"
            }
          ]
        },
        {
          "code" : "86",
          "display" : "Fort Belknap Indian Community of the Fort Belknap Reservation of Montana",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11717"
            }
          ]
        },
        {
          "code" : "87",
          "display" : "Fort Bidwell Indian Community of the Fort Bidwell Reservation of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11718"
            }
          ]
        },
        {
          "code" : "88",
          "display" : "Fort Independence Indian Community of Paiute Indians of the Fort Independence Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11719"
            }
          ]
        },
        {
          "code" : "89",
          "display" : "Fort McDermitt Paiute and Shoshone Tribes of the Fort McDermitt Indian Reservation, Nevada and Oregon",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11720"
            }
          ]
        },
        {
          "code" : "90",
          "display" : "Fort McDowell Yavapai Nation, Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11721"
            }
          ]
        },
        {
          "code" : "91",
          "display" : "Fort Mojave Indian Tribe of Arizona, California & Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11722"
            }
          ]
        },
        {
          "code" : "92",
          "display" : "Fort Sill Apache Tribe of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11723"
            }
          ]
        },
        {
          "code" : "93",
          "display" : "Gila River Indian Community of the Gila River Indian Reservation, Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11724"
            }
          ]
        },
        {
          "code" : "94",
          "display" : "Grand Traverse Band of Ottawa and Chippewa Indians, Michigan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11725"
            }
          ]
        },
        {
          "code" : "95",
          "display" : "Federated Indians of Graton Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11726"
            }
          ]
        },
        {
          "code" : "96",
          "display" : "Greenville Rancheria",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11727"
            }
          ]
        },
        {
          "code" : "97",
          "display" : "Grindstone Indian Rancheria of Wintun-Wailaki Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11728"
            }
          ]
        },
        {
          "code" : "98",
          "display" : "Guidiville Rancheria of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11729"
            }
          ]
        },
        {
          "code" : "99",
          "display" : "Hannahville Indian Community, Michigan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11730"
            }
          ]
        },
        {
          "code" : "100",
          "display" : "Havasupai Tribe of the Havasupai Reservation, Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11731"
            }
          ]
        },
        {
          "code" : "101",
          "display" : "Ho-Chunk Nation of Wisconsin",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11732"
            }
          ]
        },
        {
          "code" : "102",
          "display" : "Hoh Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11733"
            }
          ]
        },
        {
          "code" : "103",
          "display" : "Hoopa Valley Tribe, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11734"
            }
          ]
        },
        {
          "code" : "104",
          "display" : "Hopi Tribe of Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11735"
            }
          ]
        },
        {
          "code" : "105",
          "display" : "Hopland Band of Pomo Indians, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11736"
            }
          ]
        },
        {
          "code" : "106",
          "display" : "Houlton Band of Maliseet Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11737"
            }
          ]
        },
        {
          "code" : "107",
          "display" : "Hualapai Indian Tribe of the Hualapai Indian Reservation, Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11738"
            }
          ]
        },
        {
          "code" : "108",
          "display" : "Nottawaseppi Huron Band of the Potawatomi, Michigan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11739"
            }
          ]
        },
        {
          "code" : "109",
          "display" : "Inaja Band of Diegueno Mission Indians of the Inaja and Cosmit Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11740"
            }
          ]
        },
        {
          "code" : "110",
          "display" : "Ione Band of Miwok Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11741"
            }
          ]
        },
        {
          "code" : "111",
          "display" : "Iowa Tribe of Kansas and Nebraska",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11742"
            }
          ]
        },
        {
          "code" : "112",
          "display" : "Iowa Tribe of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11743"
            }
          ]
        },
        {
          "code" : "113",
          "display" : "Jackson Band of Miwuk Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11744"
            }
          ]
        },
        {
          "code" : "114",
          "display" : "Jamestown S'Klallam Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11745"
            }
          ]
        },
        {
          "code" : "115",
          "display" : "Jamul Indian Village of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11746"
            }
          ]
        },
        {
          "code" : "116",
          "display" : "Jena Band of Choctaw Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11747"
            }
          ]
        },
        {
          "code" : "117",
          "display" : "Jicarilla Apache Nation, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11748"
            }
          ]
        },
        {
          "code" : "118",
          "display" : "Kaibab Band of Paiute Indians of the Kaibab Indian Reservation, Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11749"
            }
          ]
        },
        {
          "code" : "119",
          "display" : "Kalispel Indian Community of the Kalispel Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11750"
            }
          ]
        },
        {
          "code" : "120",
          "display" : "Karuk Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11751"
            }
          ]
        },
        {
          "code" : "121",
          "display" : "Kashia Band of Pomo Indians of the Stewarts Point Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11752"
            }
          ]
        },
        {
          "code" : "122",
          "display" : "Kaw Nation, Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11753"
            }
          ]
        },
        {
          "code" : "123",
          "display" : "Keweenaw Bay Indian Community, Michigan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11754"
            }
          ]
        },
        {
          "code" : "124",
          "display" : "Kialegee Tribal Town",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11755"
            }
          ]
        },
        {
          "code" : "127",
          "display" : "Kickapoo Traditional Tribe of Texas",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11758"
            }
          ]
        },
        {
          "code" : "125",
          "display" : "Kickapoo Tribe of Indians of the Kickapoo Reservation in Kansas",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11756"
            }
          ]
        },
        {
          "code" : "126",
          "display" : "Kickapoo Tribe of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11757"
            }
          ]
        },
        {
          "code" : "128",
          "display" : "Kiowa Indian Tribe of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11759"
            }
          ]
        },
        {
          "code" : "129",
          "display" : "Klamath Tribes",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11760"
            }
          ]
        },
        {
          "code" : "130",
          "display" : "Kootenai Tribe of Idaho",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11761"
            }
          ]
        },
        {
          "code" : "131",
          "display" : "La Jolla Band of Luiseno Indians, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11762"
            }
          ]
        },
        {
          "code" : "132",
          "display" : "La Posta Band of Diegueno Mission Indians of the La Posta Indian Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11763"
            }
          ]
        },
        {
          "code" : "133",
          "display" : "Lac Courte Oreilles Band of Lake Superior Chippewa Indians of Wisconsin",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11764"
            }
          ]
        },
        {
          "code" : "134",
          "display" : "Lac du Flambeau Band of Lake Superior Chippewa Indians of the Lac du Flambeau Reservation of Wisconsin",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11765"
            }
          ]
        },
        {
          "code" : "135",
          "display" : "Lac Vieux Desert Band of Lake Superior Chippewa Indians of Michigan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11766"
            }
          ]
        },
        {
          "code" : "136",
          "display" : "Las Vegas Tribe of Paiute Indians of the Las Vegas Indian Colony, Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11767"
            }
          ]
        },
        {
          "code" : "137",
          "display" : "Little River Band of Ottawa Indians, Michigan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11768"
            }
          ]
        },
        {
          "code" : "138",
          "display" : "Little Traverse Bay Bands of Odawa Indians, Michigan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11769"
            }
          ]
        },
        {
          "code" : "140",
          "display" : "Los Coyotes Band of Cahuilla and Cupeno Indians, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11771"
            }
          ]
        },
        {
          "code" : "141",
          "display" : "Lovelock Paiute Tribe of the Lovelock Indian Colony, Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11772"
            }
          ]
        },
        {
          "code" : "142",
          "display" : "Lower Brule Sioux Tribe of the Lower Brule Reservation, South Dakota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11773"
            }
          ]
        },
        {
          "code" : "143",
          "display" : "Lower Elwha Tribal Community",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11774"
            }
          ]
        },
        {
          "code" : "139",
          "display" : "Koi Nation of Northern California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11770"
            }
          ]
        },
        {
          "code" : "144",
          "display" : "Lower Sioux Indian Community in the State of Minnesota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11775"
            }
          ]
        },
        {
          "code" : "145",
          "display" : "Lummi Tribe of the Lummi Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11776"
            }
          ]
        },
        {
          "code" : "146",
          "display" : "Lytton Rancheria of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11777"
            }
          ]
        },
        {
          "code" : "147",
          "display" : "Makah Indian Tribe of the Makah Indian Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11778"
            }
          ]
        },
        {
          "code" : "148",
          "display" : "Manchester Band of Pomo Indians of the Manchester Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11779"
            }
          ]
        },
        {
          "code" : "149",
          "display" : "Manzanita Band of Diegueno Mission Indians of the Manzanita Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11780"
            }
          ]
        },
        {
          "code" : "150",
          "display" : "Mashantucket Pequot Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11781"
            }
          ]
        },
        {
          "code" : "151",
          "display" : "Match-e-be-nash-she-wish Band of Pottawatomi Indians of Michigan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11782"
            }
          ]
        },
        {
          "code" : "152",
          "display" : "Mechoopda Indian Tribe of Chico Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11783"
            }
          ]
        },
        {
          "code" : "153",
          "display" : "Menominee Indian Tribe of Wisconsin",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11784"
            }
          ]
        },
        {
          "code" : "154",
          "display" : "Mesa Grande Band of Diegueno Mission Indians of the Mesa Grande Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11785"
            }
          ]
        },
        {
          "code" : "155",
          "display" : "Mescalero Apache Tribe of the Mescalero Reservation, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11786"
            }
          ]
        },
        {
          "code" : "156",
          "display" : "Miami Tribe of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11787"
            }
          ]
        },
        {
          "code" : "157",
          "display" : "Miccosukee Tribe of Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11788"
            }
          ]
        },
        {
          "code" : "158",
          "display" : "Middletown Rancheria of Pomo Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11789"
            }
          ]
        },
        {
          "code" : "159",
          "display" : "Minnesota Chippewa Tribe, Minnesota (Six component reservations: Bois Forte Band (Nett Lake); Fond du Lac Band; Grand Portage Band; Leech Lake Band; Mille Lacs Band; White Earth Band)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11790"
            }
          ]
        },
        {
          "code" : "161",
          "display" : "Mississippi Band of Choctaw Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11792"
            }
          ]
        },
        {
          "code" : "162",
          "display" : "Moapa Band of Paiute Indians of the Moapa River Indian Reservation, Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11793"
            }
          ]
        },
        {
          "code" : "163",
          "display" : "Modoc Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11794"
            }
          ]
        },
        {
          "code" : "164",
          "display" : "Mohegan Tribe of Indians of Connecticut",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11795"
            }
          ]
        },
        {
          "code" : "165",
          "display" : "Mooretown Rancheria of Maidu Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11796"
            }
          ]
        },
        {
          "code" : "166",
          "display" : "Morongo Band of Mission Indians, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11797"
            }
          ]
        },
        {
          "code" : "167",
          "display" : "Muckleshoot Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11798"
            }
          ]
        },
        {
          "code" : "168",
          "display" : "The Muscogee (Creek) Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11799"
            }
          ]
        },
        {
          "code" : "169",
          "display" : "Narragansett Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11800"
            }
          ]
        },
        {
          "code" : "170",
          "display" : "Navajo Nation, Arizona, New Mexico, & Utah",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11801"
            }
          ]
        },
        {
          "code" : "171",
          "display" : "Nez Perce Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11802"
            }
          ]
        },
        {
          "code" : "172",
          "display" : "Nisqually Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11803"
            }
          ]
        },
        {
          "code" : "173",
          "display" : "Nooksack Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11804"
            }
          ]
        },
        {
          "code" : "174",
          "display" : "Northern Cheyenne Tribe of the Northern Cheyenne Indian Reservation, Montana",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11805"
            }
          ]
        },
        {
          "code" : "175",
          "display" : "Northfork Rancheria of Mono Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11806"
            }
          ]
        },
        {
          "code" : "176",
          "display" : "Northwestern Band of the Shoshone Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11807"
            }
          ]
        },
        {
          "code" : "177",
          "display" : "Oglala Sioux Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11808"
            }
          ]
        },
        {
          "code" : "178",
          "display" : "Omaha Tribe of Nebraska",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11809"
            }
          ]
        },
        {
          "code" : "179",
          "display" : "Oneida Indian Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11810"
            }
          ]
        },
        {
          "code" : "180",
          "display" : "Oneida Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11811"
            }
          ]
        },
        {
          "code" : "181",
          "display" : "Onondaga Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11812"
            }
          ]
        },
        {
          "code" : "182",
          "display" : "The Osage Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11813"
            }
          ]
        },
        {
          "code" : "184",
          "display" : "Otoe-Missouria Tribe of Indians, Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11815"
            }
          ]
        },
        {
          "code" : "183",
          "display" : "Ottawa Tribe of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11814"
            }
          ]
        },
        {
          "code" : "185",
          "display" : "Paiute Indian Tribe of Utah (Cedar Band of Paiutes, Kanosh Band of Paiutes, Koosharem Band of Paiutes, Indian Peaks Band of Paiutes, and Shivwits Band of Paiutes)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11816"
            }
          ]
        },
        {
          "code" : "186",
          "display" : "Bishop Paiute Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11817"
            }
          ]
        },
        {
          "code" : "188",
          "display" : "Lone Pine Paiute-Shoshone Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11819"
            }
          ]
        },
        {
          "code" : "187",
          "display" : "Paiute-Shoshone Tribe of the Fallon Reservation and Colony, Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11818"
            }
          ]
        },
        {
          "code" : "189",
          "display" : "Pala Band of Mission Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11820"
            }
          ]
        },
        {
          "code" : "190",
          "display" : "Pascua Yaqui Tribe of Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11821"
            }
          ]
        },
        {
          "code" : "191",
          "display" : "Paskenta Band of Nomlaki Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11822"
            }
          ]
        },
        {
          "code" : "192",
          "display" : "Passamaquoddy Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11823"
            }
          ]
        },
        {
          "code" : "193",
          "display" : "Pauma Band of Luiseno Mission Indians of the Pauma & Yuima Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11824"
            }
          ]
        },
        {
          "code" : "194",
          "display" : "Pawnee Nation of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11825"
            }
          ]
        },
        {
          "code" : "195",
          "display" : "Pechanga Band of Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11826"
            }
          ]
        },
        {
          "code" : "196",
          "display" : "Penobscot Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11827"
            }
          ]
        },
        {
          "code" : "197",
          "display" : "Peoria Tribe of Indians of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11828"
            }
          ]
        },
        {
          "code" : "198",
          "display" : "Picayune Rancheria of Chukchansi Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11829"
            }
          ]
        },
        {
          "code" : "199",
          "display" : "Pinoleville Pomo Nation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11830"
            }
          ]
        },
        {
          "code" : "200",
          "display" : "Pit River Tribe, California (includes XL Ranch, Big Bend, Likely, Lookout, Montgomery Creek, and Roaring Creek Rancherias)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11831"
            }
          ]
        },
        {
          "code" : "201",
          "display" : "Poarch Band of Creek Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11832"
            }
          ]
        },
        {
          "code" : "202",
          "display" : "Pokagon Band of Potawatomi Indians, Michigan and Indiana",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11833"
            }
          ]
        },
        {
          "code" : "203",
          "display" : "Ponca Tribe of Indians of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11834"
            }
          ]
        },
        {
          "code" : "204",
          "display" : "Ponca Tribe of Nebraska",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11835"
            }
          ]
        },
        {
          "code" : "205",
          "display" : "Port Gamble S'Klallam Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11836"
            }
          ]
        },
        {
          "code" : "206",
          "display" : "Potter Valley Tribe, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11837"
            }
          ]
        },
        {
          "code" : "207",
          "display" : "Prairie Band Potawatomi Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11838"
            }
          ]
        },
        {
          "code" : "208",
          "display" : "Prairie Island Indian Community in the State of Minnesota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11839"
            }
          ]
        },
        {
          "code" : "209",
          "display" : "Pueblo of Acoma, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11840"
            }
          ]
        },
        {
          "code" : "210",
          "display" : "Pueblo of Cochiti, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11841"
            }
          ]
        },
        {
          "code" : "212",
          "display" : "Pueblo of Isleta, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11843"
            }
          ]
        },
        {
          "code" : "211",
          "display" : "Pueblo of Jemez, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11842"
            }
          ]
        },
        {
          "code" : "213",
          "display" : "Pueblo of Laguna, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11844"
            }
          ]
        },
        {
          "code" : "214",
          "display" : "Pueblo of Nambe, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11845"
            }
          ]
        },
        {
          "code" : "215",
          "display" : "Pueblo of Picuris, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11846"
            }
          ]
        },
        {
          "code" : "216",
          "display" : "Pueblo of Pojoaque, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11847"
            }
          ]
        },
        {
          "code" : "217",
          "display" : "Pueblo of San Felipe, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11848"
            }
          ]
        },
        {
          "code" : "219",
          "display" : "Pueblo of San Ildefonso, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11850"
            }
          ]
        },
        {
          "code" : "218",
          "display" : "Ohkay Owingeh, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11849"
            }
          ]
        },
        {
          "code" : "220",
          "display" : "Pueblo of Sandia, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11851"
            }
          ]
        },
        {
          "code" : "221",
          "display" : "Pueblo of Santa Ana, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11852"
            }
          ]
        },
        {
          "code" : "222",
          "display" : "Pueblo of Santa Clara, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11853"
            }
          ]
        },
        {
          "code" : "223",
          "display" : "Santo Domingo Pueblo",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11854"
            }
          ]
        },
        {
          "code" : "224",
          "display" : "Pueblo of Taos, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11855"
            }
          ]
        },
        {
          "code" : "225",
          "display" : "Pueblo of Tesuque, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11856"
            }
          ]
        },
        {
          "code" : "226",
          "display" : "Pueblo of Zia, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11857"
            }
          ]
        },
        {
          "code" : "227",
          "display" : "Puyallup Tribe of the Puyallup Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11858"
            }
          ]
        },
        {
          "code" : "228",
          "display" : "Pyramid Lake Paiute Tribe of the Pyramid Lake Reservation, Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11859"
            }
          ]
        },
        {
          "code" : "229",
          "display" : "Quapaw Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11860"
            }
          ]
        },
        {
          "code" : "230",
          "display" : "Quartz Valley Indian Community of the Quartz Valley Reservation of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11861"
            }
          ]
        },
        {
          "code" : "231",
          "display" : "Quechan Tribe of the Fort Yuma Indian Reservation, California & Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11862"
            }
          ]
        },
        {
          "code" : "232",
          "display" : "Quileute Tribe of the Quileute Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11863"
            }
          ]
        },
        {
          "code" : "233",
          "display" : "Quinault Indian Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11864"
            }
          ]
        },
        {
          "code" : "234",
          "display" : "Ramona Band of Cahuilla, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11865"
            }
          ]
        },
        {
          "code" : "235",
          "display" : "Red Cliff Band of Lake Superior Chippewa Indians of Wisconsin",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11866"
            }
          ]
        },
        {
          "code" : "236",
          "display" : "Red Lake Band of Chippewa Indians, Minnesota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11867"
            }
          ]
        },
        {
          "code" : "237",
          "display" : "Redding Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11868"
            }
          ]
        },
        {
          "code" : "238",
          "display" : "Redwood Valley or Little River Band of Pomo Indians of the Redwood Valley Rancheria California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11869"
            }
          ]
        },
        {
          "code" : "239",
          "display" : "Reno-Sparks Indian Colony, Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11870"
            }
          ]
        },
        {
          "code" : "240",
          "display" : "Resighini Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11871"
            }
          ]
        },
        {
          "code" : "241",
          "display" : "Rincon Band of Luiseno Mission Indians of Rincon Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11872"
            }
          ]
        },
        {
          "code" : "242",
          "display" : "Robinson Rancheria",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11873"
            }
          ]
        },
        {
          "code" : "243",
          "display" : "Rosebud Sioux Tribe of the Rosebud Indian Reservation, South Dakota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11874"
            }
          ]
        },
        {
          "code" : "244",
          "display" : "Round Valley Indian Tribes, Round Valley Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11875"
            }
          ]
        },
        {
          "code" : "245",
          "display" : "Yocha Dehe Wintun Nation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11876"
            }
          ]
        },
        {
          "code" : "247",
          "display" : "Sac & Fox Nation of Missouri in Kansas and Nebraska",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11878"
            }
          ]
        },
        {
          "code" : "248",
          "display" : "Sac & Fox Nation, Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11879"
            }
          ]
        },
        {
          "code" : "246",
          "display" : "Sac & Fox Tribe of the Mississippi in Iowa",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11877"
            }
          ]
        },
        {
          "code" : "249",
          "display" : "Saginaw Chippewa Indian Tribe of Michigan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11880"
            }
          ]
        },
        {
          "code" : "250",
          "display" : "Salt River Pima-Maricopa Indian Community of the Salt River Reservation, Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11881"
            }
          ]
        },
        {
          "code" : "251",
          "display" : "Samish Indian Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11882"
            }
          ]
        },
        {
          "code" : "252",
          "display" : "San Carlos Apache Tribe of the San Carlos Reservation, Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11883"
            }
          ]
        },
        {
          "code" : "253",
          "display" : "San Juan Southern Paiute Tribe of Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11884"
            }
          ]
        },
        {
          "code" : "254",
          "display" : "Yuhaaviatam of San Manuel Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11885"
            }
          ]
        },
        {
          "code" : "255",
          "display" : "San Pasqual Band of Diegueno Mission Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11886"
            }
          ]
        },
        {
          "code" : "257",
          "display" : "Santa Rosa Band of Cahuilla Indians, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11888"
            }
          ]
        },
        {
          "code" : "256",
          "display" : "Santa Rosa Indian Community of the Santa Rosa Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11887"
            }
          ]
        },
        {
          "code" : "258",
          "display" : "Santa Ynez Band of Chumash Mission Indians of the Santa Ynez Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11889"
            }
          ]
        },
        {
          "code" : "259",
          "display" : "Iipay Nation of Santa Ysabel, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11890"
            }
          ]
        },
        {
          "code" : "260",
          "display" : "Santee Sioux Nation, Nebraska",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11891"
            }
          ]
        },
        {
          "code" : "261",
          "display" : "Sauk-Suiattle Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11892"
            }
          ]
        },
        {
          "code" : "262",
          "display" : "Sault Ste. Marie Tribe of Chippewa Indians, Michigan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11893"
            }
          ]
        },
        {
          "code" : "263",
          "display" : "Scotts Valley Band of Pomo Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11894"
            }
          ]
        },
        {
          "code" : "264",
          "display" : "The Seminole Nation of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11895"
            }
          ]
        },
        {
          "code" : "265",
          "display" : "Seminole Tribe of Florida",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11896"
            }
          ]
        },
        {
          "code" : "266",
          "display" : "Seneca Nation of Indians",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11897"
            }
          ]
        },
        {
          "code" : "267",
          "display" : "Seneca-Cayuga Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11898"
            }
          ]
        },
        {
          "code" : "268",
          "display" : "Shakopee Mdewakanton Sioux Community of Minnesota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11899"
            }
          ]
        },
        {
          "code" : "269",
          "display" : "Shawnee Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11900"
            }
          ]
        },
        {
          "code" : "270",
          "display" : "Sherwood Valley Rancheria of Pomo Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11901"
            }
          ]
        },
        {
          "code" : "271",
          "display" : "Shingle Springs Band of Miwok Indians, Shingle Springs Rancheria (Verona Tract), California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11902"
            }
          ]
        },
        {
          "code" : "272",
          "display" : "Shoalwater Bay Indian Tribe of the Shoalwater Bay Indian Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11903"
            }
          ]
        },
        {
          "code" : "273",
          "display" : "Eastern Shoshone Tribe of the Wind River Reservation, Wyoming",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11904"
            }
          ]
        },
        {
          "code" : "274",
          "display" : "Shoshone-Bannock Tribes of the Fort Hall Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11905"
            }
          ]
        },
        {
          "code" : "275",
          "display" : "Shoshone-Paiute Tribes of the Duck Valley Reservation, Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11906"
            }
          ]
        },
        {
          "code" : "276",
          "display" : "Sisseton-Wahpeton Oyate of the Lake Traverse Reservation, South Dakota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11907"
            }
          ]
        },
        {
          "code" : "277",
          "display" : "Skokomish Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11908"
            }
          ]
        },
        {
          "code" : "278",
          "display" : "Skull Valley Band of Goshute Indians of Utah",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11909"
            }
          ]
        },
        {
          "code" : "279",
          "display" : "Tolowa Dee-ni' Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11910"
            }
          ]
        },
        {
          "code" : "280",
          "display" : "Snoqualmie Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11911"
            }
          ]
        },
        {
          "code" : "281",
          "display" : "Soboba Band of Luiseno Indians, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11912"
            }
          ]
        },
        {
          "code" : "282",
          "display" : "Sokaogon Chippewa Community, Wisconsin",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11913"
            }
          ]
        },
        {
          "code" : "283",
          "display" : "Southern Ute Indian Tribe of the Southern Ute Reservation, Colorado",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11914"
            }
          ]
        },
        {
          "code" : "284",
          "display" : "Spirit Lake Tribe, North Dakota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11915"
            }
          ]
        },
        {
          "code" : "285",
          "display" : "Spokane Tribe of the Spokane Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11916"
            }
          ]
        },
        {
          "code" : "286",
          "display" : "Squaxin Island Tribe of the Squaxin Island Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11917"
            }
          ]
        },
        {
          "code" : "287",
          "display" : "St. Croix Chippewa Indians of Wisconsin",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11918"
            }
          ]
        },
        {
          "code" : "288",
          "display" : "Saint Regis Mohawk Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11919"
            }
          ]
        },
        {
          "code" : "289",
          "display" : "Standing Rock Sioux Tribe of North & South Dakota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11920"
            }
          ]
        },
        {
          "code" : "291",
          "display" : "Stillaguamish Tribe of Indians of Washington",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11922"
            }
          ]
        },
        {
          "code" : "290",
          "display" : "Stockbridge Munsee Community, Wisconsin",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11921"
            }
          ]
        },
        {
          "code" : "292",
          "display" : "Summit Lake Paiute Tribe of Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11923"
            }
          ]
        },
        {
          "code" : "293",
          "display" : "Suquamish Indian Tribe of the Port Madison Reservation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11924"
            }
          ]
        },
        {
          "code" : "294",
          "display" : "Susanville Indian Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11925"
            }
          ]
        },
        {
          "code" : "295",
          "display" : "Swinomish Indian Tribal Community",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11926"
            }
          ]
        },
        {
          "code" : "296",
          "display" : "Sycuan Band of the Kumeyaay Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11927"
            }
          ]
        },
        {
          "code" : "297",
          "display" : "Wiyot Tribe, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11928"
            }
          ]
        },
        {
          "code" : "298",
          "display" : "Table Mountain Rancheria",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11929"
            }
          ]
        },
        {
          "code" : "299",
          "display" : "Te-Moak Tribe of Western Shoshone Indians of Nevada (Four constituent bands: Battle Mountain Band; Elko Band; South Fork Band; and Wells Band)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11930"
            }
          ]
        },
        {
          "code" : "300",
          "display" : "Thlopthlocco Tribal Town",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11931"
            }
          ]
        },
        {
          "code" : "301",
          "display" : "Three Affiliated Tribes of the Fort Berthold Reservation, North Dakota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11932"
            }
          ]
        },
        {
          "code" : "302",
          "display" : "Tohono O'odham Nation of Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11933"
            }
          ]
        },
        {
          "code" : "303",
          "display" : "Tonawanda Band of Seneca",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11934"
            }
          ]
        },
        {
          "code" : "304",
          "display" : "Tonkawa Tribe of Indians of Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11935"
            }
          ]
        },
        {
          "code" : "305",
          "display" : "Tonto Apache Tribe of Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11936"
            }
          ]
        },
        {
          "code" : "306",
          "display" : "Torres Martinez Desert Cahuilla Indians, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11937"
            }
          ]
        },
        {
          "code" : "308",
          "display" : "Tulalip Tribes of Washington",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11939"
            }
          ]
        },
        {
          "code" : "307",
          "display" : "Tule River Indian Tribe of the Tule River Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11938"
            }
          ]
        },
        {
          "code" : "309",
          "display" : "Tunica-Biloxi Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11940"
            }
          ]
        },
        {
          "code" : "310",
          "display" : "Tuolumne Band of Me-Wuk Indians of the Tuolumne Rancheria of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11941"
            }
          ]
        },
        {
          "code" : "311",
          "display" : "Turtle Mountain Band of Chippewa Indians of North Dakota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11942"
            }
          ]
        },
        {
          "code" : "312",
          "display" : "Tuscarora Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11943"
            }
          ]
        },
        {
          "code" : "313",
          "display" : "Twenty-Nine Palms Band of Mission Indians of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11944"
            }
          ]
        },
        {
          "code" : "314",
          "display" : "United Auburn Indian Community of the Auburn Rancheria of California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11945"
            }
          ]
        },
        {
          "code" : "315",
          "display" : "United Keetoowah Band of Cherokee Indians in Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11946"
            }
          ]
        },
        {
          "code" : "316",
          "display" : "Habematolel Pomo of Upper Lake, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11947"
            }
          ]
        },
        {
          "code" : "317",
          "display" : "Upper Sioux Community, Minnesota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11948"
            }
          ]
        },
        {
          "code" : "318",
          "display" : "Upper Skagit Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11949"
            }
          ]
        },
        {
          "code" : "319",
          "display" : "Ute Indian Tribe of the Uintah & Ouray Reservation, Utah",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11950"
            }
          ]
        },
        {
          "code" : "320",
          "display" : "Ute Mountain Ute Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11951"
            }
          ]
        },
        {
          "code" : "321",
          "display" : "Utu Utu Gwaitu Paiute Tribe of the Benton Paiute Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11952"
            }
          ]
        },
        {
          "code" : "34",
          "display" : "Viejas (Baron Long) Group of Capitan Grande Band o",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "11665"
            }
          ]
        },
        {
          "code" : "322",
          "display" : "Walker River Paiute Tribe of the Walker River Reservation, Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11953"
            }
          ]
        },
        {
          "code" : "323",
          "display" : "Wampanoag Tribe of Gay Head (Aquinnah)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11954"
            }
          ]
        },
        {
          "code" : "324",
          "display" : "Washoe Tribe of Nevada & California (Carson Colony, Dresslerville Colony, Woodfords Community, Stewart Community, & Washoe Ranches)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11955"
            }
          ]
        },
        {
          "code" : "325",
          "display" : "White Mountain Apache Tribe of the Fort Apache Reservation, Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11956"
            }
          ]
        },
        {
          "code" : "326",
          "display" : "Wichita and Affiliated Tribes (Wichita, Keechi, Waco, & Tawakonie), Oklahoma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11957"
            }
          ]
        },
        {
          "code" : "327",
          "display" : "Winnebago Tribe of Nebraska",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11958"
            }
          ]
        },
        {
          "code" : "328",
          "display" : "Winnemucca Indian Colony of Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11959"
            }
          ]
        },
        {
          "code" : "329",
          "display" : "Wyandotte Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11960"
            }
          ]
        },
        {
          "code" : "330",
          "display" : "Yankton Sioux Tribe of South Dakota",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11961"
            }
          ]
        },
        {
          "code" : "331",
          "display" : "Yavapai-Apache Nation of the Camp Verde Indian Reservation, Arizona",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11962"
            }
          ]
        },
        {
          "code" : "332",
          "display" : "Yavapai-Prescott Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11963"
            }
          ]
        },
        {
          "code" : "333",
          "display" : "Yerington Paiute Tribe of the Yerington Colony & Campbell Ranch, Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11964"
            }
          ]
        },
        {
          "code" : "334",
          "display" : "Yomba Shoshone Tribe of the Yomba Reservation, Nevada",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11965"
            }
          ]
        },
        {
          "code" : "335",
          "display" : "Ysleta del Sur Pueblo",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11966"
            }
          ]
        },
        {
          "code" : "336",
          "display" : "Yurok Tribe of the Yurok Reservation, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11967"
            }
          ]
        },
        {
          "code" : "337",
          "display" : "Zuni Tribe of the Zuni Reservation, New Mexico",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "11968"
            }
          ]
        },
        {
          "code" : "567",
          "display" : "Chickahominy Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30003"
            }
          ]
        },
        {
          "code" : "568",
          "display" : "Chickahominy Indian Tribe—Eastern Division",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30004"
            }
          ]
        },
        {
          "code" : "569",
          "display" : "Monacan Indian Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30005"
            }
          ]
        },
        {
          "code" : "570",
          "display" : "Nansemond Indian Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30006"
            }
          ]
        },
        {
          "code" : "571",
          "display" : "Rappahannock Tribe, Inc.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30008"
            }
          ]
        },
        {
          "code" : "572",
          "display" : "Upper Mattaponi Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30009"
            }
          ]
        },
        {
          "code" : "573",
          "display" : "Cowlitz Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30010"
            }
          ]
        },
        {
          "code" : "574",
          "display" : "Little Shell Tribe of Chippewa Indians of Montana",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30011"
            }
          ]
        },
        {
          "code" : "575",
          "display" : "Mashpee Wampanoag Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30012"
            }
          ]
        },
        {
          "code" : "576",
          "display" : "Pamunkey Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30013"
            }
          ]
        },
        {
          "code" : "577",
          "display" : "Shinnecock Indian Nation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30014"
            }
          ]
        },
        {
          "code" : "578",
          "display" : "Wilton Rancheria, California",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30015"
            }
          ]
        },
        {
          "code" : "579",
          "display" : "Tejon Indian Tribe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "30016"
            }
          ]
        }
      ]
    }
  ]
}

```
