# RoleLinkStatus - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RoleLinkStatus**

## CodeSystem: RoleLinkStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-RoleLinkStatus | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RoleLinkStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1137 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Description:**Codes representing possible states of a RoleLink, as defined by the RoleLink class state machine. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [RoleLinkStatus](ValueSet-v3-RoleLinkStatus.md)
* [RoleLinkStatusActive](ValueSet-v3-RoleLinkStatusActive.md)
* [RoleLinkStatusCancelled](ValueSet-v3-RoleLinkStatusCancelled.md)
* [RoleLinkStatusCompleted](ValueSet-v3-RoleLinkStatusCompleted.md)
* [RoleLinkStatusNormal](ValueSet-v3-RoleLinkStatusNormal.md)
* [RoleLinkStatusNullified](ValueSet-v3-RoleLinkStatusNullified.md)
* [RoleLinkStatusPending](ValueSet-v3-RoleLinkStatusPending.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-RoleLinkStatus",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-RoleLinkStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1137"
    }
  ],
  "version" : "3.0.0",
  "name" : "RoleLinkStatus",
  "title" : "RoleLinkStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Description:**Codes representing possible states of a RoleLink, as defined by the RoleLink class state machine.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "NORMAL",
      "display" : "normal",
      "definition" : "**Description:** The 'typical' state. Excludes \"nullified\" which represents the termination state of a RoleLink instance that was created in error.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23254"
        }
      ],
      "concept" : [
        {
          "code" : "ACTIVE",
          "display" : "active",
          "definition" : "**Description:** The state indicates the RoleLink is in progress.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23255"
            }
          ]
        },
        {
          "code" : "CANCELLED",
          "display" : "cancelled",
          "definition" : "**Description:** The terminal state resulting from abandoning the RoleLink prior to or after activation.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23256"
            }
          ]
        },
        {
          "code" : "COMPLETED",
          "display" : "completed",
          "definition" : "**Description:** The terminal state representing the successful completion of the RoleLink.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23257"
            }
          ]
        },
        {
          "code" : "PENDING",
          "display" : "pending",
          "definition" : "**Description:** The state indicates the RoleLink has not yet become active.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23258"
            }
          ]
        }
      ]
    },
    {
      "code" : "NULLIFIED",
      "display" : "nullified",
      "definition" : "**Description:** The state representing the termination of a RoleLink instance that was created in error.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23259"
        }
      ]
    }
  ]
}

```
