# Religious Affiliation - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Religious Affiliation**

## CodeSystem: Religious Affiliation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ReligiousAffiliation | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ReligiousAffiliation |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1076 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Assigment of spiritual faith affiliation 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ReligiousAffiliation](ValueSet-v3-ReligiousAffiliation.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ReligiousAffiliation",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ReligiousAffiliation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1076"
    }
  ],
  "version" : "3.0.0",
  "name" : "ReligiousAffiliation",
  "title" : "Religious Affiliation",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Assigment of spiritual faith affiliation",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "1001",
      "display" : "Adventist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19186"
        }
      ]
    },
    {
      "code" : "1002",
      "display" : "African Religions",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19187"
        }
      ]
    },
    {
      "code" : "1003",
      "display" : "Afro-Caribbean Religions",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19188"
        }
      ]
    },
    {
      "code" : "1004",
      "display" : "Agnosticism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19189"
        }
      ]
    },
    {
      "code" : "1005",
      "display" : "Anglican",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19190"
        }
      ]
    },
    {
      "code" : "1006",
      "display" : "Animism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19191"
        }
      ]
    },
    {
      "code" : "1007",
      "display" : "Atheism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19192"
        }
      ]
    },
    {
      "code" : "1008",
      "display" : "Babi & Baha'I faiths",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19193"
        }
      ]
    },
    {
      "code" : "1009",
      "display" : "Baptist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19194"
        }
      ]
    },
    {
      "code" : "1010",
      "display" : "Bon",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19195"
        }
      ]
    },
    {
      "code" : "1011",
      "display" : "Cao Dai",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19196"
        }
      ]
    },
    {
      "code" : "1012",
      "display" : "Celticism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19197"
        }
      ]
    },
    {
      "code" : "1013",
      "display" : "Christian (non-Catholic, non-specific)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19198"
        }
      ]
    },
    {
      "code" : "1014",
      "display" : "Confucianism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19199"
        }
      ]
    },
    {
      "code" : "1015",
      "display" : "Cyberculture Religions",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19200"
        }
      ]
    },
    {
      "code" : "1016",
      "display" : "Divination",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19201"
        }
      ]
    },
    {
      "code" : "1017",
      "display" : "Fourth Way",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19202"
        }
      ]
    },
    {
      "code" : "1018",
      "display" : "Free Daism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19203"
        }
      ]
    },
    {
      "code" : "1019",
      "display" : "Gnosis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19204"
        }
      ]
    },
    {
      "code" : "1020",
      "display" : "Hinduism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19205"
        }
      ]
    },
    {
      "code" : "1021",
      "display" : "Humanism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19206"
        }
      ]
    },
    {
      "code" : "1022",
      "display" : "Independent",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19207"
        }
      ]
    },
    {
      "code" : "1023",
      "display" : "Islam",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19208"
        }
      ]
    },
    {
      "code" : "1024",
      "display" : "Jainism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19209"
        }
      ]
    },
    {
      "code" : "1025",
      "display" : "Jehovah's Witnesses",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19210"
        }
      ]
    },
    {
      "code" : "1026",
      "display" : "Judaism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19211"
        }
      ]
    },
    {
      "code" : "1027",
      "display" : "Latter Day Saints",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19212"
        }
      ]
    },
    {
      "code" : "1028",
      "display" : "Lutheran",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19213"
        }
      ]
    },
    {
      "code" : "1029",
      "display" : "Mahayana",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19214"
        }
      ]
    },
    {
      "code" : "1030",
      "display" : "Meditation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19215"
        }
      ]
    },
    {
      "code" : "1031",
      "display" : "Messianic Judaism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19216"
        }
      ]
    },
    {
      "code" : "1032",
      "display" : "Mitraism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19217"
        }
      ]
    },
    {
      "code" : "1033",
      "display" : "New Age",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19218"
        }
      ]
    },
    {
      "code" : "1034",
      "display" : "non-Roman Catholic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19219"
        }
      ]
    },
    {
      "code" : "1035",
      "display" : "Occult",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19220"
        }
      ]
    },
    {
      "code" : "1036",
      "display" : "Orthodox",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19221"
        }
      ]
    },
    {
      "code" : "1037",
      "display" : "Paganism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19222"
        }
      ]
    },
    {
      "code" : "1038",
      "display" : "Pentecostal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19223"
        }
      ]
    },
    {
      "code" : "1039",
      "display" : "Process, The",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19224"
        }
      ]
    },
    {
      "code" : "1040",
      "display" : "Reformed/Presbyterian",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19225"
        }
      ]
    },
    {
      "code" : "1041",
      "display" : "Roman Catholic Church",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19226"
        }
      ]
    },
    {
      "code" : "1042",
      "display" : "Satanism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19227"
        }
      ]
    },
    {
      "code" : "1043",
      "display" : "Scientology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19228"
        }
      ]
    },
    {
      "code" : "1044",
      "display" : "Shamanism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19229"
        }
      ]
    },
    {
      "code" : "1045",
      "display" : "Shiite (Islam)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19230"
        }
      ]
    },
    {
      "code" : "1046",
      "display" : "Shinto",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19231"
        }
      ]
    },
    {
      "code" : "1047",
      "display" : "Sikism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19232"
        }
      ]
    },
    {
      "code" : "1048",
      "display" : "Spiritualism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19233"
        }
      ]
    },
    {
      "code" : "1049",
      "display" : "Sunni (Islam)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19234"
        }
      ]
    },
    {
      "code" : "1050",
      "display" : "Taoism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19235"
        }
      ]
    },
    {
      "code" : "1051",
      "display" : "Theravada",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19236"
        }
      ]
    },
    {
      "code" : "1052",
      "display" : "Unitarian-Universalism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19237"
        }
      ]
    },
    {
      "code" : "1053",
      "display" : "Universal Life Church",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19238"
        }
      ]
    },
    {
      "code" : "1054",
      "display" : "Vajrayana (Tibetan)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19239"
        }
      ]
    },
    {
      "code" : "1055",
      "display" : "Veda",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19240"
        }
      ]
    },
    {
      "code" : "1056",
      "display" : "Voodoo",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19241"
        }
      ]
    },
    {
      "code" : "1057",
      "display" : "Wicca",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19242"
        }
      ]
    },
    {
      "code" : "1058",
      "display" : "Yaohushua",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19243"
        }
      ]
    },
    {
      "code" : "1059",
      "display" : "Zen Buddhism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19244"
        }
      ]
    },
    {
      "code" : "1060",
      "display" : "Zoroastrianism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19245"
        }
      ]
    },
    {
      "code" : "1061",
      "display" : "Assembly of God",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21466"
        }
      ]
    },
    {
      "code" : "1062",
      "display" : "Brethren",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21467"
        }
      ]
    },
    {
      "code" : "1063",
      "display" : "Christian Scientist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21468"
        }
      ]
    },
    {
      "code" : "1064",
      "display" : "Church of Christ",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21469"
        }
      ]
    },
    {
      "code" : "1065",
      "display" : "Church of God",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21470"
        }
      ]
    },
    {
      "code" : "1066",
      "display" : "Congregational",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21471"
        }
      ]
    },
    {
      "code" : "1067",
      "display" : "Disciples of Christ",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21472"
        }
      ]
    },
    {
      "code" : "1068",
      "display" : "Eastern Orthodox",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21473"
        }
      ]
    },
    {
      "code" : "1069",
      "display" : "Episcopalian",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21474"
        }
      ]
    },
    {
      "code" : "1070",
      "display" : "Evangelical Covenant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21475"
        }
      ]
    },
    {
      "code" : "1071",
      "display" : "Friends",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21476"
        }
      ]
    },
    {
      "code" : "1072",
      "display" : "Full Gospel",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21477"
        }
      ]
    },
    {
      "code" : "1073",
      "display" : "Methodist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21478"
        }
      ]
    },
    {
      "code" : "1074",
      "display" : "Native American",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21479"
        }
      ]
    },
    {
      "code" : "1075",
      "display" : "Nazarene",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21480"
        }
      ]
    },
    {
      "code" : "1076",
      "display" : "Presbyterian",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21481"
        }
      ]
    },
    {
      "code" : "1077",
      "display" : "Protestant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21482"
        }
      ]
    },
    {
      "code" : "1078",
      "display" : "Protestant, No Denomination",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21483"
        }
      ]
    },
    {
      "code" : "1079",
      "display" : "Reformed",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21484"
        }
      ]
    },
    {
      "code" : "1080",
      "display" : "Salvation Army",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21485"
        }
      ]
    },
    {
      "code" : "1081",
      "display" : "Unitarian Universalist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21486"
        }
      ]
    },
    {
      "code" : "1082",
      "display" : "United Church of Christ",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21487"
        }
      ]
    }
  ]
}

```
