# ParticipationType - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ParticipationType**

## CodeSystem: ParticipationType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ParticipationType | *Version*:5.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ParticipationType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.90 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A code specifying the meaning and purpose of every Participation instance. Each of its values implies specific constraints on the Roles undertaking the participation. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [FHIRClinicalDocInformationRecipientVs](ValueSet-fhir-clinical-doc-information-recipient.md)
* [FHIRClinicalDocParticipantVs](ValueSet-fhir-clinical-doc-participant.md)
* [ParticipationAdmitter](ValueSet-v3-ParticipationAdmitter.md)
* [ParticipationAnalyte](ValueSet-v3-ParticipationAnalyte.md)
* [ParticipationAncillary](ValueSet-v3-ParticipationAncillary.md)
* [ParticipationAttender](ValueSet-v3-ParticipationAttender.md)
* [ParticipationAuthenticator](ValueSet-v3-ParticipationAuthenticator.md)
* [ParticipationAuthorOriginator](ValueSet-v3-ParticipationAuthorOriginator.md)
* [ParticipationBaby](ValueSet-v3-ParticipationBaby.md)
* [ParticipationBeneficiary](ValueSet-v3-ParticipationBeneficiary.md)
* [ParticipationCallbackContact](ValueSet-v3-ParticipationCallbackContact.md)
* [ParticipationCatalyst](ValueSet-v3-ParticipationCatalyst.md)
* [ParticipationCausativeAgent](ValueSet-v3-ParticipationCausativeAgent.md)
* [ParticipationConsultant](ValueSet-v3-ParticipationConsultant.md)
* [ParticipationConsumable](ValueSet-v3-ParticipationConsumable.md)
* [ParticipationCoverageTarget](ValueSet-v3-ParticipationCoverageTarget.md)
* [ParticipationCustodian](ValueSet-v3-ParticipationCustodian.md)
* [ParticipationDataEntryPerson](ValueSet-v3-ParticipationDataEntryPerson.md)
* [ParticipationDestination](ValueSet-v3-ParticipationDestination.md)
* [ParticipationDischarger](ValueSet-v3-ParticipationDischarger.md)
* [ParticipationDistributor](ValueSet-v3-ParticipationDistributor.md)
* [ParticipationDonor](ValueSet-v3-ParticipationDonor.md)
* [ParticipationEntryLocation](ValueSet-v3-ParticipationEntryLocation.md)
* [ParticipationEscort](ValueSet-v3-ParticipationEscort.md)
* [ParticipationExposureagent](ValueSet-v3-ParticipationExposureagent.md)
* [ParticipationExposureparticipation](ValueSet-v3-ParticipationExposureparticipation.md)
* [ParticipationExposuresource](ValueSet-v3-ParticipationExposuresource.md)
* [ParticipationExposuretarget](ValueSet-v3-ParticipationExposuretarget.md)
* [ParticipationGuarantorParty](ValueSet-v3-ParticipationGuarantorParty.md)
* [ParticipationHolder](ValueSet-v3-ParticipationHolder.md)
* [ParticipationIndirectTarget](ValueSet-v3-ParticipationIndirectTarget.md)
* [ParticipationInformant](ValueSet-v3-ParticipationInformant.md)
* [ParticipationInformationGenerator](ValueSet-v3-ParticipationInformationGenerator.md)
* [ParticipationInformationRecipient](ValueSet-v3-ParticipationInformationRecipient.md)
* [ParticipationInformationTranscriber](ValueSet-v3-ParticipationInformationTranscriber.md)
* [ParticipationLegalAuthenticator](ValueSet-v3-ParticipationLegalAuthenticator.md)
* [ParticipationNonReuseableDevice](ValueSet-v3-ParticipationNon-reuseableDevice.md)
* [ParticipationOrigin](ValueSet-v3-ParticipationOrigin.md)
* [ParticipationParticipation](ValueSet-v3-ParticipationParticipation.md)
* [ParticipationPhysicalPerformer](ValueSet-v3-ParticipationPhysicalPerformer.md)
* [ParticipationPrimaryInformationRecipient](ValueSet-v3-ParticipationPrimaryInformationRecipient.md)
* [ParticipationPrimaryPerformer](ValueSet-v3-ParticipationPrimaryPerformer.md)
* [ParticipationProduct](ValueSet-v3-ParticipationProduct.md)
* [ParticipationReceiver](ValueSet-v3-ParticipationReceiver.md)
* [ParticipationRecordTarget](ValueSet-v3-ParticipationRecordTarget.md)
* [ParticipationReferredBy](ValueSet-v3-ParticipationReferredBy.md)
* [ParticipationReferredTo](ValueSet-v3-ParticipationReferredTo.md)
* [ParticipationReferrer](ValueSet-v3-ParticipationReferrer.md)
* [ParticipationRemote](ValueSet-v3-ParticipationRemote.md)
* [ParticipationResponsibleParty](ValueSet-v3-ParticipationResponsibleParty.md)
* [ParticipationReusableDevice](ValueSet-v3-ParticipationReusableDevice.md)
* [ParticipationSecondaryPerformer](ValueSet-v3-ParticipationSecondaryPerformer.md)
* [ParticipationSpecimen](ValueSet-v3-ParticipationSpecimen.md)
* [ParticipationTargetDevice](ValueSet-v3-ParticipationTargetDevice.md)
* [ParticipationTargetDirect](ValueSet-v3-ParticipationTargetDirect.md)
* [ParticipationTargetLocation](ValueSet-v3-ParticipationTargetLocation.md)
* [ParticipationTargetSubject](ValueSet-v3-ParticipationTargetSubject.md)
* [ParticipationTracker](ValueSet-v3-ParticipationTracker.md)
* [ParticipationType](ValueSet-v3-ParticipationType.md)
* [ParticipationTypeCDASectionOverride](ValueSet-v3-ParticipationTypeCDASectionOverride.md)
* [ParticipationUgentNotificationContact](ValueSet-v3-ParticipationUgentNotificationContact.md)
* [ParticipationVerifier](ValueSet-v3-ParticipationVerifier.md)
* [ParticipationVia](ValueSet-v3-ParticipationVia.md)
* [ParticipationWitness](ValueSet-v3-ParticipationWitness.md)
* [ReactionParticipant](ValueSet-v3-ReactionParticipant.md)
* [XEncounterParticipant](ValueSet-v3-xEncounterParticipant.md)
* [XEncounterPerformerParticipation](ValueSet-v3-xEncounterPerformerParticipation.md)
* [XInformationRecipient](ValueSet-v3-xInformationRecipient.md)
* [XParticipationAuthorPerformer](ValueSet-v3-xParticipationAuthorPerformer.md)
* [XParticipationEntVrf](ValueSet-v3-xParticipationEntVrf.md)
* [XParticipationPrfEntVrf](ValueSet-v3-xParticipationPrfEntVrf.md)
* [XParticipationVrfRespSprfWit](ValueSet-v3-xParticipationVrfRespSprfWit.md)
* [XServiceEventPerformer](ValueSet-v3-xServiceEventPerformer.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ParticipationType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.90"
    }
  ],
  "version" : "5.0.0",
  "name" : "ParticipationType",
  "title" : "ParticipationType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A code specifying the meaning and purpose of every Participation instance. Each of its values implies specific constraints on the Roles undertaking the participation.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "conductible",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-conductible",
      "description" : "If true, indicates that ActRelationships or Participations of the specified type (and any specializations thereof) will normally conduct. For more usage information, refer to the Core Principles specification.",
      "type" : "boolean"
    },
    {
      "code" : "Name:Act:participation:Participation",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-participation",
      "description" : "Name of relationship from Act to Participation",
      "type" : "string"
    },
    {
      "code" : "Name:Role:participation:Participation",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Role-participation",
      "description" : "Name of relationship from Role to Participation",
      "type" : "string"
    },
    {
      "code" : "Sort:Act:participation:Participation",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Act-participation-sort",
      "description" : "Sort key for relationship from Act to Participation",
      "type" : "string"
    },
    {
      "code" : "Sort:Role:participation:Participation",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Role-participation-sort",
      "description" : "Sort key for relationship from Role to Participation",
      "type" : "string"
    },
    {
      "code" : "isDocumentCharacteristic",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-document-characteristic",
      "description" : "If true, indicates that the Act attribute or association (as represented by a typeCode for eaither ActRelationship or Pareticipation is a descriptor of the document (record) represented by the act object. If false, indicates the property is a descriptor of the action itself, actual, intended, or potential.  Applies to interpretation of attributes and associations with respect to changes in the value of Act.actionNegationInd and Act.moodCode. (See descriptions of these attributes for further discussion.) For example, in an order, the id attribute [isDocumentCharacteristic = true] is an identifier of the record of the order, not an identifier of the intended event.  On the other hand, the code attribute [isDocumentCharacteristic = false] describes a characteristic of the intended event.",
      "type" : "boolean"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "PART",
      "display" : "Participation",
      "definition" : "Indicates that the target of the participation is involved in some manner in the act, but does not qualify how.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21573"
        }
      ],
      "concept" : [
        {
          "code" : "_ParticipationAncillary",
          "display" : "ParticipationAncillary",
          "definition" : "Participations related, but not primary to an act. The Referring, Admitting, and Discharging practitioners must be the same person as those authoring the ControlAct event for their respective trigger events.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21110"
            },
            {
              "code" : "conductible",
              "valueBoolean" : false
            },
            {
              "code" : "Name:Act:participation:Participation",
              "valueString" : "ancillaryRole"
            },
            {
              "code" : "Name:Role:participation:Participation",
              "valueString" : "participation"
            },
            {
              "code" : "Sort:Act:participation:Participation",
              "valueString" : "F________"
            },
            {
              "code" : "Sort:Role:participation:Participation",
              "valueString" : "F________"
            }
          ],
          "concept" : [
            {
              "code" : "ADM",
              "display" : "admitter",
              "definition" : "The practitioner who is responsible for admitting a patient to a patient encounter.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "16845"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "admitter"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "admission"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "FA_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "FA_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : false
                }
              ]
            },
            {
              "code" : "ATND",
              "display" : "attender",
              "definition" : "The practitioner that has responsibility for overseeing a patient's care during a patient encounter.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "16843"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "attender"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "attenderOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "FB_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "FB_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : false
                }
              ]
            },
            {
              "code" : "CALLBCK",
              "display" : "callback contact",
              "definition" : "A person or organization who should be contacted for follow-up questions about the act in place of the author.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21385"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "callBackContact"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "callBackAvailability"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "FF_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "FF_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : false
                }
              ]
            },
            {
              "code" : "CON",
              "display" : "consultant",
              "definition" : "An advisor participating in the service by performing evaluations and making recommendations.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10256"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "consultant"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "consultation"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "FE_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "FE_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : false
                }
              ]
            },
            {
              "code" : "DIS",
              "display" : "discharger",
              "definition" : "The practitioner who is responsible for the discharge of a patient from a patient encounter.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "16844"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "discharger"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "discharge"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "FC_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "FC_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : false
                }
              ]
            },
            {
              "code" : "ESC",
              "display" : "escort",
              "definition" : "Only with Transportation services. A person who escorts the patient.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10250"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "escort"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "escort"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "FG_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "FG_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : false
                }
              ]
            },
            {
              "code" : "REF",
              "display" : "referrer",
              "definition" : "A person having referred the subject of the service to the performer (referring physician). Typically, a referring physician will receive a report.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10264"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "referrer"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "referral"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "FD_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "FD_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : false
                }
              ]
            }
          ]
        },
        {
          "code" : "_ParticipationInformationGenerator",
          "display" : "ParticipationInformationGenerator",
          "definition" : "Parties that may or should contribute or have contributed information to the Act. Such information includes information leading to the decision to perform the Act and how to perform the Act (e.g., consultant), information that the Act itself seeks to reveal (e.g., informant of clinical history), or information about what Act was performed (e.g., informant witness).",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21111"
            },
            {
              "code" : "conductible",
              "valueBoolean" : true
            },
            {
              "code" : "isDocumentCharacteristic",
              "valueBoolean" : true
            },
            {
              "code" : "Name:Act:participation:Participation",
              "valueString" : "informationOriginator"
            },
            {
              "code" : "Name:Role:participation:Participation",
              "valueString" : "origination"
            },
            {
              "code" : "Sort:Act:participation:Participation",
              "valueString" : "E________"
            },
            {
              "code" : "Sort:Role:participation:Participation",
              "valueString" : "E________"
            }
          ],
          "concept" : [
            {
              "code" : "AUT",
              "display" : "author (originator)",
              "definition" : "**Definition:** A party that originates the Act and therefore has responsibility for the information given in the Act and ownership of this Act.\r\n\r\n**Example:** the report writer, the person writing the act definition, the guideline author, the placer of an order, the EKG cart (device) creating a report etc. Every Act should have an author. Authorship is regardless of mood always actual authorship.\r\n\r\nExamples of such policies might include:\r\n\r\n *  The author and anyone they explicitly delegate may update the report;\r\n *  All administrators within the same clinic may cancel and reschedule appointments created by other administrators within that clinic;\r\n\r\nA party that is neither an author nor a party who is extended authorship maintenance rights by policy, may only amend, reverse, override, replace, or follow up in other ways on this Act, whereby the Act remains intact and is linked to another Act authored by that other party.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10252"
                },
                {
                  "code" : "isDocumentCharacteristic",
                  "valueBoolean" : true
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "author"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "origination"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "EA_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "EA_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "INF",
              "display" : "informant",
              "definition" : "A source of reported information (e.g., a next of kin who answers questions about the patient's history). For history questions, the patient is logically an informant, yet the informant of history questions is implicitly the subject.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10254"
                },
                {
                  "code" : "isDocumentCharacteristic",
                  "valueBoolean" : true
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "informant"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "informationGiven"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "EC_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "EC_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "TRANS",
              "display" : "Transcriber",
              "definition" : "An entity entering the data into the originating system. The data entry entity is collected optionally for internal quality control purposes. This includes the transcriptionist for dictated text transcribed into electronic form.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21463"
                },
                {
                  "code" : "isDocumentCharacteristic",
                  "valueBoolean" : true
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "transcriber"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "transcription"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "EB_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "EB_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ],
              "concept" : [
                {
                  "code" : "ENT",
                  "display" : "data entry person",
                  "definition" : "A person entering the data into the originating system. The data entry person is collected optionally for internal quality control purposes. This includes the transcriptionist for dictated text.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10253"
                    },
                    {
                      "code" : "isDocumentCharacteristic",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "Name:Act:participation:Participation",
                      "valueString" : "dataEnterer"
                    },
                    {
                      "code" : "Name:Role:participation:Participation",
                      "valueString" : "dataEntry"
                    },
                    {
                      "code" : "Sort:Act:participation:Participation",
                      "valueString" : "EBB______"
                    },
                    {
                      "code" : "Sort:Role:participation:Participation",
                      "valueString" : "EBB______"
                    },
                    {
                      "code" : "conductible",
                      "valueBoolean" : true
                    }
                  ]
                }
              ]
            },
            {
              "code" : "WIT",
              "display" : "witness",
              "definition" : "Only with service events. A person witnessing the action happening without doing anything. A witness is not necessarily aware, much less approves of anything stated in the service event. Example for a witness is students watching an operation or an advanced directive witness.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10260"
                },
                {
                  "code" : "isDocumentCharacteristic",
                  "valueBoolean" : true
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "witness"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "witness"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "ED_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "ED_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "NOTARY",
              "display" : "notary",
              "definition" : "The entity (person or organization) who legally attests that the information present in the Act is a true replica of an original.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "110260"
                },
                {
                  "code" : "isDocumentCharacteristic",
                  "valueBoolean" : true
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "notary"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "notarization"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "EE_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "EE_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            }
          ]
        },
        {
          "code" : "CST",
          "display" : "custodian",
          "definition" : "An entity (person, organization or device) that is in charge of maintaining the information of this act (e.g., who maintains the report or the master service catalog item, etc.).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10266"
            },
            {
              "code" : "conductible",
              "valueBoolean" : true
            },
            {
              "code" : "isDocumentCharacteristic",
              "valueBoolean" : true
            },
            {
              "code" : "Name:Act:participation:Participation",
              "valueString" : "custodian"
            },
            {
              "code" : "Name:Role:participation:Participation",
              "valueString" : "custodianship"
            },
            {
              "code" : "Sort:Act:participation:Participation",
              "valueString" : "G________"
            },
            {
              "code" : "Sort:Role:participation:Participation",
              "valueString" : "G________"
            }
          ]
        },
        {
          "code" : "DIR",
          "display" : "direct target",
          "definition" : "Target participant that is substantially present in the act and which is directly involved in the action (includes consumed material, devices, etc.).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10286"
            },
            {
              "code" : "conductible",
              "valueBoolean" : true
            },
            {
              "code" : "Name:Act:participation:Participation",
              "valueString" : "directTarget"
            },
            {
              "code" : "Name:Role:participation:Participation",
              "valueString" : "directTargetOf"
            },
            {
              "code" : "Sort:Act:participation:Participation",
              "valueString" : "A________"
            },
            {
              "code" : "Sort:Role:participation:Participation",
              "valueString" : "A________"
            }
          ],
          "concept" : [
            {
              "code" : "ALY",
              "display" : "analyte",
              "definition" : "The target of an Observation action. Links an observation to a Role whose player is the substance or most specific component entity (material, micro-organism, etc.) being measured within the subject.\r\n\r\n*Examples:* A \"plasma porcelain substance concentration\" has analyte a Role with player substance Entity \"porcelain\".\r\n\r\n*UsageNotes:* The Role that this participation connects to may be any Role whose player is that substance measured. Very often, the scoper may indicate the system in which the component is being measured. E.g., for \"plasma porcelain\" the scoper could be \"Plasma\".",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "HL7usageNotes",
                  "valueString" : "The Role that this participation connects to may be any Role whose player is that substance measured. Very often, the scoper may indicate the system in which the component is being measured. E.g., for \"plasma porcelain\" the scoper could be \"Plasma\"."
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23093"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "analyte"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "analyzedBy"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "AAB______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "AAB______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "BBY",
              "display" : "baby",
              "definition" : "In an obstetric service, the baby.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10293"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "baby"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "babyOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "AB_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "AB_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "CAT",
              "display" : "catalyst",
              "definition" : "The catalyst of a chemical reaction, such as an enzyme or a platinum surface. In biochemical reactions, connects the enzyme with the molecular interaction",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "23094"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "catalyst"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "catalystOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "AA_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "AA_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "CSM",
              "display" : "consumable",
              "definition" : "Participant material that is taken up, diminished, altered, or disappears in the act.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10296"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "consumable"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "consumedIn"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "AE_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "AE_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ],
              "concept" : [
                {
                  "code" : "TPA",
                  "display" : "therapeutic agent",
                  "definition" : "Something incorporated in the subject of a therapy service to achieve a physiologic effect (e.g., heal, relieve, provoke a condition, etc.) on the subject. In an administration service the therapeutic agent is a consumable, in a preparation or dispense service, it is a product. Thus, consumable or product must be specified in accordance with the kind of service.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "retired"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10297"
                    },
                    {
                      "code" : "conductible",
                      "valueBoolean" : true
                    }
                  ]
                }
              ]
            },
            {
              "code" : "DEV",
              "display" : "device",
              "definition" : "Participant used in performing the act without being substantially affected by the act (i.e. durable or inert with respect to that particular service).\r\n\r\n*Examples:* monitoring equipment, tools, but also access/drainage lines, prostheses, pace maker, etc.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10298"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "device"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "deviceOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "AD_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "AD_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ],
              "concept" : [
                {
                  "code" : "NRD",
                  "display" : "non-reuseable device",
                  "definition" : "A device that changes ownership due to the service, e.g., a pacemaker, a prosthesis, an insulin injection equipment (pen), etc. Such material may need to be restocked after he service.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10299"
                    },
                    {
                      "code" : "Name:Act:participation:Participation",
                      "valueString" : "nonReusableDevice"
                    },
                    {
                      "code" : "Name:Role:participation:Participation",
                      "valueString" : "nonReusableDeviceOf"
                    },
                    {
                      "code" : "Sort:Act:participation:Participation",
                      "valueString" : "ADB______"
                    },
                    {
                      "code" : "Sort:Role:participation:Participation",
                      "valueString" : "ADB______"
                    },
                    {
                      "code" : "conductible",
                      "valueBoolean" : true
                    }
                  ]
                },
                {
                  "code" : "RDV",
                  "display" : "reusable device",
                  "definition" : "A device that does not change ownership due to the service, i.e., a surgical instrument or tool or an endoscope. The distinction between reuseable and non-reuseable must be made in order to know whether material must be re-stocked.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10300"
                    },
                    {
                      "code" : "Name:Act:participation:Participation",
                      "valueString" : "reusableDevice"
                    },
                    {
                      "code" : "Name:Role:participation:Participation",
                      "valueString" : "reusableDeviceOf"
                    },
                    {
                      "code" : "Sort:Act:participation:Participation",
                      "valueString" : "ADA______"
                    },
                    {
                      "code" : "Sort:Role:participation:Participation",
                      "valueString" : "ADA______"
                    },
                    {
                      "code" : "conductible",
                      "valueBoolean" : true
                    }
                  ]
                }
              ]
            },
            {
              "code" : "DON",
              "display" : "donor",
              "definition" : "In some organ transplantation services and rarely in transfusion services a donor will be a target participant in the service. However, in most cases transplantation is decomposed in three services: explantation, transport, and implantation. The identity of the donor (recipient) is often irrelevant for the explantation (implantation) service.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10291"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "organDonor"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "organDonation"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "AC_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "AC_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "EXPAGNT",
              "display" : "ExposureAgent",
              "definition" : "**Description:** The entity playing the associated role is the physical (including energy), chemical or biological substance that is participating in the exposure. For example in communicable diseases, the associated playing entity is the disease causing pathogen.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22347"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "EXPART",
              "display" : "ExposureParticipation",
              "definition" : "**Description:**Direct participation in an exposure act where it is unknown that the participant is the source or subject of the exposure. If the participant is known to be the contact of an exposure then the SBJ participation type should be used. If the participant is known to be the source then the EXSRC participation type should be used.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21978"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ],
              "concept" : [
                {
                  "code" : "EXPTRGT",
                  "display" : "ExposureTarget",
                  "definition" : "**Description:** The entity playing the associated role is the target (contact) of exposure.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22346"
                    },
                    {
                      "code" : "conductible",
                      "valueBoolean" : true
                    }
                  ]
                },
                {
                  "code" : "EXSRC",
                  "display" : "ExposureSource",
                  "definition" : "**Description:**The entity playing the associated role is the source of exposure.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21979"
                    },
                    {
                      "code" : "conductible",
                      "valueBoolean" : true
                    }
                  ]
                }
              ]
            },
            {
              "code" : "PRD",
              "display" : "product",
              "definition" : "Participant material that is brought forth (produced) in the act (e.g., specimen in a specimen collection, access or drainage in a placement service, medication package in a dispense service). It does not matter whether the material produced had existence prior to the service, or whether it is created in the service (e.g., in supply services the product is taken from a stock).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10295"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "product"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "productOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "AF_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "AF_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "SBJ",
              "display" : "subject",
              "definition" : "The principle target on which the action happens.\r\n\r\n*Examples:* The patient in physical examination, a specimen in a lab observation. May also be a patient's family member (teaching) or a device or room (cleaning, disinfecting, housekeeping).\r\n\r\n*UsageNotes:* Not all direct targets are subjects. Consumables and devices used as tools for an act are not subjects. However, a device may be a subject of a maintenance action.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "HL7usageNotes",
                  "valueString" : "Not all direct targets are subjects. Consumables and devices used as tools for an act are not subjects. However, a device may be a subject of a maintenance action."
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10287"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "subject"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "subjectOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "AA_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "AA_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ],
              "concept" : [
                {
                  "code" : "SPC",
                  "display" : "specimen",
                  "definition" : "The subject of non-clinical (e.g. laboratory) observation services is a specimen.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10294"
                    },
                    {
                      "code" : "Name:Act:participation:Participation",
                      "valueString" : "specimen"
                    },
                    {
                      "code" : "Name:Role:participation:Participation",
                      "valueString" : "specimenOf"
                    },
                    {
                      "code" : "Sort:Act:participation:Participation",
                      "valueString" : "AAA______"
                    },
                    {
                      "code" : "Sort:Role:participation:Participation",
                      "valueString" : "AAA______"
                    },
                    {
                      "code" : "conductible",
                      "valueBoolean" : true
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "IND",
          "display" : "indirect target",
          "definition" : "Target that is not substantially present in the act and which is not directly affected by the act, but which will be a focus of the record or documentation of the act.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19032"
            },
            {
              "code" : "conductible",
              "valueBoolean" : true
            },
            {
              "code" : "Name:Act:participation:Participation",
              "valueString" : "indirectTarget"
            },
            {
              "code" : "Name:Role:participation:Participation",
              "valueString" : "indirectTargetOf"
            },
            {
              "code" : "Sort:Act:participation:Participation",
              "valueString" : "B________"
            },
            {
              "code" : "Sort:Role:participation:Participation",
              "valueString" : "B________"
            }
          ],
          "concept" : [
            {
              "code" : "BEN",
              "display" : "beneficiary",
              "definition" : "Target on behalf of whom the service happens, but that is not necessarily present in the service. Can occur together with direct target to indicate that a target is both, as in the case where the patient is the indirect beneficiary of a service rendered to a family member, e.g. counseling or given home care instructions. This concept includes a participant, such as a covered party, who derives benefits from a service act covered by a coverage act.\r\n\r\nNote that the semantic role of the intended recipient who benefits from the happening denoted by the verb in the clause. Thus, a patient who has no coverage under a policy or program may be a beneficiary of a health service while not being the beneficiary of coverage for that service.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10288"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "beneficiary"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "beneficiaryOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "BC_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "BC_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "CAGNT",
              "display" : "causative agent",
              "definition" : "Definition: A factor, such as a microorganism, chemical substance, or form of radiation, whose presence, excessive presence, or (in deficiency diseases) relative absence is essential, in whole or in part, for the occurrence of a condition.\r\n\r\nConstraint: The use of this participation is limited to observations.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21639"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "COV",
              "display" : "coverage target",
              "definition" : "The target participation for an individual in a health care coverage act in which the target role is either the policy holder of the coverage, or a covered party under the coverage.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14017"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "coveredParty"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "coveredPartyOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "BB_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "BB_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "GUAR",
              "display" : "guarantor party",
              "definition" : "The target person or organization contractually recognized by the issuer as a participant who has assumed fiscal responsibility for another personaTMs financial obligations by guaranteeing to pay for amounts owed to a particular account\r\n\r\n*Example:*The subscriber of the patientaTMs health insurance policy signs a contract with the provider to be fiscally responsible for the patient billing account balance amount owed.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21570"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "HLD",
              "display" : "holder",
              "definition" : "Participant who posses an instrument such as a financial contract (insurance policy) usually based on some agreement with the author.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "16751"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "holder"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "contractHeld"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "BE_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "BE_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "RCT",
              "display" : "record target",
              "definition" : "The record target indicates whose medical record holds the documentation of this act. This is especially important when the subject of a service is not the patient himself.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10289"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "recordTarget"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "recordTargetOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "BA_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "BA_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "RCV",
              "display" : "receiver",
              "definition" : "The person (or organization) who receives the product of an Act.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "13974"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "receiver"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "receiverOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "BD_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "BD_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            }
          ]
        },
        {
          "code" : "IRCP",
          "display" : "information recipient",
          "definition" : "A party, who may or should receive or who has recieved the Act or subsequent or derivative information of that Act. Information recipient is inert, i.e., independent of mood.\" Rationale: this is a generalization of a too diverse family that the definition can't be any more specific, and the concept is abstract so one of the specializations should be used.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10263"
            },
            {
              "code" : "conductible",
              "valueBoolean" : true
            },
            {
              "code" : "isDocumentCharacteristic",
              "valueBoolean" : true
            },
            {
              "code" : "Name:Act:participation:Participation",
              "valueString" : "informationRecipient"
            },
            {
              "code" : "Name:Role:participation:Participation",
              "valueString" : "informationReceived"
            },
            {
              "code" : "Sort:Act:participation:Participation",
              "valueString" : "H________"
            },
            {
              "code" : "Sort:Role:participation:Participation",
              "valueString" : "H________"
            }
          ],
          "concept" : [
            {
              "code" : "NOT",
              "display" : "ugent notification contact",
              "definition" : "An information recipient to notify for urgent matters about this Act. (e.g., in a laboratory order, critical results are being called by phone right away, this is the contact to call; or for an inpatient encounter, a next of kin to notify when the patient becomes critically ill).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "19057"
                },
                {
                  "code" : "isDocumentCharacteristic",
                  "valueBoolean" : true
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "notificationContact"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "contactFor"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "HE_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "HE_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "PRCP",
              "display" : "primary information recipient",
              "definition" : "Information recipient to whom an act statement is primarily directed. E.g., a primary care provider receiving a discharge letter from a hospitalist, a health department receiving information on a suspected case of infectious disease. Multiple of these participations may exist on the same act without requiring that recipients be ranked as primary vs. secondary.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "19055"
                },
                {
                  "code" : "isDocumentCharacteristic",
                  "valueBoolean" : true
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "primaryInformationRecipient"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "informationReceived"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "HA_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "HA_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "REFB",
              "display" : "Referred By",
              "definition" : "A participant (e.g. provider) who has referred the subject of an act (e.g. patient).\r\n\r\nTypically, a referred by participant will provide a report (e.g. referral).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20842"
                },
                {
                  "code" : "isDocumentCharacteristic",
                  "valueBoolean" : true
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "subjectReferrer"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "subjectReferral"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "HC_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "HC_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "REFT",
              "display" : "Referred to",
              "definition" : "The person who receives the patient",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18116"
                },
                {
                  "code" : "isDocumentCharacteristic",
                  "valueBoolean" : true
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "subjectReferredTo"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "referral"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "HD_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "HD_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "TRC",
              "display" : "tracker",
              "definition" : "A secondary information recipient, who receives copies (e.g., a primary care provider receiving copies of results as ordered by specialist).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10265"
                },
                {
                  "code" : "isDocumentCharacteristic",
                  "valueBoolean" : true
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "tracker"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "tracking"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "HB_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "HB_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            }
          ]
        },
        {
          "code" : "LOC",
          "display" : "location",
          "definition" : "The facility where the service is done. May be a static building (or room therein) or a moving location (e.g., ambulance, helicopter, aircraft, train, truck, ship, etc.)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10302"
            },
            {
              "code" : "conductible",
              "valueBoolean" : true
            },
            {
              "code" : "Name:Act:participation:Participation",
              "valueString" : "location"
            },
            {
              "code" : "Name:Role:participation:Participation",
              "valueString" : "locationOf"
            },
            {
              "code" : "Sort:Act:participation:Participation",
              "valueString" : "J________"
            },
            {
              "code" : "Sort:Role:participation:Participation",
              "valueString" : "J________"
            }
          ],
          "concept" : [
            {
              "code" : "DST",
              "display" : "destination",
              "definition" : "The destination for services. May be a static building (or room therein) or a movable facility (e.g., ship).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10304"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "destination"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "destinationOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "JC_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "JC_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "ELOC",
              "display" : "entry location",
              "definition" : "A location where data about an Act was entered.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "13973"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "dataEntryLocation"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "dataEntryLocationOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "JD_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "JD_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "ORG",
              "display" : "origin",
              "definition" : "The location of origin for services. May be a static building (or room therein) or a movable facility (e.g., ship).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10303"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "origin"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "originOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "JA_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "JA_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "RML",
              "display" : "remote",
              "definition" : "Some services take place at multiple concurrent locations (e.g., telemedicine, telephone consultation). The location where the principal performing actor is located is taken as the primary location (LOC) while the other location(s) are considered \"remote.\"",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10306"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "remoteLocation"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "remoteLocationOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "JE_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "JE_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "VIA",
              "display" : "via",
              "definition" : "For services, an intermediate location that specifies a path between origin an destination.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10305"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "via"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "viaOf"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "JB_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "JB_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            }
          ]
        },
        {
          "code" : "PRF",
          "display" : "performer",
          "definition" : "**Definition:** A person, non-person living subject, organization or device that who actually and principally carries out the action. Device should only be assigned as a performer in circumstances where the device is performing independent of human intervention. Need not be the principal responsible actor.\r\n\r\n**Exampe:** A surgery resident operating under supervision of attending surgeon, a search and rescue dog locating survivors, an electronic laboratory analyzer or the laboratory discipline requested to perform a laboratory test. The performer may also be the patient in self-care, e.g. fingerstick blood sugar. The traditional order filler is a performer. This information should accompany every service event.\r\n\r\n**Note:** that existing HL7 designs assign an organization as the playing entity of the Role that is the performer. These designs should be revised in subsequent releases to make this the scooping entity for the role involved.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10248"
            },
            {
              "code" : "conductible",
              "valueBoolean" : true
            },
            {
              "code" : "Name:Act:participation:Participation",
              "valueString" : "performer"
            },
            {
              "code" : "Name:Role:participation:Participation",
              "valueString" : "performance"
            },
            {
              "code" : "Sort:Act:participation:Participation",
              "valueString" : "D________"
            },
            {
              "code" : "Sort:Role:participation:Participation",
              "valueString" : "D________"
            }
          ],
          "concept" : [
            {
              "code" : "DIST",
              "display" : "distributor",
              "definition" : "Distributes material used in or generated during the act.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "19063"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "distributer"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "distributed"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "DC_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "DC_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "PPRF",
              "display" : "primary performer",
              "definition" : "The principal or primary performer of the act.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "19064"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "primaryPerformer"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "performance"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "DA_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "DA_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "SPRF",
              "display" : "secondary performer",
              "definition" : "A person assisting in an act through his substantial presence and involvement This includes: assistants, technicians, associates, or whatever the job titles may be.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "19065"
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "secondaryPerformer"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "performance"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "DB_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "DB_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            }
          ]
        },
        {
          "code" : "RESP",
          "display" : "responsible party",
          "definition" : "The person or organization that has primary responsibility for the act. The responsible party is not necessarily present in an action, but is accountable for the action through the power to delegate, and the duty to review actions with the performing actor after the fact. This responsibility may be ethical, legal, contractual, fiscal, or fiduciary in nature.\r\n\r\n*Example:* A person who is the head of a biochemical laboratory; a sponsor for a policy or government program.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "17931"
            },
            {
              "code" : "conductible",
              "valueBoolean" : true
            },
            {
              "code" : "isDocumentCharacteristic",
              "valueBoolean" : true
            },
            {
              "code" : "Name:Act:participation:Participation",
              "valueString" : "responsibleParty"
            },
            {
              "code" : "Name:Role:participation:Participation",
              "valueString" : "responsibleFor"
            },
            {
              "code" : "Sort:Act:participation:Participation",
              "valueString" : "C________"
            },
            {
              "code" : "Sort:Role:participation:Participation",
              "valueString" : "C________"
            }
          ]
        },
        {
          "code" : "VRF",
          "display" : "verifier",
          "definition" : "A person who verifies the correctness and appropriateness of the service (plan, order, event, etc.) and hence takes on accountability.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10259"
            },
            {
              "code" : "conductible",
              "valueBoolean" : true
            },
            {
              "code" : "isDocumentCharacteristic",
              "valueBoolean" : true
            },
            {
              "code" : "Name:Act:participation:Participation",
              "valueString" : "verifier"
            },
            {
              "code" : "Name:Role:participation:Participation",
              "valueString" : "verification"
            },
            {
              "code" : "Sort:Act:participation:Participation",
              "valueString" : "I________"
            },
            {
              "code" : "Sort:Role:participation:Participation",
              "valueString" : "I________"
            }
          ],
          "concept" : [
            {
              "code" : "AUTHEN",
              "display" : "authenticator",
              "definition" : "A verifier who attests to the accuracy of an act, but who does not have privileges to legally authenticate the act. An example would be a resident physician who sees a patient and dictates a note, then later signs it. Their signature constitutes an authentication.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "19072"
                },
                {
                  "code" : "isDocumentCharacteristic",
                  "valueBoolean" : true
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "authenticator"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "authenticated"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "IB_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "IB_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            },
            {
              "code" : "LA",
              "display" : "legal authenticator",
              "definition" : "A verifier who legally authenticates the accuracy of an act. An example would be a staff physician who sees a patient and dictates a note, then later signs it. Their signature constitutes a legal authentication.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "19073"
                },
                {
                  "code" : "isDocumentCharacteristic",
                  "valueBoolean" : true
                },
                {
                  "code" : "Name:Act:participation:Participation",
                  "valueString" : "legalAuthenticator"
                },
                {
                  "code" : "Name:Role:participation:Participation",
                  "valueString" : "legallyAuthenticated"
                },
                {
                  "code" : "Sort:Act:participation:Participation",
                  "valueString" : "IA_______"
                },
                {
                  "code" : "Sort:Role:participation:Participation",
                  "valueString" : "IA_______"
                },
                {
                  "code" : "conductible",
                  "valueBoolean" : true
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
