# ObservationInterpretation - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ObservationInterpretation**

## CodeSystem: ObservationInterpretation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ObservationInterpretation |
| *Other Identifiers:*OID:2.16.840.1.113883.5.83 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
One or more codes providing a rough qualitative interpretation of the observation, such as "normal" / "abnormal", "low" / "high", "better" / "worse", "resistant" / "susceptible", "expected" / "not expected". The value set is intended to be for ANY use where coded representation of an interpretation is needed. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [GeneticObservationInterpretation](ValueSet-v3-GeneticObservationInterpretation.md)
* [ObservationInterpretation](ValueSet-v3-ObservationInterpretation.md)
* [ObservationInterpretationChange](ValueSet-v3-ObservationInterpretationChange.md)
* [ObservationInterpretationDetected](ValueSet-v3-ObservationInterpretationDetected.md)
* [ObservationInterpretationExceptions](ValueSet-v3-ObservationInterpretationExceptions.md)
* [ObservationInterpretationExpectation](ValueSet-v3-ObservationInterpretationExpectation.md)
* [ObservationInterpretationNormality](ValueSet-v3-ObservationInterpretationNormality.md)
* [ObservationInterpretationNormalityAbnormal](ValueSet-v3-ObservationInterpretationNormalityAbnormal.md)
* [ObservationInterpretationNormalityCriticallyAbnormal](ValueSet-v3-ObservationInterpretationNormalityCriticallyAbnormal.md)
* [ObservationInterpretationNormalityHigh](ValueSet-v3-ObservationInterpretationNormalityHigh.md)
* [ObservationInterpretationNormalityLow](ValueSet-v3-ObservationInterpretationNormalityLow.md)
* [ObservationInterpretationOustsideThreshold](ValueSet-v3-ObservationInterpretationOustsideThreshold.md)
* [ObservationInterpretationProtocolInclusion](ValueSet-v3-ObservationInterpretationProtocolInclusion.md)
* [ObservationInterpretationSusceptibility](ValueSet-v3-ObservationInterpretationSusceptibility.md)
* [ReactivityObservationInterpretation](ValueSet-v3-ReactivityObservationInterpretation.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ObservationInterpretation",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.83"
    }
  ],
  "version" : "3.0.0",
  "name" : "ObservationInterpretation",
  "title" : "ObservationInterpretation",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "One or more codes providing a rough qualitative interpretation of the observation, such as \"normal\" / \"abnormal\", \"low\" / \"high\", \"better\" / \"worse\", \"resistant\" / \"susceptible\", \"expected\" / \"not expected\". The value set is intended to be for ANY use where coded representation of an interpretation is needed.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A property that indicates the status of the concept. One of active, experimental, deprecated, or retired.",
      "type" : "code"
    },
    {
      "code" : "deprecationDate",
      "uri" : "http://hl7.org/fhir/concept-properties#deprecationDate",
      "description" : "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged.",
      "type" : "dateTime"
    },
    {
      "code" : "subsumedBy",
      "uri" : "http://hl7.org/fhir/concept-properties#parent",
      "description" : "The concept code of a parent concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_GeneticObservationInterpretation",
      "display" : "GeneticObservationInterpretation",
      "definition" : "Codes that specify interpretation of genetic analysis, such as \"positive\", \"negative\", \"carrier\", \"responsive\", etc.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22646"
        }
      ]
    },
    {
      "code" : "_ObservationInterpretationChange",
      "display" : "ObservationInterpretationChange",
      "definition" : "Interpretations of change of quantity and/or severity. At most one of B or W and one of U or D allowed.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21090"
        }
      ]
    },
    {
      "code" : "_ObservationInterpretationExceptions",
      "display" : "ObservationInterpretationExceptions",
      "definition" : "Technical exceptions resulting in the inability to provide an interpretation. At most one allowed. Does not imply normality or severity.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21091"
        }
      ]
    },
    {
      "code" : "_ObservationInterpretationNormality",
      "display" : "ObservationInterpretationNormality",
      "definition" : "Interpretation of normality or degree of abnormality (including critical or \"alert\" level). Concepts in this category are mutually exclusive, i.e., at most one is allowed.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21092"
        }
      ]
    },
    {
      "code" : "_ObservationInterpretationSusceptibility",
      "display" : "ObservationInterpretationSusceptibility",
      "definition" : "Interpretations of anti-microbial susceptibility testing results (microbiology). At most one allowed.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21093"
        }
      ]
    },
    {
      "code" : "EX",
      "display" : "outside threshold",
      "definition" : "The observation/test result is interpreted as being outside the inclusion range for a particular protocol within which the result is being reported.\r\n\r\n**Example:** A positive result on a Hepatitis screening test.\r\n\r\n*Open Issue:* EX, HX, LX: These three concepts do not seem to meet a clear need in the vocabulary, and their use in observation interpretation appears likely to be covered by other existing concepts (e.g., A, H, L). The only apparent significant difference is their reference to use in protocols for exclusion of study subjects. These concepts/codes were proposed by RCRIM for use in the CTLaboratory message. They were submitted and approved in the November 2005 Harmonization cycle in proposal \"030103C\\_VOCAB\\_RCRIM\\_l\\_quade\\_RCRIM Obs Interp\\_20051028154455\". However, this proposal was not fully implemented in the vocabulary. The proposal recommended creation of the x\\_ClinicalResearchExclusion domain in ObservationInterpretation with a value set including those three concepts/codes, but there is no subdomain of that name or equivalent with a binding to either of the value sets that contain these concepts/codes. Members of the OO WG have recently attempted to contact members of RCRIM regarding these concepts, both by email and at the recent WGM in Atlanta, without response. It is felt by OO that the best course of action to take at this time is to add this comprehensive Open Issue rather than deprecate these three concepts at this time, until further discussion is held.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21634"
        }
      ]
    },
    {
      "code" : "HM",
      "display" : "Hold for Medical Review",
      "definition" : "Hold for Medical Review\r\n\r\n*Usage Note:* This code is not intended for use in V3 artifacts. It is included in the code system to maintain alignment with the V2 Table 0078 \"Interpretation Codes.\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2016-11-10"
        },
        {
          "code" : "internalId",
          "valueCode" : "23790"
        }
      ]
    },
    {
      "code" : "ObservationInterpretationDetection",
      "display" : "ObservationInterpretationDetection",
      "definition" : "Interpretations of the presence or absence of a component / analyte or organism in a test or of a sign in a clinical observation. In keeping with laboratory data processing practice, these concepts provide a categorical interpretation of the \"meaning\" of the quantitative value for the same observation.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22805"
        }
      ]
    },
    {
      "code" : "ObservationInterpretationExpectation",
      "display" : "ObservationInterpretationExpectation",
      "definition" : "Interpretation of the observed result taking into account additional information (contraindicators) about the patient's situation. Concepts in this category are mutually exclusive, i.e., at most one is allowed.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23723"
        }
      ]
    },
    {
      "code" : "OBX",
      "display" : "Interpretation qualifiers in separate OBX segments",
      "definition" : "Interpretation qualifiers in separate OBX segments\r\n\r\n*Usage Note:* This code is not intended for use in V3 artifacts. It is included in the code system to maintain alignment with the V2 Table 0078 \"Interpretation Codes.\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2016-11-10"
        },
        {
          "code" : "internalId",
          "valueCode" : "23789"
        }
      ]
    },
    {
      "code" : "ReactivityObservationInterpretation",
      "display" : "ReactivityObservationInterpretation",
      "definition" : "Interpretations of the presence and level of reactivity of the specified component / analyte with the reagent in the performed laboratory test.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23568"
        }
      ]
    },
    {
      "code" : "CAR",
      "display" : "Carrier",
      "definition" : "The patient is considered as carrier based on the testing results. A carrier is an individual who carries an altered form of a gene which can lead to having a child or offspring in future generations with a genetic disorder.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23559"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GeneticObservationInterpretation"
        }
      ]
    },
    {
      "code" : "Carrier",
      "display" : "Carrier",
      "definition" : "The patient is considered as carrier based on the testing results. A carrier is an individual who carries an altered form of a gene which can lead to having a child or offspring in future generations with a genetic disorder.\r\n\r\n***Deprecation Comment:*** This code is currently the same string as the print name for this concept and is inconsistent with the conventions being used for the other codes in the coding system, as it is a full word with initial capitalization, rather than an all upper case mnemonic. The recommendation from OO is to deprecate the code \"Carrier\" and to add \"CAR\" as the new active code representation for this concept.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2013-07-28"
        },
        {
          "code" : "internalId",
          "valueCode" : "22647"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GeneticObservationInterpretation"
        }
      ]
    },
    {
      "code" : "B",
      "display" : "Better",
      "definition" : "The current result or observation value has improved compared to the previous result or observation value (the change is significant as defined in the respective test procedure).\r\n\r\n\\[Note: This can be applied to quantitative or qualitative observations.\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10215"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationChange"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Significant change down",
      "definition" : "The current result has decreased from the previous result for a quantitative observation (the change is significant as defined in the respective test procedure).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10218"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationChange"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Significant change up",
      "definition" : "The current result has increased from the previous result for a quantitative observation (the change is significant as defined in the respective test procedure).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10217"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationChange"
        }
      ]
    },
    {
      "code" : "W",
      "display" : "Worse",
      "definition" : "The current result or observation value has degraded compared to the previous result or observation value (the change is significant as defined in the respective test procedure).\r\n\r\n\\[Note: This can be applied to quantitative or qualitative observations.\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10216"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationChange"
        }
      ]
    },
    {
      "code" : "<",
      "display" : "Off scale low",
      "definition" : "The result is below the minimum detection limit (the test procedure or equipment is the limiting factor).\r\n\r\nSynonyms: Below analytical limit, low off scale.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10226"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationExceptions"
        }
      ]
    },
    {
      "code" : ">",
      "display" : "Off scale high",
      "definition" : "The result is above the maximum quantifiable limit (the test procedure or equipment is the limiting factor).\r\n\r\nSynonyms: Above analytical limit, high off scale.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10227"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationExceptions"
        }
      ]
    },
    {
      "code" : "AC",
      "display" : "Anti-complementary substances present",
      "definition" : "A valid result cannot be obtained for the specified component / analyte due to the presence of anti-complementary substances in the sample.\r\n\r\n***Deprecation Comment:*** This code is being deprecated to match the status in V2 Table 0078 \"Interpretation Codes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2016-11-10"
        },
        {
          "code" : "internalId",
          "valueCode" : "23564"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationExceptions"
        }
      ]
    },
    {
      "code" : "IE",
      "display" : "Insufficient evidence",
      "definition" : "There is insufficient evidence that the species in question is a good target for therapy with the drug. A categorical interpretation is not possible.\r\n\r\n\\[Note: A MIC with \"IE\" and/or a comment may be reported (without an accompanying S, I or R-categorization).\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23567"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationExceptions"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationSusceptibility"
        }
      ]
    },
    {
      "code" : "QCF",
      "display" : "Quality control failure",
      "definition" : "A result cannot be considered valid for the specified component / analyte or organism due to failure in the quality control testing component.\r\n\r\n***Deprecation Comment:*** This code is being deprecated to match the status in V2 Table 0078 \"Interpretation Codes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2016-11-10"
        },
        {
          "code" : "internalId",
          "valueCode" : "23565"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationExceptions"
        }
      ]
    },
    {
      "code" : "TOX",
      "display" : "Cytotoxic substance present",
      "definition" : "A valid result cannot be obtained for the specified organism or cell line due to the presence of cytotoxic substances in the sample or culture.\r\n\r\n***Deprecation Comment:*** This code is being deprecated to match the status in V2 Table 0078 \"Interpretation Codes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2016-11-10"
        },
        {
          "code" : "internalId",
          "valueCode" : "23566"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationExceptions"
        }
      ]
    },
    {
      "code" : "A",
      "display" : "Abnormal",
      "definition" : "The result or observation value is outside the reference range or expected norm (as defined for the respective test procedure).\r\n\r\n\\[Note: Typically applies to non-numeric results.\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10208"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationNormality"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Normal",
      "definition" : "The result or observation value is within the reference range or expected norm (as defined for the respective test procedure).\r\n\r\n\\[Note: Applies to numeric or non-numeric results.\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10207"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationNormality"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Intermediate",
      "definition" : "Bacterial strain inhibited in vitro by a concentration of an antimicrobial agent that is associated with uncertain therapeutic effect. Reference: CLSI (http://www.clsi.org/Content/NavigationMenu/Resources/HarmonizedTerminologyDatabase/Harmonized\\_Terminolo.htm) Projects: ISO 20776-1, ISO 20776-2\r\n\r\n\\[Note 1: Bacterial strains are categorized as intermediate by applying the appropriate breakpoints in a defined phenotypic test system.\\]\r\n\r\n\\[Note 2: This class of susceptibility implies that an infection due to the isolate can be appropriately treated in body sites where the drugs are physiologically concentrated or when a high dosage of drug can be used.\\]\r\n\r\n\\[Note 3: This class also indicates a \"buffer zone,\" to prevent small, uncontrolled, technical factors from causing major discrepancies in interpretations.\\]\r\n\r\n\\[Note 4: These breakpoints can be altered due to changes in circumstances (e.g., changes in commonly used drug dosages, emergence of new resistance mechanisms).\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10221"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationSusceptibility"
        }
      ]
    },
    {
      "code" : "MS",
      "display" : "moderately susceptible",
      "definition" : "The patient is considered as carrier based on the testing results. A carrier is an individual who carries an altered form of a gene which can lead to having a child or offspring in future generations with a genetic disorder.\r\n\r\n***Deprecation Comment:*** This antimicrobial susceptibility test interpretation concept is recommended by OO to be deprecated as it is no longer recommended for use in susceptibility testing by CLSI (reference CLSI document M100-S22; Vol. 32 No.3; CLSI Performance Standards for Antimicrobial Susceptibility Testing; Twenty-Second Informational Supplement. Jan 2012).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2013-07-28"
        },
        {
          "code" : "internalId",
          "valueCode" : "10222"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationSusceptibility"
        }
      ]
    },
    {
      "code" : "NCL",
      "display" : "No CLSI defined breakpoint",
      "definition" : "Use when not enough clinical trial data published by the Clinical and Laboratory Standards Institutes (CLSI) is available to establish the breakpoints for susceptible / intermediate and resistant.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23886"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationSusceptibility"
        }
      ]
    },
    {
      "code" : "NS",
      "display" : "Non-susceptible",
      "definition" : "A category used for isolates for which only a susceptible interpretive criterion has been designated because of the absence or rare occurrence of resistant strains. Isolates that have MICs above or zone diameters below the value indicated for the susceptible breakpoint should be reported as non-susceptible.\r\n\r\nNOTE 1: An isolate that is interpreted as non-susceptible does not necessarily mean that the isolate has a resistance mechanism. It is possible that isolates with MICs above the susceptible breakpoint that lack resistance mechanisms may be encountered within the wild-type distribution subsequent to the time the susceptible-only breakpoint is set.\r\n\r\nNOTE 2: For strains yielding results in the \"nonsusceptible\" category, organism identification and antimicrobial susceptibility test results should be confirmed.\r\n\r\nSynonym: decreased susceptibility.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23557"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationSusceptibility"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Resistant",
      "definition" : "Bacterial strain inhibited in vitro by a concentration of an antimicrobial agent that is associated with a high likelihood of therapeutic failure. Reference: CLSI (http://www.clsi.org/Content/NavigationMenu/Resources/HarmonizedTerminologyDatabase/Harmonized\\_Terminolo.htm) Projects: ISO 20776-1, ISO 20776-2\r\n\r\n\\[Note 1: Bacterial strains are categorized as resistant by applying the appropriate breakpoints in a defined phenotypic test system.\\]\r\n\r\n\\[Note 2: This breakpoint can be altered due to changes in circumstances (e.g., changes in commonly used drug dosages, emergence of new resistance mechanisms).\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10220"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationSusceptibility"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Susceptible",
      "definition" : "Bacterial strain inhibited by in vitro concentration of an antimicrobial agent that is associated with a high likelihood of therapeutic success. Reference: CLSI (http://www.clsi.org/Content/NavigationMenu/Resources/HarmonizedTerminologyDatabase/Harmonized\\_Terminolo.htm) Synonym (earlier term): Sensitive Projects: ISO 20776-1, ISO 20776-2\r\n\r\n\\[Note 1: Bacterial strains are categorized as susceptible by applying the appropriate breakpoints in a defined phenotypic system.\\]\r\n\r\n\\[Note 2: This breakpoint can be altered due to changes in circumstances (e.g., changes in commonly used drug dosages, emergence of new resistance mechanisms).\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10223"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationSusceptibility"
        }
      ]
    },
    {
      "code" : "VS",
      "display" : "very susceptible",
      "definition" : "The patient is considered as carrier based on the testing results. A carrier is an individual who carries an altered form of a gene which can lead to having a child or offspring in future generations with a genetic disorder.\r\n\r\n***Deprecation Comment:*** This antimicrobial susceptibility test interpretation concept is recommended by OO to be deprecated as it is no longer recommended for use in susceptibility testing by CLSI (reference CLSI document M100-S22; Vol. 32 No.3; CLSI Performance Standards for Antimicrobial Susceptibility Testing; Twenty-Second Informational Supplement. Jan 2012).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2013-07-28"
        },
        {
          "code" : "internalId",
          "valueCode" : "10224"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ObservationInterpretationSusceptibility"
        }
      ]
    },
    {
      "code" : "AA",
      "display" : "Critical abnormal",
      "definition" : "The result or observation value is outside a reference range or expected norm at a level at which immediate action should be considered for patient safety (as defined for the respective test procedure).\r\n\r\n\\[Note: Typically applies to non-numeric results. Analogous to critical/panic limits for numeric results.\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10211"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "A"
        }
      ]
    },
    {
      "code" : "H",
      "display" : "High",
      "definition" : "The result for a quantitative observation is above the upper limit of the reference range (as defined for the respective test procedure).\r\n\r\nSynonym: Above high normal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10210"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "A"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Low",
      "definition" : "The result for a quantitative observation is below the lower limit of the reference range (as defined for the respective test procedure).\r\n\r\nSynonym: Below low normal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10209"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "A"
        }
      ]
    },
    {
      "code" : "HH",
      "display" : "Critical high",
      "definition" : "The result for a quantitative observation is above a reference level at which immediate action should be considered for patient safety (as defined for the respective test procedure).\r\n\r\nSynonym: Above upper panic limits.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10213"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "AA"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "H>"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HU"
        }
      ]
    },
    {
      "code" : "LL",
      "display" : "Critical low",
      "definition" : "The result for a quantitative observation is below a reference level at which immediate action should be considered for patient safety (as defined for the respective test procedure).\r\n\r\nSynonym: Below lower panic limits.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10212"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "AA"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "L<"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "LU"
        }
      ]
    },
    {
      "code" : "HX",
      "display" : "above high threshold",
      "definition" : "The observation/test result is interpreted as being outside the inclusion range for a particular protocol within which the result is being reported.\r\n\r\n**Example:** A positive result on a Hepatitis screening test.\r\n\r\n*Open Issue:* EX, HX, LX: These three concepts do not seem to meet a clear need in the vocabulary, and their use in observation interpretation appears likely to be covered by other existing concepts (e.g., A, H, L). The only apparent significant difference is their reference to use in protocols for exclusion of study subjects. These concepts/codes were proposed by RCRIM for use in the CTLaboratory message. They were submitted and approved in the November 2005 Harmonization cycle in proposal \"030103C\\_VOCAB\\_RCRIM\\_l\\_quade\\_RCRIM Obs Interp\\_20051028154455\". However, this proposal was not fully implemented in the vocabulary. The proposal recommended creation of the x\\_ClinicalResearchExclusion domain in ObservationInterpretation with a value set including those three concepts/codes, but there is no subdomain of that name or equivalent with a binding to either of the value sets that contain these concepts/codes. Members of the OO WG have recently attempted to contact members of RCRIM regarding these concepts, both by email and at the recent WGM in Atlanta, without response. It is felt by OO that the best course of action to take at this time is to add this comprehensive Open Issue rather than deprecate these three concepts at this time, until further discussion is held.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21636"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EX"
        }
      ]
    },
    {
      "code" : "LX",
      "display" : "below low threshold",
      "definition" : "The numeric observation/test result is interpreted as being below the low threshold value for a particular protocol within which the result is being reported.\r\n\r\n**Example:** A Total White Blood Cell Count falling below a protocol-defined threshold value of 3000/mm^3\r\n\r\n*Open Issue:* EX, HX, LX: These three concepts do not seem to meet a clear need in the vocabulary, and their use in observation interpretation appears likely to be covered by other existing concepts (e.g., A, H, L). The only apparent significant difference is their reference to use in protocols for exclusion of study subjects. These concepts/codes were proposed by RCRIM for use in the CTLaboratory message. They were submitted and approved in the November 2005 Harmonization cycle in proposal \"030103C\\_VOCAB\\_RCRIM\\_l\\_quade\\_RCRIM Obs Interp\\_20051028154455\". However, this proposal was not fully implemented in the vocabulary. The proposal recommended creation of the x\\_ClinicalResearchExclusion domain in ObservationInterpretation with a value set including those three concepts/codes, but there is no subdomain of that name or equivalent with a binding to either of the value sets that contain these concepts/codes. Members of the OO WG have recently attempted to contact members of RCRIM regarding these concepts, both by email and at the recent WGM in Atlanta, without response. It is felt by OO that the best course of action to take at this time is to add this comprehensive Open Issue rather than deprecate these three concepts at this time, until further discussion is held.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21635"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EX"
        }
      ]
    },
    {
      "code" : "H>",
      "display" : "Significantly high",
      "definition" : "A test result that is significantly higher than the reference (normal) or therapeutic interval, but has not reached the critically high value and might need special attention, as defined by the laboratory or the clinician.\r\n\r\n\\[Note: This level is situated between 'H' and 'HH'.\\]\r\n\r\n*Deprecation Comment:* The code 'H>' is being deprecated in order to align with the use of the code 'HU' for \"Very high\" in V2 Table 0078 \"Interpretation Codes\".\r\n\r\n\\[Note: The use of code 'H>' is non-preferred, as this code is deprecated and on track to be retired; use code 'HU' instead.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2015-03-23"
        },
        {
          "code" : "internalId",
          "valueCode" : "23560"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "H"
        }
      ]
    },
    {
      "code" : "HU",
      "display" : "Significantly high",
      "definition" : "A test result that is significantly higher than the reference (normal) or therapeutic interval, but has not reached the critically high value and might need special attention, as defined by the laboratory or the clinician.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23742"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "H"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "Equivocal",
      "definition" : "The test or procedure was successfully performed, but the results are borderline and can neither be declared positive / negative nor detected / not detected according to the current established criteria.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23732"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IND"
        }
      ]
    },
    {
      "code" : "L<",
      "display" : "Significantly low",
      "definition" : "A test result that is significantly lower than the reference (normal) or therapeutic interval, but has not reached the critically low value and might need special attention, as defined by the laboratory or the clinician.\r\n\r\n\\[Note: This level is situated between 'L' and 'LL'.\\]\r\n\r\n*Deprecation Comment:* The code 'L<' is being deprecated in order to align with the use of the code 'LU' for \"Very low\" in V2 Table 0078 \"Interpretation Codes\".\r\n\r\n\\[Note: The use of code 'L<' is non-preferred, as this code is deprecated and on track to be retired; use code 'LU' instead.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        },
        {
          "code" : "deprecationDate",
          "valueDateTime" : "2015-03-23"
        },
        {
          "code" : "internalId",
          "valueCode" : "23561"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "L"
        }
      ]
    },
    {
      "code" : "LU",
      "display" : "Significantly low",
      "definition" : "A test result that is significantly lower than the reference (normal) or therapeutic interval, but has not reached the critically low value and might need special attention, as defined by the laboratory or the clinician.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23743"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "L"
        }
      ]
    },
    {
      "code" : "ND",
      "display" : "Not detected",
      "definition" : "The presence of the specified component / analyte, organism or clinical sign could not be determined within the limit of detection of the performed test or procedure.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23563"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NEG"
        }
      ]
    },
    {
      "code" : "IND",
      "display" : "Indeterminate",
      "definition" : "The specified component / analyte, organism or clinical sign could neither be declared positive / negative nor detected / not detected by the performed test or procedure.\r\n\r\n*Usage Note:* For example, if the specimen was degraded, poorly processed, or was missing the required anatomic structures, then \"indeterminate\" (i.e. \"cannot be determined\") is the appropriate response, not \"equivocal\".",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22807"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ObservationInterpretationDetection"
        }
      ]
    },
    {
      "code" : "NEG",
      "display" : "Negative",
      "definition" : "An absence finding of the specified component / analyte, organism or clinical sign based on the established threshold of the performed test or procedure.\r\n\r\n\\[Note: Negative does not necessarily imply the complete absence of the specified item.\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22808"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ObservationInterpretationDetection"
        }
      ]
    },
    {
      "code" : "POS",
      "display" : "Positive",
      "definition" : "A presence finding of the specified component / analyte, organism or clinical sign based on the established threshold of the performed test or procedure.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22806"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ObservationInterpretationDetection"
        }
      ]
    },
    {
      "code" : "EXP",
      "display" : "Expected",
      "definition" : "This result has been evaluated in light of known contraindicators. Once those contraindicators have been taken into account the result is determined to be \"Expected\" (e.g., presence of drugs in a patient that is taking prescription medication for pain management).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23724"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ObservationInterpretationExpectation"
        }
      ]
    },
    {
      "code" : "UNE",
      "display" : "Unexpected",
      "definition" : "This result has been evaluated in light of known contraindicators. Once those contraindicators have been taken into account the result is determined to be \"Unexpected\" (e.g., presence of non-prescribed drugs in a patient that is taking prescription medication for pain management).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23725"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ObservationInterpretationExpectation"
        }
      ]
    },
    {
      "code" : "DET",
      "display" : "Detected",
      "definition" : "The measurement of the specified component / analyte, organism or clinical sign above the limit of detection of the performed test or procedure.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23562"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "POS"
        }
      ]
    },
    {
      "code" : "SYN-R",
      "display" : "Synergy - resistant",
      "definition" : "A category for isolates where the bacteria (e.g. enterococci) are not susceptible in vitro to a combination therapy (e.g., high-level aminoglycoside and cell wall active agent). This is predictive that this combination therapy will not be effective.\r\n\r\n*Usage Note:* Since the use of penicillin or ampicillin alone often results in treatment failure of serious enterococcal or other bacterial infections, combination therapy is usually indicated to enhance bactericidal activity. The synergy between a cell wall active agent (such as penicillin, ampicillin, or vancomycin) and an aminoglycoside (such as gentamicin, kanamycin or streptomycin) is best predicted by screening for high-level bacterial resistance to the aminoglycoside.\r\n\r\n*Open Issue:* The print name of the code is very general and the description is very specific to a pair of classes of agents, which may lead to confusion of these concepts in the future should other synergies be found.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23621"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "R"
        }
      ]
    },
    {
      "code" : "NR",
      "display" : "Non-reactive",
      "definition" : "An absence finding used to indicate that the specified component / analyte did not react measurably with the reagent.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23569"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ReactivityObservationInterpretation"
        }
      ]
    },
    {
      "code" : "RR",
      "display" : "Reactive",
      "definition" : "A presence finding used to indicate that the specified component / analyte reacted with the reagent above the reliably measurable limit of the performed test.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23570"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ReactivityObservationInterpretation"
        }
      ]
    },
    {
      "code" : "WR",
      "display" : "Weakly reactive",
      "definition" : "A weighted presence finding used to indicate that the specified component / analyte reacted with the reagent, but below the reliably measurable limit of the performed test.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23571"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RR"
        }
      ]
    },
    {
      "code" : "SDD",
      "display" : "Susceptible-dose dependent",
      "definition" : "A category that includes isolates with antimicrobial agent minimum inhibitory concentrations (MICs) that approach usually attainable blood and tissue levels and for which response rates may be lower than for susceptible isolates.\r\n\r\nReference: CLSI document M44-A2 2009 \"Method for antifungal disk diffusion susceptibility testing of yeasts; approved guideline - second edition\" - page 2.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23558"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "S"
        }
      ]
    },
    {
      "code" : "SYN-S",
      "display" : "Synergy - susceptible",
      "definition" : "A category for isolates where the bacteria (e.g. enterococci) are susceptible in vitro to a combination therapy (e.g., high-level aminoglycoside and cell wall active agent). This is predictive that this combination therapy will be effective.\r\n\r\n*Usage Note:* Since the use of penicillin or ampicillin alone often results in treatment failure of serious enterococcal or other bacterial infections, combination therapy is usually indicated to enhance bactericidal activity. The synergy between a cell wall active agent (such as penicillin, ampicillin, or vancomycin) and an aminoglycoside (such as gentamicin, kanamycin or streptomycin) is best predicted by screening for high-level bacterial resistance to the aminoglycoside.\r\n\r\n*Open Issue:* The print name of the code is very general and the description is very specific to a pair of classes of agents, which may lead to confusion of these concepts in the future should other synergies be found.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23620"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "S"
        }
      ]
    }
  ]
}

```
