# MdfHmdMetSourceType - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MdfHmdMetSourceType**

## CodeSystem: MdfHmdMetSourceType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-MdfHmdMetSourceType | *Version*:2.0.1 | |
| Retired as of 2019-03-20 | *Responsible:*Health Level 7 | *Computable Name*:MdfHmdMetSourceType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.75 | | |

 
Code to identify the source of a Message Element Type represented in the 'of MET' column of an HMD. 
**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-MdfHmdMetSourceType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-MdfHmdMetSourceType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.75"
    }
  ],
  "version" : "2.0.1",
  "name" : "MdfHmdMetSourceType",
  "title" : "MdfHmdMetSourceType",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level 7",
  "contact" : [
    {
      "name" : "Health Level Seven"
    }
  ],
  "description" : "Code to identify the source of a Message Element Type represented in the 'of MET' column of an HMD.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used.",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "C",
      "display" : "Common MET",
      "definition" : "This message element type is an HL7 common message element type.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10079"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Data type",
      "definition" : "This message element type is an HL7 data type.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10078"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Reference",
      "definition" : "This row represents a reference to a previously defined type. Such a reference means that, in a given message, the message element instance for the current row is identical to the message element instance that instantiates the referred row.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10082"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "New type",
      "definition" : "New type. This row starts the definition of a new message element type. The subordinate rows beneath it compose the definition of the type. Each of these subordinate rows has the name of the message element type being defined in the In Message Element Type column. That name will be the same one that is in the Of Message Element Type of this row.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10077"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Recursive",
      "definition" : "This row represents the recursive reuse of the message element type within which is appears. See 10.3.3.3.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10081"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Re-used MET",
      "definition" : "This message element type was previously defined in this HMD and is being reused",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10080"
        }
      ]
    }
  ]
}

```
