# HL7 Document Format Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7 Document Format Codes**

## CodeSystem: HL7 Document Format Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes | *Version*:4.1.0 | |
| Active as of 2024-11-10 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:HL7DocumentFormatCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1407 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This codeSystem contains codes which specify the technical format of a document. Each code provides sufficient information to allow any potential document consumer to know if it will be able to process the document. The codes are sufficiently specific to ensure processing/display by identifying a document encoding, structure and template. For example, formatCodes can be used in the FHIR DocumentReference resource to characterize the document being referenced. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [HL7FormatCodes](ValueSet-v3-HL7FormatCodes.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-HL7DocumentFormatCodes",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1407"
    }
  ],
  "version" : "4.1.0",
  "name" : "HL7DocumentFormatCodes",
  "title" : "HL7 Document Format Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-11-10",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This codeSystem contains codes which specify the technical format of a document. Each code provides sufficient information to allow any potential document consumer to know if it will be able to process the document. The codes are sufficiently specific to ensure processing/display by identifying a document encoding, structure and template. For example, formatCodes can be used in the FHIR DocumentReference resource to characterize the document being referenced.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "urn:hl7-org:sdwg:ccda-structuredBody:1.1",
      "display" : "ccda-structuredBody:1.1",
      "definition" : "C-CDA 1.1 constraints using a structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:ccda-nonXMLBody:1.1",
      "display" : "ccda-nonXMLBody:1.1",
      "definition" : "C-CDA 1.1 constraints using a non structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:ccda-structuredBody:2.1",
      "display" : "ccda-structuredBody:2.1",
      "definition" : "C-CDA 2.1 constraints using a structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:ccda-nonXMLBody:2.1",
      "display" : "ccda-nonXMLBody:2.1",
      "definition" : "C-CDA 2.1 constraints using a non structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:pacp-structuredBody:1.0",
      "display" : "pacp-structuredBody:1.0",
      "definition" : "PACP 1.0 constraints using a structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:pacp-nonXMLBody:1.0",
      "display" : "pacp-nonXMLBody:1.0",
      "definition" : "PACP 1.0 constraints using a non structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:pacp-structuredBody:1.1",
      "display" : "pacp-structuredBody:1.1",
      "definition" : "PACP 1.1 constraints using a structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:pacp-nonXMLBody:1.1",
      "display" : "pacp-nonXMLBody:1.1",
      "definition" : "PACP 1.1 constraints using a non structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:pacp-structuredBody:1.2",
      "display" : "pacp-structuredBody:1.2",
      "definition" : "PACP 1.2 constraints using a structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:pacp-nonXMLBody:1.2",
      "display" : "pacp-nonXMLBody:1.2",
      "definition" : "PACP 1.2 constraints using a non structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:pacp-structuredBody:1.3",
      "display" : "pacp-structuredBody:1.3",
      "definition" : "PACP 1.3 constraints using a structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:pacp-nonXMLBody:1.3",
      "display" : "pacp-nonXMLBody:1.3",
      "definition" : "PACP 1.3 constraints using a non structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:ccda-structuredBody:3.0",
      "display" : "ccda-structuredBody:3.0",
      "definition" : "C-CDA 3.0 constraints using a structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:ccda-nonXMLBody:3.0",
      "display" : "ccda-nonXMLBody:3.0",
      "definition" : "C-CDA 3.0 constraints using a non structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:ccda-structuredBody:4.0",
      "display" : "ccda-structuredBody:4.0",
      "definition" : "C-CDA 4.0 constraints using a structured body"
    },
    {
      "code" : "urn:hl7-org:sdwg:ccda-nonXMLBody:4.0",
      "display" : "ccda-nonXMLBody:4.0",
      "definition" : "C-CDA 4.0 constraints using a non structured body"
    }
  ]
}

```
