# EntityHandling - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EntityHandling**

## CodeSystem: EntityHandling 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-EntityHandling | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EntityHandling |
| *Other Identifiers:*OID:2.16.840.1.113883.5.42 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Special handling requirements for an Entity. 
**Example:**Keep at room temperature; Keep frozen below 0 C; Keep in a dry environment; Keep upright, do not turn upside down. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EntityHandling](ValueSet-v3-EntityHandling.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-EntityHandling",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-EntityHandling",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.42"
    }
  ],
  "version" : "3.0.0",
  "name" : "EntityHandling",
  "title" : "EntityHandling",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Special handling requirements for an Entity.\r\n\r\n*Example:*Keep at room temperature; Keep frozen below 0 C; Keep in a dry environment; Keep upright, do not turn upside down.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AMB",
      "display" : "Ambient Temperature",
      "definition" : "Keep at ambient temperature, 22 +/- 2C",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10394"
        }
      ]
    },
    {
      "code" : "C37",
      "display" : "Body Temperature",
      "definition" : "Critical to keep at body temperature 36-38C",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10395"
        }
      ]
    },
    {
      "code" : "CAMB",
      "display" : "Critical Ambient temperature",
      "definition" : "Critical ambient - must not be refrigerated or frozen.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14405"
        }
      ]
    },
    {
      "code" : "CATM",
      "display" : "Protect from Air",
      "definition" : "Critical. Do not expose to atmosphere. Do not uncap.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14409"
        }
      ]
    },
    {
      "code" : "CFRZ",
      "display" : "Critical frozen",
      "definition" : "Critical frozen. Specimen must not be allowed to thaw until immediately prior to testing.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14407"
        }
      ]
    },
    {
      "code" : "CREF",
      "display" : "Critical refrigerated temperature",
      "definition" : "Critical refrigerated - must not be allowed to freeze or warm until imediately prior to testing.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14406"
        }
      ]
    },
    {
      "code" : "DFRZ",
      "display" : "Deep Frozen",
      "definition" : "Deep Frozen -16 to -20C.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10398"
        }
      ]
    },
    {
      "code" : "DRY",
      "display" : "dry",
      "definition" : "Keep in a dry environment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10400"
        }
      ]
    },
    {
      "code" : "FRZ",
      "display" : "frozen",
      "definition" : "Keep frozen below 0 ?C",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10397"
        }
      ]
    },
    {
      "code" : "MTLF",
      "display" : "Metal Free",
      "definition" : "Container is free of heavy metals, including lead.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14410"
        }
      ]
    },
    {
      "code" : "NTR",
      "display" : "nitrogen",
      "definition" : "Keep in liquid nitrogen",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10399"
        }
      ]
    },
    {
      "code" : "PRTL",
      "display" : "Protect from Light",
      "definition" : "Protect from light (eg. Wrap in aluminum foil).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10401"
        }
      ]
    },
    {
      "code" : "PSA",
      "display" : "do not shake",
      "definition" : "Do not shake",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10404"
        }
      ]
    },
    {
      "code" : "PSO",
      "display" : "no shock",
      "definition" : "Protect against shock",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10402"
        }
      ]
    },
    {
      "code" : "REF",
      "display" : "Refrigerated temperature",
      "definition" : "Keep at refrigerated temperature:4-8C Accidental warming or freezing is of little consequence.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10396"
        }
      ]
    },
    {
      "code" : "SBU",
      "display" : "Shake before use",
      "definition" : "Shake thoroughly before using",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14393"
        }
      ]
    },
    {
      "code" : "UFRZ",
      "display" : "Ultra frozen",
      "definition" : "Ultra cold frozen -75 to -85C. Ultra cold freezer is typically at temperature of dry ice.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14408"
        }
      ]
    },
    {
      "code" : "UPR",
      "display" : "upright",
      "definition" : "Keep upright, do not turn upside down",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10403"
        }
      ]
    }
  ]
}

```
